/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.video.voximplant;

import android.content.Context;
import com.voximplant.sdk.Voximplant;
import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientConfig;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LogLevel;
import com.voximplant.sdk.client.LoginError;
import com.voximplant.sdk.client.RequestAudioFocusMode;
import io.streamlayer.common.data.video.voximplant.AuthError;
import io.streamlayer.common.data.video.voximplant.VoximplantClientManagerKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0015\u001a\u00020\u00102\u0018\b\u0002\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eJ\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\n\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0010J\b\u0010%\u001a\u00020\u0010H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J\u0012\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u001a\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00122\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0012H\u0016J\u0010\u00102\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u00103\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00104\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010\u0014J\u000e\u00105\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/streamlayer/common/data/video/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "context", "Landroid/content/Context;", "eglBase", "Lorg/webrtc/EglBase;", "(Landroid/content/Context;Lorg/webrtc/EglBase;)V", "client", "Lcom/voximplant/sdk/client/IClient;", "listeners", "", "Lio/streamlayer/common/data/video/voximplant/VoximplantClientManager$Listener;", "reconnectCompletion", "Lkotlin/Function1;", "Lio/streamlayer/common/data/video/voximplant/AuthError;", "", "servers", "", "voximplantUser", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "connect", "completion", "createCall", "Lcom/voximplant/sdk/call/ICall;", "topicId", "isVideoEnabled", "", "listener", "Lcom/voximplant/sdk/call/ICallListener;", "endCall", "call", "getSubscribedListener", "internalConnectAndLogin", "login", "user", "logout", "onConnectionClosed", "onConnectionEstablished", "onConnectionFailed", "p0", "onLoginFailed", "reason", "Lcom/voximplant/sdk/client/LoginError;", "onLoginSuccessful", "displayName", "authParams", "Lcom/voximplant/sdk/client/AuthParams;", "onOneTimeKeyGenerated", "key", "onRefreshTokenFailed", "onRefreshTokenSuccess", "register", "unregister", "Listener", "sdk_originalVoximplantRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    @NotNull
    private final IClient client;
    @Nullable
    private VoximplantUser voximplantUser;
    @NotNull
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @NotNull
    private final List<Listener> listeners;

    public VoximplantClientManager(@NotNull Context context, @NotNull EglBase eglBase) {
        ClientConfig clientConfig;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eglBase, (String)"eglBase");
        this.servers = new ArrayList<String>();
        this.listeners = new ArrayList<Listener>();
        ClientConfig clientConfig2 = clientConfig;
        clientConfig2();
        clientConfig2.requestAudioFocusMode = RequestAudioFocusMode.REQUEST_ON_CALL_CONNECTED;
        clientConfig.eglBase = eglBase;
        if (!Intrinsics.areEqual((Object)"original", (Object)"original")) {
            Voximplant.setLogListener(VoximplantClientManager::_init_$lambda-0);
        }
        Context context2 = context = Voximplant.getClientInstance((Executor)Executors.newSingleThreadExecutor(), (Context)context, (ClientConfig)clientConfig2);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getClientInstance(Execut\u2026), context, clientConfig)");
        this.client = context2;
        context.setClientLoginListener((IClientLoginListener)this);
        context.setClientSessionListener((IClientSessionListener)this);
    }

    private final Listener getSubscribedListener() {
        Object var1_1;
        block1: {
            for (Object e : ((VoximplantClientManager)this).listeners) {
                var1_1 = e;
                if (!((Listener)e).isSubscribed()) continue;
                break block1;
            }
            var1_1 = null;
        }
        return var1_1;
    }

    public static /* synthetic */ void connect$default(VoximplantClientManager voximplantClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voximplantClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalConnectAndLogin() {
        Object object = SLRLog.INSTANCE;
        ((SLRLog)object).i("VoximplantClientManager", "internalConnectAndLogin " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            ((SLRLog)object).i("VoximplantClientManager", "internalConnectAndLogin init connect");
            IClient iClient = this.client;
            boolean bl = false;
            try {
                iClient.connect(bl, this.servers);
            }
            catch (IllegalStateException illegalStateException) {
                this.onConnectionFailed(AuthError.NetworkIssues.getDescription());
            }
        }
        if (this.client.getClientState() == ClientState.CONNECTED) {
            Unit unit;
            SLRLog.INSTANCE.i("VoximplantClientManager", "internalConnectAndLogin init login");
            object = this.voximplantUser;
            if (object != null) {
                Object object2 = object;
                object = ((VoximplantUser)object2).getUsername();
                this.client.login((String)object, ((VoximplantUser)object2).getPassword());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.onLoginFailed(LoginError.INVALID_USERNAME);
            }
        }
    }

    private static final void _init_$lambda-0(LogLevel logLevel, String string2) {
        int n = logLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"s");
                    SLRLog.INSTANCE.e("VoximplantClientManager", string2);
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"s");
                SLRLog.INSTANCE.w("VoximplantClientManager", string2);
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"s");
            SLRLog.INSTANCE.i("VoximplantClientManager", string2);
        }
    }

    public final void register(@NotNull Listener listener2, @Nullable VoximplantUser voximplantUser2) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoximplantClientManager", "register " + listener2 + ' ' + voximplantUser2);
        boolean bl = voximplantClientManager.listeners.isEmpty();
        if (voximplantClientManager.listeners.isEmpty() ^ true) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).updateSubscription(false);
            }
        }
        this.listeners.add(listener2);
        listener2.updateSubscription(true);
        if (bl && voximplantUser2 != null) {
            this.login(voximplantUser2);
        }
    }

    public final void unregister(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoximplantClientManager", "unregister " + listener2);
        this.listeners.remove(listener2);
        listener2.updateSubscription(false);
        if (this.listeners.isEmpty()) {
            this.logout();
        } else {
            ((Listener)CollectionsKt.last(this.listeners)).updateSubscription(true);
        }
    }

    public final void login(@NotNull VoximplantUser voximplantUser2) {
        Intrinsics.checkNotNullParameter((Object)voximplantUser2, (String)"user");
        SLRLog.INSTANCE.i("VoximplantClientManager", "login " + voximplantUser2 + ' ' + this.client.getClientState());
        if (Intrinsics.areEqual((Object)this.voximplantUser, (Object)voximplantUser2)) {
            return;
        }
        this.voximplantUser = voximplantUser2;
        this.internalConnectAndLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "logout " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", "connect " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        if (this.voximplantUser == null) {
            if (function1 != null) {
                function1.invoke((Object)AuthError.InvalidUsername);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalConnectAndLogin();
    }

    public void onConnectionEstablished() {
        this.internalConnectAndLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionFailed " + (String)function1);
        function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        if ((function1 = this.reconnectCompletion) != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoximplantClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        if ((function1 = this.reconnectCompletion) != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoximplantClientManager", "onLoginSuccessful " + (String)function1);
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoximplantClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoximplantClientManager", "onLoginFailed " + object);
        Function1<? super AuthError, Unit> function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener) {
        CallSettings callSettings;
        VoximplantClientManager voximplantClientManager = voximplantClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoximplantClientManager", "createCall " + string2);
        VoximplantClientManager voximplantClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voximplantClientManager2 = voximplantClientManager.client.callConference("conf_" + string2, (CallSettings)voximplantClientManager2);
        if (voximplantClientManager2 != null) {
            VoximplantClientManager voximplantClientManager3 = voximplantClientManager2;
            voximplantClientManager3.addCallListener(iCallListener);
            voximplantClientManager3.start();
        }
        return voximplantClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        SLRLog.INSTANCE.i("VoximplantClientManager", "endCall " + iCall.getCallId());
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        iCall.hangup(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/data/video/voximplant/VoximplantClientManager$Listener;", "", "isSubscribed", "", "onConnectionClosed", "", "onConnectionFailed", "error", "Lio/streamlayer/common/data/video/voximplant/AuthError;", "updateSubscription", "isActive", "sdk_originalVoximplantRelease"})
    public static interface Listener {
        public boolean isSubscribed();

        public void updateSubscription(boolean var1);

        public void onConnectionFailed(@NotNull AuthError var1);

        public void onConnectionClosed();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            nArray[LogLevel.INFO.ordinal()] = 1;
            nArray[LogLevel.WARNING.ordinal()] = 2;
            nArray[LogLevel.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

