/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import io.streamlayer.common.network.NetworkConnectionTracker;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/common/network/NetworkConnectionTracker;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "connectivityManager$delegate", "Lkotlin/Lazy;", "networkStatus", "Lkotlinx/coroutines/flow/Flow;", "", "getNetworkStatus", "()Lkotlinx/coroutines/flow/Flow;", "sdk_originalVoximplantRelease"})
@ExperimentalCoroutinesApi
public final class NetworkConnectionTracker {
    @NotNull
    private final Lazy connectivityManager$delegate;
    @NotNull
    private final Flow<Boolean> networkStatus;

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public NetworkConnectionTracker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.connectivityManager$delegate = LazyKt.lazy((Function0)new Function0<ConnectivityManager>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = context;
                super(0);
            }

            @NotNull
            public final ConnectivityManager invoke() {
                Object object = object.$context.getSystemService("connectivity");
                if (object != null) {
                    return (ConnectivityManager)object;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
        });
        this.networkStatus = FlowKt.callbackFlow((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NetworkConnectionTracker this$0;
            {
                this.this$0 = networkConnectionTracker;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                    return Unit.INSTANCE;
                } else {
                    Function0<Unit> function0;
                    ConnectivityManager.NetworkCallback networkCallback2;
                    ResultKt.throwOnFailure((Object)object);
                    ProducerScope producerScope = (ProducerScope)this.L$0;
                    ConnectivityManager.NetworkCallback networkCallback3 = networkCallback2;
                    networkCallback2 = new ConnectivityManager.NetworkCallback((ProducerScope<? super Boolean>)producerScope){
                        final /* synthetic */ ProducerScope<Boolean> $$this$callbackFlow;
                        {
                            this.$$this$callbackFlow = producerScope;
                        }

                        public void onAvailable(@NotNull Network network) {
                            networkStatus.networkCallback.1 v0 = this;
                            Network network2 = network;
                            Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
                            super.onAvailable(network2);
                            v0.$$this$callbackFlow.trySend-JP2dKIU((Object)Boolean.TRUE);
                        }

                        public void onLost(@NotNull Network network) {
                            networkStatus.networkCallback.1 v0 = this;
                            Network network2 = network;
                            Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
                            super.onLost(network2);
                            v0.$$this$callbackFlow.trySend-JP2dKIU((Object)Boolean.FALSE);
                        }
                    };
                    NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
                    if (Build.VERSION.SDK_INT >= 24) {
                        NetworkConnectionTracker.access$getConnectivityManager(this.this$0).registerDefaultNetworkCallback(networkCallback3);
                    } else {
                        NetworkConnectionTracker.access$getConnectivityManager(this.this$0).registerNetworkCallback(networkRequest, networkCallback3);
                    }
                    Function0<Unit> function02 = function0;
                    function0 = new Function0<Unit>(this.this$0, networkCallback3){
                        final /* synthetic */ NetworkConnectionTracker this$0;
                        final /* synthetic */ networkStatus.networkCallback.1 $networkCallback;
                        {
                            this.this$0 = networkConnectionTracker;
                            this.$networkCallback = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            NetworkConnectionTracker.access$getConnectivityManager(this.this$0).unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.$networkCallback);
                        }
                    };
                    this.label = 1;
                    if (ProduceKt.awaitClose((ProducerScope)producerScope, (Function0)function02, (Continuation)this) != object2) return Unit.INSTANCE;
                    return object2;
                }
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                new /* invalid duplicate definition of identical inner class */.L$0 = object;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Boolean> producerScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(producerScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.connectivityManager$delegate.getValue();
    }

    public static final /* synthetic */ ConnectivityManager access$getConnectivityManager(NetworkConnectionTracker networkConnectionTracker) {
        return networkConnectionTracker.getConnectivityManager();
    }

    @NotNull
    public final Flow<Boolean> getNetworkStatus() {
        return this.networkStatus;
    }
}

