/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.OtherUtilsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayerUI;
import io.streamlayer.sdk.databinding.SlrItemNotificationArrivingFriendBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationChatBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCreateNewWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsBannerBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$showAnimate$lambda-8$;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.main.notifications.predictions.MastersKt;
import io.streamlayer.sdk.main.notifications.predictions.NativeKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u000b\u001d\u001e\u001f !\"#$%&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "resources", "Landroid/content/res/Resources;", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;Landroid/content/res/Resources;)V", "bottomMargin", "", "notificationViewsPool", "Ljava/util/LinkedList;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "overlayHeight", "getOverlayHeight", "()I", "setOverlayHeight", "(I)V", "startMargin", "touchListenerProvider", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$TouchListenerProvider;", "addToPool", "", "view", "clearPool", "parent", "Landroid/view/ViewGroup;", "getNotificationView", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "BaseNotificationView", "NotificationArrivingFriendView", "NotificationChatView", "NotificationCreateNewWatchPartyView", "NotificationCustomViewHolder", "NotificationFriendJoinToChatView", "NotificationPredictionsBannerView", "NotificationTouchListener", "NotificationView", "NotificationWatchPartyView", "TouchListenerProvider", "sdk_originalVoximplantRelease"})
public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final Resources resources;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private final int bottomMargin;
    private final int startMargin;
    private int overlayHeight;
    @NotNull
    private final TouchListenerProvider touchListenerProvider;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2, @NotNull Resources resources) {
        NotificationViewsProvider notificationViewsProvider = this;
        NotificationViewsProvider notificationViewsProvider2 = this;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.listener = notificationViewAction2;
        notificationViewsProvider2.resources = resources;
        notificationViewsProvider2.notificationViewsPool = new LinkedList();
        this.bottomMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        notificationViewsProvider.startMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
        notificationViewsProvider.touchListenerProvider = new TouchListenerProvider();
    }

    public static final /* synthetic */ int access$getStartMargin$p(NotificationViewsProvider notificationViewsProvider) {
        return notificationViewsProvider.startMargin;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification object2) {
        block12: {
            block14: {
                Object object3;
                block11: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
                        Intrinsics.checkNotNullParameter((Object)object2, (String)"notification");
                        object3 = LayoutInflater.from((Context)object.getContext());
                        switch (WhenMappings.$EnumSwitchMapping$1[((Notification)object2).getType().ordinal()]) {
                            default: {
                                if (!NotificationViewsKt.isLikePrediction(((Notification)object2).getType())) break block11;
                            }
                            case 7: {
                                NotificationCustomViewHolder notificationCustomViewHolder;
                                object2 = notificationCustomViewHolder;
                                object = SlrItemNotificationCustomBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                                notificationCustomViewHolder = (NotificationViewsProvider)this.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                                break block12;
                            }
                            case 6: {
                                NotificationPredictionsBannerView notificationPredictionsBannerView;
                                object2 = notificationPredictionsBannerView;
                                object = SlrPredictionsBannerBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationPredictionsBannerView = (NotificationViewsProvider)this.new NotificationPredictionsBannerView((SlrPredictionsBannerBinding)object);
                                break block12;
                            }
                            case 5: {
                                NotificationCreateNewWatchPartyView notificationCreateNewWatchPartyView;
                                object2 = notificationCreateNewWatchPartyView;
                                object = SlrItemNotificationCreateNewWatchPartyBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationCreateNewWatchPartyView = (NotificationViewsProvider)this.new NotificationCreateNewWatchPartyView((SlrItemNotificationCreateNewWatchPartyBinding)object);
                                break block12;
                            }
                            case 4: {
                                NotificationArrivingFriendView notificationArrivingFriendView;
                                object2 = notificationArrivingFriendView;
                                object = SlrItemNotificationArrivingFriendBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationArrivingFriendView = (NotificationViewsProvider)this.new NotificationArrivingFriendView((SlrItemNotificationArrivingFriendBinding)object);
                                break block12;
                            }
                            case 3: {
                                NotificationWatchPartyView notificationWatchPartyView;
                                object2 = notificationWatchPartyView;
                                object = SlrItemNotificationWatchPartyBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationWatchPartyView = (NotificationViewsProvider)this.new NotificationWatchPartyView((SlrItemNotificationWatchPartyBinding)object);
                                break block12;
                            }
                            case 2: {
                                NotificationChatView notificationChatView;
                                object2 = notificationChatView;
                                object = SlrItemNotificationChatBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationChatView = (NotificationViewsProvider)this.new NotificationChatView((SlrItemNotificationChatBinding)object);
                                break block12;
                            }
                            case 1: {
                                NotificationFriendJoinToChatView notificationFriendJoinToChatView;
                                object2 = notificationFriendJoinToChatView;
                                object = SlrItemNotificationBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                                notificationFriendJoinToChatView = (NotificationViewsProvider)this.new NotificationFriendJoinToChatView((SlrItemNotificationBinding)object);
                                break block12;
                            }
                            {
                                object3 = StreamLayerUI.INSTANCE.getCustomTheme$sdk_originalVoximplantRelease().getNotificationsStyle();
                                if ((object3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object3.ordinal()]) != 1) break block13;
                            }
                        }
                        object2 = this = NativeKt.createPredictionsNotificationNative(((Notification)object2).getType(), object, ((NotificationViewsProvider)this).touchListenerProvider);
                        break block14;
                    }
                    object2 = this = MastersKt.createPredictionsNotificationMasters(((Notification)object2).getType(), object, ((NotificationViewsProvider)this).touchListenerProvider);
                    break block14;
                }
                if (((NotificationViewsProvider)this).notificationViewsPool.isEmpty()) {
                    NotificationView notificationView;
                    object2 = notificationView;
                    object = SlrItemNotificationBinding.inflate(object3, object, false);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                    notificationView = (NotificationViewsProvider)this.new NotificationView((SlrItemNotificationBinding)object);
                } else {
                    object2 = this = ((NotificationViewsProvider)this).notificationViewsPool.removeFirst();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                if (no\u2026          }\n            }");
        }
        return object2;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$TouchListenerProvider;", "", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "provide", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class TouchListenerProvider {
        @NotNull
        public final NotificationTouchListener provide(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            return new NotificationTouchListener(notification);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Landroid/view/View$OnTouchListener;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/Notification;)V", "dY", "", "getNotification", "()Lio/streamlayer/sdk/model/notifications/Notification;", "swipeThreshold", "y1", "y2", "onTouch", "", "view", "Landroid/view/View;", "motionEvent", "Landroid/view/MotionEvent;", "sdk_originalVoximplantRelease"})
    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        if (NotificationViewsKt.access$isClickable(this.notification)) {
                            NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                        }
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "isPortrait", "", "()Z", "isPortrait$delegate", "Lkotlin/Lazy;", "getLandscapeWidth", "", "prepareView", "", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "setConstraintParams", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "showAnimate", "onEnd", "Lkotlin/Function0;", "sdk_originalVoximplantRelease"})
    public abstract class BaseNotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final Lazy isPortrait$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BaseNotificationView this$0;
            {
                this.this$0 = baseNotificationView;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Context context = this.this$0.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                return OtherExtensionsKt.isScreenPortrait(context);
            }
        });

        private static final void prepareView$lambda-1(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, NotificationViewsProvider notificationViewsProvider) {
            BaseNotificationView baseNotificationView2 = baseNotificationView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"$parent");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            View view2 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewExtensionsKt.invisible(view2);
            View view3 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
                layoutParams.width = n;
                view3.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimate$lambda-8$lambda-4(View view2, ValueAnimator object) {
            View view3 = view2;
            Intrinsics.checkNotNullParameter((Object)view3, (String)"$view");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                if ((object = object.getAnimatedValue()) != null) {
                    layoutParams.width = (Integer)object;
                    view2.setLayoutParams(layoutParams);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        protected final boolean isPortrait() {
            return (Boolean)this.isPortrait$delegate.getValue();
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> BaseNotificationView.prepareView$lambda-1(this, constraintLayout, NotificationViewsProvider.this));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), (float)ViewExtensionsKt.getDp(3.0f));
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n, NotificationViewsProvider.this.bottomMargin);
        }

        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            BaseNotificationView baseNotificationView = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            View view2 = baseNotificationView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : ((BaseNotificationView)((Object)notificationViewsProvider)).getLandscapeWidth();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
            NotificationViewsProvider notificationViewsProvider = ((BaseNotificationView)((Object)notificationViewsProvider)).NotificationViewsProvider.this;
            valueAnimator.setDuration(400L);
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.addUpdateListener(arg_0 -> BaseNotificationView.showAnimate$lambda-8$lambda-4(view2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"");
            valueAnimator.addListener(new Animator.AnimatorListener(view2){
                final /* synthetic */ View $view$inlined;
                {
                    this.$view$inlined = view2;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    BaseNotificationView$showAnimate$lambda-8$$inlined$doOnStart$1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    ViewExtensionsKt.visible(v0.$view$inlined);
                    v0.$view$inlined.animate().alpha(1.0f).translationX(-20.0f).setStartDelay(200L).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(this.$view$inlined){
                        final /* synthetic */ View $view;
                        {
                            this.$view = view2;
                        }

                        public final void run() {
                            this.$view.animate().translationX(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                        }
                    }).start();
                }
            });
            valueAnimator.addListener(new Animator.AnimatorListener(view2, function0, notificationViewsProvider){
                final /* synthetic */ View $view$inlined;
                final /* synthetic */ Function0 $onEnd$inlined;
                final /* synthetic */ NotificationViewsProvider this$0;
                {
                    this.$view$inlined = view2;
                    this.$onEnd$inlined = function0;
                    this.this$0 = notificationViewsProvider;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    animator = this.$view$inlined;
                    ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                    if (layoutParams != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                        int n = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n2 = marginLayoutParams.topMargin;
                        int n3 = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n4 = marginLayoutParams.bottomMargin;
                        marginLayoutParams.setMargins(n, n2, n3, n4);
                        animator.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                        Function0 function0 = this.$onEnd$inlined;
                        if (function0 != null) {
                            function0.invoke();
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }
            });
            valueAnimator.start();
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }

        @Override
        public void hideAnimate(@Nullable Function0<Unit> function0) {
            NotificationsLayout.BaseNotificationView.DefaultImpls.hideAnimate(this, function0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationChatView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationChatBinding binding;

        public NotificationChatView(SlrItemNotificationChatBinding slrItemNotificationChatBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationChatBinding, (String)"binding");
            this.binding = slrItemNotificationChatBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationChatBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationChatView notificationChatView = slrItemNotificationChatBinding;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationChatBinding slrItemNotificationChatBinding = notificationChatView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationChatView.NotificationViewsProvider.this;
            SlrItemNotificationChatBinding slrItemNotificationChatBinding2 = slrItemNotificationChatBinding;
            slrItemNotificationChatBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationChatBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            notificationChatView.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationWatchPartyView(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            this.binding = slrItemNotificationWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            SpannableString spannableString;
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.NotificationViewsProvider.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            CharSequence[] charSequenceArray = new CharSequence[2];
            charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)(notification.getTitle() + ' ')));
            Object object = spannableString;
            spannableString = new SpannableString((CharSequence)slrItemNotificationWatchPartyBinding.getRoot().getContext().getString(R.string.slr_invited_you_to_a_watch_party));
            charSequenceArray[1] = object;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText(TextUtils.concat((CharSequence[])charSequenceArray));
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            try {
                AppCompatTextView appCompatTextView = slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV;
                Context context = slrItemNotificationWatchPartyBinding.getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
                appCompatTextView.setTextColor(ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_twitter));
            }
            catch (Exception exception) {
                SLRLog.INSTANCE.d("NotificationsLayout", "WP text error");
            }
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                object = notification.getNotificationIcon();
                object = object != null ? ((NotificationIcon)object).getAvatarUrl() : null;
                Object object2 = notification.getNotificationIcon();
                object2 = object2 != null ? ((NotificationIcon)object2).getAvatarName() : null;
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, null, 2.28f, null, 44, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.clear((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "clear", "getColor", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getIcon", "setPadding", "Landroid/view/View;", "sdk_originalVoximplantRelease"})
    public class NotificationView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            this.binding = slrItemNotificationBinding;
        }

        private final void setPadding(View view2, NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    n = 0;
                    break;
                }
                case 9: 
                case 17: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 18: {
                    n = 0;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n = 17170445;
                    break;
                }
                case 9: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_orange;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 2: {
                    Context context = this.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    n = ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_primaryBlue);
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public static final /* synthetic */ void access$setPadding(NotificationView notificationView, View view2, NotificationType notificationType) {
            notificationView.setPadding(view2, notificationType);
        }

        public static final /* synthetic */ int access$getIcon(NotificationView notificationView, NotificationType notificationType) {
            return notificationView.getIcon(notificationType);
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = notification.getDescription();
            boolean bl2 = object == null || object.length() == 0;
            bl2 ^= true;
            Object object2 = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifTitleTV");
            ViewGroup.LayoutParams layoutParams = object2.getLayoutParams();
            if (layoutParams != null) {
                layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                int n = bl2 ? 0 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.topToTop = n;
                n = bl2 ? ViewExtensionsKt.getDp(4.0f) : 0;
                layoutParams.topMargin = n;
                n = bl2 ? -1 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.bottomToBottom = n;
                object2.setLayoutParams(layoutParams);
                AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifDescriptionTV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifDescriptionTV");
                ViewExtensionsKt.visibleIf((View)appCompatTextView, bl2);
                Object object3 = notification.getNotificationIcon();
                if (object3 != null) {
                    if (((NotificationIcon)object3).getAvatarName() != null) {
                        object2 = slrItemNotificationBinding.slNotifIconIV;
                        NotificationIcon notificationIcon = object3;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = notificationIcon.getAvatarUrl();
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object2, (String)object3, notificationIcon.getAvatarName(), null, null, 0.0f, null, 60, null);
                    } else if (((NotificationIcon)object3).getAvatarUrl() != null) {
                        Function1<Boolean, Unit> function1;
                        AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                        object2 = appCompatImageView;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = ((NotificationIcon)object3).getAvatarUrl();
                        Intrinsics.checkNotNull((Object)object3);
                        object2 = this.getIcon(notification.getType());
                        Object object4 = object3;
                        object3 = function1;
                        function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                            final /* synthetic */ NotificationView this$0;
                            final /* synthetic */ SlrItemNotificationBinding $this_with;
                            final /* synthetic */ Notification $data;
                            {
                                this.this$0 = notificationView;
                                this.$this_with = slrItemNotificationBinding;
                                this.$data = notification;
                                super(1);
                            }

                            public final void invoke(boolean bl) {
                                if (!bl) {
                                    AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                    NotificationView.access$setPadding(this.this$0, (View)appCompatImageView, this.$data.getType());
                                }
                            }
                        };
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object4, false, (Integer)object2, (Function1)object3, 2, null);
                    }
                    slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                } else {
                    SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"");
                    CoilExtensionsKt.clear((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(@NotNull ImageView imageView2) {
                            Intrinsics.checkNotNullParameter((Object)imageView2, (String)"$this$clear");
                            imageView2.setImageResource(NotificationView.access$getIcon(this.this$0, this.$data.getType()));
                        }
                    });
                    this.setPadding((View)slrItemNotificationBinding, notification.getType());
                    slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                  \u2026      }\n                }");
                }
                this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Universal.ordinal()] = 1;
                nArray[NotificationType.Chat.ordinal()] = 2;
                nArray[NotificationType.Twitter.ordinal()] = 3;
                nArray[NotificationType.Alert.ordinal()] = 4;
                nArray[NotificationType.Inplay.ordinal()] = 5;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 6;
                nArray[NotificationType.JoinToChat.ordinal()] = 7;
                nArray[NotificationType.WaveReply.ordinal()] = 8;
                nArray[NotificationType.CreateNewWatchParty.ordinal()] = 9;
                nArray[NotificationType.Poll.ordinal()] = 10;
                nArray[NotificationType.Trivia.ordinal()] = 11;
                nArray[NotificationType.Prediction.ordinal()] = 12;
                nArray[NotificationType.PredictionResult.ordinal()] = 13;
                nArray[NotificationType.PredictionOnboarding.ordinal()] = 14;
                nArray[NotificationType.Factoid.ordinal()] = 15;
                nArray[NotificationType.FactoidTweet.ordinal()] = 16;
                nArray[NotificationType.WatchParty.ordinal()] = 17;
                nArray[NotificationType.Custom.ordinal()] = 18;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationArrivingFriendView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationArrivingFriendBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationArrivingFriendBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationArrivingFriendBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationArrivingFriendView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationArrivingFriendBinding binding;

        public NotificationArrivingFriendView(SlrItemNotificationArrivingFriendBinding slrItemNotificationArrivingFriendBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationArrivingFriendBinding, (String)"binding");
            this.binding = slrItemNotificationArrivingFriendBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationArrivingFriendBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationArrivingFriendView notificationArrivingFriendView = slrItemNotificationArrivingFriendBinding;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationArrivingFriendBinding slrItemNotificationArrivingFriendBinding = notificationArrivingFriendView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationArrivingFriendView.NotificationViewsProvider.this;
            slrItemNotificationArrivingFriendBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            notificationArrivingFriendView.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCreateNewWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationCreateNewWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCreateNewWatchPartyBinding binding;

        public NotificationCreateNewWatchPartyView(SlrItemNotificationCreateNewWatchPartyBinding slrItemNotificationCreateNewWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCreateNewWatchPartyBinding, (String)"binding");
            this.binding = slrItemNotificationCreateNewWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCreateNewWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFriendJoinToChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "bind", "", "item", "Lio/streamlayer/sdk/model/notifications/Notification;", "prepareView", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "setConstraintParams", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "showAnimate", "onEnd", "Lkotlin/Function0;", "sdk_originalVoximplantRelease"})
    public final class NotificationFriendJoinToChatView
    extends NotificationView {
        public NotificationFriendJoinToChatView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(slrItemNotificationBinding);
        }

        private static final void showAnimate$lambda-2(NotificationFriendJoinToChatView notificationFriendJoinToChatView) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView;
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView2, (String)"this$0");
            ConstraintLayout constraintLayout = notificationFriendJoinToChatView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout);
        }

        private static final void prepareView$lambda-5(NotificationFriendJoinToChatView notificationFriendJoinToChatView, NotificationViewsProvider notificationViewsProvider) {
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            notificationFriendJoinToChatView = notificationFriendJoinToChatView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationFriendJoinToChatView, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = notificationFriendJoinToChatView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_overlay_content_landscape_width) - ViewExtensionsKt.getDp(12.0f);
                notificationFriendJoinToChatView.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        @Override
        public void bind(@NotNull Notification object) {
            StyleSpan styleSpan;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = notificationFriendJoinToChatView2;
            Notification notification = object;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"item");
            super.bind(notification);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
            object = styleSpan;
            styleSpan = new StyleSpan(1);
            int n = spannableStringBuilder.length();
            spannableStringBuilder.append((CharSequence)((Notification)object).getTitle());
            int n2 = spannableStringBuilder.length();
            spannableStringBuilder.setSpan(object, n, n2, 17);
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = spannableStringBuilder.append((CharSequence)("" + ' ' + notificationFriendJoinToChatView2.NotificationViewsProvider.this.resources.getText(R.string.slr_messaging_chat_friend_joined_template)));
            object = notificationFriendJoinToChatView.getBinding();
            ((SlrItemNotificationBinding)object).slNotifTitleTV.setText((CharSequence)((Object)notificationFriendJoinToChatView2));
            ((SlrItemNotificationBinding)object).getRoot().setOnTouchListener(null);
            ((SlrItemNotificationBinding)object).slNotification.setBackground(ContextCompat.getDrawable((Context)((SlrItemNotificationBinding)object).getRoot().getContext(), (int)R.drawable.slr_bg_notification_friend_arrived));
            ((SlrItemNotificationBinding)object).slNotifIconIV.setBackground(null);
            ((SlrItemNotificationBinding)object).slNotifTitleTV.setTextColor(ContextCompat.getColor((Context)((SlrItemNotificationBinding)object).getRoot().getContext(), (int)R.color.slr_white));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().animate().translationX(0.0f).setDuration(400L).withStartAction(() -> NotificationFriendJoinToChatView.showAnimate$lambda-2(this)).start();
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            constraintSet.setTranslationX(this.getBinding().getRoot().getId(), (float)constraintLayout.getWidth());
            if (this.isPortrait()) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(75.0f));
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            } else {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(60.0f));
            }
            NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = this;
            ConstraintLayout constraintLayout2 = constraintLayout;
            Intrinsics.checkNotNullParameter((Object)constraintLayout2, (String)"parent");
            super.prepareView(constraintLayout2);
            if (!notificationFriendJoinToChatView.isPortrait()) {
                NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = this;
                this.getBinding().getRoot().post(() -> NotificationFriendJoinToChatView.prepareView$lambda-5(notificationFriendJoinToChatView2, notificationFriendJoinToChatView2.NotificationViewsProvider.this));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsBannerView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "getLandscapeWidth", "", "setConstraintParams", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "sdk_originalVoximplantRelease"})
    public final class NotificationPredictionsBannerView
    extends BaseNotificationView {
        @NotNull
        private final SlrPredictionsBannerBinding binding;

        public NotificationPredictionsBannerView(SlrPredictionsBannerBinding slrPredictionsBannerBinding) {
            Intrinsics.checkNotNullParameter((Object)slrPredictionsBannerBinding, (String)"binding");
            this.binding = slrPredictionsBannerBinding;
        }

        @Override
        @NotNull
        public SlrPredictionsBannerBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_onboarding_landscape_width);
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout object, @NotNull ConstraintSet constraintSet) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            NotificationPredictionsBannerView notificationPredictionsBannerView2 = this;
            Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            object = notificationPredictionsBannerView2.NotificationViewsProvider.this;
            constraintSet.setTranslationZ(notificationPredictionsBannerView2.getBinding().getRoot().getId(), 30.0f);
            int n = notificationPredictionsBannerView.getBinding().getRoot().getId();
            int n2 = notificationPredictionsBannerView.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
            NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n3 = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n3, ((NotificationViewsProvider)object).bottomMargin);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCustomViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
    public final class NotificationCustomViewHolder
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            Object object = notificationCustomViewHolder.getBinding().getRoot().getContext();
            NotificationBuilder notificationBuilder = notification.getCustomBuilder();
            if (notificationBuilder != null) {
                NotificationViewsProvider notificationViewsProvider = notificationCustomViewHolder.NotificationViewsProvider.this;
                Object object2 = LayoutInflater.from((Context)object);
                if (notificationBuilder.getLayoutId() != null) {
                    Integer n = notificationBuilder.getLayoutId();
                    Intrinsics.checkNotNull((Object)n);
                    object = object2.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                } else {
                    object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                    object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                    object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                    Integer n = notificationBuilder.getIconBackgroundColor();
                    if (n != null) {
                        int n2 = n;
                        object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                    }
                    if ((object = notificationBuilder.getIconUrl()) != null) {
                        AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                    }
                    object = notificationCustomViewHolder.getBinding().getRoot();
                }
                Context context = object;
                notificationCustomViewHolder.getBinding().getRoot().addView((View)object);
                context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                NotificationCustomViewHolder notificationCustomViewHolder = context.getLayoutParams();
                if (notificationCustomViewHolder != null) {
                    Object object3 = object;
                    notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
                    v4.gravity = 80;
                    object3.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"view");
                    notificationBuilder.bindView((View)object);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StreamLayerUI.NotificationsStyle.values().length];
            nArray[StreamLayerUI.NotificationsStyle.DESIGN_NUMBER_TWO.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[NotificationType.values().length];
            nArray2[NotificationType.JoinToChat.ordinal()] = 1;
            nArray2[NotificationType.Chat.ordinal()] = 2;
            nArray2[NotificationType.WatchParty.ordinal()] = 3;
            nArray2[NotificationType.ArrivingFriend.ordinal()] = 4;
            nArray2[NotificationType.CreateNewWatchParty.ordinal()] = 5;
            nArray2[NotificationType.PredictionOnboarding.ordinal()] = 6;
            nArray2[NotificationType.Custom.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

