/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlayStatistics;
import io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlayStatisticsDetails;
import io.streamlayer.sdk.statistics.baseball.DetailsItem;
import io.streamlayer.sdk.statistics.baseball.HeaderItem;
import io.streamlayer.sdk.statistics.baseball.PlayByPlayItem;
import io.streamlayer.sdk.statistics.baseball.SummaryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "()V", "data", "", "Lio/streamlayer/sdk/statistics/baseball/PlayByPlayItem;", "summary", "Lio/streamlayer/sdk/model/sports/EventSummary;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "statistics", "Lio/streamlayer/sdk/model/sports/baseball/BaseballPlayByPlayStatistics;", "setSummary", "eventSummary", "DetailsViewHolder", "HeaderViewHolder", "SummaryViewHolder", "sdk_originalVoximplantRelease"})
public final class BaseballPlayByPlayAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @Nullable
    private EventSummary summary;
    @NotNull
    private List<? extends PlayByPlayItem> data = CollectionsKt.emptyList();

    public final void setSummary(@NotNull EventSummary eventSummary2) {
        EventSummary eventSummary3 = eventSummary2;
        Intrinsics.checkNotNullParameter((Object)eventSummary3, (String)"eventSummary");
        this.summary = eventSummary3;
        if (this.data.isEmpty() ^ true) {
            this.notifyDataSetChanged();
        }
    }

    public final void setData(@NotNull List<BaseballPlayByPlayStatistics> arrayList) {
        ArrayList<? extends PlayByPlayItem> arrayList2;
        ArrayList<? extends PlayByPlayItem> arrayList3 = arrayList;
        Intrinsics.checkNotNullParameter(arrayList3, (String)"statistics");
        arrayList = arrayList2;
        arrayList2 = new ArrayList<PlayByPlayItem>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            SummaryItem summaryItem;
            ArrayList arrayList4;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics2 = baseballPlayByPlayStatistics = (BaseballPlayByPlayStatistics)iterator.next();
            Object object = baseballPlayByPlayStatistics2.getTeam();
            Object object2 = baseballPlayByPlayStatistics2.getInning();
            Object object3 = baseballPlayByPlayStatistics2.getPlayText();
            arrayList.add(new HeaderItem((EventTeam)object, (String)object2, (String)object3));
            object = baseballPlayByPlayStatistics.getDetails();
            object2 = arrayList4;
            arrayList4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (BaseballPlayByPlayStatisticsDetails)object.next();
                object2.add(new DetailsItem((BaseballPlayByPlayStatisticsDetails)object3));
            }
            ArrayList<? extends PlayByPlayItem> arrayList5 = arrayList;
            arrayList5.addAll((Collection<? extends PlayByPlayItem>)object2);
            object = summaryItem;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics3 = baseballPlayByPlayStatistics;
            int n = baseballPlayByPlayStatistics3.getRuns();
            int n2 = baseballPlayByPlayStatistics3.getErrors();
            int n3 = baseballPlayByPlayStatistics3.getHits();
            summaryItem = new SummaryItem(n, n2, n3);
            arrayList5.add((PlayByPlayItem)object);
        }
        this.data = arrayList;
        if (this.summary != null) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            if (n != 1) {
                SummaryViewHolder summaryViewHolder;
                if (n != 2) throw new RuntimeException("Unsupported viewType: " + n);
                viewHolder = summaryViewHolder;
                summaryViewHolder = new SummaryViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_summary));
                return viewHolder;
            } else {
                DetailsViewHolder detailsViewHolder;
                viewHolder = detailsViewHolder;
                detailsViewHolder = new DetailsViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_detail));
            }
            return viewHolder;
        } else {
            HeaderViewHolder headerViewHolder;
            viewHolder = headerViewHolder;
            headerViewHolder = new HeaderViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_header));
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        return this.data.get(n).getViewType();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof HeaderViewHolder && object instanceof HeaderItem) {
            ((HeaderViewHolder)viewHolder).bind((HeaderItem)object);
        } else if (viewHolder instanceof DetailsViewHolder && object instanceof DetailsItem) {
            ((DetailsViewHolder)viewHolder).bind((DetailsItem)object);
        } else if (viewHolder instanceof SummaryViewHolder && object instanceof SummaryItem) {
            ((SummaryViewHolder)viewHolder).bind((SummaryItem)object);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter$HeaderViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "item", "Lio/streamlayer/sdk/statistics/baseball/HeaderItem;", "sdk_originalVoximplantRelease"})
    public final class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull HeaderItem object) {
            HeaderViewHolder headerViewHolder = headerViewHolder2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"item");
            HeaderViewHolder headerViewHolder2 = headerViewHolder.itemView;
            BaseballPlayByPlayAdapter baseballPlayByPlayAdapter = headerViewHolder.BaseballPlayByPlayAdapter.this;
            HeaderViewHolder headerViewHolder3 = headerViewHolder2;
            ImageView imageView2 = (ImageView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayTeamLogo);
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slBaseballPlayByPlayTeamLogo");
            ViewExtensionsKt.loadUrl$default(imageView2, ((HeaderItem)object).getTeam().getLogo(), false, null, null, 12, null);
            ((TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayTeamName)).setText((CharSequence)headerViewHolder2.getContext().getString(R.string.slr_statistics_baseball_play_by_play_play_team_name, new Object[]{((HeaderItem)object).getTeam().getName(), ((HeaderItem)object).getInning()}));
            ((TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayPlayText)).setText((CharSequence)headerViewHolder2.getContext().getString(R.string.slr_statistics_baseball_play_by_play_play_text, new Object[]{((HeaderItem)object).getPlayText(), ((HeaderItem)object).getTeam().getAlias()}));
            object = (TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayPointsHome);
            Object object2 = baseballPlayByPlayAdapter.summary;
            object2 = object2 != null && (object2 = ((EventSummary)object2).getHomeTeam()) != null ? ((EventTeam)object2).getAlias() : null;
            object.setText((CharSequence)object2);
            headerViewHolder2 = (TextView)headerViewHolder2.findViewById(R.id.slBaseballPlayByPlayPointsAway);
            object = baseballPlayByPlayAdapter.summary;
            object = object != null && (object = ((EventSummary)object).getAwayTeam()) != null ? ((EventTeam)object).getAlias() : null;
            headerViewHolder2.setText((CharSequence)object);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter$DetailsViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "detailsItem", "Lio/streamlayer/sdk/statistics/baseball/DetailsItem;", "sdk_originalVoximplantRelease"})
    public final class DetailsViewHolder
    extends RecyclerView.ViewHolder {
        public DetailsViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull DetailsItem detailsItem) {
            DetailsViewHolder detailsViewHolder = baseballPlayByPlayStatisticsDetails;
            DetailsItem detailsItem2 = detailsItem;
            Intrinsics.checkNotNullParameter((Object)detailsItem2, (String)"detailsItem");
            BaseballPlayByPlayStatisticsDetails baseballPlayByPlayStatisticsDetails = detailsItem2.component1();
            View view2 = detailsViewHolder.itemView;
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPlayText)).setText((CharSequence)baseballPlayByPlayStatisticsDetails.getPlayText());
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPointsHome)).setText((CharSequence)String.valueOf(baseballPlayByPlayStatisticsDetails.getScoreHome()));
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPointsAway)).setText((CharSequence)String.valueOf(baseballPlayByPlayStatisticsDetails.getScoreAway()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter$SummaryViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "summaryItem", "Lio/streamlayer/sdk/statistics/baseball/SummaryItem;", "sdk_originalVoximplantRelease"})
    public final class SummaryViewHolder
    extends RecyclerView.ViewHolder {
        public SummaryViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull SummaryItem summaryItem) {
            Intrinsics.checkNotNullParameter((Object)summaryItem, (String)"summaryItem");
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = summaryItem.getRuns();
            objectArray2[1] = summaryItem.getHits();
            objectArray[2] = summaryItem.getErrors();
            ((TextView)objectArray2.itemView.findViewById(R.id.slBaseballPlayByPlaySummary)).setText((CharSequence)objectArray2.itemView.getContext().getString(R.string.slr_statistics_baseball_play_by_play_summary, objectArray));
        }
    }
}

