/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.basketball.playbyplay;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0014\u0010\u001a\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "()V", "homeTeamId", "", "Ljava/lang/Long;", "items", "", "", "findHomeTeamId", "", "listItems", "", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "getItem", "position", "", "getItemCount", "getItemViewType", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "BasketballPlayByPlayHeaderViewHolder", "BasketballPlayByPlayViewHolder", "Companion", "HeaderItem", "sdk_originalVoximplantRelease"})
public final class BasketballPlayByPlayAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_STATISTIC = 1;
    @Nullable
    private Long homeTeamId;
    @NotNull
    private List<Object> items;

    public BasketballPlayByPlayAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    private final void findHomeTeamId(List<? extends PlayByPlayStatistics> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PlayByPlayStatistics playByPlayStatistics = (PlayByPlayStatistics)object.next();
            if (!playByPlayStatistics.getScoring() || this.homeTeamId != null || playByPlayStatistics.getHomeScore() <= 0) continue;
            this.homeTeamId = playByPlayStatistics.getTeam().getId();
        }
    }

    public final void setItems(@NotNull List<? extends PlayByPlayStatistics> iterator) {
        LinkedHashMap linkedHashMap;
        Iterator<Map.Entry<Integer, List>> iterator2 = iterator;
        Intrinsics.checkNotNullParameter(iterator, (String)"listItems");
        this.items.clear();
        this.findHomeTeamId((List<? extends PlayByPlayStatistics>)((Object)iterator));
        iterator = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        Iterator iterator3 = iterator2.iterator();
        while (iterator3.hasNext()) {
            PlayByPlayStatistics object = (PlayByPlayStatistics)iterator3.next();
            List list2 = (List)((LinkedHashMap)((Object)iterator)).get(object.getEventTime().getPeriod());
            if (list2 == null) {
                ArrayList arrayList;
                list2 = arrayList;
                arrayList = new ArrayList();
            }
            list2.add(object);
            if (((HashMap)((Object)iterator)).containsKey(object.getEventTime().getPeriod())) continue;
            iterator.put(object.getEventTime().getPeriod(), list2);
        }
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            BasketballPlayByPlayAdapter basketballPlayByPlayAdapter = this;
            Map.Entry entry = iterator.next();
            int n = ((Number)entry.getKey()).intValue();
            List list3 = (List)entry.getValue();
            basketballPlayByPlayAdapter.items.add(new HeaderItem(n));
            basketballPlayByPlayAdapter.items.addAll(list3);
        }
        this.notifyDataSetChanged();
    }

    @Nullable
    public final Object getItem(int n) {
        return CollectionsKt.getOrNull(this.items, (int)n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.items.get(n);
                    if (!(object instanceof HeaderItem)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof PlayByPlayStatistics)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported item type at data[" + n + ']');
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof BasketballPlayByPlayHeaderViewHolder) {
            ((BasketballPlayByPlayHeaderViewHolder)viewHolder).bind((HeaderItem)this.items.get(n));
        } else if (viewHolder instanceof BasketballPlayByPlayViewHolder) {
            ((BasketballPlayByPlayViewHolder)viewHolder).bind((PlayByPlayStatistics)this.items.get(n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder;
            if (n != 1) throw new RuntimeException("Unsupported viewType: " + n);
            viewHolder = basketballPlayByPlayViewHolder;
            basketballPlayByPlayViewHolder = new BasketballPlayByPlayViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_basketball_play_by_play));
            return viewHolder;
        } else {
            BasketballPlayByPlayHeaderViewHolder basketballPlayByPlayHeaderViewHolder;
            viewHolder = basketballPlayByPlayHeaderViewHolder;
            basketballPlayByPlayHeaderViewHolder = new BasketballPlayByPlayHeaderViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_basketball_play_by_play_header));
        }
        return viewHolder;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$Companion;", "", "()V", "TYPE_HEADER", "", "TYPE_STATISTIC", "sdk_originalVoximplantRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$HeaderItem;", "", "period", "", "(I)V", "getPeriod", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "sdk_originalVoximplantRelease"})
    public static final class HeaderItem {
        private final int period;

        public HeaderItem(int n) {
            this.period = n;
        }

        public static /* synthetic */ HeaderItem copy$default(HeaderItem headerItem, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = headerItem.period;
            }
            return headerItem.copy(n);
        }

        public final int getPeriod() {
            return this.period;
        }

        public final int component1() {
            return this.period;
        }

        @NotNull
        public final HeaderItem copy(int n) {
            return new HeaderItem(n);
        }

        @NotNull
        public String toString() {
            return "HeaderItem(period=" + this.period + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.period);
        }

        public boolean equals(@Nullable Object object) {
            if (headerItem2 == object) {
                return true;
            }
            if (!(object instanceof HeaderItem)) {
                return false;
            }
            HeaderItem headerItem = headerItem2;
            HeaderItem headerItem2 = (HeaderItem)object;
            return headerItem.period == headerItem2.period;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$BasketballPlayByPlayHeaderViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$HeaderItem;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "data", "sdk_originalVoximplantRelease"})
    public final class BasketballPlayByPlayHeaderViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<HeaderItem> {
        public BasketballPlayByPlayHeaderViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        @Override
        public void bind(@NotNull HeaderItem headerItem) {
            Intrinsics.checkNotNullParameter((Object)headerItem, (String)"data");
            ((TextView)this.itemView.findViewById(R.id.slBasketballPlayByPlayHeaderTV)).setText((CharSequence)this.itemView.getContext().getString(R.string.slr_s_quarter, new Object[]{OtherExtensionsKt.toOrdinalString(headerItem.getPeriod())}));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$BasketballPlayByPlayViewHolder;", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/statistics/common/model/PlayByPlayStatistics;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "data", "formatCurrentScore", "Landroid/text/Spannable;", "context", "Landroid/content/Context;", "formatPlayText", "playTV", "Landroid/widget/TextView;", "scoring", "", "spanText", "text", "", "highlight", "sdk_originalVoximplantRelease"})
    public final class BasketballPlayByPlayViewHolder
    extends GenericAdapter.GenericViewHolder<PlayByPlayStatistics> {
        public BasketballPlayByPlayViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        private final void formatPlayText(TextView textView, boolean bl) {
            if (bl) {
                TextView textView2 = textView;
                textView2.setTypeface(textView2.getTypeface(), 1);
                textView2.setTextColor(ContextCompat.getColor((Context)textView2.getContext(), (int)R.color.slr_amber));
            } else {
                TextView textView3 = textView;
                textView3.setTypeface(textView3.getTypeface(), 0);
                textView3.setTextColor(ContextCompat.getColor((Context)textView3.getContext(), (int)R.color.slr_white_alpha_80));
            }
        }

        private final Spannable formatCurrentScore(PlayByPlayStatistics object, Context context) {
            String string2 = String.format("%d - %d", Arrays.copyOf(new Object[]{object.getHomeScore(), object.getAwayScore()}, 2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            if (object.getScoring()) {
                Long l = BasketballPlayByPlayAdapter.this.homeTeamId;
                long l2 = object.getTeam().getId();
                if (l != null && l == l2) {
                    object = String.format("%d -", Arrays.copyOf(new Object[]{object.getHomeScore()}, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
                } else {
                    object = String.format("- %d", Arrays.copyOf(new Object[]{object.getAwayScore()}, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
                }
                return this.spanText(string2, (String)object, context);
            }
            return new SpannableString((CharSequence)string2);
        }

        private final Spannable spanText(String string2, String string3, Context context) {
            TypefaceSpan typefaceSpan;
            ForegroundColorSpan foregroundColorSpan;
            SpannableString spannableString;
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder = spannableString;
            String string4 = string2;
            String string5 = string2;
            basketballPlayByPlayViewHolder(string2);
            basketballPlayByPlayViewHolder = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.slr_white));
            string2 = typefaceSpan;
            typefaceSpan = new TypefaceSpan("sans-serif-black");
            int n = StringsKt.indexOf$default((CharSequence)string5, (String)string3, (int)0, (boolean)false, (int)6, null);
            int n2 = StringsKt.indexOf$default((CharSequence)string4, (String)string3, (int)0, (boolean)false, (int)6, null) + string3.length();
            spannableString.setSpan((Object)basketballPlayByPlayViewHolder, n, n2, 18);
            spannableString.setSpan((Object)string2, n, n2, 18);
            return spannableString;
        }

        @Override
        public void bind(@NotNull PlayByPlayStatistics playByPlayStatistics) {
            View view2;
            Intrinsics.checkNotNullParameter((Object)playByPlayStatistics, (String)"data");
            View view3 = view2 = basketballPlayByPlayViewHolder2.itemView;
            ImageView imageView2 = (ImageView)view3.findViewById(R.id.slBasketballPlayByPlayTeamLogoIV);
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slBasketballPlayByPlayTeamLogoIV");
            ViewExtensionsKt.loadUrl$default(imageView2, playByPlayStatistics.getTeam().getLogo(), false, null, null, 14, null);
            ((TextView)view3.findViewById(R.id.slBasketballPlayByPlayTimeTV)).setText((CharSequence)playByPlayStatistics.eventTimeFormat());
            ((TextView)view3.findViewById(R.id.slBasketballPlayByPlayInfoTV)).setText((CharSequence)playByPlayStatistics.getPlayText());
            TextView textView = (TextView)view3.findViewById(R.id.slBasketballPlayByPlayInfoTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBasketballPlayByPlayInfoTV");
            basketballPlayByPlayViewHolder2.formatPlayText(textView, playByPlayStatistics.getScoring());
            TextView textView2 = (TextView)view2.findViewById(R.id.slBasketballPlayByPlayScoreTV);
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder = basketballPlayByPlayViewHolder2;
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder2 = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)basketballPlayByPlayViewHolder2), (String)"context");
            textView2.setText((CharSequence)basketballPlayByPlayViewHolder.formatCurrentScore(playByPlayStatistics, (Context)basketballPlayByPlayViewHolder2));
        }
    }
}

