/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.auth.verifyphone;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import io.streamlayer.common.utils.SLRLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J(\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/auth/verifyphone/PhoneNumberFormattingTextWatcher;", "Landroid/text/TextWatcher;", "countryCode", "", "(Ljava/lang/String;)V", "mFormatter", "Lcom/google/i18n/phonenumbers/AsYouTypeFormatter;", "mSelfChange", "", "mStopFormatting", "afterTextChanged", "", "s", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "", "count", "after", "getFormattedNumber", "lastNonSeparator", "", "hasCursor", "hasSeparator", "onTextChanged", "before", "reformat", "cursor", "stopFormatting", "sdk_originalRelease"})
public final class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private boolean mSelfChange;
    private boolean mStopFormatting;
    @NotNull
    private final AsYouTypeFormatter mFormatter;
    @NotNull
    private final String countryCode;

    public PhoneNumberFormattingTextWatcher(@Nullable String string2) {
        if (string2 != null) {
            AsYouTypeFormatter asYouTypeFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(string2);
            Intrinsics.checkNotNullExpressionValue((Object)asYouTypeFormatter, (String)"getInstance().getAsYouTypeFormatter(countryCode)");
            this.mFormatter = asYouTypeFormatter;
            this.countryCode = string2;
            return;
        }
        throw new IllegalArgumentException("Required value was null.".toString());
    }

    private final String reformat(CharSequence charSequence, int n) {
        --n;
        this.mFormatter.clear();
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c3 = charSequence.charAt(i);
            if (PhoneNumberUtils.isNonSeparator((char)c3)) {
                if (c != '\u0000') {
                    this.getFormattedNumber(c, c2 != '\u0000');
                    c2 = c = '\u0000';
                }
                c = c3;
            }
            if (i != n) continue;
            c2 = '\u0001';
        }
        SLRLog.INSTANCE.d("lastNonSeparator", "" + c);
        String string2 = this.getFormattedNumber(c, c2 != '\u0000');
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    private final String getFormattedNumber(char c, boolean bl) {
        Object object;
        if (bl) {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigitAndRememberPosition(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigitAnd\u2026osition(lastNonSeparator)");
        } else {
            object = ((PhoneNumberFormattingTextWatcher)object).mFormatter.inputDigit(c);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mFormatter.inputDigit(\n \u2026astNonSeparator\n        )");
        }
        return object;
    }

    private final void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private final boolean hasSeparator(CharSequence charSequence, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (!PhoneNumberUtils.isNonSeparator((char)charSequence.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void beforeTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n2 > 0 && this.hasSeparator(charSequence, n, n2)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public void onTextChanged(@NotNull CharSequence charSequence, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"s");
        if (!this.mSelfChange && !this.mStopFormatting) {
            if (n3 > 0 && this.hasSeparator(charSequence, n, n3)) {
                this.stopFormatting();
            }
            return;
        }
    }

    public synchronized void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"s");
        if (this.mStopFormatting) {
            boolean bl = editable.length() != 0;
            this.mStopFormatting = bl;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String string2 = this.reformat((CharSequence)editable, Selection.getSelectionEnd((CharSequence)editable));
        if (string2 != null) {
            Editable editable2 = editable;
            this.mSelfChange = true;
            int n = editable.length();
            int n2 = string2.length();
            editable2.replace(0, n, (CharSequence)string2, 0, n2);
            Selection.setSelection((Spannable)editable2, (int)Selection.getSelectionEnd((CharSequence)editable2));
            this.mSelfChange = false;
        }
    }
}

