/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.watchparty;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.calls.WatchPartyType;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicPrivateData;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class WatchPartyDao_Impl
implements WatchPartyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WatchPartyStatus> __insertionAdapterOfWatchPartyStatus;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<WatchPartyStatus> __updateAdapterOfWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateWatchPartyStatusParticipated;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfDeleteTopic;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantsCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatOwnerCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfSetWatchPartyPrivate;
    private final SharedSQLiteStatement __preparedStmtOfHidePublicWatchParties;

    public WatchPartyDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        SharedSQLiteStatement sharedSQLiteStatement8;
        EntityDeletionOrUpdateAdapter<WatchPartyStatus> entityDeletionOrUpdateAdapter;
        EntityInsertionAdapter<WatchPartyStatus> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WatchPartyStatus` (`chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
            }
        };
        this.__insertionAdapterOfWatchPartyStatus = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `WatchPartyStatus` SET `chatId` = ?,`participantStatuses` = ?,`isPrivate` = ?,`isParticipated` = ?,`type` = ? WHERE `chatId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, watchPartyStatus.getChatId());
                }
            }
        };
        this.__updateAdapterOfWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement8;
        sharedSQLiteStatement8 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isParticipated=1 WHERE WatchPartyStatus.chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateWatchPartyStatusParticipated = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WatchPartyStatus WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteTopic = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantsCrossRef = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=? AND chatUserId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantCrossRef = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatOwnerCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatOwnerCrossRef = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetWatchPartyPrivate = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=1 WHERE type =? AND isParticipated=0";
            }
        };
        this.__preparedStmtOfHidePublicWatchParties = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __WatchPartyType_enumToString(WatchPartyType watchPartyType) {
        if (watchPartyType == null) {
            return null;
        }
        int n = 28.$SwitchMap$io$streamlayer$sdk$model$calls$WatchPartyType[watchPartyType.ordinal()];
        if (n != 1) {
            if (n == 2) {
                return "REGULAR";
            }
            throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)watchPartyType));
        }
        return "PUBLIC";
    }

    private WatchPartyType __WatchPartyType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        if (!string2.equals("PUBLIC")) {
            if (string2.equals("REGULAR")) {
                return WatchPartyType.REGULAR;
            }
            throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
        }
        return WatchPartyType.PUBLIC;
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                set2.put((String)arrayMap.keyAt(i), null);
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set2);
                arrayMap.putAll((Map)((Object)set2));
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set2);
                arrayMap.putAll((Map)((Object)set2));
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`bypassId` AS `bypassId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`lastSeenTime` AS `lastSeenTime`,`TinodeContact`.`want` AS `want`,`TinodeContact`.`given` AS `given`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string2 : set2) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string2);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        while (true) {
            TinodeContact tinodeContact;
            Object object;
            Comparable<Long> comparable;
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            Object object2;
            Object object3;
            String string2;
            block53: {
                Access access;
                String string7;
                block57: {
                    block56: {
                        block55: {
                            block54: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block47: {
                                                        block46: {
                                                            block45: {
                                                                block44: {
                                                                    block43: {
                                                                        block42: {
                                                                            block41: {
                                                                                block40: {
                                                                                    block39: {
                                                                                        block38: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                                                            object3 = roomSQLiteQuery.getString(10);
                                                                                            if (!arrayMap4.containsKey(object3)) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block38;
                                                                                            object2 = null;
                                                                                            break block39;
                                                                                        }
                                                                                        object2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block40;
                                                                                    string2 = null;
                                                                                    break block41;
                                                                                }
                                                                                string2 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block42;
                                                                            string6 = null;
                                                                            break block43;
                                                                        }
                                                                        string6 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block44;
                                                                    string5 = null;
                                                                    break block45;
                                                                }
                                                                string5 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block46;
                                                            string4 = null;
                                                            break block47;
                                                        }
                                                        string4 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block48;
                                                    string3 = null;
                                                    break block49;
                                                }
                                                string3 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block50;
                                            comparable = null;
                                            break block51;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block52;
                                    if (!roomSQLiteQuery.isNull(9)) break block52;
                                    object = null;
                                    break block53;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block54;
                                object = null;
                                break block55;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block56;
                        string7 = null;
                        break block57;
                    }
                    string7 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string7);
                object = access2;
            }
            ArrayMap<String, TinodeContact> arrayMap5 = arrayMap;
            String string8 = object3;
            object3 = tinodeContact;
            tinodeContact = new TinodeContact((String)object2, string2, string6, string5, bl, string4, string3, (Date)comparable, (Access)object);
            arrayMap5.put((Object)string8, object3);
        }
        roomSQLiteQuery.close();
        return;
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        RoomSQLiteQuery roomSQLiteQuery;
        block24: {
            int n;
            block23: {
                Set set2 = arrayMap.keySet();
                if (set2.isEmpty()) {
                    return;
                }
                if (arrayMap.size() > 999) {
                    ArrayMap arrayMap2;
                    set2 = arrayMap2;
                    arrayMap2 = new ArrayMap(999);
                    int n2 = 0;
                    int n3 = arrayMap.size();
                    for (int i = 0; i < n3; ++i) {
                        ArrayMap arrayMap3;
                        set2.put((String)arrayMap.keyAt(i), null);
                        if (++n2 != 999) continue;
                        this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set2);
                        arrayMap.putAll((Map)((Object)set2));
                        set2 = arrayMap3;
                        arrayMap3 = new ArrayMap(999);
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set2);
                        arrayMap.putAll((Map)((Object)set2));
                    }
                    return;
                }
                StringBuilder stringBuilder = StringUtil.newStringBuilder();
                stringBuilder.append("SELECT `chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type` FROM `WatchPartyStatus` WHERE `chatId` IN (");
                int n4 = set2.size();
                StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
                stringBuilder.append(")");
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
                n = 1;
                for (String string2 : set2) {
                    if (string2 == null) {
                        roomSQLiteQuery.bindNull(n);
                    } else {
                        roomSQLiteQuery.bindString(n, string2);
                    }
                    ++n;
                }
                roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
                if (n != -1) break block23;
                roomSQLiteQuery.close();
                return;
            }
            while (true) {
                Object object;
                Object object2;
                String string2;
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                if (!roomSQLiteQuery.moveToNext()) break block24;
                                ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
                                object2 = roomSQLiteQuery.getString(n);
                                if (!arrayMap4.containsKey(object2)) continue;
                                if (!roomSQLiteQuery.isNull(0)) break block25;
                                string2 = null;
                                break block26;
                            }
                            string2 = roomSQLiteQuery.getString(0);
                        }
                        if (!roomSQLiteQuery.isNull(1)) break block27;
                        object = null;
                        break block28;
                    }
                    object = roomSQLiteQuery.getString(1);
                }
                object = this.__converters.stringToParticipantStatuses((String)object);
                if (object == null) break;
                boolean bl = roomSQLiteQuery.getInt(2) != 0;
                boolean bl2 = roomSQLiteQuery.getInt(3) != 0;
                ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
                Object object3 = object2;
                object2 = this.__WatchPartyType_stringToEnum(roomSQLiteQuery.getString(4));
                arrayMap5.put(object3, (Object)new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, bl, bl2, (WatchPartyType)((Object)object2)));
            }
            try {
                throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
            }
            catch (Throwable throwable) {
                roomSQLiteQuery.close();
                throw throwable;
            }
        }
        roomSQLiteQuery.close();
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set2);
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set2);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`bypassId` AS `bypassId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`lastSeenTime` AS `lastSeenTime`,`TinodeContact`.`want` AS `want`,`TinodeContact`.`given` AS `given`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string3 : set2) {
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string3);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        while (true) {
            Object object;
            Comparable<Long> comparable;
            String string4;
            String string5;
            boolean bl;
            String string6;
            String string7;
            Object object2;
            ArrayList arrayList;
            String string3;
            block51: {
                Access access;
                String string8;
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block50: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    block41: {
                                                                        block40: {
                                                                            block39: {
                                                                                block38: {
                                                                                    block37: {
                                                                                        block36: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(10));
                                                                                            if (arrayList == null) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block36;
                                                                                            object2 = null;
                                                                                            break block37;
                                                                                        }
                                                                                        object2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block38;
                                                                                    string3 = null;
                                                                                    break block39;
                                                                                }
                                                                                string3 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block40;
                                                                            string7 = null;
                                                                            break block41;
                                                                        }
                                                                        string7 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block42;
                                                                    string6 = null;
                                                                    break block43;
                                                                }
                                                                string6 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block44;
                                                            string5 = null;
                                                            break block45;
                                                        }
                                                        string5 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block46;
                                                    string4 = null;
                                                    break block47;
                                                }
                                                string4 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block48;
                                            comparable = null;
                                            break block49;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block50;
                                    if (!roomSQLiteQuery.isNull(9)) break block50;
                                    object = null;
                                    break block51;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block52;
                                object = null;
                                break block53;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block54;
                        string8 = null;
                        break block55;
                    }
                    string8 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string8);
                object = access2;
            }
            arrayList.add(new TinodeContact((String)object2, string3, string7, string6, bl, string5, string4, (Date)comparable, (Access)object));
        }
        roomSQLiteQuery.close();
        return;
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        RoomSQLiteQuery roomSQLiteQuery;
        block37: {
            int n;
            block36: {
                Set set2 = arrayMap.keySet();
                if (set2.isEmpty()) {
                    return;
                }
                if (arrayMap.size() > 999) {
                    ArrayMap arrayMap2;
                    set2 = arrayMap2;
                    arrayMap2 = new ArrayMap(999);
                    int n2 = 0;
                    int n3 = arrayMap.size();
                    for (int i = 0; i < n3; ++i) {
                        ArrayMap arrayMap3;
                        String string2 = (String)arrayMap.keyAt(i);
                        set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                        if (++n2 != 999) continue;
                        this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set2);
                        set2 = arrayMap3;
                        arrayMap3 = new ArrayMap(999);
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set2);
                    }
                    return;
                }
                StringBuilder stringBuilder = StringUtil.newStringBuilder();
                stringBuilder.append("SELECT `chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
                int n4 = set2.size();
                StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
                stringBuilder.append(")");
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
                n = 1;
                for (String string3 : set2) {
                    if (string3 == null) {
                        roomSQLiteQuery.bindNull(n);
                    } else {
                        roomSQLiteQuery.bindString(n, string3);
                    }
                    ++n;
                }
                roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
                if (n != -1) break block36;
                roomSQLiteQuery.close();
                return;
            }
            while (true) {
                ChatMessage chatMessage;
                ArrayList arrayList;
                String string3;
                block55: {
                    block54: {
                        ChatMessage chatMessage2;
                        Object object;
                        String string4;
                        String string5;
                        String string6;
                        String string7;
                        Comparable<Long> comparable;
                        int n5;
                        String string8;
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                block39: {
                                                                                    block38: {
                                                                                        if (!roomSQLiteQuery.moveToNext()) break block37;
                                                                                        arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n));
                                                                                        if (arrayList == null) continue;
                                                                                        if (!roomSQLiteQuery.isNull(0)) break block38;
                                                                                        string3 = null;
                                                                                        break block39;
                                                                                    }
                                                                                    string3 = roomSQLiteQuery.getString(0);
                                                                                }
                                                                                if (!roomSQLiteQuery.isNull(1)) break block40;
                                                                                string8 = null;
                                                                                break block41;
                                                                            }
                                                                            string8 = roomSQLiteQuery.getString(1);
                                                                        }
                                                                        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                                                        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
                                                                        n5 = roomSQLiteQuery2.getInt(2);
                                                                        if (!roomSQLiteQuery3.isNull(3)) break block42;
                                                                        comparable = null;
                                                                        break block43;
                                                                    }
                                                                    comparable = roomSQLiteQuery.getLong(3);
                                                                }
                                                                RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery;
                                                                comparable = this.__converters.timestampToDate((Long)comparable);
                                                                if (!roomSQLiteQuery4.isNull(4)) break block44;
                                                                string7 = null;
                                                                break block45;
                                                            }
                                                            string7 = roomSQLiteQuery.getString(4);
                                                        }
                                                        if (!roomSQLiteQuery.isNull(5)) break block46;
                                                        string6 = null;
                                                        break block47;
                                                    }
                                                    string6 = roomSQLiteQuery.getString(5);
                                                }
                                                if (!roomSQLiteQuery.isNull(6)) break block48;
                                                string5 = null;
                                                break block49;
                                            }
                                            string5 = roomSQLiteQuery.getString(6);
                                        }
                                        if (!roomSQLiteQuery.isNull(7)) break block50;
                                        string4 = null;
                                        break block51;
                                    }
                                    string4 = roomSQLiteQuery.getString(7);
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block52;
                                object = null;
                                break block53;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        object = this.__converters.stringToChatStatus((String)object);
                        if (object == null) break;
                        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery;
                        chatMessage = chatMessage2;
                        chatMessage2 = new ChatMessage(string3, string8, n5, (Date)comparable, string7, string6, string5, string4, (ChatMessageStatus)((Object)object));
                        if (!roomSQLiteQuery5.isNull(9)) break block54;
                        string3 = null;
                        break block55;
                    }
                    string3 = roomSQLiteQuery.getString(9);
                }
                ChatMessage chatMessage3 = chatMessage;
                chatMessage3.setId(string3);
                arrayList.add(chatMessage3);
            }
            try {
                throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
            }
            catch (Throwable throwable) {
                roomSQLiteQuery.close();
                throw throwable;
            }
        }
        roomSQLiteQuery.close();
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipChatParticipantCrossRefAsioStreamlayerSdkModelMessagingChatParticipantCrossRef(ArrayMap<String, ArrayList<ChatParticipantCrossRef>> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n != 999) continue;
                watchPartyDao_Impl.__fetchRelationshipChatParticipantCrossRefAsioStreamlayerSdkModelMessagingChatParticipantCrossRef((ArrayMap<String, ArrayList<ChatParticipantCrossRef>>)set2);
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                watchPartyDao_Impl.__fetchRelationshipChatParticipantCrossRefAsioStreamlayerSdkModelMessagingChatParticipantCrossRef((ArrayMap<String, ArrayList<ChatParticipantCrossRef>>)set2);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `ChatParticipantCrossRef`.`chatId` AS `chatId`,`ChatParticipantCrossRef`.`chatUserId` AS `chatUserId`,`ChatParticipantCrossRef`.`want` AS `want`,`ChatParticipantCrossRef`.`given` AS `given`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `ChatParticipantCrossRef` ON (_junction.`chatId` = `ChatParticipantCrossRef`.`chatId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        Object object = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (Object object2 : set2) {
            if (object2 == null) {
                object.bindNull(n3);
            } else {
                object.bindString(n3, (String)object2);
            }
            ++n3;
        }
        WatchPartyDao_Impl watchPartyDao_Impl = DBUtil.query((RoomDatabase)watchPartyDao_Impl.__db, (SupportSQLiteQuery)object, (boolean)false, null);
        while (true) {
            Object object3;
            String string3;
            Object object2;
            block32: {
                Access access;
                String string4;
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    block26: {
                                                        if (!watchPartyDao_Impl.moveToNext()) break;
                                                        object = (ArrayList)arrayMap.get((Object)watchPartyDao_Impl.getString(4));
                                                        if (object == null) continue;
                                                        if (!watchPartyDao_Impl.isNull(0)) break block26;
                                                        string3 = null;
                                                        break block27;
                                                    }
                                                    string3 = watchPartyDao_Impl.getString(0);
                                                }
                                                if (!watchPartyDao_Impl.isNull(1)) break block28;
                                                object3 = null;
                                                break block29;
                                            }
                                            object3 = watchPartyDao_Impl.getString(1);
                                        }
                                        if (watchPartyDao_Impl.isNull(0)) break block30;
                                        watchPartyDao_Impl.getString(0);
                                    }
                                    if (!watchPartyDao_Impl.isNull(2)) break block31;
                                    if (!watchPartyDao_Impl.isNull(3)) break block31;
                                    object2 = null;
                                    break block32;
                                }
                                if (!watchPartyDao_Impl.isNull(2)) break block33;
                                object2 = null;
                                break block34;
                            }
                            object2 = watchPartyDao_Impl.getString(2);
                        }
                        if (!watchPartyDao_Impl.isNull(3)) break block35;
                        string4 = null;
                        break block36;
                    }
                    string4 = watchPartyDao_Impl.getString(3);
                }
                Access access2 = access;
                access = new Access((String)object2, string4);
                object2 = access2;
            }
            ((ArrayList)object).add(new ChatParticipantCrossRef(string3, (String)object3, (Access)object2));
        }
        watchPartyDao_Impl.close();
        return;
        catch (Throwable throwable) {
            watchPartyDao_Impl.close();
            throw throwable;
        }
    }

    static /* synthetic */ void access$1400(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap);
    }

    static /* synthetic */ void access$1500(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)arrayMap);
    }

    static /* synthetic */ void access$1600(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1700(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    static /* synthetic */ void access$1800(WatchPartyDao_Impl watchPartyDao_Impl, ArrayMap arrayMap) {
        watchPartyDao_Impl.__fetchRelationshipChatParticipantCrossRefAsioStreamlayerSdkModelMessagingChatParticipantCrossRef((ArrayMap<String, ArrayList<ChatParticipantCrossRef>>)arrayMap);
    }

    @Override
    public Object saveWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                11 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__insertionAdapterOfWatchPartyStatus.insert((Object)watchPartyStatus);
                    v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                12 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__updateAdapterOfWatchPartyStatus.handle((Object)watchPartyStatus);
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchParty(String string2, Continuation<? super Unit> continuation2) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, continuation -> WatchPartyDao.DefaultImpls.deleteWatchParty(this, string2, (Continuation<? super Unit>)continuation), continuation2);
    }

    @Override
    public Object updateWatchPartyStatusParticipated(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                13 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    13 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                13 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchPartyStatus(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                14 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    14 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                14 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteTopic(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                15 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    15 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                15 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantsCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                16 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    16 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                16 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantCrossRef(final String string2, final String string3, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                17 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                n = 2;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    17 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                17 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatOwnerCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                18 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    18 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                18 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setWatchPartyPrivate(final String string2, final boolean bl, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                19 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.acquire();
                supportSQLiteStatement.bindLong(1, (long)bl);
                int n = 2;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    19 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                19 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object hidePublicWatchParties(final WatchPartyType watchPartyType, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                20 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.acquire();
                int n = 1;
                WatchPartyType watchPartyType2 = v0.watchPartyType;
                if (watchPartyType2 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyType2));
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    20 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                20 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Flow<WatchPartyStatus> observeWatchPartyStatus(String stringArray) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "WatchPartyStatus";
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_14;
                        void var4_10;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int n3;
                                block23: {
                                    int n4;
                                    block22: {
                                        block21: {
                                            int n5;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    throw throwable;
                                                }
                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n5)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n5);
                                        }
                                        if (!cursor.isNull(n4)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n4);
                                }
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (object == null) throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
                                if (cursor.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_10, (boolean)var5_14, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                return watchPartyStatus;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getWatchPartyStatus(String string2, Continuation<? super WatchPartyStatus> continuation) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int n3;
                                block23: {
                                    int n4;
                                    block22: {
                                        block21: {
                                            int n5;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    roomSQLiteQuery.release();
                                                    throw throwable;
                                                }
                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n5)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n5);
                                        }
                                        if (!cursor.isNull(n4)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n4);
                                }
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (object == null) throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
                                if (cursor.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return watchPartyStatus;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyRelation(String string2, Continuation<? super WatchPartyRelation> continuation) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block129: {
                    block105: {
                        block107: {
                            block128: {
                                block109: {
                                    block127: {
                                        block126: {
                                            block125: {
                                                block124: {
                                                    block119: {
                                                        block123: {
                                                            block122: {
                                                                block121: {
                                                                    block120: {
                                                                        block118: {
                                                                            block117: {
                                                                                block116: {
                                                                                    block115: {
                                                                                        block114: {
                                                                                            block113: {
                                                                                                block112: {
                                                                                                    block111: {
                                                                                                        block110: {
                                                                                                            block108: {
                                                                                                                block106: {
                                                                                                                    var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                                    var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                                    var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                                    var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                                    var7_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                                    var8_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                                    var9_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                                    var10_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                                    var11_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                                    var12_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                                    var13_28 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                                    var14_30 = v0;
                                                                                                                    v0 = new ArrayMap();
                                                                                                                    var15_31 = v1;
                                                                                                                    v1 = new ArrayMap();
                                                                                                                    var16_32 = v2;
                                                                                                                    v2 = new ArrayMap();
                                                                                                                    var17_33 = v3;
                                                                                                                    v3 = new ArrayMap();
                                                                                                                    var18_34 = v4;
                                                                                                                    try {
                                                                                                                        v4 = new ArrayMap();
                                                                                                                        ** while (var1_1.moveToNext())
                                                                                                                    }
                                                                                                                    catch (Throwable v5) {
                                                                                                                        var1_1.close();
                                                                                                                        roomSQLiteQuery.release();
                                                                                                                        throw v5;
                                                                                                                    }
lbl-1000:
                                                                                                                    // 1 sources

                                                                                                                    {
                                                                                                                        block104: {
                                                                                                                            block103: {
                                                                                                                                v6 = var16_32;
                                                                                                                                v7 = var1_1;
                                                                                                                                v8 = var2_2;
                                                                                                                                v9 = var15_31;
                                                                                                                                v10 = var1_1;
                                                                                                                                v11 = var2_2;
                                                                                                                                var14_30.put((Object)var1_1.getString(var2_2), null);
                                                                                                                                v9.put((Object)v10.getString(v11), null);
                                                                                                                                var19_35 = v7.getString(v8);
                                                                                                                                if ((ArrayList)v6.get(var19_35) != null) break block103;
                                                                                                                                v12 = var16_32;
                                                                                                                                v13 = var19_35;
                                                                                                                                var19_35 = v14;
                                                                                                                                v14 = new ArrayList<E>();
                                                                                                                                v12.put((Object)v13, var19_35);
                                                                                                                            }
                                                                                                                            v15 = var17_33;
                                                                                                                            var19_35 = var1_1.getString(var2_2);
                                                                                                                            if ((ArrayList)v15.get(var19_35) != null) break block104;
                                                                                                                            v16 = var17_33;
                                                                                                                            v17 = var19_35;
                                                                                                                            var19_35 = v18;
                                                                                                                            v18 = new ArrayList<E>();
                                                                                                                            v16.put(v17, var19_35);
                                                                                                                        }
                                                                                                                        v19 = var18_34;
                                                                                                                        var19_35 = var1_1.getString(var2_2);
                                                                                                                        if ((ArrayList)v19.get(var19_35) != null) continue;
                                                                                                                        v20 = var18_34;
                                                                                                                        v21 = var19_35;
                                                                                                                        var19_35 = v22;
                                                                                                                        v22 = new ArrayList<E>();
                                                                                                                        v20.put(v21, var19_35);
                                                                                                                        continue;
                                                                                                                    }
lbl100:
                                                                                                                    // 2 sources

                                                                                                                    v23 = var1_1;
                                                                                                                    v24 = this;
                                                                                                                    v25 = v24;
                                                                                                                    v26 = v24;
                                                                                                                    v27 = v24;
                                                                                                                    v28 = v24;
                                                                                                                    v29 = v24;
                                                                                                                    var1_1.moveToPosition(-1);
                                                                                                                    WatchPartyDao_Impl.access$1400(v26.WatchPartyDao_Impl.this, var14_30);
                                                                                                                    WatchPartyDao_Impl.access$1500(v27.WatchPartyDao_Impl.this, var15_31);
                                                                                                                    WatchPartyDao_Impl.access$1600(v28.WatchPartyDao_Impl.this, var16_32);
                                                                                                                    WatchPartyDao_Impl.access$1700(v29.WatchPartyDao_Impl.this, var17_33);
                                                                                                                    WatchPartyDao_Impl.access$1800(v25.WatchPartyDao_Impl.this, var18_34);
                                                                                                                    if (!v23.moveToFirst()) break block105;
                                                                                                                    if (!var1_1.isNull(var2_2)) break block106;
                                                                                                                    if (!var1_1.isNull(var3_4)) break block106;
                                                                                                                    if (!var1_1.isNull(var4_6)) break block106;
                                                                                                                    if (!var1_1.isNull(var5_9)) break block106;
                                                                                                                    if (!var1_1.isNull(var6_12)) break block106;
                                                                                                                    if (!var1_1.isNull(var7_14)) break block106;
                                                                                                                    if (!var1_1.isNull(var8_17)) break block106;
                                                                                                                    if (!var1_1.isNull(var9_19)) break block106;
                                                                                                                    if (!var1_1.isNull(var10_21)) break block106;
                                                                                                                    if (!var1_1.isNull(var11_22)) break block106;
                                                                                                                    if (!var1_1.isNull(var12_24)) break block106;
                                                                                                                    if (!var1_1.isNull(var13_28)) break block106;
                                                                                                                    var3_5 = null;
                                                                                                                    break block107;
                                                                                                                }
                                                                                                                if (!var1_1.isNull(var2_2)) break block108;
                                                                                                                if (!var1_1.isNull(var3_4)) break block108;
                                                                                                                if (!var1_1.isNull(var4_6)) break block108;
                                                                                                                if (!var1_1.isNull(var5_9)) break block108;
                                                                                                                if (!var1_1.isNull(var6_12)) break block108;
                                                                                                                if (!var1_1.isNull(var7_14)) break block108;
                                                                                                                if (!var1_1.isNull(var8_17)) break block108;
                                                                                                                if (!var1_1.isNull(var9_19)) break block108;
                                                                                                                if (!var1_1.isNull(var10_21)) break block108;
                                                                                                                if (!var1_1.isNull(var11_22)) break block108;
                                                                                                                if (!var1_1.isNull(var12_24)) break block108;
                                                                                                                if (!var1_1.isNull(var13_28)) break block108;
                                                                                                                var3_5 = null;
                                                                                                                break block109;
                                                                                                            }
                                                                                                            if (!var1_1.isNull(var2_2)) break block110;
                                                                                                            var19_35 = null;
                                                                                                            break block111;
                                                                                                        }
                                                                                                        var19_35 = var1_1.getString(var2_2);
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var3_4)) break block112;
                                                                                                    var3_5 = null;
                                                                                                    break block113;
                                                                                                }
                                                                                                var3_5 = var1_1.getString(var3_4);
                                                                                            }
                                                                                            v30 = var1_1;
                                                                                            v31 = var7_14;
                                                                                            v32 = var1_1;
                                                                                            v33 = var6_12;
                                                                                            v34 = var1_1;
                                                                                            v35 = var5_9;
                                                                                            var4_6 = var1_1.getInt(var4_6);
                                                                                            var5_9 = v34.getInt(v35);
                                                                                            var6_12 = v32.getInt(v33);
                                                                                            if (!v30.isNull(v31)) break block114;
                                                                                            var7_15 /* !! */  = null;
                                                                                            break block115;
                                                                                        }
                                                                                        var7_15 /* !! */  = var1_1.getLong(var7_14);
                                                                                    }
                                                                                    v36 = var1_1;
                                                                                    v37 = var8_17;
                                                                                    var7_15 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var7_15 /* !! */ );
                                                                                    if (!v36.isNull(v37)) break block116;
                                                                                    var8_18 /* !! */  = null;
                                                                                    break block117;
                                                                                }
                                                                                var8_18 /* !! */  = var1_1.getLong(var8_17);
                                                                            }
                                                                            v38 = var1_1;
                                                                            v39 = var11_22;
                                                                            v40 = this;
                                                                            v41 = var1_1;
                                                                            v42 = var9_19;
                                                                            var8_18 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var8_18 /* !! */ );
                                                                            var9_19 = v41.getInt(v42);
                                                                            var9_20 = WatchPartyDao_Impl.access$000(v40.WatchPartyDao_Impl.this).intToTopicType(var9_19);
                                                                            if (!v38.isNull(v39)) break block118;
                                                                            if (!var1_1.isNull(var12_24)) break block118;
                                                                            var11_23 = null;
                                                                            break block119;
                                                                        }
                                                                        if (!var1_1.isNull(var11_22)) break block120;
                                                                        var11_23 = null;
                                                                        break block121;
                                                                    }
                                                                    var11_23 = var1_1.getString(var11_22);
                                                                }
                                                                if (!var1_1.isNull(var12_24)) break block122;
                                                                var12_25 = null;
                                                                break block123;
                                                            }
                                                            var12_25 = var1_1.getString(var12_24);
                                                        }
                                                        var20_36 = v43;
                                                        v43 = new Access((String)var11_23, var12_25);
                                                        var11_23 = var20_36;
                                                    }
                                                    if (var1_1.isNull(var13_28)) break block124;
                                                    var12_26 = var1_1.getInt(var13_28) != 0;
                                                    var13_29 = v44;
                                                    v44 = new TopicPrivateData(var12_26);
                                                    break block125;
                                                }
                                                var13_29 = null;
                                            }
                                            v45 = var1_1;
                                            v46 = var10_21;
                                            var12_27 = v47;
                                            v47 = new Topic((String)var19_35, (String)var3_5, var4_6, var5_9, var6_12, (Date)var7_15 /* !! */ , (Date)var8_18 /* !! */ , (Access)var11_23, var9_20, var13_29);
                                            if (!v45.isNull(v46)) break block126;
                                            var3_5 = null;
                                            break block127;
                                        }
                                        var3_5 = var1_1.getString(var10_21);
                                    }
                                    var12_27.setWatchPartyStreamId((String)var3_5);
                                    var3_5 = var12_27;
                                }
                                var4_7 = (ArrayList)var16_32.get((Object)var1_1.getString(var2_2));
                                if (var4_7 != null) ** GOTO lbl291
                                var4_7 = v48;
                                v48 = new ArrayList<E>();
lbl291:
                                // 2 sources

                                if ((var5_10 = (ArrayList)var17_33.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl295
                                var5_10 = v49;
                                v49 = new ArrayList<E>();
lbl295:
                                // 2 sources

                                if ((var6_13 = (ArrayList)var18_34.get((Object)var1_1.getString(var2_2))) != null) break block128;
                                var6_13 = v50;
                                v50 = new ArrayList<E>();
                            }
                            var7_16 = v51;
                            v51 = new ChatRelation((Topic)var3_5, var4_7, var5_10, var6_13);
                            var3_5 = var7_16;
                        }
                        v52 = var15_31;
                        v53 = var1_1;
                        v54 = var2_2;
                        var2_3 = (TinodeContact)var14_30.get((Object)var1_1.getString(var2_2));
                        var4_8 = (WatchPartyStatus)v52.get((Object)v53.getString(v54));
                        var5_11 = v55;
                        v55 = new WatchPartyRelation((ChatRelation)var3_5, var2_3, var4_8);
                        break block129;
                    }
                    var5_11 = null;
                }
                var1_1.close();
                roomSQLiteQuery.release();
                return var5_11;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyOwner(String string2, Continuation<? super String> continuation) {
        Callable<String> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatOwnerCrossRef.chatUserId FROM ChatOwnerCrossRef WHERE ChatOwnerCrossRef.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<String> callable2 = callable;
        callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                Cursor cursor;
                block5: {
                    block4: {
                        cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!cursor.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        if (cursor.isNull(0)) break block4;
                        string2 = cursor.getString(0);
                        break block5;
                    }
                    string2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return string2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isParticipatedInPublicParty(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT WatchPartyStatus.isParticipated FROM WatchPartyStatus WHERE WatchPartyStatus.chatId =?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                Cursor cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    Boolean bl2;
                    if (cursor.moveToFirst()) {
                        boolean bl3 = cursor.getInt(0) != 0;
                        bl2 = bl3;
                    } else {
                        bl2 = Boolean.FALSE;
                    }
                    bl = bl2;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return bl;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Flow<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT `chatId`, `name`, `seq`, `readSeq`, `recvSeq`, `updatedAt`, `touchedAt`, `type`, `watchPartyStreamId`, `want`, `given`, `mute` FROM Topic WHERE type = 1 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatOwnerCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "WatchPartyStatus";
        stringArray[3] = "ChatParticipantCrossRef";
        stringArray[4] = "ChatMessage";
        stringArray[5] = "Topic";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                WatchPartyDao_Impl.access$200(v0.WatchPartyDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(v0.WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = v1;
                v1 = new ArrayMap();
                var3_4 = v2;
                v2 = new ArrayMap();
                var4_5 = v3;
                v3 = new ArrayMap();
                var5_6 = v4;
                v4 = new ArrayMap();
                var6_7 = v5;
                v5 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block98: {
                        block97: {
                            v6 = var4_5;
                            v7 = var1_1;
                            v8 = var3_4;
                            v9 = var1_1;
                            var2_2.put((Object)var1_1.getString(0), null);
                            v8.put((Object)v9.getString(0), null);
                            var7_8 = v7.getString(0);
                            if ((ArrayList)v6.get(var7_8) != null) break block97;
                            v10 = var4_5;
                            v11 = var7_8;
                            var7_8 = v12;
                            v12 = new ArrayList<E>();
                            v10.put(v11, var7_8);
                        }
                        v13 = var5_6;
                        var7_8 = var1_1.getString(0);
                        if ((ArrayList)v13.get(var7_8) != null) break block98;
                        v14 = var5_6;
                        v15 = var7_8;
                        var7_8 = v16;
                        v16 = new ArrayList<E>();
                        v14.put(v15, var7_8);
                    }
                    v17 = var6_7;
                    var7_8 = var1_1.getString(0);
                    if ((ArrayList)v17.get(var7_8) != null) continue;
                    v18 = var6_7;
                    v19 = var7_8;
                    var7_8 = v20;
                    v20 = new ArrayList<E>();
                    v18.put(v19, var7_8);
                    continue;
                }
lbl73:
                // 2 sources

                v21 = this;
                v22 = v21;
                v23 = v21;
                v24 = v21;
                v25 = v21;
                v26 = v21;
                var1_1.moveToPosition(-1);
                WatchPartyDao_Impl.access$1400(v23.WatchPartyDao_Impl.this, var2_2);
                WatchPartyDao_Impl.access$1500(v24.WatchPartyDao_Impl.this, var3_4);
                WatchPartyDao_Impl.access$1600(v25.WatchPartyDao_Impl.this, var4_5);
                WatchPartyDao_Impl.access$1700(v26.WatchPartyDao_Impl.this, var5_6);
                WatchPartyDao_Impl.access$1800(v22.WatchPartyDao_Impl.this, var6_7);
                var7_8 = v27;
                v27 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block100: {
                        block121: {
                            block102: {
                                block120: {
                                    block119: {
                                        block118: {
                                            block117: {
                                                block112: {
                                                    block116: {
                                                        block115: {
                                                            block114: {
                                                                block113: {
                                                                    block111: {
                                                                        block110: {
                                                                            block109: {
                                                                                block108: {
                                                                                    block107: {
                                                                                        block106: {
                                                                                            block105: {
                                                                                                block104: {
                                                                                                    block103: {
                                                                                                        block101: {
                                                                                                            block99: {
                                                                                                                if (!var1_1.isNull(0)) break block99;
                                                                                                                if (!var1_1.isNull(1)) break block99;
                                                                                                                if (!var1_1.isNull(2)) break block99;
                                                                                                                if (!var1_1.isNull(3)) break block99;
                                                                                                                if (!var1_1.isNull(4)) break block99;
                                                                                                                if (!var1_1.isNull(5)) break block99;
                                                                                                                if (!var1_1.isNull(6)) break block99;
                                                                                                                if (!var1_1.isNull(7)) break block99;
                                                                                                                if (!var1_1.isNull(8)) break block99;
                                                                                                                if (!var1_1.isNull(9)) break block99;
                                                                                                                if (!var1_1.isNull(10)) break block99;
                                                                                                                if (!var1_1.isNull(11)) break block99;
                                                                                                                var8_9 = null;
                                                                                                                break block100;
                                                                                                            }
                                                                                                            if (!var1_1.isNull(0)) break block101;
                                                                                                            if (!var1_1.isNull(1)) break block101;
                                                                                                            if (!var1_1.isNull(2)) break block101;
                                                                                                            if (!var1_1.isNull(3)) break block101;
                                                                                                            if (!var1_1.isNull(4)) break block101;
                                                                                                            if (!var1_1.isNull(5)) break block101;
                                                                                                            if (!var1_1.isNull(6)) break block101;
                                                                                                            if (!var1_1.isNull(7)) break block101;
                                                                                                            if (!var1_1.isNull(8)) break block101;
                                                                                                            if (!var1_1.isNull(9)) break block101;
                                                                                                            if (!var1_1.isNull(10)) break block101;
                                                                                                            if (!var1_1.isNull(11)) break block101;
                                                                                                            var8_9 = null;
                                                                                                            break block102;
                                                                                                        }
                                                                                                        if (!var1_1.isNull(0)) break block103;
                                                                                                        var8_9 = null;
                                                                                                        break block104;
                                                                                                    }
                                                                                                    var8_9 = var1_1.getString(0);
                                                                                                }
                                                                                                if (!var1_1.isNull(1)) break block105;
                                                                                                var9_10 = null;
                                                                                                break block106;
                                                                                            }
                                                                                            var9_10 = var1_1.getString(1);
                                                                                        }
                                                                                        v28 = var1_1;
                                                                                        v29 = v28;
                                                                                        v30 = v28;
                                                                                        v31 = v28;
                                                                                        var10_12 = v28.getInt(2);
                                                                                        var11_14 = v29.getInt(3);
                                                                                        var12_16 = v30.getInt(4);
                                                                                        if (!v31.isNull(5)) break block107;
                                                                                        var13_17 /* !! */  = null;
                                                                                        break block108;
                                                                                    }
                                                                                    var13_17 /* !! */  = var1_1.getLong(5);
                                                                                }
                                                                                v32 = var1_1;
                                                                                var13_17 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var13_17 /* !! */ );
                                                                                if (!v32.isNull(6)) break block109;
                                                                                var14_18 /* !! */  = null;
                                                                                break block110;
                                                                            }
                                                                            var14_18 /* !! */  = var1_1.getLong(6);
                                                                        }
                                                                        v33 = var1_1;
                                                                        v34 = this;
                                                                        v35 = var1_1;
                                                                        var14_18 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var14_18 /* !! */ );
                                                                        var15_20 = v35.getInt(7);
                                                                        var15_19 = WatchPartyDao_Impl.access$000(v34.WatchPartyDao_Impl.this).intToTopicType(var15_20);
                                                                        if (!v33.isNull(9)) break block111;
                                                                        if (!var1_1.isNull(10)) break block111;
                                                                        var16_21 = null;
                                                                        break block112;
                                                                    }
                                                                    if (!var1_1.isNull(9)) break block113;
                                                                    var16_21 = null;
                                                                    break block114;
                                                                }
                                                                var16_21 = var1_1.getString(9);
                                                            }
                                                            if (!var1_1.isNull(10)) break block115;
                                                            var17_22 = null;
                                                            break block116;
                                                        }
                                                        var17_22 = var1_1.getString(10);
                                                    }
                                                    var18_25 = v36;
                                                    v36 = new Access((String)var16_21, (String)var17_22);
                                                    var16_21 = var18_25;
                                                }
                                                if (var1_1.isNull(11)) break block117;
                                                var17_23 = var1_1.getInt(11) != 0;
                                                var18_25 = v37;
                                                v37 = new TopicPrivateData(var17_23);
                                                break block118;
                                            }
                                            var18_25 = null;
                                        }
                                        v38 = var1_1;
                                        var17_22 = v39;
                                        v39 = new Topic((String)var8_9, (String)var9_10, var10_12, var11_14, var12_16, (Date)var13_17 /* !! */ , (Date)var14_18 /* !! */ , (Access)var16_21, var15_19, (TopicPrivateData)var18_25);
                                        if (!v38.isNull(8)) break block119;
                                        var8_9 = null;
                                        break block120;
                                    }
                                    var8_9 = var1_1.getString(8);
                                }
                                var17_22.setWatchPartyStreamId((String)var8_9);
                                var8_9 = var17_22;
                            }
                            var9_10 = (ArrayList)var4_5.get((Object)var1_1.getString(0));
                            if (var9_10 != null) ** GOTO lbl260
                            var9_10 = v40;
                            v40 = new ArrayList<E>();
lbl260:
                            // 2 sources

                            if ((var10_11 = (ArrayList)var5_6.get((Object)var1_1.getString(0))) != null) ** GOTO lbl264
                            var10_11 = v41;
                            v41 = new ArrayList<E>();
lbl264:
                            // 2 sources

                            if ((var11_13 = (ArrayList)var6_7.get((Object)var1_1.getString(0))) != null) break block121;
                            var11_13 = v42;
                            v42 = new ArrayList<E>();
                        }
                        var12_15 = v43;
                        v43 = new ChatRelation((Topic)var8_9, (List<TinodeContact>)var9_10, (List<ChatMessage>)var10_11, var11_13);
                        var8_9 = var12_15;
                    }
                    v44 = var7_8;
                    v45 = var3_4;
                    v46 = var1_1;
                    var9_10 = (TinodeContact)var2_2.get((Object)var1_1.getString(0));
                    var10_11 = (WatchPartyStatus)v45.get((Object)v46.getString(0));
                    v44.add(new WatchPartyRelation((ChatRelation)var8_9, (TinodeContact)var9_10, (WatchPartyStatus)var10_11));
                    continue;
                }
lbl286:
                // 2 sources

                v47 = var7_8;
                v48 = this;
                v49 = var1_1;
                WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this).setTransactionSuccessful();
                v49.close();
                {
                    catch (Throwable v50) {
                        WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this).endTransaction();
                        throw v50;
                    }
                }
                WatchPartyDao_Impl.access$200(v48.WatchPartyDao_Impl.this).endTransaction();
                return v47;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyRelation> observeWatchPartyRelation(String stringArray) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[6];
        stringArray = stringArray2;
        stringArray2[0] = "ChatOwnerCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "WatchPartyStatus";
        stringArray2[3] = "ChatParticipantCrossRef";
        stringArray2[4] = "ChatMessage";
        stringArray2[5] = "Topic";
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block129: {
                    block105: {
                        block107: {
                            block128: {
                                block109: {
                                    block127: {
                                        block126: {
                                            block125: {
                                                block124: {
                                                    block119: {
                                                        block123: {
                                                            block122: {
                                                                block121: {
                                                                    block120: {
                                                                        block118: {
                                                                            block117: {
                                                                                block116: {
                                                                                    block115: {
                                                                                        block114: {
                                                                                            block113: {
                                                                                                block112: {
                                                                                                    block111: {
                                                                                                        block110: {
                                                                                                            block108: {
                                                                                                                block106: {
                                                                                                                    var1_1 = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.access$200(WatchPartyDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                                    var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                                    var5_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                                    var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                                    var7_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                                    var8_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                                    var9_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                                    var10_23 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                                    var11_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                                    var12_28 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                                    var13_31 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                                    var14_32 = v0;
                                                                                                                    v0 = new ArrayMap();
                                                                                                                    var15_33 = v1;
                                                                                                                    v1 = new ArrayMap();
                                                                                                                    var16_34 = v2;
                                                                                                                    v2 = new ArrayMap();
                                                                                                                    var17_35 = v3;
                                                                                                                    v3 = new ArrayMap();
                                                                                                                    var18_36 = v4;
                                                                                                                    try {
                                                                                                                        v4 = new ArrayMap();
                                                                                                                        ** while (var1_1.moveToNext())
                                                                                                                    }
                                                                                                                    catch (Throwable v5) {
                                                                                                                        var1_1.close();
                                                                                                                        throw v5;
                                                                                                                    }
lbl-1000:
                                                                                                                    // 1 sources

                                                                                                                    {
                                                                                                                        block104: {
                                                                                                                            block103: {
                                                                                                                                v6 = var16_34;
                                                                                                                                v7 = var1_1;
                                                                                                                                v8 = var2_2;
                                                                                                                                v9 = var15_33;
                                                                                                                                v10 = var1_1;
                                                                                                                                v11 = var2_2;
                                                                                                                                var14_32.put((Object)var1_1.getString(var2_2), null);
                                                                                                                                v9.put((Object)v10.getString(v11), null);
                                                                                                                                var19_37 = v7.getString(v8);
                                                                                                                                if ((ArrayList)v6.get(var19_37) != null) break block103;
                                                                                                                                v12 = var16_34;
                                                                                                                                v13 = var19_37;
                                                                                                                                var19_37 = v14;
                                                                                                                                v14 = new ArrayList<E>();
                                                                                                                                v12.put((Object)v13, var19_37);
                                                                                                                            }
                                                                                                                            v15 = var17_35;
                                                                                                                            var19_37 = var1_1.getString(var2_2);
                                                                                                                            if ((ArrayList)v15.get(var19_37) != null) break block104;
                                                                                                                            v16 = var17_35;
                                                                                                                            v17 = var19_37;
                                                                                                                            var19_37 = v18;
                                                                                                                            v18 = new ArrayList<E>();
                                                                                                                            v16.put(v17, var19_37);
                                                                                                                        }
                                                                                                                        v19 = var18_36;
                                                                                                                        var19_37 = var1_1.getString(var2_2);
                                                                                                                        if ((ArrayList)v19.get(var19_37) != null) continue;
                                                                                                                        v20 = var18_36;
                                                                                                                        v21 = var19_37;
                                                                                                                        var19_37 = v22;
                                                                                                                        v22 = new ArrayList<E>();
                                                                                                                        v20.put(v21, var19_37);
                                                                                                                        continue;
                                                                                                                    }
lbl99:
                                                                                                                    // 2 sources

                                                                                                                    v23 = var1_1;
                                                                                                                    v24 = this;
                                                                                                                    v25 = v24;
                                                                                                                    v26 = v24;
                                                                                                                    v27 = v24;
                                                                                                                    v28 = v24;
                                                                                                                    v29 = v24;
                                                                                                                    var1_1.moveToPosition(-1);
                                                                                                                    WatchPartyDao_Impl.access$1400(v26.WatchPartyDao_Impl.this, var14_32);
                                                                                                                    WatchPartyDao_Impl.access$1500(v27.WatchPartyDao_Impl.this, var15_33);
                                                                                                                    WatchPartyDao_Impl.access$1600(v28.WatchPartyDao_Impl.this, var16_34);
                                                                                                                    WatchPartyDao_Impl.access$1700(v29.WatchPartyDao_Impl.this, var17_35);
                                                                                                                    WatchPartyDao_Impl.access$1800(v25.WatchPartyDao_Impl.this, var18_36);
                                                                                                                    if (!v23.moveToFirst()) break block105;
                                                                                                                    if (!var1_1.isNull(var2_2)) break block106;
                                                                                                                    if (!var1_1.isNull(var3_4)) break block106;
                                                                                                                    if (!var1_1.isNull(var4_8)) break block106;
                                                                                                                    if (!var1_1.isNull(var5_11)) break block106;
                                                                                                                    if (!var1_1.isNull(var6_13)) break block106;
                                                                                                                    if (!var1_1.isNull(var7_15)) break block106;
                                                                                                                    if (!var1_1.isNull(var8_17)) break block106;
                                                                                                                    if (!var1_1.isNull(var9_21)) break block106;
                                                                                                                    if (!var1_1.isNull(var10_23)) break block106;
                                                                                                                    if (!var1_1.isNull(var11_24)) break block106;
                                                                                                                    if (!var1_1.isNull(var12_28)) break block106;
                                                                                                                    if (!var1_1.isNull(var13_31)) break block106;
                                                                                                                    this = null;
                                                                                                                    break block107;
                                                                                                                }
                                                                                                                if (!var1_1.isNull(var2_2)) break block108;
                                                                                                                if (!var1_1.isNull(var3_4)) break block108;
                                                                                                                if (!var1_1.isNull(var4_8)) break block108;
                                                                                                                if (!var1_1.isNull(var5_11)) break block108;
                                                                                                                if (!var1_1.isNull(var6_13)) break block108;
                                                                                                                if (!var1_1.isNull(var7_15)) break block108;
                                                                                                                if (!var1_1.isNull(var8_17)) break block108;
                                                                                                                if (!var1_1.isNull(var9_21)) break block108;
                                                                                                                if (!var1_1.isNull(var10_23)) break block108;
                                                                                                                if (!var1_1.isNull(var11_24)) break block108;
                                                                                                                if (!var1_1.isNull(var12_28)) break block108;
                                                                                                                if (!var1_1.isNull(var13_31)) break block108;
                                                                                                                this = null;
                                                                                                                break block109;
                                                                                                            }
                                                                                                            if (!var1_1.isNull(var2_2)) break block110;
                                                                                                            var19_37 = null;
                                                                                                            break block111;
                                                                                                        }
                                                                                                        var19_37 = var1_1.getString(var2_2);
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var3_4)) break block112;
                                                                                                    var3_5 = null;
                                                                                                    break block113;
                                                                                                }
                                                                                                var3_5 = var1_1.getString(var3_4);
                                                                                            }
                                                                                            v30 = var1_1;
                                                                                            v31 = var7_15;
                                                                                            v32 = var1_1;
                                                                                            v33 = var6_13;
                                                                                            v34 = var1_1;
                                                                                            v35 = var5_11;
                                                                                            var4_8 = var1_1.getInt(var4_8);
                                                                                            var5_11 = v34.getInt(v35);
                                                                                            var6_13 = v32.getInt(v33);
                                                                                            if (!v30.isNull(v31)) break block114;
                                                                                            var7_16 /* !! */  = null;
                                                                                            break block115;
                                                                                        }
                                                                                        var7_16 /* !! */  = var1_1.getLong(var7_15);
                                                                                    }
                                                                                    v36 = var1_1;
                                                                                    v37 = var8_17;
                                                                                    var7_16 /* !! */  = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var7_16 /* !! */ );
                                                                                    if (!v36.isNull(v37)) break block116;
                                                                                    var8_18 = null;
                                                                                    break block117;
                                                                                }
                                                                                var8_18 = var1_1.getLong(var8_17);
                                                                            }
                                                                            v38 = var1_1;
                                                                            v39 = var11_24;
                                                                            v40 = this;
                                                                            v41 = var1_1;
                                                                            v42 = var9_21;
                                                                            this = WatchPartyDao_Impl.access$000(WatchPartyDao_Impl.this).timestampToDate(var8_18);
                                                                            var8_19 = v41.getInt(v42);
                                                                            var8_20 = WatchPartyDao_Impl.access$000(v40.WatchPartyDao_Impl.this).intToTopicType(var8_19);
                                                                            if (!v38.isNull(v39)) break block118;
                                                                            if (!var1_1.isNull(var12_28)) break block118;
                                                                            var9_22 = null;
                                                                            break block119;
                                                                        }
                                                                        if (!var1_1.isNull(var11_24)) break block120;
                                                                        var9_22 = null;
                                                                        break block121;
                                                                    }
                                                                    var9_22 = var1_1.getString(var11_24);
                                                                }
                                                                if (!var1_1.isNull(var12_28)) break block122;
                                                                var11_25 = null;
                                                                break block123;
                                                            }
                                                            var11_25 = var1_1.getString(var12_28);
                                                        }
                                                        var12_29 = v43;
                                                        v43 = new Access((String)var9_22, var11_25);
                                                        var9_22 = var12_29;
                                                    }
                                                    if (var1_1.isNull(var13_31)) break block124;
                                                    var11_26 = var1_1.getInt(var13_31) != 0;
                                                    var12_30 = v44;
                                                    v44 = new TopicPrivateData(var11_26);
                                                    break block125;
                                                }
                                                var12_30 = null;
                                            }
                                            v45 = var1_1;
                                            v46 = var10_23;
                                            var11_27 = v47;
                                            v47 = new Topic((String)var19_37, var3_5, var4_8, var5_11, var6_13, (Date)var7_16 /* !! */ , (Date)this, (Access)var9_22, var8_20, var12_30);
                                            if (!v45.isNull(v46)) break block126;
                                            this = null;
                                            break block127;
                                        }
                                        this = var1_1.getString(var10_23);
                                    }
                                    var11_27.setWatchPartyStreamId((String)this);
                                    this = var11_27;
                                }
                                var3_6 = (ArrayList)var16_34.get((Object)var1_1.getString(var2_2));
                                if (var3_6 != null) ** GOTO lbl290
                                var3_6 = v48;
                                v48 = new ArrayList<E>();
lbl290:
                                // 2 sources

                                if ((var4_9 = (ArrayList)var17_35.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl294
                                var4_9 = v49;
                                v49 = new ArrayList<E>();
lbl294:
                                // 2 sources

                                if ((var5_12 = (ArrayList)var18_36.get((Object)var1_1.getString(var2_2))) != null) break block128;
                                var5_12 = v50;
                                v50 = new ArrayList<E>();
                            }
                            var6_14 = v51;
                            v51 = new ChatRelation((Topic)this, var3_6, var4_9, var5_12);
                            this = var6_14;
                        }
                        v52 = var15_33;
                        v53 = var1_1;
                        v54 = var2_2;
                        var2_3 = (TinodeContact)var14_32.get((Object)var1_1.getString(var2_2));
                        var3_7 = (WatchPartyStatus)v52.get((Object)v53.getString(v54));
                        var4_10 = v55;
                        v55 = new WatchPartyRelation((ChatRelation)this, var2_3, var3_7);
                        break block129;
                    }
                    var4_10 = null;
                }
                var1_1.close();
                return var4_10;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<List<WatchParty>> observeWatchParties(Function1<? super WatchPartyRelation, WatchParty> function1) {
        return WatchPartyDao.DefaultImpls.observeWatchParties(this, function1);
    }
}

