/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.sdk.SLRVideoPlayer;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoPlayerCache;", "mediaProvider", "Lio/streamlayer/common/media/MediaProvider;", "(Lio/streamlayer/common/media/MediaProvider;)V", "playersCache", "", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo$Url;", "Lio/streamlayer/sdk/SLRVideoPlayer;", "getPlayer", "video", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "forceCreate", "", "release", "", "releasePlayer", "sdk_originalRelease"})
public final class TweetVideoComponent
implements TweetVideoPlayerCache {
    @NotNull
    private MediaProvider mediaProvider;
    @NotNull
    private final Map<TweetVideo.Url, SLRVideoPlayer> playersCache;

    public TweetVideoComponent(@NotNull MediaProvider mediaProvider) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)mediaProvider, (String)"mediaProvider");
        ((TweetVideoComponent)((Object)linkedHashMap2)).mediaProvider = mediaProvider;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.playersCache = linkedHashMap2;
    }

    @Override
    @Nullable
    public SLRVideoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        Object object = tweetVideoComponent.playersCache.get(tweetVideo.getUrl());
        if (object == null) {
            if (!bl) {
                TweetVideoComponent tweetVideoComponent = null;
                object = tweetVideoComponent;
            } else {
                Object object2 = tweetVideoComponent.mediaProvider.getVideoPlayerProvider();
                if (object2 != null) {
                    TweetVideo tweetVideo2 = tweetVideo;
                    object = tweetVideo2.getUrl().getValue();
                    SLRVideoPlayer.Type type2 = tweetVideo2.isHlsType() ? SLRVideoPlayer.Type.HLS : SLRVideoPlayer.Type.DEFAULT;
                    SLRVideoPlayer.RepeatMode repeatMode = tweetVideo.isLooping() ? SLRVideoPlayer.RepeatMode.ONE : SLRVideoPlayer.RepeatMode.OFF;
                    object2 = object2.getVideoPlayer((String)object, type2, repeatMode);
                } else {
                    object2 = null;
                }
                if (object2 != null) {
                    tweetVideoComponent.playersCache.put(tweetVideo.getUrl(), (SLRVideoPlayer)object2);
                }
                object = object2;
            }
        }
        return object;
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        SLRVideoPlayer sLRVideoPlayer = this.playersCache.get(tweetVideo.getUrl());
        if (sLRVideoPlayer != null) {
            sLRVideoPlayer.release();
        }
        this.playersCache.remove(tweetVideo.getUrl());
    }

    @Override
    public void release() {
        Iterator<Map.Entry<TweetVideo.Url, SLRVideoPlayer>> iterator = this.playersCache.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().release();
        }
        this.playersCache.clear();
    }
}

