/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import com.github.marlonlom.utilities.timeago.TimeAgo;
import io.streamlayer.common.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b \b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b:\u0010;J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002R\"\u0010\u0017\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001d\u0010!\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001d\u0010$\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001e\u001a\u0004\b#\u0010 R\u001d\u0010'\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001e\u001a\u0004\b&\u0010 R\u001d\u0010*\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u001e\u001a\u0004\b)\u0010 R\u001d\u0010-\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u001e\u001a\u0004\b,\u0010 R\u001d\u00100\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001e\u001a\u0004\b/\u0010 R\u001d\u00103\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001e\u001a\u0004\b2\u0010 R\u001d\u00106\u001a\u00020\u001c8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u001e\u001a\u0004\b5\u0010 R\u001d\u00109\u001a\u00020\u001c8F@\u0006X\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u001e\u001a\u0004\b8\u0010 \u00a8\u0006<"}, d2={"Lio/streamlayer/common/utils/DateUtil;", "", "Ljava/util/Date;", "value", "", "toWeekDayMonthDay", "Ljava/util/TimeZone;", "timeZone", "fromString", "toDateTimeString", "toDateString", "dateFromString", "toShort", "toWeekDay", "toDayMonth", "date1", "date2", "", "isSameDay", "toRelativeTimeString", "fromTwitterStringToDate", "date", "fromDateToTwitterString", "is24HourFormat", "Z", "()Z", "set24HourFormat", "(Z)V", "Ljava/text/SimpleDateFormat;", "fullDateFormat$delegate", "Lkotlin/Lazy;", "getFullDateFormat", "()Ljava/text/SimpleDateFormat;", "fullDateFormat", "twitterDateFormat$delegate", "getTwitterDateFormat", "twitterDateFormat", "dateFormat$delegate", "getDateFormat", "dateFormat", "shortDate24Format$delegate", "getShortDate24Format", "shortDate24Format", "shortDateFormat$delegate", "getShortDateFormat", "shortDateFormat", "weekDayFormat$delegate", "getWeekDayFormat", "weekDayFormat", "dayMonthFormat$delegate", "getDayMonthFormat", "dayMonthFormat", "weekDayMonthDayFormat$delegate", "getWeekDayMonthDayFormat", "weekDayMonthDayFormat", "requestDateFormat$delegate", "getRequestDateFormat", "requestDateFormat", "<init>", "()V", "sdk_originalRelease"})
public final class DateUtil {
    @NotNull
    public static final DateUtil INSTANCE = new DateUtil();
    private static boolean is24HourFormat;
    @NotNull
    private static final Lazy fullDateFormat$delegate;
    @NotNull
    private static final Lazy twitterDateFormat$delegate;
    @NotNull
    private static final Lazy dateFormat$delegate;
    @NotNull
    private static final Lazy shortDate24Format$delegate;
    @NotNull
    private static final Lazy shortDateFormat$delegate;
    @NotNull
    private static final Lazy weekDayFormat$delegate;
    @NotNull
    private static final Lazy dayMonthFormat$delegate;
    @NotNull
    private static final Lazy weekDayMonthDayFormat$delegate;
    @NotNull
    private static final Lazy requestDateFormat$delegate;

    private DateUtil() {
    }

    private final SimpleDateFormat getFullDateFormat() {
        return (SimpleDateFormat)fullDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getTwitterDateFormat() {
        return (SimpleDateFormat)twitterDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)dateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getShortDate24Format() {
        return (SimpleDateFormat)shortDate24Format$delegate.getValue();
    }

    private final SimpleDateFormat getShortDateFormat() {
        return (SimpleDateFormat)shortDateFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayFormat() {
        return (SimpleDateFormat)weekDayFormat$delegate.getValue();
    }

    private final SimpleDateFormat getDayMonthFormat() {
        return (SimpleDateFormat)dayMonthFormat$delegate.getValue();
    }

    private final SimpleDateFormat getWeekDayMonthDayFormat() {
        return (SimpleDateFormat)weekDayMonthDayFormat$delegate.getValue();
    }

    public static /* synthetic */ Date fromString$default(DateUtil dateUtil, String string2, TimeZone timeZone, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.getTimeZone("UTC");
            Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"UTC\")");
        }
        return dateUtil.fromString(string2, timeZone);
    }

    static {
        fullDateFormat$delegate = LazyKt.lazy((Function0)fullDateFormat.2.INSTANCE);
        twitterDateFormat$delegate = LazyKt.lazy((Function0)twitterDateFormat.2.INSTANCE);
        dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
        shortDate24Format$delegate = LazyKt.lazy((Function0)shortDate24Format.2.INSTANCE);
        shortDateFormat$delegate = LazyKt.lazy((Function0)shortDateFormat.2.INSTANCE);
        weekDayFormat$delegate = LazyKt.lazy((Function0)weekDayFormat.2.INSTANCE);
        dayMonthFormat$delegate = LazyKt.lazy((Function0)dayMonthFormat.2.INSTANCE);
        weekDayMonthDayFormat$delegate = LazyKt.lazy((Function0)weekDayMonthDayFormat.2.INSTANCE);
        requestDateFormat$delegate = LazyKt.lazy((Function0)requestDateFormat.2.INSTANCE);
    }

    public final boolean is24HourFormat() {
        return is24HourFormat;
    }

    public final void set24HourFormat(boolean bl) {
        is24HourFormat = bl;
    }

    @NotNull
    public final SimpleDateFormat getRequestDateFormat() {
        return (SimpleDateFormat)requestDateFormat$delegate.getValue();
    }

    @NotNull
    public final String toWeekDayMonthDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getWeekDayMonthDayFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"weekDayMonthDayFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date fromString(@NotNull String string2, @NotNull TimeZone timeZone) {
        DateUtil dateUtil = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        dateUtil.getFullDateFormat().setTimeZone(timeZone);
        return dateUtil.getFullDateFormat().parse(string2);
    }

    @Nullable
    public final String toDateTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getFullDateFormat().format(date);
    }

    @NotNull
    public final String toDateString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        String string2 = this.getDateFormat().format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(value)");
        return string2;
    }

    @Nullable
    public final Date dateFromString(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return this.getDateFormat().parse(string2);
    }

    @Nullable
    public final String toShort(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return is24HourFormat ? this.getShortDate24Format().format(date) : this.getShortDateFormat().format(date);
    }

    @Nullable
    public final String toWeekDay(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getWeekDayFormat().format(date);
    }

    @Nullable
    public final String toDayMonth(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return this.getDayMonthFormat().format(date);
    }

    public final boolean isSameDay(@NotNull Date date, @NotNull Date date2) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date1");
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date2");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    @NotNull
    public final String toRelativeTimeString(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"value");
        return TimeAgo.Companion.using$default((TimeAgo.Companion)TimeAgo.Companion, (long)date.getTime(), null, (int)2, null);
    }

    @Nullable
    public final Date fromTwitterStringToDate(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getTwitterDateFormat().parse(string2);
    }

    @Nullable
    public final String fromDateToTwitterString(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return this.getTwitterDateFormat().format(date);
    }
}

