/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatOwnerCrossRef;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicPrivateData;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<ChatOwnerCrossRef> __insertionAdapterOfChatOwnerCrossRef;
    private final EntityInsertionAdapter<Topic> __insertionAdapterOfTopic;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityInsertionAdapter<WaveMessage> __insertionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<WaveMessage> __deletionAdapterOfWaveMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessagedByLocalSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageRecvSeq;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChatMessageRecvSeqAndDate;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMessageStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMessageStatus_1;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChat;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipants;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWaveEvents;
    private final SharedSQLiteStatement __preparedStmtOfSetWantAccess;
    private final SharedSQLiteStatement __preparedStmtOfSetTopicMuted;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        SharedSQLiteStatement sharedSQLiteStatement8;
        SharedSQLiteStatement sharedSQLiteStatement9;
        SharedSQLiteStatement sharedSQLiteStatement10;
        SharedSQLiteStatement sharedSQLiteStatement11;
        SharedSQLiteStatement sharedSQLiteStatement12;
        EntityDeletionOrUpdateAdapter<ChatMessageUpdate> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<WaveMessage> entityDeletionOrUpdateAdapter2;
        EntityDeletionOrUpdateAdapter<ChatMessage> entityDeletionOrUpdateAdapter3;
        EntityInsertionAdapter<WaveMessage> entityInsertionAdapter;
        EntityInsertionAdapter<ChatParticipantCrossRef> entityInsertionAdapter2;
        EntityInsertionAdapter<Topic> entityInsertionAdapter3;
        EntityInsertionAdapter<ChatOwnerCrossRef> entityInsertionAdapter4;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter5;
        EntityInsertionAdapter<ChatMessage> entityInsertionAdapter6;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter6;
        entityInsertionAdapter6 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(3, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, chatMessage.getId());
                }
            }
        };
        this.__insertionAdapterOfChatMessage = converters2;
        converters2 = entityInsertionAdapter5;
        entityInsertionAdapter5 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getSenderUserId());
                }
                long l = chatMessage.getSeqId();
                supportSQLiteStatement.bindLong(3, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, chatMessage.getId());
                }
            }
        };
        this.__insertionAdapterOfChatMessage_1 = converters2;
        converters2 = entityInsertionAdapter4;
        entityInsertionAdapter4 = new EntityInsertionAdapter<ChatOwnerCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatOwnerCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatOwnerCrossRef chatOwnerCrossRef) {
                if (chatOwnerCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatOwnerCrossRef.getChatId());
                }
                if (chatOwnerCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatOwnerCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatOwnerCrossRef = converters2;
        converters2 = entityInsertionAdapter3;
        entityInsertionAdapter3 = new EntityInsertionAdapter<Topic>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Topic` (`chatId`,`name`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`touchedAt`,`type`,`watchPartyStreamId`,`want`,`given`,`mute`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Topic topic2) {
                if (topic2.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, topic2.getChatId());
                }
                if (topic2.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, topic2.getName());
                }
                long l = topic2.getSeq();
                supportSQLiteStatement.bindLong(3, l);
                l = topic2.getReadSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = topic2.getRecvSeq();
                supportSQLiteStatement.bindLong(5, l);
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(topic2.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(6, l3);
                }
                Long l4 = object.MessagingDao_Impl.this.__converters.dateToString(topic2.getTouchedAt());
                if (l4 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l5 = l4;
                    supportSQLiteStatement.bindLong(7, l5);
                }
                long l6 = object.MessagingDao_Impl.this.__converters.topicTypeToInt(topic2.getType());
                supportSQLiteStatement.bindLong(8, l6);
                if (topic2.getWatchPartyStreamId() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, topic2.getWatchPartyStreamId());
                }
                Object object = topic2.getAccess();
                if (object != null) {
                    if (((Access)object).getWant() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, ((Access)object).getWant());
                    }
                    if (((Access)object).getGiven() == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, ((Access)object).getGiven());
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(10);
                    supportSQLiteStatement2.bindNull(11);
                }
                object = topic2.getPrivateData();
                if (object != null) {
                    long l7 = (long)((TopicPrivateData)object).getMute();
                    supportSQLiteStatement.bindLong(12, l7);
                } else {
                    supportSQLiteStatement.bindNull(12);
                }
            }
        };
        this.__insertionAdapterOfTopic = converters2;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        this.__insertionAdapterOfChatParticipantCrossRef = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WaveMessage` (`chatUserId`,`chatId`,`userName`,`userAvatar`,`sentAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
                if (waveMessage.getChatId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, waveMessage.getChatId());
                }
                if (waveMessage.getUserName() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, waveMessage.getUserName());
                }
                if (waveMessage.getUserAvatar() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, waveMessage.getUserAvatar());
                }
                Long l = l.MessagingDao_Impl.this.__converters.dateToString(waveMessage.getSentAt());
                if (l == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(5, l2);
                }
            }
        };
        this.__insertionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter3;
        entityDeletionOrUpdateAdapter3 = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                if (chatMessage.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessage.getId());
                }
            }
        };
        this.__deletionAdapterOfChatMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<WaveMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `WaveMessage` WHERE `chatUserId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WaveMessage waveMessage) {
                if (waveMessage.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, waveMessage.getChatUserId());
                }
            }
        };
        this.__deletionAdapterOfWaveMessage = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`uuid` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatMessageUpdate.getId());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                if (chatMessageUpdate.getId() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessageUpdate.getId());
                }
            }
        };
        this.__updateAdapterOfChatMessageUpdateAsChatMessage = converters2;
        converters2 = sharedSQLiteStatement12;
        sharedSQLiteStatement12 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE ChatMessage SET remoteSeqId=?, status=? WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=?";
            }
        };
        this.__preparedStmtOfUpdateChatMessagedByLocalSeq = converters2;
        converters2 = sharedSQLiteStatement11;
        sharedSQLiteStatement11 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET readSeq=?,seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageSeq = converters2;
        converters2 = sharedSQLiteStatement10;
        sharedSQLiteStatement10 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET seq=?,recvSeq=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageRecvSeq = converters2;
        converters2 = sharedSQLiteStatement9;
        sharedSQLiteStatement9 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET seq=?,recvSeq=?,updatedAt=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate = converters2;
        converters2 = sharedSQLiteStatement8;
        sharedSQLiteStatement8 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        this.__preparedStmtOfDeleteMessages = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE ChatMessage SET status=? WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=?";
            }
        };
        this.__preparedStmtOfUpdateMessageStatus = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE ChatMessage SET status=? WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.remoteSeqId=?";
            }
        };
        this.__preparedStmtOfUpdateMessageStatus_1 = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic WHERE Topic.chatId = ?";
            }
        };
        this.__preparedStmtOfDeleteChat = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE ChatParticipantCrossRef.chatId = ?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipants = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WaveMessage WHERE sentAt <= ?";
            }
        };
        this.__preparedStmtOfDeleteWaveEvents = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET want=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetWantAccess = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE Topic SET mute=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetTopicMuted = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        int n;
        RoomSQLiteQuery roomSQLiteQuery;
        block39: {
            Set set2 = arrayMap.keySet();
            if (set2.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set2 = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n2 = 0;
                int n3 = arrayMap.size();
                for (int i = 0; i < n3; ++i) {
                    ArrayMap arrayMap3;
                    set2.put((String)arrayMap.keyAt(i), null);
                    if (++n2 != 999) continue;
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set2);
                    arrayMap.putAll((Map)((Object)set2));
                    set2 = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n2 = 0;
                }
                if (n2 > 0) {
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set2);
                    arrayMap.putAll((Map)((Object)set2));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatUserId`,`externalId`,`bypassId`,`chatName`,`online`,`photoData`,`privateData`,`lastSeenTime`,`want`,`given` FROM `TinodeContact` WHERE `chatUserId` IN (");
            int n4 = set2.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
            n = 1;
            for (String string2 : set2) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, string2);
                }
                ++n;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            try {
                n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatUserId");
                if (n != -1) break block39;
            }
            catch (Throwable throwable) {
                roomSQLiteQuery.close();
                throw throwable;
            }
            roomSQLiteQuery.close();
            return;
        }
        while (true) {
            TinodeContact tinodeContact;
            Object object;
            Comparable<Long> comparable;
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            String string7;
            Object object2;
            String string2;
            block55: {
                Access access;
                String string8;
                block59: {
                    block58: {
                        block57: {
                            block56: {
                                block54: {
                                    block53: {
                                        block52: {
                                            block51: {
                                                block50: {
                                                    block49: {
                                                        block48: {
                                                            block47: {
                                                                block46: {
                                                                    block45: {
                                                                        block44: {
                                                                            block43: {
                                                                                block42: {
                                                                                    block41: {
                                                                                        block40: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                                                            object2 = roomSQLiteQuery.getString(n);
                                                                                            if (!arrayMap4.containsKey(object2)) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block40;
                                                                                            string2 = null;
                                                                                            break block41;
                                                                                        }
                                                                                        string2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block42;
                                                                                    string7 = null;
                                                                                    break block43;
                                                                                }
                                                                                string7 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block44;
                                                                            string6 = null;
                                                                            break block45;
                                                                        }
                                                                        string6 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block46;
                                                                    string5 = null;
                                                                    break block47;
                                                                }
                                                                string5 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block48;
                                                            string4 = null;
                                                            break block49;
                                                        }
                                                        string4 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block50;
                                                    string3 = null;
                                                    break block51;
                                                }
                                                string3 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block52;
                                            comparable = null;
                                            break block53;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block54;
                                    if (!roomSQLiteQuery.isNull(9)) break block54;
                                    object = null;
                                    break block55;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block56;
                                object = null;
                                break block57;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block58;
                        string8 = null;
                        break block59;
                    }
                    string8 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string8);
                object = access2;
            }
            ArrayMap<String, TinodeContact> arrayMap5 = arrayMap;
            Object object3 = object2;
            object2 = tinodeContact;
            tinodeContact = new TinodeContact(string2, string7, string6, string5, bl, string4, string3, (Date)comparable, (Access)object);
            arrayMap5.put(object3, object2);
        }
        roomSQLiteQuery.close();
        return;
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set2);
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set2);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`bypassId` AS `bypassId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`lastSeenTime` AS `lastSeenTime`,`TinodeContact`.`want` AS `want`,`TinodeContact`.`given` AS `given`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string3 : set2) {
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string3);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        while (true) {
            Object object;
            Comparable<Long> comparable;
            String string4;
            String string5;
            boolean bl;
            String string6;
            String string7;
            Object object2;
            ArrayList arrayList;
            String string3;
            block51: {
                Access access;
                String string8;
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block50: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    block41: {
                                                                        block40: {
                                                                            block39: {
                                                                                block38: {
                                                                                    block37: {
                                                                                        block36: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(10));
                                                                                            if (arrayList == null) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block36;
                                                                                            object2 = null;
                                                                                            break block37;
                                                                                        }
                                                                                        object2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block38;
                                                                                    string3 = null;
                                                                                    break block39;
                                                                                }
                                                                                string3 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block40;
                                                                            string7 = null;
                                                                            break block41;
                                                                        }
                                                                        string7 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block42;
                                                                    string6 = null;
                                                                    break block43;
                                                                }
                                                                string6 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block44;
                                                            string5 = null;
                                                            break block45;
                                                        }
                                                        string5 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block46;
                                                    string4 = null;
                                                    break block47;
                                                }
                                                string4 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block48;
                                            comparable = null;
                                            break block49;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block50;
                                    if (!roomSQLiteQuery.isNull(9)) break block50;
                                    object = null;
                                    break block51;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block52;
                                object = null;
                                break block53;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block54;
                        string8 = null;
                        break block55;
                    }
                    string8 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string8);
                object = access2;
            }
            arrayList.add(new TinodeContact((String)object2, string3, string7, string6, bl, string5, string4, (Date)comparable, (Access)object));
        }
        roomSQLiteQuery.close();
        return;
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        RoomSQLiteQuery roomSQLiteQuery;
        block37: {
            int n;
            block36: {
                Set set2 = arrayMap.keySet();
                if (set2.isEmpty()) {
                    return;
                }
                if (arrayMap.size() > 999) {
                    ArrayMap arrayMap2;
                    set2 = arrayMap2;
                    arrayMap2 = new ArrayMap(999);
                    int n2 = 0;
                    int n3 = arrayMap.size();
                    for (int i = 0; i < n3; ++i) {
                        ArrayMap arrayMap3;
                        String string2 = (String)arrayMap.keyAt(i);
                        set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                        if (++n2 != 999) continue;
                        this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set2);
                        set2 = arrayMap3;
                        arrayMap3 = new ArrayMap(999);
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set2);
                    }
                    return;
                }
                StringBuilder stringBuilder = StringUtil.newStringBuilder();
                stringBuilder.append("SELECT `chatMessageTopicId`,`senderUserId`,`remoteSeqId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`,`uuid` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
                int n4 = set2.size();
                StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
                stringBuilder.append(")");
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
                n = 1;
                for (String string3 : set2) {
                    if (string3 == null) {
                        roomSQLiteQuery.bindNull(n);
                    } else {
                        roomSQLiteQuery.bindString(n, string3);
                    }
                    ++n;
                }
                roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
                if (n != -1) break block36;
                roomSQLiteQuery.close();
                return;
            }
            while (true) {
                ChatMessage chatMessage;
                ArrayList arrayList;
                String string3;
                block55: {
                    block54: {
                        ChatMessage chatMessage2;
                        Object object;
                        String string4;
                        String string5;
                        String string6;
                        String string7;
                        Comparable<Long> comparable;
                        int n5;
                        String string8;
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                block39: {
                                                                                    block38: {
                                                                                        if (!roomSQLiteQuery.moveToNext()) break block37;
                                                                                        arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n));
                                                                                        if (arrayList == null) continue;
                                                                                        if (!roomSQLiteQuery.isNull(0)) break block38;
                                                                                        string3 = null;
                                                                                        break block39;
                                                                                    }
                                                                                    string3 = roomSQLiteQuery.getString(0);
                                                                                }
                                                                                if (!roomSQLiteQuery.isNull(1)) break block40;
                                                                                string8 = null;
                                                                                break block41;
                                                                            }
                                                                            string8 = roomSQLiteQuery.getString(1);
                                                                        }
                                                                        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                                                        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
                                                                        n5 = roomSQLiteQuery2.getInt(2);
                                                                        if (!roomSQLiteQuery3.isNull(3)) break block42;
                                                                        comparable = null;
                                                                        break block43;
                                                                    }
                                                                    comparable = roomSQLiteQuery.getLong(3);
                                                                }
                                                                RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery;
                                                                comparable = this.__converters.timestampToDate((Long)comparable);
                                                                if (!roomSQLiteQuery4.isNull(4)) break block44;
                                                                string7 = null;
                                                                break block45;
                                                            }
                                                            string7 = roomSQLiteQuery.getString(4);
                                                        }
                                                        if (!roomSQLiteQuery.isNull(5)) break block46;
                                                        string6 = null;
                                                        break block47;
                                                    }
                                                    string6 = roomSQLiteQuery.getString(5);
                                                }
                                                if (!roomSQLiteQuery.isNull(6)) break block48;
                                                string5 = null;
                                                break block49;
                                            }
                                            string5 = roomSQLiteQuery.getString(6);
                                        }
                                        if (!roomSQLiteQuery.isNull(7)) break block50;
                                        string4 = null;
                                        break block51;
                                    }
                                    string4 = roomSQLiteQuery.getString(7);
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block52;
                                object = null;
                                break block53;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        object = this.__converters.stringToChatStatus((String)object);
                        if (object == null) break;
                        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery;
                        chatMessage = chatMessage2;
                        chatMessage2 = new ChatMessage(string3, string8, n5, (Date)comparable, string7, string6, string5, string4, (ChatMessageStatus)((Object)object));
                        if (!roomSQLiteQuery5.isNull(9)) break block54;
                        string3 = null;
                        break block55;
                    }
                    string3 = roomSQLiteQuery.getString(9);
                }
                ChatMessage chatMessage3 = chatMessage;
                chatMessage3.setId(string3);
                arrayList.add(chatMessage3);
            }
            try {
                throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
            }
            catch (Throwable throwable) {
                roomSQLiteQuery.close();
                throw throwable;
            }
        }
        roomSQLiteQuery.close();
    }

    static /* synthetic */ void access$1800(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$1900(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list2) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list2);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatOwner(ChatOwnerCrossRef chatOwnerCrossRef) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatOwnerCrossRef.insert((Object)chatOwnerCrossRef);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Topic> list2) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfTopic.insert(list2);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveTopic(final Topic topic2, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                22 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfTopic.insertAndReturnId((Object)topic2);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object saveChatParticipantCrossRefs(final List<ChatParticipantCrossRef> list2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                23 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    v0.MessagingDao_Impl.this.__insertionAdapterOfChatParticipantCrossRef.insert((Iterable)list2);
                    v0.MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object saveWaveMessage(final WaveMessage waveMessage, Continuation<? super Long> continuation) {
        Callable<Long> callable;
        Callable<Long> callable2 = callable;
        callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                Long l;
                24 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    long l2 = v0.MessagingDao_Impl.this.__insertionAdapterOfWaveMessage.insertAndReturnId((Object)waveMessage);
                    MessagingDao_Impl.this.__db.setTransactionSuccessful();
                    l = l2;
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.endTransaction();
                return l;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object deleteWaveMessage(final WaveMessage waveMessage, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                25 v0 = this;
                v0.MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    v0.MessagingDao_Impl.this.__deletionAdapterOfWaveMessage.handle((Object)waveMessage);
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                MessagingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Topic> list2) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list2);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public Object saveChatParticipants(final String string2, final List<TinodeContact> list2, Continuation<? super Unit> continuation) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> continuation) {
                26 v0 = string22;
                String string22 = v0.string2;
                return MessagingDao.DefaultImpls.saveChatParticipants(string22.MessagingDao_Impl.this, string22, v0.list2, continuation);
            }
        }, continuation);
    }

    @Override
    public Object updateChatMessagedByLocalSeq(final String string2, final String string3, final int n, final ChatMessageStatus chatMessageStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                27 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                int n2 = 2;
                String string22 = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 3;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 4;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    27 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                27 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessagedByLocalSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                28 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                l = n;
                supportSQLiteStatement.bindLong(3, l);
                int n2 = 4;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    28 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                28 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageRecvSeq(final String string2, final int n, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                29 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                int n2 = 3;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    29 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                29 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeq.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateChatMessageRecvSeqAndDate(final String string2, final int n, final Date date, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                30 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.acquire();
                long l = n;
                supportSQLiteStatement.bindLong(1, l);
                l = n;
                supportSQLiteStatement.bindLong(2, l);
                int n2 = 3;
                Object object = v0.MessagingDao_Impl.this.__converters.dateToString(date);
                if (object == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindLong(n2, ((Long)object).longValue());
                }
                n2 = 4;
                object = string2;
                if (object == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, (String)object);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    30 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                30 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateChatMessageRecvSeqAndDate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public Object updateMessageStatus(final String string2, final String string3, final ChatMessageStatus chatMessageStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                31 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus.acquire();
                int n = 1;
                String string22 = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                n = 2;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                n = 3;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    31 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                31 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateMessageStatus(final String string2, final int n, final ChatMessageStatus chatMessageStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                32 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus_1.acquire();
                int n2 = 1;
                String string22 = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                n2 = 2;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n2);
                } else {
                    supportSQLiteStatement.bindString(n2, string22);
                }
                long l = n;
                supportSQLiteStatement.bindLong(3, l);
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    32 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus_1.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                32 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfUpdateMessageStatus_1.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChat(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                33 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfDeleteChat.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    33 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfDeleteChat.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                33 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfDeleteChat.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipants(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                34 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfDeleteChatParticipants.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    34 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfDeleteChatParticipants.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                34 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfDeleteChatParticipants.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWaveEvents(final Date date, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                35 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.acquire();
                int n = 1;
                Long l = v0.MessagingDao_Impl.this.__converters.dateToString(date);
                if (l == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindLong(n, l.longValue());
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    35 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                35 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfDeleteWaveEvents.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setWantAccess(final String string2, final String string3, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                36 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfSetWantAccess.acquire();
                int n = 1;
                String string22 = v0.string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                n = 2;
                string22 = string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    36 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfSetWantAccess.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                36 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfSetWantAccess.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setTopicMuted(final String string2, final boolean bl, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                37 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.MessagingDao_Impl.this.__preparedStmtOfSetTopicMuted.acquire();
                supportSQLiteStatement.bindLong(1, (long)bl);
                int n = 2;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    37 v2 = this;
                    v2.MessagingDao_Impl.this.__db.endTransaction();
                    v2.MessagingDao_Impl.this.__preparedStmtOfSetTopicMuted.release(supportSQLiteStatement);
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                37 v4 = this;
                v4.MessagingDao_Impl.this.__db.endTransaction();
                v4.MessagingDao_Impl.this.__preparedStmtOfSetTopicMuted.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasRemoteSeq(String string2, String string3, String string4) {
        void var1_6;
        MessagingDao_Impl messagingDao_Impl2;
        RoomSQLiteQuery roomSQLiteQuery;
        block10: {
            block9: {
                void var2_7;
                void var3_8;
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.uuid=? AND ChatMessage.senderUserId=?)", (int)3);
                int n = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, string2);
                }
                int bl = 2;
                if (var3_8 == null) {
                    roomSQLiteQuery.bindNull(bl);
                } else {
                    roomSQLiteQuery.bindString(bl, (String)var3_8);
                }
                int n2 = 3;
                if (var2_7 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, (String)var2_7);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block9;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.getInt(0) == 0) break block9;
                boolean bl2 = true;
                break block10;
            }
            boolean bl = false;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return (boolean)var1_6;
    }

    @Override
    public boolean hasLocalSeq(String string2, int n) {
        boolean bl;
        Cursor cursor;
        RoomSQLiteQuery roomSQLiteQuery;
        block6: {
            block5: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND ChatMessage.remoteSeqId=?)", (int)2);
                int n2 = 1;
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                MessagingDao_Impl messagingDao_Impl = this;
                long l = n;
                roomSQLiteQuery.bindLong(2, l);
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                cursor = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!cursor.moveToFirst()) break block5;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (cursor.getInt(0) == 0) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        cursor.close();
        roomSQLiteQuery.release();
        return bl;
    }

    @Override
    public Integer getLastRemoteSeqId(String object) {
        RoomSQLiteQuery roomSQLiteQuery;
        block7: {
            block6: {
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.remoteSeqId FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.remoteSeqId DESC LIMIT 1", (int)1);
                int n = 1;
                if (object == null) {
                    roomSQLiteQuery.bindNull(n);
                } else {
                    roomSQLiteQuery.bindString(n, (String)object);
                }
                MessagingDao_Impl messagingDao_Impl = messagingDao_Impl2;
                messagingDao_Impl.__db.assertNotSuspendingTransaction();
                MessagingDao_Impl messagingDao_Impl2 = DBUtil.query((RoomDatabase)messagingDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    if (!messagingDao_Impl2.moveToFirst()) break block6;
                }
                catch (Throwable throwable) {
                    messagingDao_Impl2.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                if (messagingDao_Impl2.isNull(0)) break block6;
                object = messagingDao_Impl2.getInt(0);
                break block7;
            }
            object = null;
        }
        messagingDao_Impl2.close();
        roomSQLiteQuery.release();
        return object;
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesRelationSource(String string2, List<? extends ChatMessageStatus> stringArray) {
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ");
        stringBuilder.append("?");
        stringBuilder.append(" AND status IN(");
        int n = stringArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(") ORDER BY ChatMessage.remoteSeqId DESC");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 1));
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        int n3 = 2;
        stringArray = stringArray.iterator();
        while (stringArray.hasNext()) {
            ChatMessageStatus object = (ChatMessageStatus)((Object)stringArray.next());
            String string3 = this.__converters.chatStatusToString(object);
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string3);
            }
            ++n3;
        }
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray2 = new String[2];
        stringArray = stringArray2;
        stringArray2[0] = "TinodeContact";
        stringArray2[1] = "ChatMessage";
        return new LimitOffsetPagingSource<ChatMessageRelation>(roomSQLiteQuery, roomDatabase, (String[])stringArray){

            protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                ArrayList<ChatMessageRelation> arrayList;
                ArrayMap arrayMap;
                Cursor cursor2 = cursor;
                int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"remoteSeqId");
                int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"uuid");
                ArrayMap arrayMap2 = arrayMap;
                arrayMap = new ArrayMap();
                while (cursor.moveToNext()) {
                    arrayMap2.put((Object)cursor.getString(n2), null);
                }
                cursor.moveToPosition(-1);
                MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                while (cursor.moveToNext()) {
                    block6: {
                        Object object;
                        Object object2;
                        block5: {
                            ChatMessage chatMessage;
                            block4: {
                                if (!cursor.isNull(n) || !cursor.isNull(n2) || !cursor.isNull(n3) || !cursor.isNull(n4) || !cursor.isNull(n5) || !cursor.isNull(n6) || !cursor.isNull(n7) || !cursor.isNull(n8) || !cursor.isNull(n9) || !cursor.isNull(n10)) break block4;
                                object2 = null;
                                break block5;
                            }
                            object2 = cursor.isNull(n) ? null : cursor.getString(n);
                            object = cursor.isNull(n2) ? null : cursor.getString(n2);
                            int n11 = cursor.getInt(n3);
                            Comparable<Long> comparable = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
                            comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                            String string2 = cursor.isNull(n5) ? null : cursor.getString(n5);
                            String string3 = cursor.isNull(n6) ? null : cursor.getString(n6);
                            String string4 = cursor.isNull(n7) ? null : cursor.getString(n7);
                            String string5 = cursor.isNull(n8) ? null : cursor.getString(n8);
                            Object object3 = cursor.isNull(n9) ? null : cursor.getString(n9);
                            object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                            if (object3 == null) break block6;
                            ChatMessage chatMessage2 = chatMessage;
                            chatMessage = new ChatMessage((String)object2, (String)object, n11, (Date)comparable, string2, string3, string4, string5, (ChatMessageStatus)((Object)object3));
                            object2 = cursor.isNull(n10) ? null : cursor.getString(n10);
                            chatMessage2.setId((String)object2);
                            object2 = chatMessage2;
                        }
                        object = (TinodeContact)arrayMap2.get((Object)cursor.getString(n2));
                        arrayList2.add(new ChatMessageRelation((ChatMessage)object2, (TinodeContact)object));
                        continue;
                    }
                    throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
                }
                return arrayList2;
            }
        };
    }

    @Override
    public Object getReplyEmoji(String string2, String object, Continuation<? super List<ChatMessage>> continuation) {
        Callable<List<ChatMessage>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND ChatMessage.replyTo = ? ORDER BY ChatMessage.remoteSeqId DESC LIMIT 1", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, (String)object);
        }
        CancellationSignal cancellationSignal = DBUtil.createCancellationSignal();
        object = callable;
        callable = new Callable<List<ChatMessage>>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ChatMessage> call() throws Exception {
                ChatMessageStatus chatMessageStatus;
                String string2;
                String string3;
                String string4;
                String string5;
                Date date;
                int n;
                String string6;
                String string7;
                ArrayList<ChatMessage> arrayList;
                Cursor cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatMessageTopicId");
                int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"senderUserId");
                int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"remoteSeqId");
                int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"date");
                int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"text");
                int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"subtype");
                int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"replyTo");
                int n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"status");
                int n11 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"uuid");
                ArrayList<ChatMessage> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<ChatMessage>(cursor.getCount());
                    while (cursor.moveToNext()) {
                        void var21_27;
                        void var16_19;
                        string7 = cursor.isNull(n2) ? null : cursor.getString(n2);
                        string6 = cursor.isNull(n3) ? null : cursor.getString(n3);
                        n = cursor.getInt(n4);
                        if (cursor.isNull(n5)) {
                            Object var16_17 = null;
                        } else {
                            Long l = cursor.getLong(n5);
                        }
                        date = MessagingDao_Impl.this.__converters.timestampToDate((Long)var16_19);
                        string5 = cursor.isNull(n6) ? null : cursor.getString(n6);
                        string4 = cursor.isNull(n7) ? null : cursor.getString(n7);
                        string3 = cursor.isNull(n8) ? null : cursor.getString(n8);
                        string2 = cursor.isNull(n9) ? null : cursor.getString(n9);
                        if (cursor.isNull(n10)) {
                            Object var21_25 = null;
                        } else {
                            String string8 = cursor.getString(n10);
                        }
                        chatMessageStatus = MessagingDao_Impl.this.__converters.stringToChatStatus((String)var21_27);
                        if (chatMessageStatus == null) break block11;
                    }
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                {
                    block11: {
                        ChatMessage chatMessage;
                        Cursor cursor2 = cursor;
                        int n12 = n11;
                        ChatMessage chatMessage2 = chatMessage;
                        chatMessage = new ChatMessage(string7, string6, n, date, string5, string4, string3, string2, chatMessageStatus);
                        string7 = cursor2.isNull(n12) ? null : cursor.getString(n11);
                        ChatMessage chatMessage3 = chatMessage2;
                        chatMessage3.setId(string7);
                        arrayList2.add(chatMessage3);
                        continue;
                    }
                    throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
                }
                cursor.close();
                roomSQLiteQuery.release();
                return arrayList2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)cancellationSignal, (Callable)object, continuation);
    }

    @Override
    public Flow<ChatMessageRelation> observeInviteMessages(String string2, long l, String string3, ChatMessageStatus chatMessageStatus) {
        Callable<ChatMessageRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND type LIKE ? AND date > ? AND status =? ORDER BY ChatMessage.remoteSeqId DESC", (int)4);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        if (string3 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string3);
        }
        roomSQLiteQuery.bindLong(3, l);
        n2 = 4;
        Object object = this.__converters.chatStatusToString(chatMessageStatus);
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, (String)object);
        }
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        object = callable;
        callable = new Callable<ChatMessageRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatMessageRelation call() throws Exception {
                block79: {
                    block58: {
                        block60: {
                            block78: {
                                block77: {
                                    block76: {
                                        block75: {
                                            block74: {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            block70: {
                                                                block69: {
                                                                    block68: {
                                                                        block67: {
                                                                            block66: {
                                                                                block65: {
                                                                                    block64: {
                                                                                        block63: {
                                                                                            block62: {
                                                                                                block61: {
                                                                                                    block59: {
                                                                                                        v0 = this;
                                                                                                        MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                                                        var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                                                                                                        var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                                                                                                        var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"remoteSeqId");
                                                                                                        var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                                                                                                        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                                                                                                        var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                        var8_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                                                                                                        var9_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                                                                                                        var10_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                                                                                        var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"uuid");
                                                                                                        var12_22 = v1;
                                                                                                        v1 = new ArrayMap();
                                                                                                        ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                        // 1 sources

                                                                                                        {
                                                                                                            var12_22.put((Object)var1_1.getString(var3_5), null);
                                                                                                            continue;
                                                                                                        }
lbl34:
                                                                                                        // 2 sources

                                                                                                        v2 = var1_1;
                                                                                                        v3 = this;
                                                                                                        var1_1.moveToPosition(-1);
                                                                                                        MessagingDao_Impl.access$1700(v3.MessagingDao_Impl.this, var12_22);
                                                                                                        if (!v2.moveToFirst()) break block58;
                                                                                                        if (!var1_1.isNull(var2_2)) break block59;
                                                                                                        if (!var1_1.isNull(var3_5)) break block59;
                                                                                                        if (!var1_1.isNull(var4_7)) break block59;
                                                                                                        if (!var1_1.isNull(var5_9)) break block59;
                                                                                                        if (!var1_1.isNull(var6_11)) break block59;
                                                                                                        if (!var1_1.isNull(var7_13)) break block59;
                                                                                                        if (!var1_1.isNull(var8_15)) break block59;
                                                                                                        if (!var1_1.isNull(var9_17)) break block59;
                                                                                                        if (!var1_1.isNull(var10_19)) break block59;
                                                                                                        if (!var1_1.isNull(var11_21)) break block59;
                                                                                                        var2_3 = null;
                                                                                                        break block60;
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var2_2)) break block61;
                                                                                                    var2_3 = null;
                                                                                                    break block62;
                                                                                                }
                                                                                                var2_3 = var1_1.getString(var2_2);
                                                                                            }
                                                                                            if (!var1_1.isNull(var3_5)) break block63;
                                                                                            var13_23 = null;
                                                                                            break block64;
                                                                                        }
                                                                                        var13_23 = var1_1.getString(var3_5);
                                                                                    }
                                                                                    v4 = var1_1;
                                                                                    v5 = var5_9;
                                                                                    var4_7 = var1_1.getInt(var4_7);
                                                                                    if (!v4.isNull(v5)) break block65;
                                                                                    var5_10 /* !! */  = null;
                                                                                    break block66;
                                                                                }
                                                                                var5_10 /* !! */  = var1_1.getLong(var5_9);
                                                                            }
                                                                            v6 = var1_1;
                                                                            v7 = var6_11;
                                                                            var5_10 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var5_10 /* !! */ );
                                                                            if (!v6.isNull(v7)) break block67;
                                                                            var6_12 = null;
                                                                            break block68;
                                                                        }
                                                                        var6_12 = var1_1.getString(var6_11);
                                                                    }
                                                                    if (!var1_1.isNull(var7_13)) break block69;
                                                                    var7_14 = null;
                                                                    break block70;
                                                                }
                                                                var7_14 = var1_1.getString(var7_13);
                                                            }
                                                            if (!var1_1.isNull(var8_15)) break block71;
                                                            var8_16 = null;
                                                            break block72;
                                                        }
                                                        var8_16 = var1_1.getString(var8_15);
                                                    }
                                                    if (!var1_1.isNull(var9_17)) break block73;
                                                    var9_18 = null;
                                                    break block74;
                                                }
                                                var9_18 = var1_1.getString(var9_17);
                                            }
                                            if (!var1_1.isNull(var10_19)) break block75;
                                            var10_20 /* !! */  = null;
                                            break block76;
                                        }
                                        var10_20 /* !! */  = var1_1.getString(var10_19);
                                    }
                                    var10_20 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).stringToChatStatus(var10_20 /* !! */ );
                                    if (var10_20 /* !! */  == null) ** GOTO lbl162
                                    v8 = var1_1;
                                    v9 = var11_21;
                                    var14_24 = v10;
                                    v10 = new ChatMessage((String)var2_3, var13_23, var4_7, (Date)var5_10 /* !! */ , var6_12, var7_14, var8_16, var9_18, (ChatMessageStatus)var10_20 /* !! */ );
                                    if (!v8.isNull(v9)) break block77;
                                    var2_3 = null;
                                    break block78;
                                }
                                var2_3 = var1_1.getString(var11_21);
                            }
                            var14_24.setId((String)var2_3);
                            var2_3 = var14_24;
                        }
                        var3_6 = (TinodeContact)var12_22.get((Object)var1_1.getString(var3_5));
                        var4_8 = v11;
                        v11 = new ChatMessageRelation((ChatMessage)var2_3, var3_6);
                        break block79;
lbl162:
                        // 1 sources

                        throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
                    }
                    var4_8 = null;
                }
                v12 = var4_8;
                v13 = this;
                v14 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v14.close();
                {
                    catch (Throwable v15) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v15;
                    }
                }
                MessagingDao_Impl.access$100(v13.MessagingDao_Impl.this).endTransaction();
                return v12;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Flow<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT `Topic`.`chatId` AS `chatId`, `Topic`.`name` AS `name`, `Topic`.`seq` AS `seq`, `Topic`.`readSeq` AS `readSeq`, `Topic`.`recvSeq` AS `recvSeq`, `Topic`.`updatedAt` AS `updatedAt`, `Topic`.`touchedAt` AS `touchedAt`, `Topic`.`type` AS `type`, `Topic`.`watchPartyStreamId` AS `watchPartyStreamId`, `Topic`.`want` AS `want`, `Topic`.`given` AS `given`, `Topic`.`mute` AS `mute` FROM Topic WHERE chatId LIKE 'grp%' AND type = 0 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Topic";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = v1;
                v1 = new ArrayMap();
                var3_4 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block71: {
                        v3 = var2_2;
                        var4_5 = var1_1.getString(0);
                        if ((ArrayList)v3.get(var4_5) != null) break block71;
                        v4 = var2_2;
                        v5 = var4_5;
                        var4_5 = v6;
                        v6 = new ArrayList<E>();
                        v4.put((Object)v5, var4_5);
                    }
                    v7 = var3_4;
                    var4_5 = var1_1.getString(0);
                    if ((ArrayList)v7.get(var4_5) != null) continue;
                    v8 = var3_4;
                    v9 = var4_5;
                    var4_5 = v10;
                    v10 = new ArrayList<E>();
                    v8.put(v9, var4_5);
                    continue;
                }
lbl41:
                // 2 sources

                v11 = this;
                v12 = v11;
                v13 = v11;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$1800(v12.MessagingDao_Impl.this, var2_2);
                MessagingDao_Impl.access$1900(v13.MessagingDao_Impl.this, var3_4);
                var4_5 = v14;
                v14 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block73: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        block83: {
                                            block87: {
                                                block86: {
                                                    block85: {
                                                        block84: {
                                                            block82: {
                                                                block81: {
                                                                    block80: {
                                                                        block79: {
                                                                            block78: {
                                                                                block77: {
                                                                                    block76: {
                                                                                        block75: {
                                                                                            block74: {
                                                                                                block72: {
                                                                                                    if (!var1_1.isNull(0)) break block72;
                                                                                                    if (!var1_1.isNull(1)) break block72;
                                                                                                    if (!var1_1.isNull(2)) break block72;
                                                                                                    if (!var1_1.isNull(3)) break block72;
                                                                                                    if (!var1_1.isNull(4)) break block72;
                                                                                                    if (!var1_1.isNull(5)) break block72;
                                                                                                    if (!var1_1.isNull(6)) break block72;
                                                                                                    if (!var1_1.isNull(7)) break block72;
                                                                                                    if (!var1_1.isNull(8)) break block72;
                                                                                                    if (!var1_1.isNull(9)) break block72;
                                                                                                    if (!var1_1.isNull(10)) break block72;
                                                                                                    if (!var1_1.isNull(11)) break block72;
                                                                                                    var5_6 = null;
                                                                                                    break block73;
                                                                                                }
                                                                                                if (!var1_1.isNull(0)) break block74;
                                                                                                var5_6 = null;
                                                                                                break block75;
                                                                                            }
                                                                                            var5_6 = var1_1.getString(0);
                                                                                        }
                                                                                        if (!var1_1.isNull(1)) break block76;
                                                                                        var6_7 = null;
                                                                                        break block77;
                                                                                    }
                                                                                    var6_7 = var1_1.getString(1);
                                                                                }
                                                                                v15 = var1_1;
                                                                                v16 = v15;
                                                                                v17 = v15;
                                                                                v18 = v15;
                                                                                var7_9 = v15.getInt(2);
                                                                                var8_11 = v16.getInt(3);
                                                                                var9_12 = v17.getInt(4);
                                                                                if (!v18.isNull(5)) break block78;
                                                                                var10_13 /* !! */  = null;
                                                                                break block79;
                                                                            }
                                                                            var10_13 /* !! */  = var1_1.getLong(5);
                                                                        }
                                                                        v19 = var1_1;
                                                                        var10_13 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var10_13 /* !! */ );
                                                                        if (!v19.isNull(6)) break block80;
                                                                        var11_14 /* !! */  = null;
                                                                        break block81;
                                                                    }
                                                                    var11_14 /* !! */  = var1_1.getLong(6);
                                                                }
                                                                v20 = var1_1;
                                                                v21 = this;
                                                                v22 = var1_1;
                                                                var11_14 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var11_14 /* !! */ );
                                                                var12_16 = v22.getInt(7);
                                                                var12_15 = MessagingDao_Impl.access$000(v21.MessagingDao_Impl.this).intToTopicType(var12_16);
                                                                if (!v20.isNull(9)) break block82;
                                                                if (!var1_1.isNull(10)) break block82;
                                                                var13_17 = null;
                                                                break block83;
                                                            }
                                                            if (!var1_1.isNull(9)) break block84;
                                                            var13_17 = null;
                                                            break block85;
                                                        }
                                                        var13_17 = var1_1.getString(9);
                                                    }
                                                    if (!var1_1.isNull(10)) break block86;
                                                    var14_18 = null;
                                                    break block87;
                                                }
                                                var14_18 = var1_1.getString(10);
                                            }
                                            var15_21 = v23;
                                            v23 = new Access((String)var13_17, (String)var14_18);
                                            var13_17 = var15_21;
                                        }
                                        if (var1_1.isNull(11)) break block88;
                                        var14_19 = var1_1.getInt(11) != 0;
                                        var15_21 = v24;
                                        v24 = new TopicPrivateData(var14_19);
                                        break block89;
                                    }
                                    var15_21 = null;
                                }
                                v25 = var1_1;
                                var14_18 = v26;
                                v26 = new Topic((String)var5_6, (String)var6_7, var7_9, var8_11, var9_12, (Date)var10_13 /* !! */ , (Date)var11_14 /* !! */ , (Access)var13_17, var12_15, (TopicPrivateData)var15_21);
                                if (!v25.isNull(8)) break block90;
                                var5_6 = null;
                                break block91;
                            }
                            var5_6 = var1_1.getString(8);
                        }
                        var14_18.setWatchPartyStreamId((String)var5_6);
                        var5_6 = var14_18;
                    }
                    var6_7 = (ArrayList)var2_2.get((Object)var1_1.getString(0));
                    if (var6_7 != null) ** GOTO lbl195
                    var6_7 = v27;
                    v27 = new ArrayList<E>();
lbl195:
                    // 2 sources

                    if ((var7_8 = (ArrayList)var3_4.get((Object)var1_1.getString(0))) != null) ** GOTO lbl199
                    var7_8 = v28;
                    v28 = new ArrayList<E>();
lbl199:
                    // 2 sources

                    v29 = var4_5;
                    var8_10 = v30;
                    v30 = new ChatRelation((Topic)var5_6, (List<TinodeContact>)var6_7, var7_8);
                    v29.add(var8_10);
                    continue;
                }
lbl207:
                // 2 sources

                v31 = var4_5;
                v32 = this;
                v33 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v33.close();
                {
                    catch (Throwable v34) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v34;
                    }
                }
                MessagingDao_Impl.access$100(v32.MessagingDao_Impl.this).endTransaction();
                return v31;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Topic";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block104: {
                    block82: {
                        block103: {
                            block84: {
                                block102: {
                                    block101: {
                                        block100: {
                                            block99: {
                                                block94: {
                                                    block98: {
                                                        block97: {
                                                            block96: {
                                                                block95: {
                                                                    block93: {
                                                                        block92: {
                                                                            block91: {
                                                                                block90: {
                                                                                    block89: {
                                                                                        block88: {
                                                                                            block87: {
                                                                                                block86: {
                                                                                                    block85: {
                                                                                                        block83: {
                                                                                                            v0 = this;
                                                                                                            MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                                                                            var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                            var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                            var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                            var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                            var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                            var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                            var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                            var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                            var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                            var11_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                            var12_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                            var13_25 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                            var14_27 = v1;
                                                                                                            v1 = new ArrayMap();
                                                                                                            var15_28 = v2;
                                                                                                            v2 = new ArrayMap();
                                                                                                            ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                            // 1 sources

                                                                                                            {
                                                                                                                block81: {
                                                                                                                    v3 = var14_27;
                                                                                                                    var16_29 = var1_1.getString(var2_2);
                                                                                                                    if ((ArrayList)v3.get(var16_29) != null) break block81;
                                                                                                                    v4 = var14_27;
                                                                                                                    v5 = var16_29;
                                                                                                                    var16_29 = v6;
                                                                                                                    v6 = new ArrayList<E>();
                                                                                                                    v4.put((Object)v5, var16_29);
                                                                                                                }
                                                                                                                v7 = var15_28;
                                                                                                                var16_29 = var1_1.getString(var2_2);
                                                                                                                if ((ArrayList)v7.get(var16_29) != null) continue;
                                                                                                                v8 = var15_28;
                                                                                                                v9 = var16_29;
                                                                                                                var16_29 = v10;
                                                                                                                v10 = new ArrayList<E>();
                                                                                                                v8.put(v9, var16_29);
                                                                                                                continue;
                                                                                                            }
lbl65:
                                                                                                            // 2 sources

                                                                                                            v11 = var1_1;
                                                                                                            v12 = this;
                                                                                                            v13 = v12;
                                                                                                            v14 = v12;
                                                                                                            var1_1.moveToPosition(-1);
                                                                                                            MessagingDao_Impl.access$1800(v13.MessagingDao_Impl.this, var14_27);
                                                                                                            MessagingDao_Impl.access$1900(v14.MessagingDao_Impl.this, var15_28);
                                                                                                            if (!v11.moveToFirst()) break block82;
                                                                                                            if (!var1_1.isNull(var2_2)) break block83;
                                                                                                            if (!var1_1.isNull(var3_5)) break block83;
                                                                                                            if (!var1_1.isNull(var4_7)) break block83;
                                                                                                            if (!var1_1.isNull(var5_9)) break block83;
                                                                                                            if (!var1_1.isNull(var6_11)) break block83;
                                                                                                            if (!var1_1.isNull(var7_12)) break block83;
                                                                                                            if (!var1_1.isNull(var8_14)) break block83;
                                                                                                            if (!var1_1.isNull(var9_16)) break block83;
                                                                                                            if (!var1_1.isNull(var10_18)) break block83;
                                                                                                            if (!var1_1.isNull(var11_19)) break block83;
                                                                                                            if (!var1_1.isNull(var12_21)) break block83;
                                                                                                            if (!var1_1.isNull(var13_25)) break block83;
                                                                                                            var3_6 = null;
                                                                                                            break block84;
                                                                                                        }
                                                                                                        if (!var1_1.isNull(var2_2)) break block85;
                                                                                                        var16_29 = null;
                                                                                                        break block86;
                                                                                                    }
                                                                                                    var16_29 = var1_1.getString(var2_2);
                                                                                                }
                                                                                                if (!var1_1.isNull(var3_5)) break block87;
                                                                                                var3_6 = null;
                                                                                                break block88;
                                                                                            }
                                                                                            var3_6 = var1_1.getString(var3_5);
                                                                                        }
                                                                                        v15 = var1_1;
                                                                                        v16 = var7_12;
                                                                                        v17 = var1_1;
                                                                                        v18 = var6_11;
                                                                                        v19 = var1_1;
                                                                                        v20 = var5_9;
                                                                                        var4_7 = var1_1.getInt(var4_7);
                                                                                        var5_9 = v19.getInt(v20);
                                                                                        var6_11 = v17.getInt(v18);
                                                                                        if (!v15.isNull(v16)) break block89;
                                                                                        var7_13 /* !! */  = null;
                                                                                        break block90;
                                                                                    }
                                                                                    var7_13 /* !! */  = var1_1.getLong(var7_12);
                                                                                }
                                                                                v21 = var1_1;
                                                                                v22 = var8_14;
                                                                                var7_13 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var7_13 /* !! */ );
                                                                                if (!v21.isNull(v22)) break block91;
                                                                                var8_15 /* !! */  = null;
                                                                                break block92;
                                                                            }
                                                                            var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                                        }
                                                                        v23 = var1_1;
                                                                        v24 = var11_19;
                                                                        v25 = this;
                                                                        v26 = var1_1;
                                                                        v27 = var9_16;
                                                                        var8_15 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_15 /* !! */ );
                                                                        var9_16 = v26.getInt(v27);
                                                                        var9_17 = MessagingDao_Impl.access$000(v25.MessagingDao_Impl.this).intToTopicType(var9_16);
                                                                        if (!v23.isNull(v24)) break block93;
                                                                        if (!var1_1.isNull(var12_21)) break block93;
                                                                        var11_20 = null;
                                                                        break block94;
                                                                    }
                                                                    if (!var1_1.isNull(var11_19)) break block95;
                                                                    var11_20 = null;
                                                                    break block96;
                                                                }
                                                                var11_20 = var1_1.getString(var11_19);
                                                            }
                                                            if (!var1_1.isNull(var12_21)) break block97;
                                                            var12_22 = null;
                                                            break block98;
                                                        }
                                                        var12_22 = var1_1.getString(var12_21);
                                                    }
                                                    var17_30 = v28;
                                                    v28 = new Access((String)var11_20, var12_22);
                                                    var11_20 = var17_30;
                                                }
                                                if (var1_1.isNull(var13_25)) break block99;
                                                var12_23 = var1_1.getInt(var13_25) != 0;
                                                var13_26 = v29;
                                                v29 = new TopicPrivateData(var12_23);
                                                break block100;
                                            }
                                            var13_26 = null;
                                        }
                                        v30 = var1_1;
                                        v31 = var10_18;
                                        var12_24 = v32;
                                        v32 = new Topic((String)var16_29, (String)var3_6, var4_7, var5_9, var6_11, (Date)var7_13 /* !! */ , (Date)var8_15 /* !! */ , (Access)var11_20, var9_17, var13_26);
                                        if (!v30.isNull(v31)) break block101;
                                        var3_6 = null;
                                        break block102;
                                    }
                                    var3_6 = var1_1.getString(var10_18);
                                }
                                var12_24.setWatchPartyStreamId((String)var3_6);
                                var3_6 = var12_24;
                            }
                            var4_8 = (ArrayList)var14_27.get((Object)var1_1.getString(var2_2));
                            if (var4_8 != null) ** GOTO lbl223
                            var4_8 = v33;
                            v33 = new ArrayList<E>();
lbl223:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var15_28.get((Object)var1_1.getString(var2_2))) != null) break block103;
                            var2_3 = v34;
                            v34 = new ArrayList<E>();
                        }
                        var5_10 = v35;
                        v35 = new ChatRelation((Topic)var3_6, var4_8, var2_3);
                        break block104;
                    }
                    var5_10 = null;
                }
                v36 = var5_10;
                v37 = this;
                v38 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v38.close();
                {
                    catch (Throwable v39) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v39;
                    }
                }
                MessagingDao_Impl.access$100(v37.MessagingDao_Impl.this).endTransaction();
                return v36;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getTopic(String string2, Continuation<? super Topic> continuation) {
        Callable<Topic> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Topic> callable2 = callable;
        callable = new Callable<Topic>(){

            @Override
            public Topic call() throws Exception {
                Topic topic2;
                Cursor cursor;
                block64: {
                    block45: {
                        String string2;
                        block63: {
                            int n;
                            block62: {
                                Topic topic3;
                                TopicPrivateData topicPrivateData;
                                Object object;
                                TopicType topicType;
                                Comparable<Long> comparable;
                                Comparable<Long> comparable2;
                                String string3;
                                int n2;
                                int n3;
                                int n4;
                                block61: {
                                    block60: {
                                        TopicPrivateData topicPrivateData2;
                                        int n5;
                                        block55: {
                                            Access access;
                                            String string4;
                                            block59: {
                                                int n6;
                                                block58: {
                                                    block57: {
                                                        int n7;
                                                        block56: {
                                                            block54: {
                                                                int n8;
                                                                block53: {
                                                                    int n9;
                                                                    block52: {
                                                                        block51: {
                                                                            int n10;
                                                                            block50: {
                                                                                block49: {
                                                                                    int n11;
                                                                                    block48: {
                                                                                        block47: {
                                                                                            int n12;
                                                                                            block46: {
                                                                                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                                                try {
                                                                                                    n12 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                                                                }
                                                                                                catch (Throwable throwable) {
                                                                                                    cursor.close();
                                                                                                    roomSQLiteQuery.release();
                                                                                                    throw throwable;
                                                                                                }
                                                                                                n11 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                                                                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"seq");
                                                                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"readSeq");
                                                                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"recvSeq");
                                                                                                n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                                                                                                n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"touchedAt");
                                                                                                n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"watchPartyStreamId");
                                                                                                n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"want");
                                                                                                n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"given");
                                                                                                n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"mute");
                                                                                                if (!cursor.moveToFirst()) break block45;
                                                                                                if (!cursor.isNull(n12)) break block46;
                                                                                                string2 = null;
                                                                                                break block47;
                                                                                            }
                                                                                            string2 = cursor.getString(n12);
                                                                                        }
                                                                                        if (!cursor.isNull(n11)) break block48;
                                                                                        string3 = null;
                                                                                        break block49;
                                                                                    }
                                                                                    string3 = cursor.getString(n11);
                                                                                }
                                                                                Cursor cursor2 = cursor;
                                                                                int n13 = n10;
                                                                                Cursor cursor3 = cursor;
                                                                                int n14 = n2;
                                                                                Cursor cursor4 = cursor;
                                                                                int n15 = n3;
                                                                                n4 = cursor.getInt(n4);
                                                                                n3 = cursor4.getInt(n15);
                                                                                n2 = cursor3.getInt(n14);
                                                                                if (!cursor2.isNull(n13)) break block50;
                                                                                comparable2 = null;
                                                                                break block51;
                                                                            }
                                                                            comparable2 = cursor.getLong(n10);
                                                                        }
                                                                        Cursor cursor5 = cursor;
                                                                        int n16 = n9;
                                                                        comparable2 = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable2);
                                                                        if (!cursor5.isNull(n16)) break block52;
                                                                        comparable = null;
                                                                        break block53;
                                                                    }
                                                                    comparable = cursor.getLong(n9);
                                                                }
                                                                Cursor cursor6 = cursor;
                                                                int n17 = n7;
                                                                43 v11 = this;
                                                                Cursor cursor7 = cursor;
                                                                int n18 = n8;
                                                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                                                n8 = cursor7.getInt(n18);
                                                                topicType = v11.MessagingDao_Impl.this.__converters.intToTopicType(n8);
                                                                if (!cursor6.isNull(n17)) break block54;
                                                                if (!cursor.isNull(n6)) break block54;
                                                                object = null;
                                                                break block55;
                                                            }
                                                            if (!cursor.isNull(n7)) break block56;
                                                            object = null;
                                                            break block57;
                                                        }
                                                        object = cursor.getString(n7);
                                                    }
                                                    if (!cursor.isNull(n6)) break block58;
                                                    string4 = null;
                                                    break block59;
                                                }
                                                string4 = cursor.getString(n6);
                                            }
                                            Access access2 = access;
                                            access = new Access((String)object, string4);
                                            object = access2;
                                        }
                                        if (cursor.isNull(n5)) break block60;
                                        boolean bl = cursor.getInt(n5) != 0;
                                        topicPrivateData = topicPrivateData2;
                                        topicPrivateData2 = new TopicPrivateData(bl);
                                        break block61;
                                    }
                                    topicPrivateData = null;
                                }
                                Cursor cursor8 = cursor;
                                int n19 = n;
                                topic2 = topic3;
                                topic3 = new Topic(string2, string3, n4, n3, n2, (Date)comparable2, (Date)comparable, (Access)object, topicType, topicPrivateData);
                                if (!cursor8.isNull(n19)) break block62;
                                string2 = null;
                                break block63;
                            }
                            string2 = cursor.getString(n);
                        }
                        topic2.setWatchPartyStreamId(string2);
                        break block64;
                    }
                    topic2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return topic2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isChatExist(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT * FROM Topic WHERE Topic.chatId = ?)", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                Cursor cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    Boolean bl2;
                    if (cursor.moveToFirst()) {
                        boolean bl3 = cursor.getInt(0) != 0;
                        bl2 = bl3;
                    } else {
                        bl2 = Boolean.FALSE;
                    }
                    bl = bl2;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return bl;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWaveByIdAndDate(String string2, Date object, Continuation<? super WaveMessage> continuation) {
        Callable<WaveMessage> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WaveMessage WHERE chatUserId = ? AND sentAt >= ?", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.dateToString((Date)object);
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            long l = (Long)object;
            roomSQLiteQuery.bindLong(n2, l);
        }
        CancellationSignal cancellationSignal = DBUtil.createCancellationSignal();
        object = callable;
        callable = new Callable<WaveMessage>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WaveMessage call() throws Exception {
                WaveMessage waveMessage;
                Cursor cursor;
                block31: {
                    block20: {
                        WaveMessage waveMessage2;
                        void var6_13;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        block30: {
                            int n;
                            block29: {
                                block28: {
                                    int n2;
                                    block27: {
                                        block26: {
                                            int n3;
                                            block25: {
                                                block24: {
                                                    int n4;
                                                    block23: {
                                                        block22: {
                                                            int n5;
                                                            block21: {
                                                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                try {
                                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatUserId");
                                                                }
                                                                catch (Throwable throwable) {
                                                                    cursor.close();
                                                                    roomSQLiteQuery.release();
                                                                    throw throwable;
                                                                }
                                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userName");
                                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userAvatar");
                                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sentAt");
                                                                if (!cursor.moveToFirst()) break block20;
                                                                if (!cursor.isNull(n5)) break block21;
                                                                string5 = null;
                                                                break block22;
                                                            }
                                                            string5 = cursor.getString(n5);
                                                        }
                                                        if (!cursor.isNull(n4)) break block23;
                                                        string4 = null;
                                                        break block24;
                                                    }
                                                    string4 = cursor.getString(n4);
                                                }
                                                if (!cursor.isNull(n3)) break block25;
                                                string3 = null;
                                                break block26;
                                            }
                                            string3 = cursor.getString(n3);
                                        }
                                        if (!cursor.isNull(n2)) break block27;
                                        string2 = null;
                                        break block28;
                                    }
                                    string2 = cursor.getString(n2);
                                }
                                if (!cursor.isNull(n)) break block29;
                                Object var6_11 = null;
                                break block30;
                            }
                            Long l = cursor.getLong(n);
                        }
                        Date date = MessagingDao_Impl.this.__converters.timestampToDate((Long)var6_13);
                        if (date == null) throw new IllegalStateException("Expected non-null java.util.Date, but it was null.");
                        waveMessage = waveMessage2;
                        waveMessage2 = new WaveMessage(string5, string4, string3, string2, date);
                        break block31;
                    }
                    waveMessage = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return waveMessage;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)cancellationSignal, (Callable)object, continuation);
    }

    @Override
    public Object getChatMessageByRemoteSeqId(String string2, int n, Continuation<? super ChatMessage> continuation) {
        Callable<ChatMessage> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId=? AND remoteSeqId=?", (int)2);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        long l = n;
        roomSQLiteQuery.bindLong(2, l);
        CancellationSignal cancellationSignal = DBUtil.createCancellationSignal();
        Callable<ChatMessage> callable2 = callable;
        callable = new Callable<ChatMessage>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public ChatMessage call() throws Exception {
                ChatMessage chatMessage;
                Cursor cursor;
                block54: {
                    block35: {
                        String string2;
                        block53: {
                            int n;
                            block52: {
                                ChatMessage chatMessage2;
                                void var10_23;
                                String string3;
                                String string4;
                                String string5;
                                String string6;
                                Date date;
                                String string7;
                                int n2;
                                block51: {
                                    int n3;
                                    block50: {
                                        block49: {
                                            int n4;
                                            block48: {
                                                block47: {
                                                    int n5;
                                                    block46: {
                                                        block45: {
                                                            int n6;
                                                            block44: {
                                                                block43: {
                                                                    int n7;
                                                                    block42: {
                                                                        void var5_10;
                                                                        block41: {
                                                                            int n8;
                                                                            block40: {
                                                                                block39: {
                                                                                    int n9;
                                                                                    block38: {
                                                                                        block37: {
                                                                                            int n10;
                                                                                            block36: {
                                                                                                cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                                                try {
                                                                                                    n10 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatMessageTopicId");
                                                                                                }
                                                                                                catch (Throwable throwable) {
                                                                                                    cursor.close();
                                                                                                    roomSQLiteQuery.release();
                                                                                                    throw throwable;
                                                                                                }
                                                                                                n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"senderUserId");
                                                                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"remoteSeqId");
                                                                                                n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"date");
                                                                                                n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"text");
                                                                                                n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                                                                n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"subtype");
                                                                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"replyTo");
                                                                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"status");
                                                                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"uuid");
                                                                                                if (!cursor.moveToFirst()) break block35;
                                                                                                if (!cursor.isNull(n10)) break block36;
                                                                                                string2 = null;
                                                                                                break block37;
                                                                                            }
                                                                                            string2 = cursor.getString(n10);
                                                                                        }
                                                                                        if (!cursor.isNull(n9)) break block38;
                                                                                        string7 = null;
                                                                                        break block39;
                                                                                    }
                                                                                    string7 = cursor.getString(n9);
                                                                                }
                                                                                Cursor cursor2 = cursor;
                                                                                int n11 = n8;
                                                                                n2 = cursor.getInt(n2);
                                                                                if (!cursor2.isNull(n11)) break block40;
                                                                                Object var5_8 = null;
                                                                                break block41;
                                                                            }
                                                                            Long l = cursor.getLong(n8);
                                                                        }
                                                                        Cursor cursor3 = cursor;
                                                                        int n12 = n7;
                                                                        date = MessagingDao_Impl.this.__converters.timestampToDate((Long)var5_10);
                                                                        if (!cursor3.isNull(n12)) break block42;
                                                                        string6 = null;
                                                                        break block43;
                                                                    }
                                                                    string6 = cursor.getString(n7);
                                                                }
                                                                if (!cursor.isNull(n6)) break block44;
                                                                string5 = null;
                                                                break block45;
                                                            }
                                                            string5 = cursor.getString(n6);
                                                        }
                                                        if (!cursor.isNull(n5)) break block46;
                                                        string4 = null;
                                                        break block47;
                                                    }
                                                    string4 = cursor.getString(n5);
                                                }
                                                if (!cursor.isNull(n4)) break block48;
                                                string3 = null;
                                                break block49;
                                            }
                                            string3 = cursor.getString(n4);
                                        }
                                        if (!cursor.isNull(n3)) break block50;
                                        Object var10_21 = null;
                                        break block51;
                                    }
                                    String string8 = cursor.getString(n3);
                                }
                                ChatMessageStatus chatMessageStatus = MessagingDao_Impl.this.__converters.stringToChatStatus((String)var10_23);
                                if (chatMessageStatus == null) throw new IllegalStateException("Expected non-null io.streamlayer.sdk.model.messaging.ChatMessageStatus, but it was null.");
                                Cursor cursor4 = cursor;
                                int n13 = n;
                                chatMessage = chatMessage2;
                                chatMessage2 = new ChatMessage(string2, string7, n2, date, string6, string5, string4, string3, chatMessageStatus);
                                if (!cursor4.isNull(n13)) break block52;
                                string2 = null;
                                break block53;
                            }
                            string2 = cursor.getString(n);
                        }
                        chatMessage.setId(string2);
                        break block54;
                    }
                    chatMessage = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return chatMessage;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)cancellationSignal, (Callable)callable2, continuation);
    }

    @Override
    public Object getWantAccess(String string2, Continuation<? super String> continuation) {
        Callable<String> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT Topic.want FROM Topic WHERE chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<String> callable2 = callable;
        callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                Cursor cursor;
                block5: {
                    block4: {
                        cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!cursor.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        if (cursor.isNull(0)) break block4;
                        string2 = cursor.getString(0);
                        break block5;
                    }
                    string2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return string2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isTopicMuted(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT Topic.mute FROM Topic WHERE chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                Cursor cursor = DBUtil.query((RoomDatabase)MessagingDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    Boolean bl2;
                    if (cursor.moveToFirst()) {
                        boolean bl3 = cursor.getInt(0) != 0;
                        bl2 = bl3;
                    } else {
                        bl2 = Boolean.FALSE;
                    }
                    bl = bl2;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return bl;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object setMessagesStatusBeforeSeqIdAndStatuses(final String string2, final int n, final ChatMessageStatus chatMessageStatus, final List<? extends ChatMessageStatus> list2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                49 v0 = this;
                StringBuilder stringBuilder = StringUtil.newStringBuilder();
                stringBuilder.append("UPDATE ChatMessage SET status=");
                stringBuilder.append("?");
                stringBuilder.append(" WHERE ChatMessage.chatMessageTopicId=");
                stringBuilder.append("?");
                stringBuilder.append(" AND ChatMessage.remoteSeqId < ");
                stringBuilder.append("?");
                stringBuilder.append(" AND ChatMessage.status IN(");
                StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)list2.size());
                stringBuilder.append(")");
                String string22 = stringBuilder.toString();
                string22 = v0.MessagingDao_Impl.this.__db.compileStatement(string22);
                int n3 = 1;
                Object object = v0.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageStatus);
                if (object == null) {
                    string22.bindNull(n3);
                } else {
                    string22.bindString(n3, (String)object);
                }
                n3 = 2;
                object = string2;
                if (object == null) {
                    string22.bindNull(n3);
                } else {
                    string22.bindString(n3, (String)object);
                }
                long l = n;
                string22.bindLong(3, l);
                int n2 = 4;
                for (Object object2 : list2) {
                    object2 = MessagingDao_Impl.this.__converters.chatStatusToString((ChatMessageStatus)((Object)object2));
                    if (object2 == null) {
                        string22.bindNull(n2);
                    } else {
                        string22.bindString(n2, (String)object2);
                    }
                    ++n2;
                }
                MessagingDao_Impl.this.__db.beginTransaction();
                try {
                    string22.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    MessagingDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                MessagingDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                MessagingDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public PagingSource<Integer, ChatMessageRelation> getChatMessagesSource(String string2, List<? extends ChatMessageStatus> list2) {
        return MessagingDao.DefaultImpls.getChatMessagesSource(this, string2, list2);
    }

    @Override
    public Flow<List<Topic>> getChats() {
        return MessagingDao.DefaultImpls.getChats(this);
    }

    @Override
    public Flow<Topic> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }
}

