/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.google.gson.Gson;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.data.workes.OnPushMessageWorker;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ(\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J&\u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\u001a\u0010\u0010\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000eR\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/model/deeplink/Payload;", "payload", "", "groupKey", "", "showSystemNotification", "Landroid/app/PendingIntent;", "pendingIntent", "updateSummary", "getNotificationTag", "", "data", "handlePushMessage", "Landroid/content/Context;", "context", "Landroid/content/Context;", "Lio/streamlayer/common/session/Session;", "session", "Lio/streamlayer/common/session/Session;", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "<init>", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;)V", "Companion", "sdk_originalRelease"})
public final class PushNotificationsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final MessagingRepo messagingRepo;

    public PushNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull MessagingRepo messagingRepo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)messagingRepo, (String)"messagingRepo");
        this.context = context;
        this.session = session2;
        this.messagingRepo = messagingRepo;
    }

    private final void showSystemNotification(Notification notification, Payload payload, String string2) {
        Number number = notification.getId();
        number = number == null ? null : Integer.valueOf((int)number.longValue());
        int n = number == null ? notification.hashCode() : ((Integer)number).intValue();
        Context context = ((PushNotificationsService)((Object)string3)).context;
        DeepLinkRoute deepLinkRoute = DeepLinkRoute.MAIN;
        Uri uri = NotificationKt.deepLink(notification);
        payload = DeepLinkHandler.INSTANCE.buildDeepLinkIntent$sdk_originalRelease(context, deepLinkRoute, uri, payload);
        int n2 = Build.VERSION.SDK_INT >= 31 ? 0xC000000 : 0x8000000;
        payload = PendingIntent.getActivity((Context)((PushNotificationsService)((Object)string3)).context, (int)n, (Intent)payload, (int)n2);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(((PushNotificationsService)((Object)string3)).context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)((PushNotificationsService)((Object)string3)).context, (int)R.color.slr_primaryBlue)).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, Notific\u2026notification.description)");
        if (payload != null) {
            builder.setContentIntent((PendingIntent)payload);
        }
        if (string2 != null) {
            builder.setGroup(((PushNotificationsService)((Object)string3)).context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = string3;
        pushNotificationsService.updateSummary(notification, string2, (PendingIntent)payload);
        String string3 = ((PushNotificationsService)((Object)string3)).getNotificationTag();
        notification = builder.build();
        NotificationManagerCompat.from((Context)pushNotificationsService.context).notify(string3, n, (android.app.Notification)notification);
    }

    static /* synthetic */ void showSystemNotification$default(PushNotificationsService pushNotificationsService, Notification notification, Payload payload, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            payload = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        pushNotificationsService.showSystemNotification(notification, payload, string2);
    }

    private final void updateSummary(Notification notification, String string2, PendingIntent object) {
        notification = new NotificationCompat.Builder(pushNotificationsService2.context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)pushNotificationsService2.context, (int)R.color.slr_primaryBlue)).setGroupSummary(true).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription()).setGroupAlertBehavior(2).setOnlyAlertOnce(true);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, Notific\u2026  .setOnlyAlertOnce(true)");
        if (object != null) {
            notification.setContentIntent((PendingIntent)object);
        }
        if (string2 != null) {
            notification.setGroup(pushNotificationsService2.context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = pushNotificationsService2;
        PushNotificationsService pushNotificationsService2 = NotificationManagerCompat.from((Context)pushNotificationsService.context);
        object = pushNotificationsService.getNotificationTag();
        int n = string2 == null ? 0 : string2.hashCode();
        PushNotificationsService pushNotificationsService3 = pushNotificationsService2;
        pushNotificationsService2 = notification.build();
        pushNotificationsService3.notify((String)object, n, (android.app.Notification)pushNotificationsService2);
    }

    static /* synthetic */ void updateSummary$default(PushNotificationsService pushNotificationsService, Notification notification, String string2, PendingIntent pendingIntent, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        pushNotificationsService.updateSummary(notification, string2, pendingIntent);
    }

    private final String getNotificationTag() {
        return Intrinsics.stringPlus((String)this.context.getPackageName(), (Object)"StreamLayer");
    }

    public final void handlePushMessage(@NotNull Map<String, String> object) {
        Data.Builder builder;
        OneTimeWorkRequest.Builder builder2;
        Object object2;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter(object, (String)"data");
        if (!pushNotificationsService.session.isLoggedIn()) {
            return;
        }
        Object object3 = object.get("category");
        Object object4 = GsonUtil.INSTANCE.getDefaultGson();
        Object object5 = (Intrinsics.areEqual((Object)object3, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object3, (Object)"sl_watch_party")) ? (ChatMessage)object4.fromJson(object.get("extra"), ChatMessage.class) : null;
        object4 = (Intrinsics.areEqual((Object)object3, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object3, (Object)"sl_watch_party")) ? (ChatMessageHeadPayload)object4.fromJson(object.get("extra"), ChatMessageHeadPayload.class) : null;
        object3 = Intrinsics.areEqual((Object)object3, (Object)"sl_chat") ? NotificationType.Chat : (Intrinsics.areEqual((Object)object3, (Object)"sl_watch_party") ? NotificationType.WatchParty : NotificationType.Universal);
        int n = object5 instanceof ChatMessage;
        if (n != 0) {
            pairArray = NotificationUtilKt.toNotification((ChatMessage)object5, (NotificationType)((Object)object3));
            object2 = WhenMappings.$EnumSwitchMapping$0[((Enum)object3).ordinal()] == 1 ? Long.valueOf((long)((ChatMessage)object5).getTopicId().hashCode() + (long)((ChatMessage)object5).getSeqId()) : Long.valueOf(((ChatMessage)object5).getTopicId().hashCode());
            pairArray.setId((Long)object2);
        } else {
            Pair[] pairArray2;
            pairArray = pairArray2;
            object2 = ((Enum)object3).name();
            pairArray2 = new Notification(null, null, null, (String)object2, null, null, null, null, 247, null);
        }
        if (object4 instanceof ChatMessageHeadPayload) {
            if (ChatMessageKt.isWave((ChatMessageHeadPayload)object4)) {
                Gson gson = object4;
                object2 = gson.getHead();
                object2 = object2 == null ? null : ((ChatMessageHead)object2).getEventId();
                object4 = new Payload.Wave((String)object2);
            } else {
                Payload.Notification notification;
                object4 = notification;
                notification = new Payload.Notification((NotificationType)((Object)object3), false, 2, null);
            }
        } else {
            object4 = null;
        }
        object2 = n != 0 ? ((ChatMessage)object5).getTopicId() : "general_group";
        Object object6 = object.get("title");
        if (object6 != null) {
            pairArray.setTitle((String)object6);
        }
        object6 = object.get("body");
        if (object6 != null) {
            pairArray.setDescription((String)object6);
        }
        object6 = SLRLog.INSTANCE;
        ((SLRLog)object6).i("PushNotificationsService", Intrinsics.stringPlus((String)"handlePush ", object));
        if (n != 0 && object3 == NotificationType.Chat) {
            if (TopicKt.isP2PTopic(((ChatMessage)object5).getTopicId())) {
                return;
            }
            if (TopicKt.isGroupTopic(((ChatMessage)object5).getTopicId()) && ((ChatMessage)object5).getSeqId() == 0) {
                return;
            }
        }
        int n2 = ((NotificationUtil)(object = NotificationUtil.INSTANCE)).isNotificationEnabled$sdk_originalRelease(pushNotificationsService.session, (Notification)pairArray) && !((NotificationUtil)object).isAppInForeground() ? 1 : 0;
        Boolean bl = pushNotificationsService.messagingRepo.isTopicMuted((String)object2);
        boolean bl2 = bl == null ? false : bl;
        ((SLRLog)object6).i("PushNotificationsService", Intrinsics.stringPlus((String)"isMuted ", (Object)bl2));
        if (n2 != 0 && !bl2) {
            pushNotificationsService.showSystemNotification((Notification)pairArray, (Payload)object4, (String)object2);
        }
        int n3 = n;
        PushNotificationsService pushNotificationsService = WorkManager.getInstance((Context)pushNotificationsService.context);
        object4 = builder2;
        builder2 = new OneTimeWorkRequest.Builder(OnPushMessageWorker.class);
        n = 3;
        Pair[] pairArray3 = new Pair[3];
        pairArray = pairArray3;
        pairArray[0] = TuplesKt.to((Object)"need_send_analytics", (Object)(n2 != 0));
        pairArray3[1] = TuplesKt.to((Object)"notification_type", (Object)((Enum)object3).name());
        n2 = 2;
        object3 = "topic_id";
        object5 = n3 != 0 ? ((ChatMessage)object5).getTopicId() : null;
        pairArray[n2] = TuplesKt.to((Object)object3, (Object)object5);
        Data.Builder builder3 = builder;
        builder = new Data.Builder();
        for (int i = 0; i < n; ++i) {
            Pair pair = pairArray[i];
            object5 = (String)pair.getFirst();
            builder3.put((String)object5, pair.getSecond());
        }
        Object object7 = object4;
        Data data = builder3.build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
        object7.setInputData(data);
        pushNotificationsService.enqueue(object7.build());
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService$Companion;", "", "", "", "data", "", "isStreamLayerPush", "<init>", "()V", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean isStreamLayerPush(@NotNull Map<String, String> map2) {
            Map<String, String> map3 = map2;
            Intrinsics.checkNotNullParameter(map3, (String)"data");
            return map3.containsKey("category") && ArraysKt.contains((Object[])new String[]{"sl_chat", "sl_watch_party"}, (Object)map2.get("category"));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.Chat.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

