/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.keyboard;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.keyboard.EmojiLayout;
import io.streamlayer.common.views.keyboard.KeyboardEmojiView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.ChatHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u00041234B'\b\u0007\u0012\u0006\u0010*\u001a\u00020)\u0012\n\b\u0002\u0010,\u001a\u0004\u0018\u00010+\u0012\b\b\u0002\u0010.\u001a\u00020-\u00a2\u0006\u0004\b/\u00100J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0002J\u0006\u0010\t\u001a\u00020\u0002J\u0010\u0010\f\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\nR\u0019\u0010\u000e\u001a\u00020\r8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0013\u001a\u00020\u00128\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\u00060\u001bR\u00020\u00008\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0018\u0010'\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "", "showEmoji", "showStickers", "", "value", "setKeyboardVisibility", "show", "hide", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$InputKeyboardEventListener;", "listener", "setInputKeyboardEventListener", "Lcom/google/android/material/tabs/TabLayout;", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "getTabLayout", "()Lcom/google/android/material/tabs/TabLayout;", "Landroidx/viewpager2/widget/ViewPager2;", "pager", "Landroidx/viewpager2/widget/ViewPager2;", "getPager", "()Landroidx/viewpager2/widget/ViewPager2;", "", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "keyboardPages", "Ljava/util/List;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "adapter", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "getAdapter", "()Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "Landroidx/appcompat/widget/AppCompatEditText;", "editText", "Landroidx/appcompat/widget/AppCompatEditText;", "getEditText", "()Landroidx/appcompat/widget/AppCompatEditText;", "setEditText", "(Landroidx/appcompat/widget/AppCompatEditText;)V", "inputKeyboardEventListener", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$InputKeyboardEventListener;", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attrs", "", "defStyleAttr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "Adapter", "InputKeyboardEventListener", "LayoutKeyboardConfiguration", "Pages", "sdk_originalRelease"})
public final class KeyboardEmojiView
extends ConstraintLayout {
    @NotNull
    private final TabLayout tabLayout;
    @NotNull
    private final ViewPager2 pager;
    @NotNull
    private final List<Pages> keyboardPages;
    @NotNull
    private final Adapter adapter;
    @Nullable
    private AppCompatEditText editText;
    @Nullable
    private InputKeyboardEventListener inputKeyboardEventListener;

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context, @Nullable AttributeSet object, int n) {
        ViewPager2 viewPager2;
        Adapter adapter2;
        ArrayList arrayList;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, (AttributeSet)object, n);
        object = arrayList;
        arrayList = new ArrayList();
        Object object2 = ChatHelper.INSTANCE;
        if (object2.isStickersEnable()) {
            object.add(Pages.STICKERS);
        }
        if (object2.isEmojiEnable()) {
            object.add(Pages.EMOJI);
        }
        if (object2.isGifsEnable()) {
            object.add(Pages.GIFS);
        }
        KeyboardEmojiView keyboardEmojiView = this;
        KeyboardEmojiView keyboardEmojiView2 = this;
        keyboardEmojiView2.keyboardPages = object;
        object2 = adapter2;
        keyboardEmojiView2.adapter = new Adapter((List<? extends Pages>)object);
        LayoutInflater.from((Context)context).inflate(R.layout.slr_layout_keyboard, (ViewGroup)this, true);
        View view2 = keyboardEmojiView.findViewById(R.id.tab_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.tab_layout)");
        object = (TabLayout)view2;
        keyboardEmojiView.tabLayout = object;
        View view3 = keyboardEmojiView.findViewById(R.id.pager);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.pager)");
        this.pager = viewPager2 = (ViewPager2)view3;
        viewPager2.setAdapter((RecyclerView.Adapter)object2);
        new TabLayoutMediator((TabLayout)object, viewPager2, (arg_0, arg_1) -> KeyboardEmojiView._init_$lambda-1(context, this, arg_0, arg_1)).attach();
        this.postDelayed(() -> KeyboardEmojiView._init_$lambda-2(context, keyboardEmojiView), 100L);
    }

    public /* synthetic */ KeyboardEmojiView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _init_$lambda-1(Context context, KeyboardEmojiView keyboardEmojiView, TabLayout.Tab tab, int n) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)((Object)keyboardEmojiView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        tab.setIcon(ContextCompat.getDrawable((Context)context, (int)keyboardEmojiView.keyboardPages.get(n).getIdRes()));
    }

    private static final void _init_$lambda-2(Context context, KeyboardEmojiView keyboardEmojiView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)((Object)keyboardEmojiView), (String)"this$0");
        if (LayoutKeyboardConfiguration.INSTANCE.getHeight(context) == 0) {
            AppCompatEditText appCompatEditText = keyboardEmojiView.getEditText();
            if (appCompatEditText != null) {
                appCompatEditText.requestFocus();
            }
            context = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (context != null) {
                context.showSoftInput((View)keyboardEmojiView.getEditText(), 0);
            }
        }
    }

    @NotNull
    public final TabLayout getTabLayout() {
        return this.tabLayout;
    }

    @NotNull
    public final ViewPager2 getPager() {
        return this.pager;
    }

    @NotNull
    public final Adapter getAdapter() {
        return this.adapter;
    }

    @Nullable
    public final AppCompatEditText getEditText() {
        return this.editText;
    }

    public final void setEditText(@Nullable AppCompatEditText appCompatEditText) {
        this.editText = appCompatEditText;
    }

    public final void showEmoji() {
        KeyboardEmojiView keyboardEmojiView = this;
        keyboardEmojiView.show();
        keyboardEmojiView.pager.setCurrentItem(1, false);
    }

    public final void showStickers() {
        KeyboardEmojiView keyboardEmojiView = this;
        keyboardEmojiView.show();
        keyboardEmojiView.pager.setCurrentItem(0, false);
    }

    public final void setKeyboardVisibility(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public final void show() {
        Context context = inputKeyboardEventListener.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(inputKeyboardEventListener.getWindowToken(), 0);
        }
        inputMethodManager = inputKeyboardEventListener.getLayoutParams();
        if (inputMethodManager != null) {
            inputMethodManager = (ConstraintLayout.LayoutParams)inputMethodManager;
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = LayoutKeyboardConfiguration.INSTANCE;
            Context context2 = inputKeyboardEventListener.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            if (layoutKeyboardConfiguration.getHeight(context2) != 0) {
                Context context3 = inputKeyboardEventListener.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                inputMethodManager.height = layoutKeyboardConfiguration.getHeight(context3);
            }
            KeyboardEmojiView keyboardEmojiView = inputKeyboardEventListener;
            keyboardEmojiView.setVisibility(0);
            keyboardEmojiView.setLayoutParams((ViewGroup.LayoutParams)inputMethodManager);
            InputKeyboardEventListener inputKeyboardEventListener = keyboardEmojiView.inputKeyboardEventListener;
            if (inputKeyboardEventListener != null) {
                inputKeyboardEventListener.onKeyboardVisible(true);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
    }

    public final void hide() {
        KeyboardEmojiView keyboardEmojiView = inputKeyboardEventListener;
        keyboardEmojiView.setVisibility(8);
        InputKeyboardEventListener inputKeyboardEventListener = keyboardEmojiView.inputKeyboardEventListener;
        if (inputKeyboardEventListener != null) {
            inputKeyboardEventListener.onKeyboardVisible(false);
        }
    }

    public final void setInputKeyboardEventListener(@Nullable InputKeyboardEventListener inputKeyboardEventListener) {
        this.inputKeyboardEventListener = inputKeyboardEventListener;
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0019\u0010\u0003\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "", "", "idRes", "I", "getIdRes", "()I", "<init>", "(Ljava/lang/String;II)V", "STICKERS", "EMOJI", "GIFS", "sdk_originalRelease"})
    public static final class Pages
    extends Enum<Pages> {
        public static final /* enum */ Pages STICKERS;
        public static final /* enum */ Pages EMOJI;
        public static final /* enum */ Pages GIFS;
        private static final /* synthetic */ Pages[] $VALUES;
        private final int idRes;

        private Pages(int n2) {
            this.idRes = n2;
        }

        public static Pages[] values() {
            return (Pages[])$VALUES.clone();
        }

        public static Pages valueOf(String string2) {
            return Enum.valueOf(Pages.class, string2);
        }

        private static final /* synthetic */ Pages[] $values() {
            return new Pages[]{STICKERS, EMOJI, GIFS};
        }

        static {
            int n = R.drawable.slr_ic_chat_attach;
            STICKERS = new Pages(n);
            n = R.drawable.slr_ic_emoji_tab;
            EMOJI = new Pages(n);
            n = R.drawable.slr_ic_gif_tab;
            GIFS = new Pages(n);
            $VALUES = Pages.$values();
        }

        public final int getIdRes() {
            return this.idRes;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u0010\u0012\f\u0012\n0\u0002R\u00060\u0000R\u00020\u00030\u0001:\u0001\u0014B\u0015\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\b\u001a\n0\u0002R\u00060\u0000R\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\u000b2\u000e\u0010\t\u001a\n0\u0002R\u00060\u0000R\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter$PageVH;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "Landroid/view/ViewGroup;", "parent", "", "viewType", "onCreateViewHolder", "holder", "position", "", "onBindViewHolder", "getItemCount", "", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "pages", "Ljava/util/List;", "<init>", "(Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;Ljava/util/List;)V", "PageVH", "sdk_originalRelease"})
    public final class Adapter
    extends RecyclerView.Adapter<PageVH> {
        @NotNull
        private final List<Pages> pages;

        public Adapter(List<? extends Pages> list2) {
            Intrinsics.checkNotNullParameter((Object)((Object)KeyboardEmojiView.this), (String)"this$0");
            Intrinsics.checkNotNullParameter(list2, (String)"pages");
            this.pages = list2;
        }

        @NotNull
        public PageVH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
            FrameLayout frameLayout;
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
            FrameLayout frameLayout2 = frameLayout;
            new FrameLayout(viewGroup.getContext()).setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
            return new PageVH(this, (ViewGroup)frameLayout2);
        }

        public void onBindViewHolder(@NotNull PageVH pageVH, int n) {
            RecyclerView recyclerView;
            Intrinsics.checkNotNullParameter((Object)((Object)pageVH), (String)"holder");
            int n2 = WhenMappings.$EnumSwitchMapping$0[object.pages.get(n).ordinal()];
            if (n2 != 1) {
                if (n2 == 2) {
                    MaterialTextView materialTextView;
                    MaterialTextView materialTextView2;
                    ViewGroup viewGroup = pageVH.getParent();
                    MaterialTextView materialTextView3 = materialTextView2 = materialTextView;
                    materialTextView3(object.KeyboardEmojiView.this.getContext());
                    Context context = materialTextView2.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    materialTextView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, LayoutKeyboardConfiguration.INSTANCE.getHeight(context)));
                    materialTextView3.setGravity(17);
                    materialTextView.setText((CharSequence)object.pages.get(n).name());
                    viewGroup.addView((View)materialTextView);
                }
            } else {
                ViewGroup viewGroup = pageVH.getParent();
                Context context = object.KeyboardEmojiView.this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                EmojiLayout emojiLayout = new EmojiLayout(context, null, 0, 6, null);
                KeyboardEmojiView keyboardEmojiView = object.KeyboardEmojiView.this;
                emojiLayout.setId(View.generateViewId());
                emojiLayout.setEditText(keyboardEmojiView.getEditText());
                emojiLayout.setPager(keyboardEmojiView.getPager());
                viewGroup.addView((View)emojiLayout);
            }
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = LayoutKeyboardConfiguration.INSTANCE;
            Context context = object.KeyboardEmojiView.this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (layoutKeyboardConfiguration.getHeight(context) != 0 && (recyclerView = pageVH.getList()) != null) {
                Object object = object.KeyboardEmojiView.this;
                ViewGroup.LayoutParams layoutParams = recyclerView.getLayoutParams();
                if (layoutParams != null) {
                    ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
                    Context context2 = object.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                    layoutParams2.height = layoutKeyboardConfiguration.getHeight(context2) - pageVH.getParent().getResources().getDimensionPixelSize(R.dimen.slr_keyboard_tab_height) - pageVH.getParent().getResources().getDimensionPixelSize(R.dimen.slr_emoji_tab_height);
                    recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
            }
        }

        public int getItemCount() {
            return this.pages.size();
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0019\u0010\u0003\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\f\u001a\u0004\u0018\u00010\u00078F@\u0006X\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter$PageVH;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Landroid/view/ViewGroup;", "parent", "Landroid/view/ViewGroup;", "getParent", "()Landroid/view/ViewGroup;", "Landroidx/recyclerview/widget/RecyclerView;", "list$delegate", "Lkotlin/Lazy;", "getList", "()Landroidx/recyclerview/widget/RecyclerView;", "list", "<init>", "(Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;Landroid/view/ViewGroup;)V", "sdk_originalRelease"})
        public final class PageVH
        extends RecyclerView.ViewHolder {
            @NotNull
            private final ViewGroup parent;
            @NotNull
            private final Lazy list$delegate;
            final /* synthetic */ Adapter this$0;

            public PageVH(@NotNull Adapter adapter2, ViewGroup viewGroup) {
                PageVH pageVH = this;
                Intrinsics.checkNotNullParameter((Object)((Object)adapter2), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
                this.this$0 = adapter2;
                super((View)viewGroup);
                pageVH.parent = viewGroup;
                pageVH.list$delegate = LazyKt.lazy((Function0)new Function0<RecyclerView>(this){
                    final /* synthetic */ PageVH this$0;
                    {
                        this.this$0 = pageVH;
                        super(0);
                    }

                    public final RecyclerView invoke() {
                        return (RecyclerView)this.this$0.getParent().findViewById(R.id.list_item);
                    }
                });
            }

            @NotNull
            public final ViewGroup getParent() {
                return this.parent;
            }

            @Nullable
            public final RecyclerView getList() {
                return (RecyclerView)this.list$delegate.getValue();
            }
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Pages.values().length];
                nArray[Pages.EMOJI.ordinal()] = 1;
                nArray[Pages.GIFS.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$InputKeyboardEventListener;", "", "", "value", "", "onKeyboardVisible", "sdk_originalRelease"})
    public static interface InputKeyboardEventListener {
        public void onKeyboardVisible(boolean var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bR\"\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u00188\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$LayoutKeyboardConfiguration;", "", "Landroid/view/ViewGroup;", "parent", "", "initKeyboardHeight", "Landroidx/fragment/app/FragmentActivity;", "activity", "Landroid/content/Context;", "context", "", "height", "setupKeyboardHeight", "getNavigationBarHeight", "getHeight", "keyboardHeightPortrait", "I", "getKeyboardHeightPortrait", "()I", "setKeyboardHeightPortrait", "(I)V", "keyboardHeightLandscape", "getKeyboardHeightLandscape", "setKeyboardHeightLandscape", "", "KEYBOARD_PREF", "Ljava/lang/String;", "KEYBOARD_HEIGHT_PORT", "KEYBOARD_HEIGHT_LAND", "<init>", "()V", "sdk_originalRelease"})
    public static final class LayoutKeyboardConfiguration {
        @NotNull
        public static final LayoutKeyboardConfiguration INSTANCE = new LayoutKeyboardConfiguration();
        private static int keyboardHeightPortrait;
        private static int keyboardHeightLandscape;
        @NotNull
        private static final String KEYBOARD_PREF = "keyboard_pref";
        @NotNull
        private static final String KEYBOARD_HEIGHT_PORT = "height_port";
        @NotNull
        private static final String KEYBOARD_HEIGHT_LAND = "height_land";

        private LayoutKeyboardConfiguration() {
        }

        private static final WindowInsetsCompat initKeyboardHeight$lambda-0(ViewGroup viewGroup, View view2, WindowInsetsCompat windowInsetsCompat) {
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"$parent");
            viewGroup = viewGroup.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)viewGroup, (String)"parent.context");
            INSTANCE.setupKeyboardHeight((Context)viewGroup, windowInsetsCompat.getInsets((int)WindowInsetsCompat.Type.ime()).bottom);
            return windowInsetsCompat;
        }

        public final void initKeyboardHeight(@NotNull ViewGroup viewGroup) {
            ViewGroup viewGroup2 = viewGroup;
            Intrinsics.checkNotNullParameter((Object)viewGroup2, (String)"parent");
            ViewCompat.setOnApplyWindowInsetsListener((View)viewGroup2, (arg_0, arg_1) -> LayoutKeyboardConfiguration.initKeyboardHeight$lambda-0(viewGroup2, arg_0, arg_1));
        }

        public final void initKeyboardHeight(@NotNull FragmentActivity fragmentActivity) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"activity");
            View view2 = fragmentActivity2.findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"activity.findViewById(android.R.id.content)");
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = (ViewGroup)view2;
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener((ViewGroup)layoutKeyboardConfiguration, fragmentActivity){
                final /* synthetic */ ViewGroup $rootContent;
                final /* synthetic */ FragmentActivity $activity;
                {
                    this.$rootContent = viewGroup;
                    this.$activity = fragmentActivity;
                }

                private static final void onGlobalLayout$lambda-0(ViewGroup viewGroup, FragmentActivity fragmentActivity, initKeyboardHeight.layoutListener.1 var2_2) {
                    Rect rect;
                    ViewGroup viewGroup2 = viewGroup;
                    Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"$rootContent");
                    Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"$activity");
                    Intrinsics.checkNotNullParameter((Object)var2_2, (String)"this$0");
                    Rect rect2 = rect;
                    rect = new Rect();
                    viewGroup2.getRootView().getWindowVisibleDisplayFrame(rect2);
                    int[] nArray = new int[2];
                    viewGroup2.getLocationOnScreen(nArray);
                    int n = viewGroup2.getRootView().getHeight();
                    int n2 = fragmentActivity.getResources().getConfiguration().orientation == 1 ? LayoutKeyboardConfiguration.INSTANCE.getNavigationBarHeight((Context)fragmentActivity) : 0;
                    int n3 = n - rect2.height() - nArray[1] - n2;
                    if (n3 > fragmentActivity.getResources().getDisplayMetrics().heightPixels / 3) {
                        LayoutKeyboardConfiguration.INSTANCE.setupKeyboardHeight((Context)fragmentActivity, n3);
                        viewGroup.getRootView().getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)var2_2);
                    }
                }

                public void onGlobalLayout() {
                    ViewGroup viewGroup = this.$rootContent;
                    viewGroup.postDelayed(() -> initKeyboardHeight.layoutListener.1.onGlobalLayout$lambda-0(viewGroup, this.$activity, this), 100L);
                }
            };
            layoutKeyboardConfiguration.getRootView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
        }

        public final void setupKeyboardHeight(@NotNull Context context, int n) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (n != 0) {
                Context context2 = context;
                LayoutKeyboardConfiguration layoutKeyboardConfiguration = context2.getSharedPreferences(KEYBOARD_PREF, 0).edit();
                Intrinsics.checkNotNullExpressionValue((Object)layoutKeyboardConfiguration, (String)"context.getSharedPrefere\u2026text.MODE_PRIVATE).edit()");
                if (context2.getResources().getConfiguration().orientation == 1) {
                    keyboardHeightPortrait = n;
                    layoutKeyboardConfiguration.putInt(KEYBOARD_HEIGHT_PORT, n).apply();
                } else {
                    keyboardHeightLandscape = n;
                    layoutKeyboardConfiguration.putInt(KEYBOARD_HEIGHT_LAND, n).apply();
                }
            }
        }

        public final int getNavigationBarHeight(@NotNull Context context) {
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return context2.getResources().getDimensionPixelSize(context.getResources().getIdentifier("navigation_bar_height", "dimen", "android"));
        }

        public final int getHeight(@NotNull Context context) {
            int n;
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = context2.getSharedPreferences(KEYBOARD_PREF, 0);
            Intrinsics.checkNotNullExpressionValue((Object)layoutKeyboardConfiguration, (String)"context.getSharedPrefere\u2026EF, Context.MODE_PRIVATE)");
            if (context2.getResources().getConfiguration().orientation == 1) {
                if (keyboardHeightPortrait == 0) {
                    keyboardHeightPortrait = layoutKeyboardConfiguration.getInt(KEYBOARD_HEIGHT_PORT, 0);
                }
                SLRLog.INSTANCE.d("ChatViewModel", Intrinsics.stringPlus((String)"LayoutKeyboardConfiguration keyboardHeightPortrait ", (Object)keyboardHeightPortrait));
                n = keyboardHeightPortrait;
            } else {
                if (keyboardHeightLandscape == 0) {
                    keyboardHeightLandscape = layoutKeyboardConfiguration.getInt(KEYBOARD_HEIGHT_LAND, 0);
                }
                SLRLog.INSTANCE.d("ChatViewModel", Intrinsics.stringPlus((String)"LayoutKeyboardConfiguration keyboardHeightLandscape ", (Object)keyboardHeightLandscape));
                n = keyboardHeightLandscape;
            }
            return n;
        }

        public final int getKeyboardHeightPortrait() {
            return keyboardHeightPortrait;
        }

        public final void setKeyboardHeightPortrait(int n) {
            keyboardHeightPortrait = n;
        }

        public final int getKeyboardHeightLandscape() {
            return keyboardHeightLandscape;
        }

        public final void setKeyboardHeightLandscape(int n) {
            keyboardHeightLandscape = n;
        }
    }
}

