/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.extensions;

import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.common.extensions.FragmentExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/common/extensions/FragmentViewBindingDelegate;", "T", "Landroidx/viewbinding/ViewBinding;", "Lkotlin/properties/ReadOnlyProperty;", "Landroidx/fragment/app/Fragment;", "fragment", "viewBindingFactory", "Lkotlin/Function1;", "Landroid/view/View;", "(Landroidx/fragment/app/Fragment;Lkotlin/jvm/functions/Function1;)V", "binding", "Landroidx/viewbinding/ViewBinding;", "getFragment", "()Landroidx/fragment/app/Fragment;", "getViewBindingFactory", "()Lkotlin/jvm/functions/Function1;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Landroidx/fragment/app/Fragment;Lkotlin/reflect/KProperty;)Landroidx/viewbinding/ViewBinding;", "sdk_originalVoximplantRelease"})
public final class FragmentViewBindingDelegate<T extends ViewBinding>
implements ReadOnlyProperty<Fragment, T> {
    @NotNull
    private final Fragment fragment;
    @NotNull
    private final Function1<View, T> viewBindingFactory;
    @Nullable
    private T binding;

    public FragmentViewBindingDelegate(@NotNull Fragment fragment, @NotNull Function1<? super View, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(function1, (String)"viewBindingFactory");
        this.fragment = fragment;
        this.viewBindingFactory = function1;
        fragment.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){
            @NotNull
            private final Observer<LifecycleOwner> viewLifecycleOwnerLiveDataObserver = arg_0 -> 1.viewLifecycleOwnerLiveDataObserver$lambda-0(fragmentViewBindingDelegate, arg_0);

            private static final void viewLifecycleOwnerLiveDataObserver$lambda-0(FragmentViewBindingDelegate fragmentViewBindingDelegate, LifecycleOwner lifecycleOwner) {
                Intrinsics.checkNotNullParameter((Object)fragmentViewBindingDelegate, (String)"this$0");
                if (lifecycleOwner == null) {
                    return;
                }
                lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragmentViewBindingDelegate){
                    final /* synthetic */ FragmentViewBindingDelegate<T> this$0;
                    {
                        this.this$0 = fragmentViewBindingDelegate;
                    }

                    public void onDestroy(@NotNull LifecycleOwner lifecycleOwner) {
                        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"owner");
                        FragmentViewBindingDelegate.access$setBinding$p(this.this$0, null);
                    }
                });
            }

            @NotNull
            public final Observer<LifecycleOwner> getViewLifecycleOwnerLiveDataObserver() {
                return this.viewLifecycleOwnerLiveDataObserver;
            }

            public void onCreate(@NotNull LifecycleOwner lifecycleOwner) {
                Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"owner");
                this.getFragment().getViewLifecycleOwnerLiveData().observeForever(this.viewLifecycleOwnerLiveDataObserver);
            }

            public void onDestroy(@NotNull LifecycleOwner lifecycleOwner) {
                Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"owner");
                this.getFragment().getViewLifecycleOwnerLiveData().removeObserver(this.viewLifecycleOwnerLiveDataObserver);
            }
        });
    }

    public static final /* synthetic */ void access$setBinding$p(FragmentViewBindingDelegate fragmentViewBindingDelegate, ViewBinding viewBinding) {
        fragmentViewBindingDelegate.binding = viewBinding;
    }

    @NotNull
    public final Fragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final Function1<View, T> getViewBindingFactory() {
        return this.viewBindingFactory;
    }

    @NotNull
    public T getValue(@NotNull Fragment fragment, @NotNull KProperty<?> object) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"thisRef");
        Intrinsics.checkNotNullParameter(object, (String)"property");
        object = this.binding;
        if (object != null) {
            return (T)object;
        }
        if (FragmentExtensionsKt.canUseBinding(this.fragment)) {
            View view2 = fragment.requireView();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"thisRef.requireView()");
            this.binding = (ViewBinding)this.viewBindingFactory.invoke((Object)view2);
            return this.binding;
        }
        throw new IllegalStateException("Should not attempt to get bindings when Fragment views are destroyed.");
    }
}

