/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.tooltip;

import android.animation.Animator;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.AppCompatButton;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.ColorUtils;
import com.airbnb.lottie.LottieAnimationView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.common.views.tooltips.ViewTooltipHandlerKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.common.DashLineView;
import io.streamlayer.sdk.messaging.tooltip.MessagingZoneTooltip;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0004J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020*H&J\u0010\u0010+\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020*H&J\b\u0010,\u001a\u00020\u0013H\u0004J\u001e\u0010-\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010.\u001a\u00020\u0013H\u0004J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0006H\u0004J\b\u00101\u001a\u00020\u0013H\u0004J\u0014\u00102\u001a\u00020\u0013*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u0019R\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lio/streamlayer/sdk/messaging/tooltip/MessagingZoneTooltip;", "", "()V", "_isTooltipVisible", "", "backgroundView", "Landroid/view/View;", "blinkRunnable", "Ljava/lang/Runnable;", "getBlinkRunnable", "()Ljava/lang/Runnable;", "bubbleView", "Lio/streamlayer/common/views/tooltips/BubbleView;", "dashLineView", "Lio/streamlayer/sdk/messaging/common/DashLineView;", "getDashLineView", "()Lio/streamlayer/sdk/messaging/common/DashLineView;", "onDismiss", "Lkotlin/Function0;", "", "opacity", "", "getOpacity", "()F", "setOpacity", "(F)V", "parentView", "Landroidx/constraintlayout/widget/ConstraintLayout;", "stepOpacity", "getStepOpacity", "setStepOpacity", "zoneView", "getZoneView", "()Landroid/view/View;", "buildTooltipAnimation", "Lio/streamlayer/common/views/tooltips/BubbleView$Animation;", "lottie", "Lcom/airbnb/lottie/LottieAnimationView;", "okButton", "Landroidx/appcompat/widget/AppCompatButton;", "root", "getBackGroundView", "Landroid/view/ViewGroup;", "getBubbleView", "hideTooltip", "showTooltip", "showZone", "startAnimationBlink", "view", "stopZone", "setSwipeZoneColor", "sdk_originalVoximplantRelease"})
public abstract class MessagingZoneTooltip {
    private float opacity;
    private float stepOpacity;
    @Nullable
    private BubbleView bubbleView;
    @Nullable
    private View backgroundView;
    private boolean _isTooltipVisible;
    @Nullable
    private ConstraintLayout parentView;
    @Nullable
    private Function0<Unit> onDismiss;
    @NotNull
    private final Runnable blinkRunnable;

    public MessagingZoneTooltip() {
        MessagingZoneTooltip messagingZoneTooltip = this;
        messagingZoneTooltip.opacity = 60.0f;
        messagingZoneTooltip.stepOpacity = 5.0f;
        messagingZoneTooltip.blinkRunnable = () -> MessagingZoneTooltip.blinkRunnable$lambda-1(messagingZoneTooltip);
    }

    private static final void blinkRunnable$lambda-1(MessagingZoneTooltip messagingZoneTooltip) {
        float f;
        float f2;
        MessagingZoneTooltip messagingZoneTooltip2 = messagingZoneTooltip;
        Intrinsics.checkNotNullParameter((Object)messagingZoneTooltip2, (String)"this$0");
        View view2 = messagingZoneTooltip2.getZoneView();
        if (view2 != null) {
            MessagingZoneTooltip messagingZoneTooltip3 = messagingZoneTooltip;
            messagingZoneTooltip3.setSwipeZoneColor(view2, messagingZoneTooltip3.opacity);
        }
        messagingZoneTooltip.opacity = f2 = messagingZoneTooltip.opacity + messagingZoneTooltip.stepOpacity;
        if (f < 0.0f) {
            messagingZoneTooltip.stepOpacity = 5.0f;
        } else if (f2 > 60.0f) {
            messagingZoneTooltip.stepOpacity = -5.0f;
        }
        View view3 = messagingZoneTooltip.getZoneView();
        if (view3 != null) {
            messagingZoneTooltip.startAnimationBlink(view3);
        }
    }

    @Nullable
    protected abstract View getZoneView();

    @Nullable
    protected abstract DashLineView getDashLineView();

    protected final float getOpacity() {
        return this.opacity;
    }

    protected final void setOpacity(float f) {
        this.opacity = f;
    }

    protected final float getStepOpacity() {
        return this.stepOpacity;
    }

    protected final void setStepOpacity(float f) {
        this.stepOpacity = f;
    }

    @NotNull
    protected final Runnable getBlinkRunnable() {
        return this.blinkRunnable;
    }

    @NotNull
    public abstract BubbleView getBubbleView(@NotNull ViewGroup var1);

    @NotNull
    public abstract View getBackGroundView(@NotNull ViewGroup var1);

    public void showTooltip(@NotNull ConstraintLayout constraintLayout, @NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parentView");
        Intrinsics.checkNotNullParameter(function0, (String)"onDismiss");
        Context context = constraintLayout.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parentView.context");
        if (!OtherExtensionsKt.isScreenPortrait(context) && !this._isTooltipVisible) {
            this.parentView = constraintLayout;
            this.onDismiss = function0;
            this._isTooltipVisible = true;
            this.showZone();
            this.backgroundView = this.getBackGroundView((ViewGroup)constraintLayout);
            this.bubbleView = this.getBubbleView((ViewGroup)constraintLayout);
            return;
        }
    }

    protected final void startAnimationBlink(@NotNull View view2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.postDelayed(this.blinkRunnable, 100L);
    }

    protected final void showZone() {
        View view2 = ((MessagingZoneTooltip)this).getZoneView();
        if (view2 != null) {
            view2.setVisibility(0);
            ((MessagingZoneTooltip)this).startAnimationBlink(view2);
        }
        if ((this = ((MessagingZoneTooltip)this).getDashLineView()) != null) {
            Object object = this;
            object.setVisibility(0);
            ((DashLineView)((Object)object)).start();
        }
    }

    protected final void setSwipeZoneColor(@NotNull View view2, float f) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"<this>");
        if (!(f < 0.0f) && !(f > 255.0f)) {
            View view3 = view2;
            Context context = view3.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            view3.setBackgroundColor(ColorUtils.setAlphaComponent((int)ExtensionsKt.colorByAttribute(context, R.attr.slrChatSwipeZoneBackgroundColor, R.color.slr_blue50), (int)((int)(f / (float)100 * (float)255))));
            return;
        }
    }

    protected final void stopZone() {
        View view2 = ((MessagingZoneTooltip)this).getZoneView();
        if (view2 != null) {
            view2.setVisibility(8);
            view2.removeCallbacks(((MessagingZoneTooltip)this).blinkRunnable);
        }
        if ((this = ((MessagingZoneTooltip)this).getDashLineView()) != null) {
            Object object = this;
            object.setVisibility(8);
            ((DashLineView)((Object)object)).stop();
        }
    }

    protected final void hideTooltip() {
        ConstraintLayout constraintLayout;
        if (!this._isTooltipVisible) {
            return;
        }
        Function0<Unit> function0 = this;
        function0._isTooltipVisible = false;
        function0.stopZone();
        BubbleView bubbleView = function0.bubbleView;
        if (bubbleView != null) {
            BubbleView.close$default(bubbleView, null, 1, null);
        }
        if ((bubbleView = this.backgroundView) != null && (constraintLayout = this.parentView) != null) {
            constraintLayout.removeView((View)bubbleView);
        }
        if ((this = this.onDismiss) != null) {
            this.invoke();
        }
    }

    @NotNull
    protected final BubbleView.Animation buildTooltipAnimation(@NotNull LottieAnimationView lottieAnimationView, @NotNull AppCompatButton appCompatButton, @NotNull View view2) {
        Intrinsics.checkNotNullParameter((Object)lottieAnimationView, (String)"lottie");
        Intrinsics.checkNotNullParameter((Object)appCompatButton, (String)"okButton");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"root");
        return new BubbleView.Animation(view2, appCompatButton, this, lottieAnimationView){
            final /* synthetic */ View $root;
            final /* synthetic */ AppCompatButton $okButton;
            final /* synthetic */ MessagingZoneTooltip this$0;
            final /* synthetic */ LottieAnimationView $lottie;
            {
                this.$root = view2;
                this.$okButton = appCompatButton;
                this.this$0 = messagingZoneTooltip;
                this.$lottie = lottieAnimationView;
            }

            private static final void animateEnter$lambda-1$lambda-0(MessagingZoneTooltip messagingZoneTooltip, View view2) {
                MessagingZoneTooltip messagingZoneTooltip2 = messagingZoneTooltip;
                Intrinsics.checkNotNullParameter((Object)messagingZoneTooltip2, (String)"this$0");
                messagingZoneTooltip2.hideTooltip();
            }

            public void animateEnter(@NotNull BubbleView object) {
                BubbleView bubbleView = object;
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"view");
                bubbleView.setAlpha(0.0f);
                bubbleView.animate().alpha(1.0f).translationY((float)ViewExtensionsKt.getDp(30.0f)).setDuration(1000L).start();
                MessagingZoneTooltip messagingZoneTooltip = messagingZoneTooltip.this$0;
                object = CollectionsKt.listOf((Object[])new View[]{messagingZoneTooltip.$root, messagingZoneTooltip.$okButton}).iterator();
                while (object.hasNext()) {
                    ((View)object.next()).setOnClickListener(arg_0 -> buildTooltipAnimation.1.animateEnter$lambda-1$lambda-0(messagingZoneTooltip, arg_0));
                }
            }

            public void animateExit(@NotNull BubbleView bubbleView, @NotNull Animator.AnimatorListener animatorListener) {
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"view");
                Intrinsics.checkNotNullParameter((Object)animatorListener, (String)"animatorListener");
                this.$lottie.pauseAnimation();
                ViewTooltipHandlerKt.runExitAnimation(bubbleView, animatorListener);
            }
        };
    }
}

