/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.text.TextUtils;
import android.util.LruCache;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetHashtag;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.model.social.TweetSymbol;
import io.streamlayer.sdk.model.social.TweetUrl;
import io.streamlayer.sdk.model.social.TweetUserMention;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedMediaEntity;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedText;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedUrlEntity;
import io.streamlayer.sdk.twitter.view.internal.format.HtmlEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u0002J(\u0010\u000e\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\nH\u0002J\u001c\u0010\u0010\u001a\u00020\b2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "", "()V", "cache", "Landroid/util/LruCache;", "", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedText;", "adjustEntitiesWithOffsets", "", "entities", "", "Lio/streamlayer/sdk/twitter/view/internal/format/FormattedUrlEntity;", "indices", "", "adjustIndicesForEscapedChars", "", "adjustIndicesForSupplementaryChars", "content", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "formattedText", "convertEntities", "tweet", "Lio/streamlayer/sdk/model/social/Tweet;", "format", "formatTweetText", "Companion", "sdk_originalVoximplantRelease"})
public final class TweetFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_CACHE_SIZE = 20;
    @NotNull
    private final LruCache<Long, FormattedText> cache;

    public TweetFormatter() {
        LruCache lruCache;
        TweetFormatter tweetFormatter = lruCache;
        lruCache = new LruCache(20);
        v1.cache = tweetFormatter;
    }

    private final FormattedText format(Tweet tweet) {
        FormattedText formattedText;
        FormattedText formattedText2 = formattedText;
        TweetFormatter tweetFormatter = this;
        formattedText2();
        tweetFormatter.convertEntities(formattedText2, tweet);
        tweetFormatter.format(formattedText2, tweet);
        return formattedText;
    }

    private final void convertEntities(FormattedText formattedText, Tweet object3) {
        for (TweetUrl tweetUrl : ((Tweet)object3).getMetaData().getEntities().getUrls()) {
            formattedText.getUrlEntities().add(FormattedUrlEntity.Companion.from(tweetUrl));
        }
        for (TweetMedia tweetMedia : ((Tweet)object3).getMetaData().getEntities().getMedia()) {
            formattedText.getMediaEntities().add(new FormattedMediaEntity(tweetMedia));
        }
        for (TweetHashtag tweetHashtag : ((Tweet)object3).getMetaData().getEntities().getHashtags()) {
            formattedText.getHashtagEntities().add(FormattedUrlEntity.Companion.from(tweetHashtag));
        }
        for (TweetUserMention tweetUserMention : ((Tweet)object3).getMetaData().getEntities().getUserMentions()) {
            formattedText.getMentionEntities().add(FormattedUrlEntity.Companion.from(tweetUserMention));
        }
        for (TweetSymbol tweetSymbol : ((Tweet)object3).getMetaData().getEntities().getSymbols()) {
            formattedText.getSymbolEntities().add(FormattedUrlEntity.Companion.from(tweetSymbol));
        }
    }

    private final void format(FormattedText formattedText, Tweet list2) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)((Tweet)((Object)list2)).getText())) {
            return;
        }
        TweetFormatter tweetFormatter = stringBuilder2;
        HtmlEntities.Unescaped unescaped = HtmlEntities.HTML40.unescape(((Tweet)((Object)list2)).getText());
        list2 = unescaped;
        TweetFormatter tweetFormatter2 = stringBuilder2;
        List<FormattedUrlEntity> list3 = list2;
        TweetFormatter tweetFormatter3 = stringBuilder2;
        List<FormattedUrlEntity> list4 = list2;
        TweetFormatter tweetFormatter4 = stringBuilder2;
        List<FormattedUrlEntity> list5 = list2;
        TweetFormatter tweetFormatter5 = stringBuilder2;
        List<FormattedUrlEntity> list6 = list2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(((HtmlEntities.Unescaped)((Object)list2)).unescaped);
        list2 = formattedText.getUrlEntities();
        tweetFormatter5.adjustIndicesForEscapedChars(list2, ((HtmlEntities.Unescaped)((Object)list6)).indices);
        list2 = formattedText.getMediaEntities();
        tweetFormatter4.adjustIndicesForEscapedChars(list2, ((HtmlEntities.Unescaped)((Object)list5)).indices);
        list2 = formattedText.getHashtagEntities();
        tweetFormatter3.adjustIndicesForEscapedChars(list2, ((HtmlEntities.Unescaped)((Object)list4)).indices);
        list2 = formattedText.getMentionEntities();
        tweetFormatter2.adjustIndicesForEscapedChars(list2, ((HtmlEntities.Unescaped)((Object)list3)).indices);
        list2 = formattedText.getSymbolEntities();
        tweetFormatter.adjustIndicesForEscapedChars(list2, unescaped.indices);
        tweetFormatter.adjustIndicesForSupplementaryChars(stringBuilder2, formattedText);
        formattedText.setText(stringBuilder2.toString());
    }

    private final void adjustIndicesForEscapedChars(List<? extends FormattedUrlEntity> list2, List<int[]> list3) {
        if (list2 != null && list3 != null && !list3.isEmpty()) {
            int n = list3.size();
            int n2 = 0;
            int n3 = 0;
            for (FormattedUrlEntity formattedUrlEntity : list2) {
                int n4 = 0;
                int n5 = n3;
                n3 = n2;
                int n6 = n4;
                n4 = n5;
                while (n2 < n) {
                    int[] nArray = list3.get(n2);
                    int n7 = nArray[0];
                    int n8 = nArray[1];
                    n7 = n8 - n7;
                    if (n8 < formattedUrlEntity.getStart()) {
                        n4 += n7;
                        ++n3;
                    } else if (n8 < formattedUrlEntity.getEnd()) {
                        n6 += n7;
                    }
                    ++n2;
                }
                FormattedUrlEntity formattedUrlEntity2 = formattedUrlEntity;
                n2 = n4 + n6;
                formattedUrlEntity2.setStart(formattedUrlEntity2.getStart() - n2);
                formattedUrlEntity2.setEnd(formattedUrlEntity2.getEnd() - n2);
                int n7 = n3;
                n3 = n4;
                n2 = n7;
            }
            return;
        }
    }

    private final void adjustIndicesForSupplementaryChars(StringBuilder stringBuilder, FormattedText formattedText) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n = stringBuilder.length() - 1;
        for (int i = 0; i < n; ++i) {
            if (!Character.isHighSurrogate(stringBuilder.charAt(i)) || !Character.isLowSurrogate(stringBuilder.charAt(i + 1))) continue;
            arrayList2.add(i);
        }
        this.adjustEntitiesWithOffsets(formattedText.getUrlEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMediaEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getHashtagEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMentionEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getSymbolEntities(), arrayList2);
    }

    private final void adjustEntitiesWithOffsets(List<? extends FormattedUrlEntity> object, List<Integer> list2) {
        if (object != null && list2 != null) {
            Iterator<? extends FormattedUrlEntity> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (FormattedUrlEntity)iterator.next();
                int n = ((FormattedUrlEntity)object).getStart();
                int n2 = 0;
                Iterator<Integer> iterator2 = list2.iterator();
                while (iterator2.hasNext() && ((Number)iterator2.next()).intValue() - n2 <= n) {
                    ++n2;
                }
                Object object2 = object;
                ((FormattedUrlEntity)object2).setStart(((FormattedUrlEntity)object2).getStart() + n2);
                ((FormattedUrlEntity)object2).setEnd(((FormattedUrlEntity)object2).getEnd() + n2);
            }
            return;
        }
    }

    @NotNull
    public final FormattedText formatTweetText(@NotNull Tweet object) {
        Tweet tweet = object;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        Long l = StringsKt.toLongOrNull((String)tweet.getId());
        long l2 = l != null ? l : 0L;
        FormattedText formattedText = (FormattedText)this.cache.get((Object)l2);
        if (formattedText != null) {
            return formattedText;
        }
        if (!TextUtils.isEmpty((CharSequence)((FormattedText)(object = this.format((Tweet)object))).getText())) {
            this.cache.put((Object)l2, object);
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter$Companion;", "", "()V", "DEFAULT_CACHE_SIZE", "", "sdk_originalVoximplantRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

