/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.util.ArrayMap;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.analytics.AnalyticsDataKt;
import io.streamlayer.sdk.model.analytics.CommonKind;
import io.streamlayer.sdk.model.analytics.NotificationKind;
import io.streamlayer.sdk.model.analytics.NotificationType;
import io.streamlayer.sdk.model.analytics.TopicType;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.WaveMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100J\u000e\u00101\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00067"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/Session;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "analyticsRepo", "Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/analytics/AnalyticsRepo;)V", "mutedTopics", "Landroid/util/ArrayMap;", "", "", "getMutedTopics", "()Landroid/util/ArrayMap;", "pausedTopicsNotifications", "", "tinodeUserId", "getTinodeUserId", "()Ljava/lang/String;", "disconnect", "", "notifyChatMessage", "chatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "increment", "showNotification", "notifyFriendJoinToChat", "waveMessage", "Lio/streamlayer/sdk/model/messaging/WaveMessage;", "notifyPrediction", "questionNotification", "Lio/streamlayer/sdk/model/predictions/QuestionNotification;", "questionId", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "eventId", "", "notifyPredictionBanner", "notifyTweet", "tweet", "Lio/streamlayer/sdk/model/social/Tweet;", "notifyWatchParty", "watchParty", "Lio/streamlayer/sdk/model/calls/WatchParty;", "inviterContact", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "notifyWaveMessage", "pauseNotifications", "pause", "chatId", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVoximplantRelease"})
public final class InAppNotificationsService {
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final NotificationRepo notificationsRepo;
    @NotNull
    private final AnalyticsRepo analyticsRepo;
    @NotNull
    private final List<String> pausedTopicsNotifications;
    @NotNull
    private final ArrayMap<String, Boolean> mutedTopics;

    public InAppNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull NotificationRepo notificationRepo, @NotNull AnalyticsRepo analyticsRepo) {
        ArrayMap arrayMap;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkNotNullParameter((Object)analyticsRepo, (String)"analyticsRepo");
        ((InAppNotificationsService)object).context = context;
        ((InAppNotificationsService)object).session = session2;
        ((InAppNotificationsService)object).notificationsRepo = notificationRepo;
        ((InAppNotificationsService)object).analyticsRepo = analyticsRepo;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.pausedTopicsNotifications = object;
        object = arrayMap;
        arrayMap = new ArrayMap();
        v1.mutedTopics = object;
    }

    private final String getTinodeUserId() {
        return this.session.getTinodeUserId();
    }

    public static /* synthetic */ void notifyChatMessage$default(InAppNotificationsService inAppNotificationsService, ChatMessage chatMessage, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        inAppNotificationsService.notifyChatMessage(chatMessage, bl, bl2);
    }

    private final void showNotification(Notification object) {
        Object object2 = NotificationUtil.INSTANCE;
        if (object2.isAppInForeground() && object2.isNotificationEnabled$sdk_originalVoximplantRelease(object3.session, (Notification)object)) {
            if (ArraysKt.contains((Object[])new io.streamlayer.sdk.model.notifications.NotificationType[]{io.streamlayer.sdk.model.notifications.NotificationType.WatchParty, io.streamlayer.sdk.model.notifications.NotificationType.WaveReply}, (Object)((Object)object.getType()))) {
                object3.notificationsRepo.upsertNotificationBySourceId((Notification)object);
            } else {
                object3.notificationsRepo.saveNotification((Notification)object);
            }
            Notification notification = object;
            Object object3 = NotificationType.IN_APP;
            object = AnalyticsDataKt.toKind(notification.getType());
            object2 = CommonKind.NOTIFICATION_RECEIVED;
            String string = NotificationKt.getTopicId(notification);
            TopicType topicType = NotificationKt.getTopicType(notification);
            AnalyticsRepo.DefaultImpls.triggerNotificationEvent$default(object3.analyticsRepo, (NotificationType)((Object)object3), (NotificationKind)((Object)object), (CommonKind)((Object)object2), null, string, topicType, 8, null);
            return;
        }
    }

    @NotNull
    public final ArrayMap<String, Boolean> getMutedTopics() {
        return this.mutedTopics;
    }

    public final void notifyChatMessage(@NotNull ChatMessage object, boolean bl, boolean bl2) {
        ChatMessage chatMessage = object;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Object object2 = SLRLog.INSTANCE;
        ((SLRLog)object2).i("InAppNotificationsService", "increment " + bl + " showNotification " + bl2 + " chatMessage " + (ChatMessage)object);
        if (!Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.getTinodeUserId()) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            SLRLog sLRLog = object2;
            ChatMessage chatMessage2 = object;
            object = chatMessage2.getTopicId();
            object2 = NotificationUtilKt.toNotification$default(chatMessage2, null, 1, null);
            sLRLog.i("InAppNotificationsService", "pausedTopicsNotifications " + this.pausedTopicsNotifications.contains(object));
            if (!this.pausedTopicsNotifications.contains(object)) {
                if (bl) {
                    this.session.incrementTotalUnreadMessagesCount(1);
                }
                if (bl2 && NotificationUtil.INSTANCE.isAppInForeground()) {
                    this.showNotification((Notification)object2);
                }
            }
            return;
        }
    }

    public final void notifyWatchParty(@NotNull WatchParty object, @Nullable TinodeContact object2) {
        Object object3;
        WatchParty watchParty = object;
        Intrinsics.checkNotNullParameter((Object)watchParty, (String)"watchParty");
        Topic topic2 = watchParty.getData();
        if (!(topic2.getType() == io.streamlayer.sdk.model.messaging.TopicType.MANAGED_WP || Intrinsics.areEqual((Object)topic2.getChatId(), (Object)this.session.getActiveWpId().getValue()) || Intrinsics.areEqual((Object)((object3 = ((WatchParty)object).getOwner()) != null ? ((TinodeContact)object3).getChatUserId() : null), (Object)this.getTinodeUserId()) || Intrinsics.areEqual((Object)(object2 != null ? ((TinodeContact)object2).getChatUserId() : null), (Object)this.getTinodeUserId()))) {
            Notification notification;
            Object object4;
            Date date;
            object3 = topic2.getChatId();
            Long l = null;
            String string = object2 != null ? ((TinodeContact)object2).getChatName() : null;
            object = ((WatchParty)object).getStreamTitle();
            io.streamlayer.sdk.model.notifications.NotificationType notificationType = io.streamlayer.sdk.model.notifications.NotificationType.WatchParty;
            Date date2 = date;
            date = new Date();
            String string2 = NotificationUtilKt.toWpSourceId(topic2.getChatId());
            if (object2 != null) {
                TinodeContact tinodeContact = object2;
                object2 = NotificationIcon.Companion;
                object4 = tinodeContact.getPhotoData();
                String string3 = tinodeContact.getChatName();
                if (string3 == null) {
                    string3 = "";
                }
                object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object4, string3);
            } else {
                object2 = null;
            }
            object4 = notification;
            notification = new Notification(l, string, (String)object, notificationType, date2, string2, topic2, (NotificationIcon)object2);
            if (!this.pausedTopicsNotifications.contains(object3)) {
                this.showNotification((Notification)object4);
            }
            return;
        }
    }

    public final void notifyPredictionBanner() {
        Date date;
        Notification notification;
        InAppNotificationsService inAppNotificationsService = notification2;
        Notification notification2 = notification;
        io.streamlayer.sdk.model.notifications.NotificationType notificationType = io.streamlayer.sdk.model.notifications.NotificationType.PredictionOnboarding;
        Date date2 = date;
        date = new Date();
        notification = new Notification(null, null, null, notificationType, date2, null, null, null, 230, null);
        inAppNotificationsService.showNotification(notification2);
    }

    public final void notifyPrediction(@NotNull QuestionNotification object, @NotNull String string, @NotNull io.streamlayer.sdk.model.notifications.NotificationType object2, long l) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"questionNotification");
        Intrinsics.checkNotNullParameter((Object)string, (String)"questionId");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"type");
        object = NotificationUtilKt.toNotification((QuestionNotification)object, object2, string);
        InAppNotificationsService inAppNotificationsService = object3;
        inAppNotificationsService.showNotification((Notification)object);
        Object object3 = inAppNotificationsService.analyticsRepo;
        object = NotificationKt.getTopicType((Notification)object);
        if (object == null) {
            object = TopicType.POLLS_PREDICTION;
        }
        Object object4 = object3;
        object3 = CommonKind.POLL_RECEIVED;
        object2 = l;
        AnalyticsRepo.DefaultImpls.triggerPollEvent$default((AnalyticsRepo)object4, string, (TopicType)((Object)object), (CommonKind)((Object)object3), (Long)object2, null, null, 48, null);
    }

    public final void notifyTweet(@NotNull Tweet tweet) {
        Tweet tweet2 = tweet;
        Intrinsics.checkNotNullParameter((Object)tweet2, (String)"tweet");
        this.showNotification(NotificationUtilKt.toNotification(tweet2));
    }

    public final void notifyFriendJoinToChat(@NotNull WaveMessage object) {
        Date date;
        InAppNotificationsService inAppNotificationsService = string;
        Intrinsics.checkNotNullParameter((Object)object, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", "Friend join to chat " + (WaveMessage)object);
        WaveMessage waveMessage = object;
        String string = waveMessage.getUserName();
        io.streamlayer.sdk.model.notifications.NotificationType notificationType = io.streamlayer.sdk.model.notifications.NotificationType.JoinToChat;
        Date date2 = date;
        date = new Date();
        String string2 = NotificationUtilKt.toWaveSourceId(waveMessage.getChatId());
        WaveMessage waveMessage2 = object;
        object = waveMessage2.getUserAvatar();
        object = NotificationIcon.Companion.buildAvatarIcon((String)object, waveMessage2.getUserName());
        inAppNotificationsService.showNotification(new Notification(null, string, null, notificationType, date2, string2, null, (NotificationIcon)object, 64, null));
    }

    public final void notifyWaveMessage(@NotNull WaveMessage waveMessage) {
        Intrinsics.checkNotNullParameter((Object)waveMessage, (String)"waveMessage");
        SLRLog.INSTANCE.d("InAppNotificationsService", "Wave message waveMessage " + waveMessage);
        String string2 = this.context.getString(R.string.slr_friend_has_arrived, new Object[]{waveMessage.getUserName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ed, waveMessage.userName)");
        this.showNotification(NotificationUtilKt.toNotification(waveMessage, string2));
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        SLRLog.INSTANCE.i("InAppNotificationsService", "pauseNotifications pause " + bl + " chatId " + string2);
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string2));
        }
    }
}

