/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chats;

import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemMessagingChatBinding;
import io.streamlayer.sdk.messaging.chats.ChatsAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J@\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010$\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016H\u0016J\u001a\u0010&\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007H\u0016J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0004J$\u0010,\u001a\u00020\u00112\n\u0010\u0015\u001a\u00060-R\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u000eH\u0002J\u000e\u00101\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u00102\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u00063"}, d2={"Lio/streamlayer/sdk/messaging/chats/ChatsSwipeCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$Callback;", "()V", "clamp", "", "currentDx", "currentPosition", "", "Ljava/lang/Integer;", "maxButtonSize", "previousPosition", "clampViewPositionHorizontal", "dX", "isClamped", "", "isCurrentlyActive", "clearCurrent", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "clearView", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "clearViewHolder", "getMovementFlags", "getSwipeEscapeVelocity", "defaultValue", "getSwipeThreshold", "getTag", "getView", "Landroid/view/View;", "onChildDraw", "c", "Landroid/graphics/Canvas;", "dY", "actionState", "onMove", "target", "onSelectedChanged", "onSwiped", "direction", "removePreviousClamp", "setButtonSize", "dimension", "setButtonWidth", "Lio/streamlayer/sdk/messaging/chats/ChatsAdapter$ViewHolder;", "Lio/streamlayer/sdk/messaging/chats/ChatsAdapter;", "value", "force", "setClamp", "setTag", "sdk_originalVoximplantRelease"})
public final class ChatsSwipeCallback
extends ItemTouchHelper.Callback {
    @Nullable
    private Integer currentPosition;
    @Nullable
    private Integer previousPosition;
    private float currentDx;
    private float clamp;
    private float maxButtonSize;

    private final void setButtonWidth(ChatsAdapter.ViewHolder viewHolder, int n, boolean bl) {
        float f;
        float f2 = this.maxButtonSize;
        if ((float)n >= f) {
            n = (int)f2;
        }
        AppCompatImageButton appCompatImageButton = viewHolder.getBinding().slChatMuteBTN;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageButton, (String)"viewHolder.binding.slChatMuteBTN");
        ViewGroup.LayoutParams layoutParams = appCompatImageButton.getLayoutParams();
        if (layoutParams != null) {
            layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
            if (bl || layoutParams.width <= n) {
                layoutParams.width = n;
            }
            appCompatImageButton.setLayoutParams(layoutParams);
            appCompatImageButton = viewHolder.getBinding().slDeleteButtonContainer;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageButton, (String)"viewHolder.binding.slDeleteButtonContainer");
            viewHolder = appCompatImageButton.getLayoutParams();
            if (viewHolder != null) {
                viewHolder = (ConstraintLayout.LayoutParams)viewHolder;
                if (bl || ((ConstraintLayout.LayoutParams)viewHolder).width <= n) {
                    ((ConstraintLayout.LayoutParams)viewHolder).width = n;
                }
                appCompatImageButton.setLayoutParams((ViewGroup.LayoutParams)viewHolder);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
    }

    private final float clampViewPositionHorizontal(float f, boolean bl, boolean bl2) {
        float f2 = -(this.clamp + (float)ViewExtensionsKt.getDp(20.0f));
        float f3 = 0.0f;
        if (bl) {
            f = bl2 ? (f -= this.clamp) : -this.clamp;
        }
        return Math.min(Math.max(f2, f), f3);
    }

    private final void setTag(RecyclerView.ViewHolder viewHolder, boolean bl) {
        viewHolder.itemView.setTag((Object)bl);
    }

    private final boolean getTag(RecyclerView.ViewHolder viewHolder) {
        Object object = viewHolder.itemView.getTag();
        object = object instanceof Boolean ? (Boolean)object : null;
        return object != null ? (Boolean)object : false;
    }

    private final View getView(RecyclerView.ViewHolder viewHolder) {
        return viewHolder instanceof ChatsAdapter.ViewHolder ? ((ChatsAdapter.ViewHolder)viewHolder).getBinding().slForegroundContainer : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void clearViewHolder(RecyclerView.ViewHolder viewHolder) {
        if (!(viewHolder instanceof ChatsAdapter.ViewHolder)) return;
        SlrItemMessagingChatBinding slrItemMessagingChatBinding = ((ChatsAdapter.ViewHolder)viewHolder).getBinding();
        slrItemMessagingChatBinding.slForegroundContainer.setTranslationX(0.0f);
        ConstraintLayout constraintLayout = slrItemMessagingChatBinding.slContainer;
        constraintLayout.setTranslationX(0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"");
        ViewGroup.LayoutParams layoutParams = constraintLayout.getLayoutParams();
        if (layoutParams == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
        layoutParams2.setMarginStart(viewHolder.itemView.getContext().getResources().getDimensionPixelSize(R.dimen.slr_chat_hidden_button_padding));
        layoutParams2.startToEnd = 0;
        layoutParams2.startToStart = -1;
        layoutParams2.endToEnd = -1;
        layoutParams2.width = -2;
        constraintLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        constraintLayout = slrItemMessagingChatBinding.slDeleteButtonContainer;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slDeleteButtonContainer");
        layoutParams = constraintLayout.getLayoutParams();
        if (layoutParams == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        SlrItemMessagingChatBinding slrItemMessagingChatBinding2 = slrItemMessagingChatBinding;
        slrItemMessagingChatBinding = (ConstraintLayout.LayoutParams)layoutParams;
        ((ConstraintLayout.LayoutParams)layoutParams).startToStart = -1;
        ((ConstraintLayout.LayoutParams)layoutParams).width = -2;
        constraintLayout.setLayoutParams((ViewGroup.LayoutParams)slrItemMessagingChatBinding);
        slrItemMessagingChatBinding = slrItemMessagingChatBinding2.slChatDeleteBTN;
        Intrinsics.checkNotNullExpressionValue((Object)slrItemMessagingChatBinding, (String)"");
        constraintLayout = slrItemMessagingChatBinding.getLayoutParams();
        if (constraintLayout == null) throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        ChatsSwipeCallback chatsSwipeCallback = chatsSwipeCallback3;
        ChatsSwipeCallback chatsSwipeCallback2 = chatsSwipeCallback3;
        SlrItemMessagingChatBinding slrItemMessagingChatBinding3 = slrItemMessagingChatBinding;
        ChatsSwipeCallback chatsSwipeCallback3 = (FrameLayout.LayoutParams)constraintLayout;
        ((FrameLayout.LayoutParams)constraintLayout).gravity = 17;
        ((FrameLayout.LayoutParams)constraintLayout).width = -1;
        slrItemMessagingChatBinding3.setPadding(0, 0, 0, 0);
        slrItemMessagingChatBinding3.setLayoutParams((ViewGroup.LayoutParams)chatsSwipeCallback3);
        chatsSwipeCallback2.setButtonWidth((ChatsAdapter.ViewHolder)viewHolder, 0, true);
        chatsSwipeCallback.setTag(viewHolder, false);
        chatsSwipeCallback.previousPosition = null;
    }

    public int getMovementFlags(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        return ItemTouchHelper.Callback.makeMovementFlags((int)0, (int)12);
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder viewHolder2) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"target");
        return false;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
    }

    public void clearView(@NotNull RecyclerView object, @NotNull RecyclerView.ViewHolder viewHolder) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)object, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"viewHolder");
        if (viewHolder2 instanceof ChatsAdapter.ViewHolder) {
            object = (ChatsAdapter.ViewHolder)viewHolder;
            ItemTouchHelper.Callback.getDefaultUIUtil().clearView((View)((ChatsAdapter.ViewHolder)((Object)object)).getBinding().slForegroundContainer);
            ItemTouchHelper.Callback.getDefaultUIUtil().clearView((View)((ChatsAdapter.ViewHolder)((Object)object)).getBinding().slContainer);
            float f = this.currentDx;
            int n = (!(f == 0.0f) ? (Number)Float.valueOf(Math.abs(f) / (float)2) : (Number)0).intValue();
            this.setButtonWidth((ChatsAdapter.ViewHolder)((Object)object), n, true);
        }
        this.currentDx = 0.0f;
        this.previousPosition = viewHolder.getAbsoluteAdapterPosition();
    }

    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder != null) {
            View view2 = this.getView(viewHolder);
            if (view2 == null) {
                return;
            }
            this.currentPosition = viewHolder.getAbsoluteAdapterPosition();
            ItemTouchHelper.Callback.getDefaultUIUtil().onSelected(view2);
        }
    }

    public float getSwipeEscapeVelocity(float f) {
        return f * (float)10;
    }

    public float getSwipeThreshold(@NotNull RecyclerView.ViewHolder viewHolder) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"viewHolder");
        boolean bl = !this.getTag(viewHolder2) && this.currentDx <= -this.clamp;
        this.setTag(viewHolder, bl);
        return 2.0f;
    }

    public void onChildDraw(@NotNull Canvas canvas, @NotNull RecyclerView object, @NotNull RecyclerView.ViewHolder viewHolder, float f, float f2, int n, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"c");
        Intrinsics.checkNotNullParameter((Object)object, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        if (n == 1) {
            if (this.getView(viewHolder) == null) {
                return;
            }
            if (viewHolder instanceof ChatsAdapter.ViewHolder) {
                float f3;
                this.currentDx = f3 = this.clampViewPositionHorizontal(f, this.getTag(viewHolder), bl);
                ItemTouchHelper.Callback.getDefaultUIUtil().onDraw(canvas, object, (View)((ChatsAdapter.ViewHolder)viewHolder).getBinding().slForegroundContainer, f3, f2, n, bl);
                f = (float)(viewHolder.itemView.getWidth() - viewHolder.itemView.getWidth()) - Math.abs(f);
                if (Math.abs(f3) <= this.clamp) {
                    ItemTouchHelper.Callback.getDefaultUIUtil().onDraw(canvas, object, (View)((ChatsAdapter.ViewHolder)viewHolder).getBinding().slContainer, f3, f2, n, bl);
                }
                if (bl) {
                    int n2;
                    int n3 = (int)f;
                    if ((float)Math.abs(n2) <= this.clamp) {
                        ChatsAdapter.ViewHolder viewHolder2;
                        object = (ChatsAdapter.ViewHolder)viewHolder;
                        if ((float)viewHolder2.getBinding().slChatMuteBTN.getWidth() <= this.maxButtonSize) {
                            this.setButtonWidth((ChatsAdapter.ViewHolder)((Object)object), (int)((double)Math.abs(n3) / 1.5), false);
                        }
                    }
                }
            }
        }
    }

    public final void setClamp(float f) {
        this.clamp = f;
    }

    public final void setButtonSize(float f) {
        this.maxButtonSize = f;
    }

    public final void clearCurrent(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Integer n = this.currentPosition;
        if (n != null) {
            if ((recyclerView = recyclerView.findViewHolderForAdapterPosition(((Number)n).intValue())) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"recyclerView.findViewHol\u2026terPosition(it) ?: return");
            this.clearViewHolder((RecyclerView.ViewHolder)recyclerView);
        }
    }

    public final void removePreviousClamp(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (Intrinsics.areEqual((Object)this.currentPosition, (Object)this.previousPosition)) {
            return;
        }
        Integer n = this.previousPosition;
        if (n != null) {
            if ((recyclerView = recyclerView.findViewHolderForAdapterPosition(((Number)n).intValue())) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"recyclerView.findViewHol\u2026terPosition(it) ?: return");
            this.clearViewHolder((RecyclerView.ViewHolder)recyclerView);
        }
    }
}

