/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.common;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/messaging/common/DashLineView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dash", "", "paint", "Landroid/graphics/Paint;", "playAnimation", "", "spread", "startY", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "start", "stop", "drawDashedLine", "sdk_originalVoximplantRelease"})
public final class DashLineView
extends View {
    private final float dash;
    private float startY;
    private final float spread;
    private boolean playAnimation;
    @NotNull
    private final Paint paint;

    @JvmOverloads
    public DashLineView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this.dash = 30.0f;
        this.spread = 20.0f;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(ContextCompat.getColor((Context)context, (int)R.color.slr_white));
        paint.setStrokeWidth(10.0f);
        paint.setStyle(Paint.Style.STROKE);
        this.paint = paint;
    }

    public /* synthetic */ DashLineView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void drawDashedLine(Canvas canvas) {
        Path path;
        Path path2 = path;
        path = new Path();
        float f = this.dash;
        f = (float)canvas.getHeight() + f - f - this.startY;
        int n = 0;
        int n2 = (int)((float)canvas.getHeight() / 25.0f) + 2;
        if (n2 >= 0) {
            while (true) {
                path2.moveTo(0.0f, f);
                path2.lineTo(0.0f, f - this.dash);
                f -= this.spread + this.dash;
                if (n == n2) break;
                ++n;
            }
        }
        canvas.drawPath(path2, this.paint);
        if (this.startY > this.dash + this.spread) {
            this.startY = 0.0f;
        }
        DashLineView dashLineView = this;
        dashLineView.startY += 1.0f;
        dashLineView.postInvalidateDelayed(2L);
    }

    @JvmOverloads
    public DashLineView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public DashLineView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final void start() {
        this.playAnimation = true;
        this.invalidate();
    }

    public final void stop() {
        this.playAnimation = false;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        DashLineView dashLineView = this;
        super.onDraw(canvas);
        if (dashLineView.playAnimation && canvas != null) {
            this.drawDashedLine(canvas);
        }
    }
}

