/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import android.net.Uri;
import androidx.navigation.NavOptions;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/common/utils/NavigationUtils;", "", "()V", "buildChatMessageDeepLink", "Landroid/net/Uri;", "chatId", "", "buildInviteDeepLink", "buildStatisticsDeepLink", "buildWatchPartyDeepLink", "topicId", "cleanUri", "uriString", "defaultNavOptionsBuilder", "Landroidx/navigation/NavOptions$Builder;", "fadeNavOptionsBuilder", "isChatDeepLink", "", "uri", "isInviteDeepLink", "isStatisticsDeepLink", "isWatchPartyDeepLink", "sdk_originalVoximplantRelease"})
public final class NavigationUtils {
    @NotNull
    public static final NavigationUtils INSTANCE = new NavigationUtils();

    private NavigationUtils() {
    }

    private final String cleanUri(String string2) {
        return StringsKt.removeSuffix((String)string2, (CharSequence)"/");
    }

    @NotNull
    public final Uri buildChatMessageDeepLink(@Nullable String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = Uri.parse((String)this.cleanUri("streamlayer://chats/" + string2));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026HATS + chatId.orEmpty()))");
        return uri;
    }

    @NotNull
    public final Uri buildWatchPartyDeepLink(@Nullable String string2) {
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = Uri.parse((String)this.cleanUri("streamlayer://calls/" + string2));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026LLS + topicId.orEmpty()))");
        return uri;
    }

    public final boolean isWatchPartyDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        String string2 = uri2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.startsWith$default((String)string2, (String)"streamlayer://calls/", (boolean)false, (int)2, null);
    }

    public final boolean isInviteDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)uri2.toString(), (Object)"streamlayer://invite");
    }

    @NotNull
    public final Uri buildInviteDeepLink() {
        Uri uri = Uri.parse((String)"streamlayer://invite");
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(DEEP_LINK_SCHEME_PREFIX + DEEP_LINK_INVITE)");
        return uri;
    }

    @NotNull
    public final Uri buildStatisticsDeepLink() {
        Uri uri = Uri.parse((String)this.cleanUri("streamlayer://statistics"));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(cleanUri(DEEP_LINK\u2026 + DEEP_LINK_STATISTICS))");
        return uri;
    }

    public final boolean isChatDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        String string2 = uri2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"chats/", (boolean)false, (int)2, null);
    }

    public final boolean isStatisticsDeepLink(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        String string2 = uri2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"statistics", (boolean)false, (int)2, null);
    }

    @NotNull
    public final NavOptions.Builder defaultNavOptionsBuilder() {
        return new NavOptions.Builder().setEnterAnim(R.anim.slr_slide_from_right).setExitAnim(R.anim.slr_slide_to_left).setPopEnterAnim(R.anim.slr_slide_from_left).setPopExitAnim(R.anim.slr_slide_to_right);
    }

    @NotNull
    public final NavOptions.Builder fadeNavOptionsBuilder() {
        return new NavOptions.Builder().setEnterAnim(R.anim.slr_fade_in).setExitAnim(R.anim.slr_fade_out).setPopEnterAnim(R.anim.slr_fade_in).setPopExitAnim(R.anim.slr_fade_out);
    }
}

