/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import com.google.protobuf.ByteString;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pbx.Model;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0014H\u0000\u001a\u0016\u0010\u0013\u001a\u00020\u0011*\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"CHAT_TYPE", "", "EMOJI_REACTION", "INVITE_TYPE", "JOIN_CHAT", "LEFT_CHAT", "STICKER", "WATCH_TYPE", "X_EVENT_ID", "X_MESSAGE_ID", "X_MIME", "X_MIME_TYPE_JSON", "X_REPLY", "X_SUBTYPE", "X_TYPE", "isWave", "", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Lio/streamlayer/sdk/model/messaging/ChatMessageHeadPayload;", "toDomain", "Lio/streamlayer/sdk/model/messaging/ChatMessageRelation;", "Lpbx/Model$ServerData;", "status", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "toUpdateEntity", "Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;", "sdk_originalVoximplantRelease"})
public final class ChatMessageKt {
    @NotNull
    public static final String X_TYPE = "x-slr-type";
    @NotNull
    public static final String X_SUBTYPE = "x-slr-subtype";
    @NotNull
    public static final String X_REPLY = "x-slr-reply";
    @NotNull
    public static final String X_MESSAGE_ID = "x-message-id";
    @NotNull
    public static final String X_EVENT_ID = "x-event-id";
    @NotNull
    public static final String X_MIME = "mime";
    @NotNull
    public static final String X_MIME_TYPE_JSON = "text/x-json";
    @NotNull
    public static final String CHAT_TYPE = "chat";
    @NotNull
    public static final String INVITE_TYPE = "invite";
    @NotNull
    public static final String WATCH_TYPE = "watch";
    @NotNull
    public static final String JOIN_CHAT = "join_chat";
    @NotNull
    public static final String LEFT_CHAT = "left_chat";
    @NotNull
    public static final String EMOJI_REACTION = "emoji_reaction";
    @NotNull
    public static final String STICKER = "sticker";

    @NotNull
    public static final ChatMessage toDomain(@NotNull ChatMessageRelation chatMessageRelation) {
        ChatMessageRelation chatMessageRelation2 = chatMessageRelation;
        Intrinsics.checkNotNullParameter((Object)chatMessageRelation2, (String)"<this>");
        ChatMessage chatMessage = chatMessageRelation2.getMessage();
        chatMessage.setSender(chatMessageRelation.getSenderRelation());
        return chatMessage;
    }

    @NotNull
    public static final ChatMessageUpdate toUpdateEntity(@NotNull ChatMessage object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        ChatMessage chatMessage = object;
        object = chatMessage.getTopicId();
        String string2 = chatMessage.getId();
        ChatMessageStatus chatMessageStatus = chatMessage.getStatus();
        return new ChatMessageUpdate((String)object, string2, chatMessageStatus);
    }

    public static final boolean isWave(@NotNull ChatMessage chatMessage) {
        ChatMessage chatMessage2 = chatMessage;
        Intrinsics.checkNotNullParameter((Object)chatMessage2, (String)"<this>");
        return Intrinsics.areEqual((Object)chatMessage2.getType(), (Object)INVITE_TYPE) && Intrinsics.areEqual((Object)chatMessage.getSubtype(), (Object)WATCH_TYPE);
    }

    public static final boolean isWave(@NotNull ChatMessageHeadPayload chatMessageHeadPayload) {
        ChatMessageHeadPayload chatMessageHeadPayload2 = chatMessageHeadPayload;
        Intrinsics.checkNotNullParameter((Object)chatMessageHeadPayload2, (String)"<this>");
        ChatMessageHead chatMessageHead = chatMessageHeadPayload2.getHead();
        return Intrinsics.areEqual((Object)(chatMessageHead != null ? chatMessageHead.getType() : null), (Object)INVITE_TYPE) && Intrinsics.areEqual((Object)chatMessageHeadPayload.getHead().getSubtype(), (Object)WATCH_TYPE);
    }

    @NotNull
    public static final ChatMessage toDomain(@NotNull Model.ServerData object, @NotNull ChatMessageStatus object2) {
        ChatMessage chatMessage;
        Object object3;
        Object object4;
        Date date;
        Object object5 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"status");
        Object object52 = object5.getTopic();
        String string2 = object5.getFromUserId();
        int n = object5.getSeqId();
        Object object6 = object5.getContent();
        object6 = object6 != null ? ViewExtensionsKt.parseUtf8(object6) : null;
        if (object6 == null) {
            object6 = "";
        }
        Date date2 = date;
        date = new Date(object.getTimestamp());
        Object object7 = (ByteString)object.getHeadMap().get(X_TYPE);
        object7 = object7 != null ? ViewExtensionsKt.parseUtf8(object7) : null;
        if (object7 == null) {
            object7 = "";
        }
        if ((object4 = (object4 = (ByteString)object.getHeadMap().get(X_SUBTYPE)) != null ? ViewExtensionsKt.parseUtf8(object4) : null) == null) {
            object4 = "";
        }
        if ((object3 = (object3 = (ByteString)object.getHeadMap().get(X_REPLY)) != null ? ViewExtensionsKt.parseUtf8(object3) : null) == null) {
            object3 = "";
        }
        Object object8 = object;
        object = chatMessage;
        Intrinsics.checkNotNullExpressionValue((Object)object52, (String)"topic");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fromUserId");
        chatMessage = new ChatMessage((String)object52, string2, n, date2, (String)object6, (String)object7, (String)object4, (String)object3, (ChatMessageStatus)((Object)object2));
        object2 = object8.getHeadMap();
        if (object2 != null) {
            LinkedHashMap linkedHashMap;
            Object object9 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"headMap");
            object52 = linkedHashMap;
            linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)object2.size()));
            for (Map.Entry entry : object9.entrySet()) {
                string2 = entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                String string3 = ViewExtensionsKt.parseUtf8((ByteString)v);
                if (string3 == null) {
                    string3 = "";
                }
                object52.put(string2, string3);
            }
        } else {
            object52 = null;
        }
        Object object10 = object;
        ((ChatMessage)object10).setHead((Map<String, String>)object52);
        object2 = ((ChatMessage)object10).getHead();
        if (object2 != null && (object2 = (String)object2.get(X_MESSAGE_ID)) != null) {
            ((ChatMessage)object).setId((String)object2);
        }
        return object;
    }

    public static /* synthetic */ ChatMessage toDomain$default(Model.ServerData serverData, ChatMessageStatus chatMessageStatus, int n, Object object) {
        if ((n & 1) != 0) {
            chatMessageStatus = ChatMessageStatus.Uninitialized;
        }
        return ChatMessageKt.toDomain(serverData, chatMessageStatus);
    }
}

