/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper;", "", "()V", "getChannelDescription", "", "context", "Landroid/content/Context;", "channel", "Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "getChannelName", "getChannelPriority", "", "initChannels", "", "Channel", "sdk_originalVonageRelease"})
public final class NotificationChannelsHelper {
    @NotNull
    public static final NotificationChannelsHelper INSTANCE = new NotificationChannelsHelper();

    private NotificationChannelsHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelName(Context context, Channel channel) {
        String string2;
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026nel_low_importance)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getChannelDescription(Context context, Channel channel) {
        String string2;
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            string2 = context.getString(R.string.slr_notif_channel_low_importance_info);
        } else {
            string2 = context.getString(R.string.slr_notif_channel_high_importance_info);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (channel) {\n       \u2026ow_importance_info)\n    }");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresApi(api=26)
    private final int getChannelPriority(Channel channel) {
        int n = WhenMappings.$EnumSwitchMapping$0[channel.ordinal()];
        if (n == 1) return 4;
        if (n != 2) throw new NoWhenBranchMatchedException();
        return 2;
    }

    public final void initChannels(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager notificationManager = (NotificationManager)object;
            for (Channel channel : Channel.values()) {
                NotificationChannel notificationChannel;
                Object object2;
                if (notificationManager.getNotificationChannel(channel.name()) != null) continue;
                NotificationChannel notificationChannel2 = object2 = notificationChannel;
                object2 = channel.name();
                String string2 = this.getChannelName(context, channel);
                int n = this.getChannelPriority(channel);
                notificationChannel2((String)object2, (CharSequence)string2, n);
                notificationChannel.setDescription(this.getChannelDescription(context, channel));
                notificationManager.createNotificationChannel(notificationChannel);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "", "(Ljava/lang/String;I)V", "streamlayer_high", "streamlayer_low", "sdk_originalVonageRelease"})
    public static enum Channel {
        streamlayer_high,
        streamlayer_low;

    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Channel.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Channel.streamlayer_high.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Channel.streamlayer_low.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

