/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.video.vonage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.view.Display;
import android.view.WindowManager;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.Publisher;
import com.opentok.android.VideoUtils;
import io.streamlayer.common.data.video.vonage.SlVideoCapturer;
import io.streamlayer.common.utils.SLRLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u000b\b\u0000\u0018\u0000 p2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002pqB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\u0017H\u0002J\u0010\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\fH\u0002J\u0018\u0010T\u001a\u00020O2\u0006\u0010U\u001a\u00020\f2\u0006\u0010V\u001a\u00020\fH\u0002J\b\u0010W\u001a\u00020OH\u0016J\b\u0010X\u001a\u00020OH\u0016J \u0010Y\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\f2\u000e\u0010Z\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010[H\u0002J\u0010\u0010\\\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010]\u001a\u00020\fH\u0016J\u0010\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\u0012H\u0002J\b\u0010`\u001a\u00020aH\u0016J\b\u0010?\u001a\u00020\fH\u0002J\b\u0010C\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020OH\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J\b\u0010d\u001a\u00020OH\u0016J\u0018\u0010e\u001a\u00020O2\u0006\u0010f\u001a\u00020g2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010h\u001a\u00020OH\u0016J\u0010\u0010i\u001a\u00020\f2\u0006\u0010j\u001a\u00020\fH\u0002J\u0010\u0010k\u001a\u00020O2\b\u00102\u001a\u0004\u0018\u000103J\b\u0010l\u001a\u00020\fH\u0016J\b\u0010m\u001a\u00020\fH\u0016J\u0010\u0010n\u001a\u00020O2\u0006\u0010o\u001a\u00020\fH\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000e\"\u0004\b,\u0010\u0010R\u000e\u0010-\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000eR\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010K\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u000e\"\u0004\bM\u0010\u0010\u00a8\u0006r"}, d2={"Lio/streamlayer/common/data/video/vonage/SlVideoCapturer;", "Lcom/opentok/android/BaseVideoCapturer;", "Landroid/hardware/Camera$PreviewCallback;", "Lcom/opentok/android/BaseVideoCapturer$CaptureSwitch;", "context", "Landroid/content/Context;", "preferredResolution", "Lcom/opentok/android/Publisher$CameraCaptureResolution;", "preferredFrameRate", "Lcom/opentok/android/Publisher$CameraCaptureFrameRate;", "(Landroid/content/Context;Lcom/opentok/android/Publisher$CameraCaptureResolution;Lcom/opentok/android/Publisher$CameraCaptureFrameRate;)V", "_fps", "", "get_fps", "()I", "set_fps", "(I)V", "blackFrames", "", "camera", "Landroid/hardware/Camera;", "cameraIndex", "captureFpsRange", "", "captureHeight", "captureWidth", "currentDeviceInfo", "Landroid/hardware/Camera$CameraInfo;", "currentDisplay", "Landroid/view/Display;", "expectedFrameSize", "frame", "getFrame", "()[I", "setFrame", "([I)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "height", "getHeight", "setHeight", "isCapturePaused", "isCaptureRunning", "isCaptureStarted", "isFrontCamera", "()Z", "metadataSource", "Lio/streamlayer/common/data/video/vonage/SlVideoCapturer$CustomVideoCapturerDataSource;", "naturalCameraOrientation", "getNaturalCameraOrientation", "newFrame", "Ljava/lang/Runnable;", "getNewFrame", "()Ljava/lang/Runnable;", "setNewFrame", "(Ljava/lang/Runnable;)V", "numCaptureBuffers", "pixelFormat", "Landroid/graphics/PixelFormat;", "getPreferredFrameRate", "()Lcom/opentok/android/Publisher$CameraCaptureFrameRate;", "setPreferredFrameRate", "(Lcom/opentok/android/Publisher$CameraCaptureFrameRate;)V", "getPreferredResolution", "()Lcom/opentok/android/Publisher$CameraCaptureResolution;", "setPreferredResolution", "(Lcom/opentok/android/Publisher$CameraCaptureResolution;)V", "previewBufferLock", "Ljava/util/concurrent/locks/ReentrantLock;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "getWidth", "setWidth", "checkRangeWithWarning", "", "preferredFps", "range", "compensateCameraRotation", "uiRotation", "configureCaptureSize", "preferredWidth", "preferredHeight", "cycleCamera", "destroy", "findClosestEnclosingFpsRange", "supportedFpsRanges", "", "forceCameraRelease", "getCameraIndex", "getCameraIndexUsingFront", "front", "getCaptureSettings", "Lcom/opentok/android/BaseVideoCapturer$CaptureSettings;", "Lcom/opentok/android/VideoUtils$Size;", "init", "onPause", "onPreviewFrame", "data", "", "onResume", "roundRotation", "rotation", "setCustomVideoCapturerDataSource", "startCapture", "stopCapture", "swapCamera", "index", "Companion", "CustomVideoCapturerDataSource", "sdk_originalVonageRelease"})
public final class SlVideoCapturer
extends BaseVideoCapturer
implements Camera.PreviewCallback,
BaseVideoCapturer.CaptureSwitch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "VonageVideoCallCapturer";
    private static final int PIXEL_FORMAT = 17;
    @NotNull
    private Publisher.CameraCaptureResolution preferredResolution;
    @NotNull
    private Publisher.CameraCaptureFrameRate preferredFrameRate;
    private int cameraIndex;
    @Nullable
    private Camera camera;
    @Nullable
    private Camera.CameraInfo currentDeviceInfo;
    @NotNull
    private final ReentrantLock previewBufferLock;
    @NotNull
    private final PixelFormat pixelFormat;
    private boolean isCaptureStarted;
    private boolean isCaptureRunning;
    private final int numCaptureBuffers;
    private int expectedFrameSize;
    private int captureWidth;
    private int captureHeight;
    @NotNull
    private int[] captureFpsRange;
    @NotNull
    private final Display currentDisplay;
    @Nullable
    private SurfaceTexture surfaceTexture;
    private boolean blackFrames;
    private boolean isCapturePaused;
    private int _fps;
    private int width;
    private int height;
    @Nullable
    private int[] frame;
    @NotNull
    private Handler handler;
    @NotNull
    private Runnable newFrame;
    @Nullable
    private CustomVideoCapturerDataSource metadataSource;

    public SlVideoCapturer(@NotNull Context context, @NotNull Publisher.CameraCaptureResolution cameraCaptureResolution, @NotNull Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraCaptureResolution, (String)"preferredResolution");
        Intrinsics.checkNotNullParameter((Object)cameraCaptureFrameRate, (String)"preferredFrameRate");
        this.preferredResolution = cameraCaptureResolution;
        this.preferredFrameRate = cameraCaptureFrameRate;
        this.previewBufferLock = new ReentrantLock();
        this.pixelFormat = new PixelFormat();
        this.numCaptureBuffers = 3;
        this.captureWidth = -1;
        this.captureHeight = -1;
        this.captureFpsRange = new int[0];
        this._fps = 1;
        this.handler = new Handler();
        this.newFrame = new Runnable(this){
            final /* synthetic */ SlVideoCapturer this$0;
            {
                this.this$0 = slVideoCapturer;
            }

            public void run() {
                if (SlVideoCapturer.access$isCaptureRunning$p(this.this$0)) {
                    SlVideoCapturer slVideoCapturer;
                    Object object = this.this$0.getFrame();
                    if (object == null) {
                        SlVideoCapturer slVideoCapturer2 = this.this$0;
                        object = (Object)((Object)slVideoCapturer2);
                        slVideoCapturer = SlVideoCapturer.access$getPreferredResolution(slVideoCapturer2);
                        slVideoCapturer2.set_fps(SlVideoCapturer.access$getPreferredFrameRate(slVideoCapturer2));
                        slVideoCapturer2.setWidth(((VideoUtils.Size)slVideoCapturer).width);
                        slVideoCapturer2.setHeight(((VideoUtils.Size)slVideoCapturer).height);
                        int[] nArray = new int[slVideoCapturer2.getWidth() * object.getHeight()];
                        object = nArray;
                        slVideoCapturer2.setFrame(nArray);
                    }
                    newFrame.1 v2 = this;
                    slVideoCapturer = v2.this$0;
                    int n = slVideoCapturer.getWidth();
                    int n2 = this.this$0.getHeight();
                    slVideoCapturer.provideIntArrayFrame((int[])object, 2, n, n2, 0, false);
                    newFrame.1 v3 = this;
                    v2.this$0.getHandler().postDelayed((Runnable)v3, (long)(1000 / v3.this$0.get_fps()));
                }
            }
        };
        this.cameraIndex = this.getCameraIndexUsingFront(true);
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        Display display = ((WindowManager)object).getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"windowManager.defaultDisplay");
        this.currentDisplay = display;
    }

    public /* synthetic */ SlVideoCapturer(Context context, Publisher.CameraCaptureResolution cameraCaptureResolution, Publisher.CameraCaptureFrameRate cameraCaptureFrameRate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cameraCaptureResolution = Publisher.CameraCaptureResolution.MEDIUM;
        }
        if ((n & 4) != 0) {
            cameraCaptureFrameRate = Publisher.CameraCaptureFrameRate.FPS_30;
        }
        this(context, cameraCaptureResolution, cameraCaptureFrameRate);
    }

    private final int getNaturalCameraOrientation() {
        int n;
        SlVideoCapturer slVideoCapturer = slVideoCapturer.currentDeviceInfo;
        if (slVideoCapturer != null) {
            SlVideoCapturer slVideoCapturer2 = slVideoCapturer;
            Intrinsics.checkNotNull((Object)((Object)slVideoCapturer2));
            n = ((Camera.CameraInfo)slVideoCapturer2).orientation;
        } else {
            n = 0;
        }
        return n;
    }

    private final int compensateCameraRotation(int n) {
        int n2 = n;
        n = 0;
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 1: {
                n = 270;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        SlVideoCapturer slVideoCapturer = this;
        int n3 = this.getNaturalCameraOrientation();
        n = slVideoCapturer.roundRotation(n);
        return slVideoCapturer.isFrontCamera() ? ((360 - n) % 360 + n3) % 360 : (n + n3) % 360;
    }

    private final boolean forceCameraRelease(int n) {
        try {
            Camera.open((int)n);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
        return false;
    }

    private final VideoUtils.Size getPreferredResolution() {
        VideoUtils.Size size;
        SlVideoCapturer slVideoCapturer = slVideoCapturer2;
        SlVideoCapturer slVideoCapturer2 = size;
        size = new VideoUtils.Size();
        switch (WhenMappings.$EnumSwitchMapping$0[slVideoCapturer.preferredResolution.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                SlVideoCapturer slVideoCapturer3 = slVideoCapturer2;
                ((VideoUtils.Size)slVideoCapturer3).width = 1920;
                ((VideoUtils.Size)slVideoCapturer3).height = 1080;
                break;
            }
            case 3: {
                SlVideoCapturer slVideoCapturer4 = slVideoCapturer2;
                ((VideoUtils.Size)slVideoCapturer4).width = 1280;
                ((VideoUtils.Size)slVideoCapturer4).height = 720;
                break;
            }
            case 2: {
                SlVideoCapturer slVideoCapturer5 = slVideoCapturer2;
                ((VideoUtils.Size)slVideoCapturer5).width = 640;
                ((VideoUtils.Size)slVideoCapturer5).height = 480;
                break;
            }
            case 1: {
                SlVideoCapturer slVideoCapturer6 = slVideoCapturer2;
                ((VideoUtils.Size)slVideoCapturer6).width = 352;
                ((VideoUtils.Size)slVideoCapturer6).height = 288;
            }
        }
        return slVideoCapturer2;
    }

    private final int getPreferredFrameRate() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[this.preferredFrameRate.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                n = 1;
                break;
            }
            case 3: {
                n = 7;
                break;
            }
            case 2: {
                n = 15;
                break;
            }
            case 1: {
                n = 30;
            }
        }
        return n;
    }

    private final void configureCaptureSize(int n, int n2) {
        SlVideoCapturer slVideoCapturer = this;
        List list2 = null;
        int n3 = slVideoCapturer.getPreferredFrameRate();
        Camera camera = slVideoCapturer.camera;
        Intrinsics.checkNotNull((Object)camera);
        Camera.Parameters parameters = camera.getParameters();
        list2 = parameters.getSupportedPreviewSizes();
        n3 *= 1000;
        try {
            slVideoCapturer.captureFpsRange = slVideoCapturer.findClosestEnclosingFpsRange(n3, parameters.getSupportedPreviewFpsRange());
        }
        catch (RuntimeException runtimeException) {
            SLRLog.INSTANCE.e(TAG, "Error configuring capture size");
        }
        n3 = 0;
        int n4 = 0;
        if (list2 != null) {
            int n5 = list2.size();
            for (int i = 0; i < n5; ++i) {
                int n6;
                Camera.Size size = (Camera.Size)list2.get(i);
                int n7 = size.width;
                if (n7 < n3 || (n6 = size.height) < n4 || n7 > n || n6 > n2) continue;
                n4 = n6;
                n3 = n7;
            }
            if (n3 == 0 || n4 == 0) {
                List list3 = list2;
                Camera.Size size = (Camera.Size)list3.get(0);
                n = size.width;
                n2 = size.height;
                n4 = list3.size();
                for (n3 = 1; n3 < n4; ++n3) {
                    int n8;
                    Camera.Size size2 = (Camera.Size)list2.get(n3);
                    n5 = size2.width;
                    if (n5 > n || (n8 = size2.height) > n2) continue;
                    n2 = n8;
                    n = n5;
                }
                n4 = n2;
                n3 = n;
            }
        }
        SlVideoCapturer slVideoCapturer2 = this;
        slVideoCapturer2.captureWidth = n3;
        slVideoCapturer2.captureHeight = n4;
    }

    private final int[] findClosestEnclosingFpsRange(int n, List<int[]> object) {
        if (object != null && !object.isEmpty()) {
            if (this.isFrontCamera()) {
                String string2 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                if (Intrinsics.areEqual((Object)"samsung-sm-g900a", (Object)string3) && 30000 == n) {
                    n = 24000;
                }
            }
            int[] nArray = Collections.min(object, new Comparator<int[]>(n){
                private final int MAX_FPS_DIFF_THRESHOLD;
                private final int MAX_FPS_LOW_DIFF_WEIGHT;
                private final int MAX_FPS_HIGH_DIFF_WEIGHT;
                private final int MIN_FPS_THRESHOLD;
                private final int MIN_FPS_LOW_VALUE_WEIGHT;
                private final int MIN_FPS_HIGH_VALUE_WEIGHT;
                final /* synthetic */ int $fps;
                {
                    this.$fps = n;
                    this.MAX_FPS_DIFF_THRESHOLD = 5000;
                    this.MAX_FPS_LOW_DIFF_WEIGHT = 1;
                    this.MAX_FPS_HIGH_DIFF_WEIGHT = 3;
                    this.MIN_FPS_THRESHOLD = 8000;
                    this.MIN_FPS_LOW_VALUE_WEIGHT = 1;
                    this.MIN_FPS_HIGH_VALUE_WEIGHT = 4;
                }

                private final int progressivePenalty(int n, int n2, int n3, int n4) {
                    return n < n2 ? n * n3 : n2 * n3 + (n - n2) * n4;
                }

                private final int diff(int[] nArray) {
                    findClosestEnclosingFpsRange.closestRange.1 v0 = this;
                    int n = nArray[0];
                    int n2 = v0.MIN_FPS_THRESHOLD;
                    int n3 = v0.MIN_FPS_LOW_VALUE_WEIGHT;
                    int n4 = v0.MIN_FPS_HIGH_VALUE_WEIGHT;
                    int n5 = v0.progressivePenalty(n, n2, n3, n4);
                    findClosestEnclosingFpsRange.closestRange.1 v2 = this;
                    int n6 = Math.abs(v2.$fps * 1000 - nArray[1]);
                    int n7 = v2.MAX_FPS_DIFF_THRESHOLD;
                    n = v2.MAX_FPS_LOW_DIFF_WEIGHT;
                    n2 = v2.MAX_FPS_HIGH_DIFF_WEIGHT;
                    return n5 + v2.progressivePenalty(n6, n7, n, n2);
                }

                public final int getMAX_FPS_DIFF_THRESHOLD() {
                    return this.MAX_FPS_DIFF_THRESHOLD;
                }

                public final int getMAX_FPS_LOW_DIFF_WEIGHT() {
                    return this.MAX_FPS_LOW_DIFF_WEIGHT;
                }

                public final int getMAX_FPS_HIGH_DIFF_WEIGHT() {
                    return this.MAX_FPS_HIGH_DIFF_WEIGHT;
                }

                public final int getMIN_FPS_THRESHOLD() {
                    return this.MIN_FPS_THRESHOLD;
                }

                public final int getMIN_FPS_LOW_VALUE_WEIGHT() {
                    return this.MIN_FPS_LOW_VALUE_WEIGHT;
                }

                public final int getMIN_FPS_HIGH_VALUE_WEIGHT() {
                    return this.MIN_FPS_HIGH_VALUE_WEIGHT;
                }

                public int compare(@NotNull int[] nArray, @NotNull int[] nArray2) {
                    Intrinsics.checkNotNullParameter((Object)nArray, (String)"lhs");
                    Intrinsics.checkNotNullParameter((Object)nArray2, (String)"rhs");
                    return this.diff(nArray) - this.diff(nArray2);
                }
            });
            object = nArray;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"closestRange");
            this.checkRangeWithWarning(n, (int[])object);
            return nArray;
        }
        return new int[]{0, 0};
    }

    private final void checkRangeWithWarning(int n, int[] nArray) {
        if (n < nArray[0] || n > nArray[1]) {
            int n2 = nArray[1] / 1000;
            SLRLog.INSTANCE.w(TAG, "Closest fps range found: " + nArray[0] / 1000 + n2 + "for desired fps: " + n / 1000);
        }
    }

    private final int roundRotation(int n) {
        return (int)(Math.round((double)n / (double)90) * (long)90) % 360;
    }

    private final int getCameraIndexUsingFront(boolean bl) {
        int n = Camera.getNumberOfCameras();
        for (int i = 0; i < n; ++i) {
            Camera.CameraInfo cameraInfo;
            Camera.CameraInfo cameraInfo2 = cameraInfo;
            cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo2);
            if (bl && cameraInfo2.facing == 1) {
                return i;
            }
            if (bl || cameraInfo2.facing != 0) continue;
            return i;
        }
        return 0;
    }

    public static final /* synthetic */ boolean access$isCaptureRunning$p(SlVideoCapturer slVideoCapturer) {
        return slVideoCapturer.isCaptureRunning;
    }

    public static final /* synthetic */ VideoUtils.Size access$getPreferredResolution(SlVideoCapturer slVideoCapturer) {
        return slVideoCapturer.getPreferredResolution();
    }

    public static final /* synthetic */ int access$getPreferredFrameRate(SlVideoCapturer slVideoCapturer) {
        return slVideoCapturer.getPreferredFrameRate();
    }

    @NotNull
    public final Publisher.CameraCaptureResolution getPreferredResolution() {
        return this.preferredResolution;
    }

    public final void setPreferredResolution(@NotNull Publisher.CameraCaptureResolution cameraCaptureResolution) {
        Intrinsics.checkNotNullParameter((Object)cameraCaptureResolution, (String)"<set-?>");
        this.preferredResolution = cameraCaptureResolution;
    }

    @NotNull
    public final Publisher.CameraCaptureFrameRate getPreferredFrameRate() {
        return this.preferredFrameRate;
    }

    public final void setPreferredFrameRate(@NotNull Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        Intrinsics.checkNotNullParameter((Object)cameraCaptureFrameRate, (String)"<set-?>");
        this.preferredFrameRate = cameraCaptureFrameRate;
    }

    public final int get_fps() {
        return this._fps;
    }

    public final void set_fps(int n) {
        this._fps = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @Nullable
    public final int[] getFrame() {
        return this.frame;
    }

    public final void setFrame(@Nullable int[] nArray) {
        this.frame = nArray;
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    public final void setHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.handler = handler;
    }

    @NotNull
    public final Runnable getNewFrame() {
        return this.newFrame;
    }

    public final void setNewFrame(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.newFrame = runnable;
    }

    public synchronized void init() {
        Camera.CameraInfo cameraInfo;
        try {
            slVideoCapturer2.camera = Camera.open((int)slVideoCapturer2.cameraIndex);
        }
        catch (RuntimeException runtimeException) {
            SLRLog.INSTANCE.e(TAG, "The camera is in use by another app");
        }
        SlVideoCapturer slVideoCapturer = slVideoCapturer2;
        SlVideoCapturer slVideoCapturer2 = cameraInfo;
        slVideoCapturer.currentDeviceInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)slVideoCapturer.cameraIndex, (Camera.CameraInfo)slVideoCapturer2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int startCapture() {
        SLRLog.INSTANCE.d(TAG, "started() entered");
        if (this.isCaptureStarted) {
            return -1;
        }
        Object object = this.camera;
        if (object != null) {
            SurfaceTexture surfaceTexture;
            Object object2;
            SlVideoCapturer slVideoCapturer;
            Object object3;
            Object object4;
            SlVideoCapturer slVideoCapturer2;
            int n;
            SlVideoCapturer slVideoCapturer3;
            int n5;
            int n4;
            Camera.Parameters parameters;
            SlVideoCapturer slVideoCapturer4 = this;
            VideoUtils.Size size = slVideoCapturer4.getPreferredResolution();
            int n2 = size.width;
            slVideoCapturer4.configureCaptureSize(n2, size.height);
            Camera.Parameters parameters2 = parameters = object.getParameters();
            SlVideoCapturer slVideoCapturer5 = this;
            int n3 = slVideoCapturer5.captureWidth;
            parameters2.setPreviewSize(n3, slVideoCapturer5.captureHeight);
            parameters2.setPreviewFormat(17);
            n3 = this.captureFpsRange[0];
            parameters.setPreviewFpsRange(n3, this.captureFpsRange[1]);
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            }
            try {
                SlVideoCapturer slVideoCapturer6 = this;
                object.setParameters(parameters);
                PixelFormat.getPixelFormatInfo((int)17, (PixelFormat)slVideoCapturer6.pixelFormat);
                n4 = slVideoCapturer6.captureWidth * this.captureHeight * this.pixelFormat.bitsPerPixel / 8;
                n5 = slVideoCapturer6.numCaptureBuffers;
            }
            catch (RuntimeException runtimeException) {
                SLRLog.INSTANCE.e(TAG, "Camera.setParameters(parameters) - failed");
                return -1;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                object.addCallbackBuffer(new byte[n4]);
            }
            try {
                SlVideoCapturer slVideoCapturer7 = this;
                SlVideoCapturer slVideoCapturer8 = slVideoCapturer7;
                slVideoCapturer3 = slVideoCapturer7;
                n = n4;
                slVideoCapturer2 = this;
                Object object5 = object;
                object4 = object5;
                object3 = object5;
                slVideoCapturer = this;
                object2 = object;
                SlVideoCapturer slVideoCapturer9 = this;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            object = surfaceTexture;
            {
                slVideoCapturer9.surfaceTexture = new SurfaceTexture(42);
                object2.setPreviewTexture((SurfaceTexture)object);
            }
            object4.setPreviewCallbackWithBuffer((Camera.PreviewCallback)slVideoCapturer);
            object3.startPreview();
            slVideoCapturer2.previewBufferLock.lock();
            slVideoCapturer8.expectedFrameSize = n;
            slVideoCapturer3.previewBufferLock.unlock();
        } else {
            this.blackFrames = true;
            SlVideoCapturer slVideoCapturer = this;
            object = slVideoCapturer.newFrame;
            int n = slVideoCapturer._fps;
            this.handler.postDelayed((Runnable)object, (long)(1000 / n));
        }
        SlVideoCapturer slVideoCapturer = this;
        slVideoCapturer.isCaptureRunning = true;
        slVideoCapturer.isCaptureStarted = true;
        SLRLog.INSTANCE.d(TAG, "started() exit");
        return 0;
    }

    public synchronized int stopCapture() {
        Camera camera = this.camera;
        if (camera != null) {
            block5: {
                SlVideoCapturer slVideoCapturer = this;
                slVideoCapturer.previewBufferLock.lock();
                try {
                    if (!slVideoCapturer.isCaptureRunning) break block5;
                }
                catch (RuntimeException runtimeException) {
                    SLRLog.INSTANCE.e(TAG, "Camera.stopPreview() - failed ");
                    return -1;
                }
                Camera camera2 = camera;
                this.isCaptureRunning = false;
                camera2.stopPreview();
                camera2.setPreviewCallbackWithBuffer(null);
                camera2.release();
                SLRLog.INSTANCE.d(TAG, "Camera capture is stopped");
            }
            this.previewBufferLock.unlock();
        }
        this.isCaptureStarted = false;
        if (this.blackFrames) {
            this.handler.removeCallbacks(this.newFrame);
        }
        return 0;
    }

    public void destroy() {
        SlVideoCapturer slVideoCapturer = this;
        SLRLog.INSTANCE.d(TAG, "destroy");
        slVideoCapturer.forceCameraRelease(slVideoCapturer.cameraIndex);
    }

    public boolean isCaptureStarted() {
        return this.isCaptureStarted;
    }

    @NotNull
    public BaseVideoCapturer.CaptureSettings getCaptureSettings() {
        BaseVideoCapturer.CaptureSettings captureSettings;
        SlVideoCapturer slVideoCapturer = this;
        BaseVideoCapturer.CaptureSettings captureSettings2 = captureSettings;
        captureSettings = new BaseVideoCapturer.CaptureSettings();
        VideoUtils.Size size = slVideoCapturer.getPreferredResolution();
        int n = slVideoCapturer.getPreferredFrameRate();
        if (slVideoCapturer.camera != null) {
            BaseVideoCapturer.CaptureSettings captureSettings3 = captureSettings2;
            VideoUtils.Size size2 = size;
            int n2 = size2.width;
            this.configureCaptureSize(n2, size2.height);
            captureSettings2.fps = n;
            captureSettings2.width = this.captureWidth;
            captureSettings3.height = this.captureHeight;
            captureSettings3.format = 1;
            captureSettings3.expectedDelay = 0;
        } else {
            BaseVideoCapturer.CaptureSettings captureSettings4 = captureSettings2;
            captureSettings2.fps = n;
            captureSettings2.width = size.width;
            captureSettings4.height = size.height;
            captureSettings4.format = 2;
        }
        captureSettings2.mirrorInLocalRender = true;
        return captureSettings2;
    }

    public synchronized void onPause() {
        if (this.isCaptureStarted) {
            this.isCapturePaused = true;
            this.stopCapture();
        }
    }

    public void onResume() {
        if (this.isCapturePaused) {
            SlVideoCapturer slVideoCapturer = this;
            slVideoCapturer.init();
            slVideoCapturer.startCapture();
            slVideoCapturer.isCapturePaused = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFrontCamera() {
        SlVideoCapturer slVideoCapturer = slVideoCapturer.currentDeviceInfo;
        if (slVideoCapturer == null) return false;
        SlVideoCapturer slVideoCapturer2 = slVideoCapturer;
        Intrinsics.checkNotNull((Object)((Object)slVideoCapturer2));
        if (((Camera.CameraInfo)slVideoCapturer2).facing != 1) return false;
        return true;
    }

    public int getCameraIndex() {
        return this.cameraIndex;
    }

    public synchronized void cycleCamera() {
        SlVideoCapturer slVideoCapturer = this;
        slVideoCapturer.swapCamera((slVideoCapturer.getCameraIndex() + 1) % Camera.getNumberOfCameras());
    }

    @SuppressLint(value={"DefaultLocale"})
    public synchronized void swapCamera(int n) {
        SlVideoCapturer slVideoCapturer = slVideoCapturer5;
        boolean bl = slVideoCapturer.isCaptureStarted;
        if (slVideoCapturer.camera != null) {
            SlVideoCapturer slVideoCapturer2 = slVideoCapturer5;
            slVideoCapturer2.stopCapture();
            Camera camera = slVideoCapturer2.camera;
            if (camera != null) {
                camera.release();
            }
            slVideoCapturer5.camera = null;
        }
        slVideoCapturer5.cameraIndex = n;
        if (bl) {
            Camera.CameraInfo cameraInfo;
            String string2 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            if (-1 != StringsKt.indexOf$default((CharSequence)string3, (String)"samsung", (int)0, (boolean)false, (int)6, null)) {
                slVideoCapturer5.forceCameraRelease(n);
            }
            SlVideoCapturer slVideoCapturer3 = slVideoCapturer5;
            SlVideoCapturer slVideoCapturer4 = slVideoCapturer5;
            slVideoCapturer4.camera = Camera.open((int)n);
            SlVideoCapturer slVideoCapturer5 = cameraInfo;
            slVideoCapturer4.currentDeviceInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)slVideoCapturer5);
            slVideoCapturer3.startCapture();
        }
    }

    public final void setCustomVideoCapturerDataSource(@Nullable CustomVideoCapturerDataSource customVideoCapturerDataSource) {
        this.metadataSource = customVideoCapturerDataSource;
    }

    public void onPreviewFrame(@NotNull byte[] byArray, @NotNull Camera camera) {
        SlVideoCapturer slVideoCapturer = this;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        slVideoCapturer.previewBufferLock.lock();
        if (slVideoCapturer.isCaptureRunning && byArray.length == this.expectedFrameSize) {
            SlVideoCapturer slVideoCapturer2 = this;
            int n = slVideoCapturer2.compensateCameraRotation(slVideoCapturer2.currentDisplay.getRotation());
            Object object = slVideoCapturer2.metadataSource;
            if (object != null) {
                SlVideoCapturer slVideoCapturer3 = this;
                CustomVideoCapturerDataSource customVideoCapturerDataSource = object;
                Intrinsics.checkNotNull((Object)customVideoCapturerDataSource);
                object = customVideoCapturerDataSource.retrieveMetadata();
                int n2 = slVideoCapturer3.captureWidth;
                int n3 = slVideoCapturer3.captureHeight;
                boolean bl = slVideoCapturer3.isFrontCamera();
                slVideoCapturer3.provideByteArrayFrame(byArray, 1, n2, n3, n, bl, (byte[])object);
            } else {
                SlVideoCapturer slVideoCapturer4 = this;
                int n4 = slVideoCapturer4.captureWidth;
                int n5 = slVideoCapturer4.captureHeight;
                boolean bl = slVideoCapturer4.isFrontCamera();
                slVideoCapturer4.provideByteArrayFrame(byArray, 1, n4, n5, n, bl);
            }
            camera.addCallbackBuffer(byArray);
        }
        this.previewBufferLock.unlock();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/data/video/vonage/SlVideoCapturer$CustomVideoCapturerDataSource;", "", "retrieveMetadata", "", "sdk_originalVonageRelease"})
    public static interface CustomVideoCapturerDataSource {
        @NotNull
        public byte[] retrieveMetadata();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/common/data/video/vonage/SlVideoCapturer$Companion;", "", "()V", "PIXEL_FORMAT", "", "TAG", "", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Publisher.CameraCaptureResolution.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Publisher.CameraCaptureResolution.LOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureResolution.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureResolution.HIGH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureResolution.HIGH_1080P.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[Publisher.CameraCaptureFrameRate.values().length];
            nArray2 = nArray3;
            try {
                nArray3[Publisher.CameraCaptureFrameRate.FPS_30.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureFrameRate.FPS_15.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureFrameRate.FPS_7.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Publisher.CameraCaptureFrameRate.FPS_1.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

