/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.alphavideoview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.alphavideoview.ChromaKeyRenderer;
import io.streamlayer.common.views.alphavideoview.ChromaKeyVideoView;
import io.streamlayer.common.views.alphavideoview.GLTextureView;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 42\u00020\u0001:\u00044567B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0014J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0014J\b\u0010%\u001a\u00020 H\u0016J\u0006\u0010&\u001a\u00020 J\b\u0010'\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020 J\u0006\u0010,\u001a\u00020 J\u0010\u0010-\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010.\u001a\u00020 2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010/\u001a\u00020 2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020 R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00068"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView;", "Lio/streamlayer/common/views/alphavideoview/GLTextureView;", "color", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(ILandroid/content/Context;Landroid/util/AttributeSet;)V", "isDataSourceSet", "", "isSurfaceCreated", "<set-?>", "Landroid/media/MediaPlayer;", "mediaPlayer", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "onVideoEndedListener", "Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$OnVideoEndedListener;", "onVideoStartedListener", "Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$OnVideoStartedListener;", "renderer", "Lio/streamlayer/common/views/alphavideoview/ChromaKeyRenderer;", "state", "Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$PlayerState;", "videoAspectRatio", "", "getVideoAspectRatio", "()F", "setVideoAspectRatio", "(F)V", "initMediaPlayer", "", "onDetachedFromWindow", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPause", "pause", "prepareAndStartMediaPlayer", "prepareAsync", "onPreparedListener", "Landroid/media/MediaPlayer$OnPreparedListener;", "release", "reset", "setOnVideoEndedListener", "setOnVideoStartedListener", "setVideoFromUri", "uri", "Landroid/net/Uri;", "start", "stop", "Companion", "OnVideoEndedListener", "OnVideoStartedListener", "PlayerState", "sdk_originalVonageRelease"})
public final class ChromaKeyVideoView
extends GLTextureView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int GL_CONTEXT_VERSION = 2;
    private static final float DEFAULT_ASPECT_RATIO = 0.6666667f;
    private static final float DEFAULT_CENTER_VIDEO = 0.5f;
    @NotNull
    private static final String TAG = "ChromaKeyVideoView";
    private float videoAspectRatio;
    @Nullable
    private ChromaKeyRenderer renderer;
    @Nullable
    private MediaPlayer mediaPlayer;
    @Nullable
    private OnVideoStartedListener onVideoStartedListener;
    @Nullable
    private OnVideoEndedListener onVideoEndedListener;
    private boolean isSurfaceCreated;
    private boolean isDataSourceSet;
    @NotNull
    private PlayerState state;

    @JvmOverloads
    public ChromaKeyVideoView(int n, @NotNull Context object, @Nullable AttributeSet attributeSet) {
        ChromaKeyVideoView chromaKeyVideoView = this;
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        chromaKeyVideoView.videoAspectRatio = 0.6666667f;
        chromaKeyVideoView.state = PlayerState.NOT_PREPARED;
        if (!chromaKeyVideoView.isInEditMode()) {
            Function1<SurfaceTexture, Unit> function1;
            ChromaKeyRenderer chromaKeyRenderer;
            ChromaKeyVideoView chromaKeyVideoView2 = this;
            chromaKeyVideoView2.setEGLContextClientVersion(2);
            chromaKeyVideoView2.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            chromaKeyVideoView2.initMediaPlayer();
            chromaKeyVideoView2.setAlpha(0.0f);
            object = chromaKeyRenderer;
            new ChromaKeyRenderer().setBackgroundColor(n);
            Function1<SurfaceTexture, Unit> function12 = function1;
            function1 = new Function1<SurfaceTexture, Unit>(this){
                final /* synthetic */ ChromaKeyVideoView this$0;
                {
                    this.this$0 = chromaKeyVideoView;
                    super(1);
                }

                public final void invoke(@NotNull SurfaceTexture surfaceTexture) {
                    Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"it");
                    MediaPlayer mediaPlayer = this.this$0.getMediaPlayer();
                    if (mediaPlayer != null) {
                        Surface surface;
                        MediaPlayer mediaPlayer2 = mediaPlayer;
                        mediaPlayer = surface;
                        surface = new Surface(surfaceTexture);
                        mediaPlayer2.setSurface((Surface)mediaPlayer);
                    }
                    1.1 v2 = this;
                    ChromaKeyVideoView.access$setSurfaceCreated$p(v2.this$0, true);
                    if (ChromaKeyVideoView.access$isDataSourceSet$p(v2.this$0)) {
                        ChromaKeyVideoView.access$prepareAndStartMediaPlayer(this.this$0);
                    }
                }
            };
            object.setOnSurfacePrepareListener((Function1<? super SurfaceTexture, Unit>)function12);
            chromaKeyVideoView2.setRenderer((GLTextureView.Renderer)object);
            chromaKeyVideoView2.renderer = object;
            chromaKeyVideoView2.bringToFront();
            chromaKeyVideoView2.setRenderMode(1);
            chromaKeyVideoView2.setPreserveEGLContextOnPause(true);
            chromaKeyVideoView2.setOpaque(false);
            chromaKeyVideoView2.requestRender();
        }
    }

    public /* synthetic */ ChromaKeyVideoView(int n, Context context, AttributeSet attributeSet, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            attributeSet = null;
        }
        this(n, context, attributeSet);
    }

    private final void initMediaPlayer() {
        MediaPlayer mediaPlayer;
        MediaPlayer mediaPlayer2 = mediaPlayer;
        mediaPlayer2();
        this.mediaPlayer = mediaPlayer2;
        mediaPlayer.setScreenOnWhilePlaying(true);
        mediaPlayer2 = this.mediaPlayer;
        if (mediaPlayer2 != null) {
            mediaPlayer2.setOnCompletionListener(arg_0 -> ChromaKeyVideoView.initMediaPlayer$lambda$1(this, arg_0));
        }
    }

    private final void prepareAndStartMediaPlayer() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        chromaKeyVideoView.prepareAsync(arg_0 -> ChromaKeyVideoView.prepareAndStartMediaPlayer$lambda$2(chromaKeyVideoView, arg_0));
    }

    private final void prepareAsync(MediaPlayer.OnPreparedListener onPreparedListener) {
        PlayerState playerState = this.state;
        if (playerState == PlayerState.NOT_PREPARED || playerState == PlayerState.STOPPED) {
            playerState = this.mediaPlayer;
            if (playerState != null) {
                playerState.setOnPreparedListener(arg_0 -> ChromaKeyVideoView.prepareAsync$lambda$3(this, onPreparedListener, arg_0));
            }
            if ((this = this.mediaPlayer) != null) {
                this.prepareAsync();
            }
        }
    }

    @JvmOverloads
    public ChromaKeyVideoView(int n, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(n, context, null, 4, null);
    }

    private static final void initMediaPlayer$lambda$1(ChromaKeyVideoView object, MediaPlayer mediaPlayer) {
        ChromaKeyVideoView chromaKeyVideoView = object;
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        chromaKeyVideoView.state = PlayerState.PAUSED;
        object = chromaKeyVideoView.onVideoEndedListener;
        if (object != null) {
            object.onVideoEnded();
        }
    }

    private static final void prepareAndStartMediaPlayer$lambda$2(ChromaKeyVideoView chromaKeyVideoView, MediaPlayer mediaPlayer) {
        ChromaKeyVideoView chromaKeyVideoView2 = chromaKeyVideoView;
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView2), (String)"this$0");
        chromaKeyVideoView2.start();
    }

    private static final void prepareAsync$lambda$3(ChromaKeyVideoView chromaKeyVideoView, MediaPlayer.OnPreparedListener onPreparedListener, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)onPreparedListener, (String)"$onPreparedListener");
        chromaKeyVideoView.state = PlayerState.PREPARED;
        onPreparedListener.onPrepared(mediaPlayer);
    }

    private static final void start$lambda$5$lambda$4(MediaPlayer object, ChromaKeyVideoView chromaKeyVideoView, MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaKeyVideoView), (String)"this$0");
        object.start();
        chromaKeyVideoView.state = PlayerState.STARTED;
        object = chromaKeyVideoView.onVideoStartedListener;
        if (object != null) {
            object.onVideoStarted();
        }
    }

    public static final /* synthetic */ void access$setSurfaceCreated$p(ChromaKeyVideoView chromaKeyVideoView, boolean bl) {
        chromaKeyVideoView.isSurfaceCreated = bl;
    }

    public static final /* synthetic */ boolean access$isDataSourceSet$p(ChromaKeyVideoView chromaKeyVideoView) {
        return chromaKeyVideoView.isDataSourceSet;
    }

    public static final /* synthetic */ void access$prepareAndStartMediaPlayer(ChromaKeyVideoView chromaKeyVideoView) {
        chromaKeyVideoView.prepareAndStartMediaPlayer();
    }

    public final float getVideoAspectRatio() {
        return this.videoAspectRatio;
    }

    public final void setVideoAspectRatio(float f) {
        this.videoAspectRatio = f;
    }

    @Nullable
    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    protected void onMeasure(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        n = View.MeasureSpec.getMode((int)n);
        n2 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n4);
        int n6 = View.MeasureSpec.getSize((int)n3);
        n2 = (int)((float)n6 * this.videoAspectRatio);
        this.setTranslationX((float)(n5 - n2) * 0.5f);
        int n7 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)n);
        super.onMeasure(n7, View.MeasureSpec.makeMeasureSpec((int)n6, (int)n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setVideoFromUri(@NotNull Uri uri) {
        ChromaKeyVideoView chromaKeyVideoView = this;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        chromaKeyVideoView.reset();
        try {
            MediaPlayer mediaPlayer = chromaKeyVideoView.mediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setDataSource(this.getContext(), uri);
            }
            this.isDataSourceSet = true;
            if (!this.isSurfaceCreated) return;
            this.prepareAndStartMediaPlayer();
            return;
        }
        catch (IOException iOException) {
            SLRLog.INSTANCE.e(TAG, "Video from uri " + uri.getPath(), iOException);
        }
    }

    @Override
    public void onPause() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        super.onPause();
        chromaKeyVideoView.pause();
    }

    @Override
    protected void onDetachedFromWindow() {
        ChromaKeyVideoView chromaKeyVideoView = this;
        super.onDetachedFromWindow();
        chromaKeyVideoView.release();
    }

    public final void start() {
        MediaPlayer mediaPlayer = ((ChromaKeyVideoView)((Object)onVideoStartedListener)).mediaPlayer;
        if (mediaPlayer != null) {
            int n = WhenMappings.$EnumSwitchMapping$0[((ChromaKeyVideoView)((Object)onVideoStartedListener)).state.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        ((ChromaKeyVideoView)((Object)onVideoStartedListener)).prepareAsync(arg_0 -> ChromaKeyVideoView.start$lambda$5$lambda$4(mediaPlayer, (ChromaKeyVideoView)((Object)onVideoStartedListener), arg_0));
                    }
                } else {
                    ((ChromaKeyVideoView)((Object)onVideoStartedListener)).state = PlayerState.STARTED;
                    mediaPlayer.start();
                }
            } else {
                mediaPlayer.start();
                ((ChromaKeyVideoView)((Object)onVideoStartedListener)).state = PlayerState.STARTED;
                OnVideoStartedListener onVideoStartedListener = ((ChromaKeyVideoView)((Object)onVideoStartedListener)).onVideoStartedListener;
                if (onVideoStartedListener != null) {
                    onVideoStartedListener.onVideoStarted();
                }
            }
        }
    }

    public final void pause() {
        if (this.state == PlayerState.STARTED) {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.pause();
            }
            this.state = PlayerState.PAUSED;
        }
    }

    public final void stop() {
        PlayerState playerState = this.state;
        if (playerState == PlayerState.STARTED || playerState == PlayerState.PAUSED) {
            playerState = this.mediaPlayer;
            if (playerState != null) {
                playerState.stop();
            }
            this.state = PlayerState.STOPPED;
        }
    }

    public final void reset() {
        PlayerState playerState = this.state;
        if (playerState == PlayerState.STARTED || playerState == PlayerState.PAUSED || playerState == PlayerState.STOPPED) {
            playerState = this.mediaPlayer;
            if (playerState != null) {
                playerState.reset();
            }
            this.state = PlayerState.NOT_PREPARED;
        }
    }

    public final void release() {
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.release();
        }
        this.state = PlayerState.RELEASE;
    }

    public final void setOnVideoStartedListener(@Nullable OnVideoStartedListener onVideoStartedListener) {
        this.onVideoStartedListener = onVideoStartedListener;
    }

    public final void setOnVideoEndedListener(@Nullable OnVideoEndedListener onVideoEndedListener) {
        this.onVideoEndedListener = onVideoEndedListener;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$OnVideoStartedListener;", "", "onVideoStarted", "", "sdk_originalVonageRelease"})
    public static interface OnVideoStartedListener {
        public void onVideoStarted();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$OnVideoEndedListener;", "", "onVideoEnded", "", "sdk_originalVonageRelease"})
    public static interface OnVideoEndedListener {
        public void onVideoEnded();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$PlayerState;", "", "(Ljava/lang/String;I)V", "NOT_PREPARED", "PREPARED", "STARTED", "PAUSED", "STOPPED", "RELEASE", "sdk_originalVonageRelease"})
    private static enum PlayerState {
        NOT_PREPARED,
        PREPARED,
        STARTED,
        PAUSED,
        STOPPED,
        RELEASE;

    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyVideoView$Companion;", "", "()V", "DEFAULT_ASPECT_RATIO", "", "DEFAULT_CENTER_VIDEO", "GL_CONTEXT_VERSION", "", "TAG", "", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerState.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PlayerState.PREPARED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PlayerState.PAUSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PlayerState.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

