/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.tooltips;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.airbnb.lottie.LottieAnimationView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrTooltipProgressBinding;
import io.streamlayer.sdk.databinding.SlrTooltipViewBinding;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u00016B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u0002002\u0006\u00101\u001a\u00020\u0007H\u0002J\b\u00103\u001a\u000200H\u0002J\u000e\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001a\u00a8\u00067"}, d2={"Lio/streamlayer/common/views/tooltips/ToolTipView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/streamlayer/sdk/databinding/SlrTooltipProgressBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrTooltipProgressBinding;", "bubbleView", "Lio/streamlayer/common/views/tooltips/BubbleView;", "getBubbleView", "()Lio/streamlayer/common/views/tooltips/BubbleView;", "value", "currentItem", "getCurrentItem", "()I", "setCurrentItem", "(I)V", "description", "Landroidx/appcompat/widget/AppCompatTextView;", "getDescription", "()Landroidx/appcompat/widget/AppCompatTextView;", "dots", "Ljava/util/ArrayList;", "Landroid/widget/ImageView;", "Lkotlin/collections/ArrayList;", "dotsColor", "dotsCornerRadius", "", "dotsSize", "dotsSpacing", "lottie", "Lcom/airbnb/lottie/LottieAnimationView;", "getLottie", "()Lcom/airbnb/lottie/LottieAnimationView;", "okBtn", "Landroidx/appcompat/widget/AppCompatButton;", "getOkBtn", "()Landroidx/appcompat/widget/AppCompatButton;", "selectedDotColor", "title", "getTitle", "addDot", "", "index", "refreshDotColor", "refreshDotsColors", "setDots", "dotCount", "DotsGradientDrawable", "sdk_originalVonageRelease"})
public final class ToolTipView
extends ConstraintLayout {
    @NotNull
    private final SlrTooltipProgressBinding binding;
    @NotNull
    private final LottieAnimationView lottie;
    @NotNull
    private final AppCompatTextView title;
    @NotNull
    private final AppCompatTextView description;
    @NotNull
    private final AppCompatButton okBtn;
    @NotNull
    private final BubbleView bubbleView;
    @NotNull
    private final ArrayList<ImageView> dots;
    private final int dotsColor;
    private final int selectedDotColor;
    private int dotsSize;
    private int dotsSpacing;
    private float dotsCornerRadius;
    private int currentItem;

    @JvmOverloads
    public ToolTipView(@NotNull Context object, @Nullable AttributeSet object2, int n) {
        Context context = object;
        AttributeSet attributeSet = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        super((Context)object, object2, n);
        this.dots = new ArrayList();
        this.dotsColor = ContextCompat.getColor((Context)object, (int)R.color.slr_white);
        this.selectedDotColor = ContextCompat.getColor((Context)context2, (int)ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrOverlayTooltipBackgroundColor, R.color.slr_blue));
        this.dotsSize = ViewExtensionsKt.getDp(8.0f);
        this.dotsSpacing = ViewExtensionsKt.getDp(2.0f);
        this.dotsCornerRadius = (float)this.dotsSize / 2.0f;
        ConstraintLayout.inflate((Context)object, (int)R.layout.slr_tooltip_progress, (ViewGroup)this);
        Object object3 = object2 = SlrTooltipProgressBinding.bind((View)this);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"bind(this)");
        this.binding = object3;
        Object object4 = object = SlrTooltipViewBinding.inflate(LayoutInflater.from((Context)object), (ViewGroup)this, false);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"inflate(LayoutInflater.from(context), this, false)");
        LottieAnimationView lottieAnimationView = ((SlrTooltipViewBinding)object4).slrLottieView;
        Intrinsics.checkNotNullExpressionValue((Object)lottieAnimationView, (String)"view.slrLottieView");
        this.lottie = lottieAnimationView;
        AppCompatTextView appCompatTextView = ((SlrTooltipViewBinding)object).titleTV;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"view.titleTV");
        this.title = appCompatTextView;
        AppCompatTextView appCompatTextView2 = ((SlrTooltipViewBinding)object).slDescriptionTV;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"view.slDescriptionTV");
        this.description = appCompatTextView2;
        AppCompatButton appCompatButton = ((SlrTooltipViewBinding)object).okBtn;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton, (String)"view.okBtn");
        this.okBtn = appCompatButton;
        BubbleView bubbleView = object2.slBubbleView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bubbleView), (String)"binding.slBubbleView");
        this.bubbleView = bubbleView;
        BubbleView bubbleView2 = object2.slBubbleView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bubbleView2), (String)"binding.slBubbleView");
        ConstraintLayout constraintLayout = ((SlrTooltipViewBinding)object).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"view.root");
        BubbleView.customView$default(bubbleView2, (View)constraintLayout, 0, 0, 6, null);
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SLRToolTipView, (String)"SLRToolTipView");
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SLRToolTipView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        String string2 = typedArray.getString(R.styleable.SLRToolTipView_slrAnimation);
        if (string2 != null) {
            ((SlrTooltipViewBinding)object).slrLottieView.setAnimation(string2);
        }
        if ((string2 = typedArray.getString(R.styleable.SLRToolTipView_slrTooltipTitle)) != null) {
            ((SlrTooltipViewBinding)object).titleTV.setText((CharSequence)string2);
        }
        if ((string2 = typedArray.getString(R.styleable.SLRToolTipView_slrTooltipDescription)) != null) {
            ((SlrTooltipViewBinding)object).slDescriptionTV.setText((CharSequence)string2);
        }
        Object object5 = object2;
        int n2 = typedArray.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_arrow_height);
        object5.slBubbleView.arrowHeight(n2);
        object5.slBubbleView.arrowWidth(n2);
        object5.slBubbleView.position(BubbleView.Position.Companion.parse(typedArray.getInt(R.styleable.SLRToolTipView_slrToolTipPosition, BubbleView.Position.NONE.ordinal())));
        object5.slBubbleView.setArrowHeightPosition(typedArray.getDimensionPixelSize(R.styleable.SLRToolTipView_slrBubbleArrowHeightPosition, 0));
        this.setDots(typedArray.getInt(R.styleable.SLRToolTipView_slrDotsCount, 0));
        typedArray.recycle();
    }

    public /* synthetic */ ToolTipView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void refreshDotsColors() {
        int n = this.dots.size();
        for (int i = 0; i < n; ++i) {
            this.refreshDotColor(i);
        }
    }

    private final void addDot(int n) {
        DotsGradientDrawable dotsGradientDrawable;
        int n2;
        ImageView imageView2;
        ImageView imageView3;
        RelativeLayout relativeLayout;
        RelativeLayout relativeLayout2 = relativeLayout;
        relativeLayout = new RelativeLayout(this.getContext());
        ImageView imageView4 = imageView3 = imageView2;
        imageView4(this.getContext());
        relativeLayout2.addView((View)imageView4);
        ViewGroup.LayoutParams layoutParams = imageView2.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        ((RelativeLayout.LayoutParams)layoutParams).height = n2 = this.dotsSize;
        ((RelativeLayout.LayoutParams)layoutParams).width = n2;
        int n3 = this.dotsSpacing;
        ((RelativeLayout.LayoutParams)layoutParams).setMargins(n3, 0, n3, 0);
        DotsGradientDrawable dotsGradientDrawable2 = dotsGradientDrawable;
        dotsGradientDrawable2();
        dotsGradientDrawable.setCornerRadius(this.dotsCornerRadius);
        n = this.currentItem == n ? this.selectedDotColor : this.dotsColor;
        ToolTipView toolTipView = this;
        DotsGradientDrawable dotsGradientDrawable3 = dotsGradientDrawable2;
        dotsGradientDrawable3.setColor(n);
        imageView3.setBackground((Drawable)dotsGradientDrawable3);
        toolTipView.dots.add(imageView3);
        toolTipView.binding.slDotContainer.addView((View)relativeLayout2);
    }

    private final void refreshDotColor(int n) {
        ToolTipView toolTipView = this;
        ImageView imageView2 = toolTipView.dots.get(n);
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"dots[index]");
        ImageView imageView3 = imageView2;
        Drawable drawable2 = imageView2.getBackground();
        Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type io.streamlayer.common.views.tooltips.ToolTipView.DotsGradientDrawable");
        DotsGradientDrawable dotsGradientDrawable = (DotsGradientDrawable)drawable2;
        if (n == toolTipView.currentItem) {
            dotsGradientDrawable.setColor(this.selectedDotColor);
        } else {
            dotsGradientDrawable.setColor(this.dotsColor);
        }
        ImageView imageView4 = imageView3;
        imageView4.setBackground((Drawable)dotsGradientDrawable);
        imageView4.invalidate();
    }

    @JvmOverloads
    public ToolTipView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public ToolTipView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @NotNull
    public final SlrTooltipProgressBinding getBinding() {
        return this.binding;
    }

    @NotNull
    public final LottieAnimationView getLottie() {
        return this.lottie;
    }

    @NotNull
    public final AppCompatTextView getTitle() {
        return this.title;
    }

    @NotNull
    public final AppCompatTextView getDescription() {
        return this.description;
    }

    @NotNull
    public final AppCompatButton getOkBtn() {
        return this.okBtn;
    }

    @NotNull
    public final BubbleView getBubbleView() {
        return this.bubbleView;
    }

    public final int getCurrentItem() {
        return this.currentItem;
    }

    public final void setCurrentItem(int n) {
        this.currentItem = n;
        this.refreshDotsColors();
    }

    public final void setDots(int n) {
        for (int i = 0; i < n; ++i) {
            this.addDot(i);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/views/tooltips/ToolTipView$DotsGradientDrawable;", "Landroid/graphics/drawable/GradientDrawable;", "()V", "<set-?>", "", "currentColor", "getCurrentColor", "()I", "setColor", "", "argb", "sdk_originalVonageRelease"})
    private static final class DotsGradientDrawable
    extends GradientDrawable {
        private int currentColor;

        public final int getCurrentColor() {
            return this.currentColor;
        }

        public void setColor(int n) {
            super.setColor(n);
            this.currentColor = n;
        }
    }
}

