/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.menu;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.SLRNotificationBadge;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemMenuSubitemBinding;
import io.streamlayer.sdk.main.menu.MenuDiffCallback;
import io.streamlayer.sdk.main.menu.MenuItem;
import io.streamlayer.sdk.model.sdksettings.SdkOverlay;
import io.streamlayer.sdk.model.sdksettings.SdkOverlaySettings;
import io.streamlayer.sdk.model.sdksettings.SdkOverlayUIType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001bB6\u0012!\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\t2\n\u0010\u0013\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u001c\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0014\u0010\u0019\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/main/menu/MenuSubItemsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/sdk/main/menu/MenuSubItemsAdapter$MenuSubItemHolder;", "onItemClick", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/sdksettings/SdkOverlay;", "Lkotlin/ParameterName;", "name", "item", "", "onClose", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "items", "", "Lio/streamlayer/sdk/main/menu/MenuItem;", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "", "MenuSubItemHolder", "sdk_originalVonageRelease"})
public final class MenuSubItemsAdapter
extends RecyclerView.Adapter<MenuSubItemHolder> {
    @NotNull
    private final Function1<SdkOverlay, Unit> onItemClick;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final List<MenuItem> items;

    public MenuSubItemsAdapter(@NotNull Function1<? super SdkOverlay, Unit> function1, @NotNull Function0<Unit> function0) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(function1, (String)"onItemClick");
        Intrinsics.checkNotNullParameter(function0, (String)"onClose");
        object.onItemClick = function1;
        object.onClose = function0;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    @NotNull
    public MenuSubItemHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        MenuSubItemsAdapter menuSubItemsAdapter = object;
        Object object = SlrItemMenuSubitemBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return menuSubItemsAdapter.new MenuSubItemHolder((SlrItemMenuSubitemBinding)object);
    }

    public void onBindViewHolder(@NotNull MenuSubItemHolder menuSubItemHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)menuSubItemHolder), (String)"holder");
        menuSubItemHolder.bind(this.items.get(menuSubItemHolder.getAbsoluteAdapterPosition()));
    }

    public int getItemCount() {
        return this.items.size();
    }

    public final void setItems(@NotNull List<MenuItem> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"items");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new MenuDiffCallback(this.items, list2));
        MenuSubItemsAdapter menuSubItemsAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(MenuDiffCallback(this.items, items))");
        List<MenuItem> list3 = menuSubItemsAdapter.items;
        list3.clear();
        list3.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)menuSubItemsAdapter);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/sdk/main/menu/MenuSubItemsAdapter$MenuSubItemHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemMenuSubitemBinding;", "(Lio/streamlayer/sdk/main/menu/MenuSubItemsAdapter;Lio/streamlayer/sdk/databinding/SlrItemMenuSubitemBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemMenuSubitemBinding;", "bind", "", "item", "Lio/streamlayer/sdk/main/menu/MenuItem;", "getIconId", "", "data", "Lio/streamlayer/sdk/model/sdksettings/SdkOverlay;", "getLabel", "sdk_originalVonageRelease"})
    public final class MenuSubItemHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemMenuSubitemBinding binding;

        public MenuSubItemHolder(SlrItemMenuSubitemBinding slrItemMenuSubitemBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemMenuSubitemBinding, (String)"binding");
            super((View)slrItemMenuSubitemBinding.getRoot());
            this.binding = slrItemMenuSubitemBinding;
        }

        @DrawableRes
        private final int getIconId(SdkOverlay sdkOverlay) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[sdkOverlay.getType().ordinal()]) {
                default: {
                    n = R.drawable.slr_bg_menu_item;
                    break;
                }
                case 11: {
                    SdkOverlaySettings sdkOverlaySettings = sdkOverlay.getSettings();
                    if ((sdkOverlaySettings != null ? sdkOverlaySettings.getParams() : null) != null) {
                        n = sdkOverlay.getSettings().getParams().getIconId();
                        break;
                    }
                    n = R.drawable.slr_bg_menu_item;
                    break;
                }
                case 10: {
                    n = R.drawable.slr_ic_highlights;
                    break;
                }
                case 9: {
                    n = R.drawable.slr_ic_profile_48;
                    break;
                }
                case 8: {
                    n = R.drawable.slr_ic_bet365;
                    break;
                }
                case 7: {
                    n = R.drawable.slr_ic_shopping;
                    break;
                }
                case 6: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_statistics;
                    break;
                }
                case 4: {
                    n = R.drawable.slr_ic_fantasy;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 2: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 1: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @StringRes
        private final int getLabel(SdkOverlay sdkOverlay) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[sdkOverlay.getType().ordinal()]) {
                default: {
                    n = R.string.slr_unknown;
                    break;
                }
                case 12: {
                    n = R.string.slr_games;
                    break;
                }
                case 11: {
                    SdkOverlaySettings sdkOverlaySettings = sdkOverlay.getSettings();
                    if ((sdkOverlaySettings != null ? sdkOverlaySettings.getParams() : null) != null) {
                        n = sdkOverlay.getSettings().getParams().getTitleId();
                        break;
                    }
                    n = R.string.slr_unknown;
                    break;
                }
                case 10: {
                    n = R.string.slr_highlights;
                    break;
                }
                case 9: {
                    n = R.string.slr_profile;
                    break;
                }
                case 8: {
                    n = R.string.slr_tickets;
                    break;
                }
                case 7: {
                    n = R.string.slr_shopping;
                    break;
                }
                case 6: {
                    n = R.string.slr_betting;
                    break;
                }
                case 5: {
                    n = R.string.slr_statistics;
                    break;
                }
                case 4: {
                    n = R.string.slr_fantasy;
                    break;
                }
                case 3: {
                    n = R.string.slr_twitter;
                    break;
                }
                case 2: {
                    n = R.string.slr_watch_party;
                    break;
                }
                case 1: {
                    n = R.string.slr_chat;
                }
            }
            return n;
        }

        private static final void bind$lambda$5$lambda$0(MenuSubItemsAdapter menuSubItemsAdapter, SdkOverlay sdkOverlay, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)menuSubItemsAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)sdkOverlay, (String)"$data");
            menuSubItemsAdapter.onItemClick.invoke((Object)sdkOverlay);
        }

        private static final void bind$lambda$5$lambda$1(MenuSubItemsAdapter menuSubItemsAdapter, View view2) {
            MenuSubItemsAdapter menuSubItemsAdapter2 = menuSubItemsAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)menuSubItemsAdapter2), (String)"this$0");
            menuSubItemsAdapter2.onClose.invoke();
        }

        public static final /* synthetic */ int access$getIconId(MenuSubItemHolder menuSubItemHolder, SdkOverlay sdkOverlay) {
            return menuSubItemHolder.getIconId(sdkOverlay);
        }

        @NotNull
        public final SlrItemMenuSubitemBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull MenuItem menuItem) {
            MenuItem menuItem2 = menuItem;
            Intrinsics.checkNotNullParameter((Object)menuItem2, (String)"item");
            SdkOverlay sdkOverlay = menuItem2.getOverlay();
            SlrItemMenuSubitemBinding slrItemMenuSubitemBinding = ((MenuSubItemHolder)((Object)sLRNotificationBadge)).binding;
            MenuSubItemsAdapter menuSubItemsAdapter = ((MenuSubItemHolder)((Object)sLRNotificationBadge)).MenuSubItemsAdapter.this;
            Object object = arg_0 -> MenuSubItemHolder.bind$lambda$5$lambda$0(menuSubItemsAdapter, sdkOverlay, arg_0);
            slrItemMenuSubitemBinding.slItemView.setOnClickListener((View.OnClickListener)object);
            slrItemMenuSubitemBinding.slMenuSubitemIcon.setOnClickListener((View.OnClickListener)object);
            slrItemMenuSubitemBinding.slContainer.setOnClickListener(arg_0 -> MenuSubItemHolder.bind$lambda$5$lambda$1(menuSubItemsAdapter, arg_0));
            menuSubItemsAdapter = slrItemMenuSubitemBinding.slMenuSubitemLabelTV;
            if (menuSubItemsAdapter != null) {
                MenuSubItemsAdapter menuSubItemsAdapter2 = menuSubItemsAdapter;
                menuSubItemsAdapter2.setText(((MenuSubItemHolder)((Object)sLRNotificationBadge)).getLabel(sdkOverlay));
                menuSubItemsAdapter2.setAlpha(1.0f);
                menuSubItemsAdapter2.setTranslationY(0.0f);
                menuSubItemsAdapter2.setTranslationY(0.0f);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)menuSubItemsAdapter2), (String)"bind$lambda$5$lambda$2");
                ViewExtensionsKt.visible((View)menuSubItemsAdapter2);
            }
            menuSubItemsAdapter = slrItemMenuSubitemBinding.slMenuSubitemIcon;
            menuSubItemsAdapter.setTranslationY(0.0f);
            menuSubItemsAdapter.setAlpha(1.0f);
            object = sdkOverlay.getIcon();
            boolean bl = object == null || object.length() == 0;
            if (bl) {
                Function1<ImageView, Unit> function1;
                MenuSubItemsAdapter menuSubItemsAdapter3 = menuSubItemsAdapter;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)menuSubItemsAdapter3), (String)"bind$lambda$5$lambda$3");
                menuSubItemsAdapter = function1;
                function1 = new Function1<ImageView, Unit>((MenuSubItemHolder)((Object)sLRNotificationBadge), sdkOverlay){
                    final /* synthetic */ MenuSubItemHolder this$0;
                    final /* synthetic */ SdkOverlay $data;
                    {
                        this.this$0 = menuSubItemHolder;
                        this.$data = sdkOverlay;
                        super(1);
                    }

                    public final void invoke(@NotNull ImageView imageView2) {
                        Intrinsics.checkNotNullParameter((Object)imageView2, (String)"$this$dispose");
                        imageView2.setImageDrawable(AppCompatResources.getDrawable((Context)this.this$0.itemView.getContext(), (int)MenuSubItemHolder.access$getIconId(this.this$0, this.$data)));
                    }
                };
                CoilExtensionsKt.dispose((ImageView)menuSubItemsAdapter3, (Function1<? super ImageView, Unit>)menuSubItemsAdapter);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)menuSubItemsAdapter), (String)"bind$lambda$5$lambda$3");
                ViewExtensionsKt.loadUrl$default((ImageView)menuSubItemsAdapter, sdkOverlay.getIcon(), false, null, null, 14, null);
            }
            SLRNotificationBadge sLRNotificationBadge = slrItemMenuSubitemBinding.slMenuSubitemIconBadge;
            sLRNotificationBadge.show(menuItem.getCounter());
            if (menuItem.getCounter() == 0) {
                sLRNotificationBadge.hide();
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SdkOverlayUIType.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[SdkOverlayUIType.Messaging.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.WatchParty.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Twitter.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Contests.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Statistics.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Betting.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Merchandise.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Tickets.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Profile.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Highlights.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Custom.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[SdkOverlayUIType.Leaderboard.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }
}

