/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.odds.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemOddsFutureBinding;
import io.streamlayer.sdk.model.odds.Future;
import io.streamlayer.sdk.model.odds.League;
import io.streamlayer.sdk.odds.OpenedBet;
import io.streamlayer.sdk.odds.adapters.FuturesComparator;
import io.streamlayer.sdk.odds.adapters.SelectableBetViewHolder;
import io.streamlayer.sdk.odds.views.OddsViewExtensions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0002J\u0014\u0010'\u001a\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u0015J\u0014\u0010)\u001a\u00020\t*\u00020%2\u0006\u0010*\u001a\u00020+H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/streamlayer/sdk/odds/adapters/FuturesAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "primaryColor", "", "textColor", "openBet", "Lkotlin/Function1;", "Lio/streamlayer/sdk/odds/OpenedBet;", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "futures", "", "Lio/streamlayer/sdk/model/odds/Future;", "league", "Lio/streamlayer/sdk/model/odds/League;", "getLeague", "()Lio/streamlayer/sdk/model/odds/League;", "setLeague", "(Lio/streamlayer/sdk/model/odds/League;)V", "openedBets", "", "getOpenedBets", "()Ljava/util/List;", "setOpenedBets", "(Ljava/util/List;)V", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setClickListener", "variant", "Landroidx/constraintlayout/widget/ConstraintLayout;", "future", "setItems", "list", "setViewSelected", "selected", "", "FutureViewHolder", "sdk_originalVonageRelease"})
public final class FuturesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final String primaryColor;
    @Nullable
    private final String textColor;
    @Nullable
    private final Function1<OpenedBet, Unit> openBet;
    @NotNull
    private final List<Future> futures;
    @NotNull
    private List<OpenedBet> openedBets;
    @Nullable
    private League league;

    public FuturesAdapter(@NotNull String string2, @Nullable String string3, @Nullable Function1<? super OpenedBet, Unit> function1) {
        FuturesAdapter futuresAdapter2 = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"primaryColor");
        this.primaryColor = string2;
        this.textColor = string3;
        futuresAdapter2.openBet = function1;
        futuresAdapter2.futures = new ArrayList<Future>();
        futuresAdapter2.openedBets = CollectionsKt.emptyList();
    }

    public /* synthetic */ FuturesAdapter(String string2, String string3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(string2, string3, (Function1<? super OpenedBet, Unit>)function1);
    }

    private final void setViewSelected(ConstraintLayout constraintLayout, boolean bl) {
        FuturesAdapter futuresAdapter2;
        if (bl) {
            FuturesAdapter futuresAdapter3 = futuresAdapter2;
            futuresAdapter2 = constraintLayout.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)futuresAdapter2), (String)"context");
            int n = ViewExtensionsKt.getDp(8.0f);
            String string2 = futuresAdapter3.primaryColor;
            futuresAdapter2 = OddsViewExtensions.INSTANCE.createSelected((Context)futuresAdapter2, n, string2);
        } else {
            FuturesAdapter futuresAdapter4 = futuresAdapter2;
            futuresAdapter2 = constraintLayout.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)futuresAdapter2), (String)"context");
            int n = ViewExtensionsKt.getDp(8.0f);
            String string3 = futuresAdapter4.primaryColor;
            futuresAdapter2 = OddsViewExtensions.INSTANCE.createBorder((Context)futuresAdapter2, n, string3);
        }
        constraintLayout.setBackground((Drawable)futuresAdapter2);
    }

    private final void setClickListener(ConstraintLayout constraintLayout, Future future) {
        constraintLayout.setOnClickListener(arg_0 -> FuturesAdapter.setClickListener$lambda$1(this, future, constraintLayout, arg_0));
    }

    private static final void setClickListener$lambda$1(FuturesAdapter object, Future future, ConstraintLayout object2, View function1) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"$variant");
        function1 = object.openBet;
        if (function1 != null) {
            FuturesAdapter futuresAdapter2 = object;
            ConstraintLayout constraintLayout = object2;
            object2 = future.getName();
            String string2 = constraintLayout.getContext().getString(R.string.slr_odds_winner);
            Object object3 = futuresAdapter2.league;
            if (object3 == null || (object3 = ((League)object3).getName()) == null) {
                object3 = " ";
            }
            Object object4 = object;
            object = string2 + "\n" + (String)object3;
            float f = future.getValue();
            ((OpenedBet)object4)((String)object2, (String)object, null, f, null, null, 0.0, 0.0, null, null, 1012, null);
            function1.invoke(object4);
        }
    }

    @NotNull
    public final List<OpenedBet> getOpenedBets() {
        return this.openedBets;
    }

    public final void setOpenedBets(@NotNull List<OpenedBet> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.openedBets = list2;
    }

    @Nullable
    public final League getLeague() {
        return this.league;
    }

    public final void setLeague(@Nullable League league2) {
        this.league = league2;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup object, int n) {
        ViewGroup viewGroup = object;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        object = SlrItemOddsFutureBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), (ViewGroup)object, false);
        ConstraintLayout constraintLayout = ((SlrItemOddsFutureBinding)object).getRoot();
        Context context = ((SlrItemOddsFutureBinding)object).getRoot().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
        constraintLayout.setBackground((Drawable)OddsViewExtensions.createBorder$default(OddsViewExtensions.INSTANCE, context, 0, null, 6, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026r(root.context)\n        }");
        return new FutureViewHolder((SlrItemOddsFutureBinding)object);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        ((FutureViewHolder)viewHolder2).bind(this.futures.get(n));
    }

    public int getItemCount() {
        return this.futures.size();
    }

    public final void setItems(@NotNull List<Future> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new FuturesComparator(this.futures, list2));
        FuturesAdapter futuresAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(FuturesComparator(futures, list))");
        futuresAdapter2.futures.clear();
        futuresAdapter2.futures.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)futuresAdapter2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/odds/adapters/FuturesAdapter$FutureViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/odds/adapters/SelectableBetViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsFutureBinding;", "(Lio/streamlayer/sdk/odds/adapters/FuturesAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsFutureBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsFutureBinding;", "future", "Lio/streamlayer/sdk/model/odds/Future;", "bind", "", "select", "openedBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "selected", "", "unselectAll", "sdk_originalVonageRelease"})
    public final class FutureViewHolder
    extends RecyclerView.ViewHolder
    implements SelectableBetViewHolder {
        @NotNull
        private final SlrItemOddsFutureBinding binding;
        @Nullable
        private Future future;

        public FutureViewHolder(SlrItemOddsFutureBinding slrItemOddsFutureBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsFutureBinding, (String)"binding");
            super((View)slrItemOddsFutureBinding.getRoot());
            this.binding = slrItemOddsFutureBinding;
        }

        @NotNull
        public final SlrItemOddsFutureBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull Future object) {
            FutureViewHolder futureViewHolder = this;
            Future future = object;
            Intrinsics.checkNotNullParameter((Object)future, (String)"future");
            futureViewHolder.future = future;
            futureViewHolder.binding.slName.setText((CharSequence)((Future)object).getName());
            futureViewHolder.binding.slValue.setText((CharSequence)OtherExtensionsKt.toSignedString(((Future)object).getValue()));
            SlrItemOddsFutureBinding slrItemOddsFutureBinding = futureViewHolder.binding;
            TextView textView = slrItemOddsFutureBinding.slValue;
            Context context = slrItemOddsFutureBinding.getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            textView.setTextColor(OddsViewExtensions.INSTANCE.getColor(context, FuturesAdapter.this.textColor));
            FuturesAdapter futuresAdapter2 = futureViewHolder.FuturesAdapter.this;
            ConstraintLayout constraintLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            futuresAdapter2.setClickListener(constraintLayout, (Future)object);
            futureViewHolder.unselectAll();
            object = futureViewHolder.FuturesAdapter.this.getOpenedBets().iterator();
            while (object.hasNext()) {
                this.select((OpenedBet)object.next(), true);
            }
        }

        @Override
        public void unselectAll() {
            ConstraintLayout constraintLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            FuturesAdapter.this.setViewSelected(constraintLayout, false);
        }

        @Override
        public void select(@NotNull OpenedBet openedBet, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)openedBet, (String)"openedBet");
            Future future = this.future;
            if (future != null) {
                FuturesAdapter futuresAdapter2 = FuturesAdapter.this;
                if (Intrinsics.areEqual((Object)future.getName(), (Object)openedBet.getTitle()) && (float)future.getValue() == openedBet.getBet()) {
                    ConstraintLayout constraintLayout = this.binding.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                    futuresAdapter2.setViewSelected(constraintLayout, bl);
                }
            }
        }
    }
}

