/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.odds.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemOddsLeagueBinding;
import io.streamlayer.sdk.model.odds.League;
import io.streamlayer.sdk.odds.adapters.LeaguesComparator;
import io.streamlayer.sdk.odds.views.OddsViewExtensions;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.predictions.view.ShapesKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0016\u0010\u001f\u001a\u00020\b2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070!R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lio/streamlayer/sdk/odds/adapters/LeaguesAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "primaryColor", "", "selectLeague", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/odds/League;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "leagues", "", "selectedLeague", "getSelectedLeague", "()Lio/streamlayer/sdk/model/odds/League;", "setSelectedLeague", "(Lio/streamlayer/sdk/model/odds/League;)V", "createNotSelectedBackground", "Landroid/graphics/drawable/GradientDrawable;", "context", "Landroid/content/Context;", "createSelectedBackground", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "list", "", "LeagueViewHolder", "sdk_originalVonageRelease"})
public final class LeaguesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final String primaryColor;
    @Nullable
    private final Function1<League, Unit> selectLeague;
    @NotNull
    private final List<League> leagues;
    @Nullable
    private League selectedLeague;

    public LeaguesAdapter(@NotNull String string2, @Nullable Function1<? super League, Unit> function1) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"primaryColor");
        object.primaryColor = string2;
        object.selectLeague = function1;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.leagues = object;
    }

    public /* synthetic */ LeaguesAdapter(String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(string2, (Function1<? super League, Unit>)function1);
    }

    private final GradientDrawable createSelectedBackground(Context context) {
        OddsViewExtensions oddsViewExtensions = OddsViewExtensions.INSTANCE;
        return ShapesKt.createRoundRect(oddsViewExtensions.getColor(context, this.primaryColor), oddsViewExtensions.getColor(context, this.primaryColor), ViewExtensionsKt.getDp(6.0f), ViewExtensionsKt.getDp(1.0f));
    }

    private final GradientDrawable createNotSelectedBackground(Context context) {
        return ShapesKt.createRoundRect(ContextCompat.getColor((Context)context, (int)R.color.slr_white_alpha_10), ContextCompat.getColor((Context)context, (int)R.color.slr_white_alpha_10), ViewExtensionsKt.getDp(6.0f), ViewExtensionsKt.getDp(1.0f));
    }

    @Nullable
    public final League getSelectedLeague() {
        return this.selectedLeague;
    }

    public final void setSelectedLeague(@Nullable League league2) {
        this.selectedLeague = league2;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        LeaguesAdapter leaguesAdapter2 = object;
        Object object = SlrItemOddsLeagueBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return leaguesAdapter2.new LeagueViewHolder((SlrItemOddsLeagueBinding)object);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        ((LeagueViewHolder)viewHolder2).bind(this.leagues.get(n));
    }

    public int getItemCount() {
        return this.leagues.size();
    }

    public final void setItems(@NotNull List<League> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new LeaguesComparator(this.leagues, list2));
        LeaguesAdapter leaguesAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(LeaguesComparator(leagues, list))");
        leaguesAdapter2.leagues.clear();
        leaguesAdapter2.leagues.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)leaguesAdapter2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/odds/adapters/LeaguesAdapter$LeagueViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsLeagueBinding;", "(Lio/streamlayer/sdk/odds/adapters/LeaguesAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsLeagueBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsLeagueBinding;", "league", "Lio/streamlayer/sdk/model/odds/League;", "getLeague", "()Lio/streamlayer/sdk/model/odds/League;", "setLeague", "(Lio/streamlayer/sdk/model/odds/League;)V", "bind", "", "select", "selected", "", "sdk_originalVonageRelease"})
    public final class LeagueViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemOddsLeagueBinding binding;
        @Nullable
        private League league;

        public LeagueViewHolder(SlrItemOddsLeagueBinding slrItemOddsLeagueBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsLeagueBinding, (String)"binding");
            super((View)slrItemOddsLeagueBinding.getRoot());
            this.binding = slrItemOddsLeagueBinding;
        }

        private static final void bind$lambda$2(LeaguesAdapter leaguesAdapter2, League league2, View view2) {
            LeaguesAdapter leaguesAdapter3 = leaguesAdapter2;
            Intrinsics.checkNotNullParameter((Object)((Object)leaguesAdapter3), (String)"this$0");
            leaguesAdapter2 = leaguesAdapter3.selectLeague;
            if (leaguesAdapter2 != null) {
                leaguesAdapter2.invoke(league2);
            }
        }

        @NotNull
        public final SlrItemOddsLeagueBinding getBinding() {
            return this.binding;
        }

        @Nullable
        public final League getLeague() {
            return this.league;
        }

        public final void setLeague(@Nullable League league2) {
            this.league = league2;
        }

        public final void bind(@Nullable League league2) {
            String string2;
            this.league = league2;
            Object object = this.binding.slLeagueName;
            if (league2 == null || (string2 = league2.getName()) == null) {
                string2 = this.binding.getRoot().getContext().getString(R.string.slr_odds_league_all);
            }
            object.setText((CharSequence)string2);
            object = league2 != null ? league2.getLogo() : null;
            boolean bl = object == null || object.length() == 0;
            bl ^= true;
            string2 = this.binding.slLeagueName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"binding.slLeagueName");
            ViewGroup.LayoutParams layoutParams = string2.getLayoutParams();
            if (layoutParams != null) {
                layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                int n = bl ? ViewExtensionsKt.getDp(8.0f) : ViewExtensionsKt.getDp(16.0f);
                layoutParams.setMarginStart(n);
                n = bl ? ViewExtensionsKt.getDp(12.0f) : ViewExtensionsKt.getDp(16.0f);
                ViewGroup.LayoutParams layoutParams2 = layoutParams;
                layoutParams2.setMarginEnd(n);
                string2.setLayoutParams(layoutParams2);
                ImageView imageView2 = this.binding.slLeagueIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slLeagueIcon");
                ViewExtensionsKt.visibleIf((View)imageView2, bl);
                if (league2 != null) {
                    ImageView imageView3 = this.binding.slLeagueIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"binding.slLeagueIcon");
                    ExtensionsKt.load(imageView3, league2.getLogo());
                }
                LeagueViewHolder leagueViewHolder = this;
                leagueViewHolder.binding.getRoot().setOnClickListener(arg_0 -> LeagueViewHolder.bind$lambda$2(LeaguesAdapter.this, league2, arg_0));
                this.select(Intrinsics.areEqual((Object)league2, (Object)leagueViewHolder.LeaguesAdapter.this.getSelectedLeague()));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        public final void select(boolean bl) {
            LeagueViewHolder leagueViewHolder = leagueViewHolder2;
            LeagueViewHolder leagueViewHolder2 = leagueViewHolder.binding.getRoot();
            LeaguesAdapter leaguesAdapter2 = leagueViewHolder.LeaguesAdapter.this;
            if (bl) {
                LeaguesAdapter leaguesAdapter3 = leaguesAdapter2;
                leaguesAdapter2 = leagueViewHolder2.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)leaguesAdapter2), (String)"context");
                leaguesAdapter2 = leaguesAdapter3.createSelectedBackground((Context)leaguesAdapter2);
            } else {
                LeaguesAdapter leaguesAdapter4 = leaguesAdapter2;
                leaguesAdapter2 = leagueViewHolder2.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)leaguesAdapter2), (String)"context");
                leaguesAdapter2 = leaguesAdapter4.createNotSelectedBackground((Context)leaguesAdapter2);
            }
            leagueViewHolder2.setBackground((Drawable)leaguesAdapter2);
        }
    }
}

