/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.phonecontact;

import androidx.paging.PagingSource;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.sdk.model.contact.PhoneContact;
import io.streamlayer.sdk.model.pagination.PhoneContactPaginationParams;
import io.streamlayer.sdk.repository.phonecontact.PhoneContactRepo;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/sdk/repository/phonecontact/PhoneContactRepoImpl;", "Lio/streamlayer/sdk/repository/phonecontact/PhoneContactRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "(Lio/streamlayer/common/data/database/AppDatabase;)V", "getPhoneContacts", "Landroidx/paging/PagingSource;", "", "Lio/streamlayer/sdk/model/contact/PhoneContact;", "params", "Lio/streamlayer/sdk/model/pagination/PhoneContactPaginationParams;", "savePhoneContacts", "", "items", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sdk_originalVonageRelease"})
public final class PhoneContactRepoImpl
implements PhoneContactRepo {
    @NotNull
    private final AppDatabase database;

    public PhoneContactRepoImpl(@NotNull AppDatabase appDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)appDatabase), (String)"database");
        this.database = appDatabase;
    }

    @Override
    @NotNull
    public PagingSource<Integer, PhoneContact> getPhoneContacts(@NotNull PhoneContactPaginationParams phoneContactPaginationParams) {
        Intrinsics.checkNotNullParameter((Object)phoneContactPaginationParams, (String)"params");
        return this.database.phoneContactDao().getPhoneContacts(phoneContactPaginationParams.getQuery());
    }

    @Override
    @Nullable
    public Object savePhoneContacts(@NotNull List<PhoneContact> list2, @NotNull Continuation<? super Unit> continuation) {
        Object object = ((PhoneContactRepoImpl)object).database.phoneContactDao().mergePhoneContacts(list2, continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

