/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.whoswatching;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.CategoryViewHolder;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemCategoryViewBinding;
import io.streamlayer.sdk.databinding.SlrItemTinodeContactViewBinding;
import io.streamlayer.sdk.model.invites.AnyListItem;
import io.streamlayer.sdk.model.invites.Category;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.sdk.whoswatching.TinodeContactsDiffCallback;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0014\u0010\u001a\u001a\u00020\u00142\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u001bR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "listener", "Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter$Listener;", "session", "Lio/streamlayer/common/session/Session;", "(Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter$Listener;Lio/streamlayer/common/session/Session;)V", "listItems", "", "Lio/streamlayer/sdk/model/invites/AnyListItem;", "getListener", "()Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter$Listener;", "getSession", "()Lio/streamlayer/common/session/Session;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "", "Listener", "TinodeContactViewHolder", "sdk_originalVonageRelease"})
public final class TinodeContactsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Listener listener;
    @NotNull
    private final Session session;
    @NotNull
    private final List<AnyListItem> listItems;

    public TinodeContactsAdapter(@NotNull Listener listener2, @NotNull Session session2) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        object.listener = listener2;
        object.session = session2;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.listItems = object;
    }

    @NotNull
    public final Listener getListener() {
        return this.listener;
    }

    @NotNull
    public final Session getSession() {
        return this.session;
    }

    public int getItemCount() {
        return this.listItems.size();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof TinodeContactViewHolder) {
            TinodeContactViewHolder tinodeContactViewHolder = (TinodeContactViewHolder)viewHolder;
            AnyListItem anyListItem = this.listItems.get(n);
            Intrinsics.checkNotNull((Object)anyListItem, (String)"null cannot be cast to non-null type io.streamlayer.sdk.model.tinodecontact.TinodeContact");
            tinodeContactViewHolder.bind((TinodeContact)anyListItem);
        } else if (viewHolder instanceof CategoryViewHolder) {
            CategoryViewHolder categoryViewHolder = (CategoryViewHolder)viewHolder;
            AnyListItem anyListItem = this.listItems.get(n);
            Intrinsics.checkNotNull((Object)anyListItem, (String)"null cannot be cast to non-null type io.streamlayer.sdk.model.invites.Category");
            categoryViewHolder.bind((Category)anyListItem);
        }
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.listItems.get(n);
                    if (!(object instanceof TinodeContact)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof Category)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new Exception("Unsupported View type");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        void var0_4;
        void var2_6;
        void var1_5;
        Intrinsics.checkNotNullParameter((Object)var1_5, (String)"parent");
        if (var2_6 != false) {
            CategoryViewHolder categoryViewHolder;
            if (var2_6 != true) throw new Exception("Unsupported View type");
            CategoryViewHolder categoryViewHolder2 = categoryViewHolder;
            SlrItemCategoryViewBinding slrItemCategoryViewBinding = SlrItemCategoryViewBinding.inflate(LayoutInflater.from((Context)var1_5.getContext()), (ViewGroup)var1_5, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemCategoryViewBinding, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            categoryViewHolder = new CategoryViewHolder(slrItemCategoryViewBinding);
            return var0_4;
        } else {
            TinodeContactViewHolder tinodeContactViewHolder;
            TinodeContactViewHolder tinodeContactViewHolder2 = tinodeContactViewHolder;
            SlrItemTinodeContactViewBinding slrItemTinodeContactViewBinding = SlrItemTinodeContactViewBinding.inflate(LayoutInflater.from((Context)var1_5.getContext()), (ViewGroup)var1_5, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemTinodeContactViewBinding, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            tinodeContactViewHolder = new TinodeContactViewHolder(slrItemTinodeContactViewBinding);
            TinodeContactViewHolder tinodeContactViewHolder3 = tinodeContactViewHolder2;
        }
        return var0_4;
    }

    public final void setItems(@NotNull List<? extends AnyListItem> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new TinodeContactsDiffCallback(this.listItems, list2));
        TinodeContactsAdapter tinodeContactsAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(TinodeCont\u2026is.listItems, listItems))");
        tinodeContactsAdapter2.listItems.clear();
        tinodeContactsAdapter2.listItems.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)tinodeContactsAdapter2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter$TinodeContactViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemTinodeContactViewBinding;", "(Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter;Lio/streamlayer/sdk/databinding/SlrItemTinodeContactViewBinding;)V", "bind", "", "data", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "sdk_originalVonageRelease"})
    public final class TinodeContactViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemTinodeContactViewBinding binding;

        public TinodeContactViewHolder(SlrItemTinodeContactViewBinding slrItemTinodeContactViewBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemTinodeContactViewBinding, (String)"binding");
            super((View)slrItemTinodeContactViewBinding.getRoot());
            this.binding = slrItemTinodeContactViewBinding;
        }

        private static final void bind$lambda$2$lambda$0(TinodeContactsAdapter tinodeContactsAdapter2, TinodeContact tinodeContact, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)tinodeContactsAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)tinodeContact, (String)"$data");
            tinodeContactsAdapter2.getListener().onChatClick(tinodeContact);
        }

        private static final void bind$lambda$2$lambda$1(TinodeContactsAdapter tinodeContactsAdapter2, TinodeContact tinodeContact, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)tinodeContactsAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)tinodeContact, (String)"$data");
            tinodeContactsAdapter2.getListener().onWatchPartyClick(tinodeContact);
        }

        public final void bind(@NotNull TinodeContact tinodeContact) {
            Intrinsics.checkNotNullParameter((Object)tinodeContact, (String)"data");
            Object object = ((TinodeContactViewHolder)((Object)object2)).binding;
            Object object2 = ((TinodeContactViewHolder)((Object)object2)).TinodeContactsAdapter.this;
            MaterialTextView materialTextView = ((SlrItemTinodeContactViewBinding)object).slOnlineTV;
            Context context = ((SlrItemTinodeContactViewBinding)object).getRoot().getContext();
            int n = tinodeContact.getOnline() ? R.string.slr_status_online : R.string.slr_status_offline;
            SlrItemTinodeContactViewBinding slrItemTinodeContactViewBinding = object;
            materialTextView.setText((CharSequence)context.getString(n));
            slrItemTinodeContactViewBinding.slContactChatBtn.setOnClickListener(arg_0 -> TinodeContactViewHolder.bind$lambda$2$lambda$0((TinodeContactsAdapter)((Object)object2), tinodeContact, arg_0));
            slrItemTinodeContactViewBinding.slContactCallBtn.setOnClickListener(arg_0 -> TinodeContactViewHolder.bind$lambda$2$lambda$1((TinodeContactsAdapter)((Object)object2), tinodeContact, arg_0));
            ImageButton imageButton = slrItemTinodeContactViewBinding.slContactCallBtn;
            Intrinsics.checkNotNullExpressionValue((Object)imageButton, (String)"slContactCallBtn");
            ViewExtensionsKt.visibleIf((View)imageButton, ((TinodeContactsAdapter)((Object)object2)).getSession().isWpEnabled());
            slrItemTinodeContactViewBinding.slContactNameTV.setText((CharSequence)tinodeContact.getChatName());
            AppCompatImageView appCompatImageView = slrItemTinodeContactViewBinding.slContactIV;
            object2 = appCompatImageView;
            TinodeContact tinodeContact2 = tinodeContact;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slContactIV");
            object2 = tinodeContact2.getChatName();
            object = tinodeContact2.getPhotoData();
            boolean bl = tinodeContact2.getOnline();
            ProfileExtensionsKt.loadContactAvatarWithStatus$default((ImageView)appCompatImageView, (String)object2, (String)object, bl, 0.0f, 0.0f, null, null, null, 248, null);
            object2 = slrItemTinodeContactViewBinding.slNewDotView;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNewDotView");
            boolean bl2 = Intrinsics.areEqual((Object)tinodeContact.getAnyData(), (Object)Boolean.TRUE) && tinodeContact.getOnline();
            ViewExtensionsKt.visibleIf((View)object2, bl2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/whoswatching/TinodeContactsAdapter$Listener;", "", "onChatClick", "", "contact", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "onWatchPartyClick", "sdk_originalVonageRelease"})
    public static interface Listener {
        public void onWatchPartyClick(@NotNull TinodeContact var1);

        public void onChatClick(@NotNull TinodeContact var1);
    }
}

