/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.odds.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.paging.PagingDataAdapter;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemOddsGameBinding;
import io.streamlayer.sdk.model.odds.Game;
import io.streamlayer.sdk.model.odds.GameOdds;
import io.streamlayer.sdk.model.odds.OddsSport;
import io.streamlayer.sdk.model.odds.Team;
import io.streamlayer.sdk.model.odds.WagerSet;
import io.streamlayer.sdk.odds.OpenedBet;
import io.streamlayer.sdk.odds.adapters.GamesComparator;
import io.streamlayer.sdk.odds.adapters.SelectableBetViewHolder;
import io.streamlayer.sdk.odds.views.WagerView;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0001.BG\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0018\u001a\u00020\t2\n\u0010\u0019\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0014\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013J\u000e\u0010\"\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002J#\u0010#\u001a\u00020\t*\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010&J$\u0010'\u001a\u00020\t*\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002J$\u0010,\u001a\u00020\t*\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002J$\u0010-\u001a\u00020\t*\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/streamlayer/sdk/odds/adapters/GamesAdapter;", "Landroidx/paging/PagingDataAdapter;", "Lio/streamlayer/sdk/model/odds/Game;", "Lio/streamlayer/sdk/odds/adapters/GamesAdapter$GameViewHolder;", "textColor", "", "primaryColor", "navigateToGame", "Lkotlin/Function1;", "", "openBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "game", "getGame", "()Lio/streamlayer/sdk/model/odds/Game;", "setGame", "(Lio/streamlayer/sdk/model/odds/Game;)V", "openedBets", "", "getOpenedBets", "()Ljava/util/List;", "setOpenedBets", "(Ljava/util/List;)V", "onBindViewHolder", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "update", "games", "updateFirst", "setDrawMoneyLineListener", "Lio/streamlayer/sdk/odds/views/WagerView;", "moneyLine", "(Lio/streamlayer/sdk/odds/views/WagerView;Ljava/lang/Integer;Lio/streamlayer/sdk/model/odds/Game;)V", "setMoneyLineListener", "wagerSet", "Lio/streamlayer/sdk/model/odds/WagerSet;", "team", "Lio/streamlayer/sdk/model/odds/Team;", "setSpreadListener", "setTotalListener", "GameViewHolder", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nGamesAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GamesAdapter.kt\nio/streamlayer/sdk/odds/adapters/GamesAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1864#2,2:282\n1866#2:285\n1#3:284\n*S KotlinDebug\n*F\n+ 1 GamesAdapter.kt\nio/streamlayer/sdk/odds/adapters/GamesAdapter\n*L\n41#1:282,2\n41#1:285\n*E\n"})
public final class GamesAdapter
extends PagingDataAdapter<Game, GameViewHolder> {
    @Nullable
    private final String textColor;
    @NotNull
    private final String primaryColor;
    @Nullable
    private final Function1<Game, Unit> navigateToGame;
    @Nullable
    private final Function1<OpenedBet, Unit> openBet;
    @NotNull
    private List<OpenedBet> openedBets;
    @Nullable
    private Game game;

    public GamesAdapter(@Nullable String string2, @NotNull String string3, @Nullable Function1<? super Game, Unit> function1, @Nullable Function1<? super OpenedBet, Unit> function12) {
        GamesAdapter gamesAdapter2 = this;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"primaryColor");
        super((DiffUtil.ItemCallback)GamesComparator.INSTANCE, null, null, 6, null);
        this.textColor = string2;
        this.primaryColor = string3;
        this.navigateToGame = function1;
        gamesAdapter2.openBet = function12;
        gamesAdapter2.openedBets = CollectionsKt.emptyList();
    }

    public /* synthetic */ GamesAdapter(String string2, String string3, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            function12 = null;
        }
        this(string2, string3, (Function1<? super Game, Unit>)function1, (Function1<? super OpenedBet, Unit>)function12);
    }

    private final void setSpreadListener(WagerView wagerView, WagerSet wagerSet, Game game2, Team team) {
        wagerView.setOnClickListener(arg_0 -> GamesAdapter.setSpreadListener$lambda$5(wagerSet, this, team, game2, arg_0));
    }

    private final void setTotalListener(WagerView wagerView, WagerSet wagerSet, Game game2, Team team) {
        wagerView.setOnClickListener(arg_0 -> GamesAdapter.setTotalListener$lambda$7(wagerSet, this, team, game2, arg_0));
    }

    private final void setMoneyLineListener(WagerView wagerView, WagerSet wagerSet, Game game2, Team team) {
        wagerView.setOnClickListener(arg_0 -> GamesAdapter.setMoneyLineListener$lambda$9(wagerSet, this, team, wagerView, game2, arg_0));
    }

    private final void setDrawMoneyLineListener(WagerView wagerView, Integer n, Game game2) {
        wagerView.setOnClickListener(arg_0 -> GamesAdapter.setDrawMoneyLineListener$lambda$11(n, this, wagerView, game2, arg_0));
    }

    private static final void setSpreadListener$lambda$5(WagerSet object, GamesAdapter object2, Team team, Game game2, View object3) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$wagerSet");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)team, (String)"$team");
        Intrinsics.checkNotNullParameter((Object)game2, (String)"$game");
        object3 = ((WagerSet)object).getSpreadValue();
        if (object3 != null) {
            int n = ((Number)object3).intValue();
            Object object4 = object2.openBet;
            if (object4 != null) {
                GamesAdapter gamesAdapter2 = object2;
                WagerSet wagerSet = object;
                object2 = team.getName();
                String string2 = "Spread " + OtherExtensionsKt.toSignedString(wagerSet.getSpread());
                Object object5 = gamesAdapter2.game;
                if (object5 == null || (object5 = ((Game)object5).getTitle()) == null) {
                    object5 = game2.getTitle();
                }
                Function1<OpenedBet, Unit> function1 = object4;
                float f = n;
                object4 = OpenedBet.Type.SPREAD;
                object = new OpenedBet((String)object2, string2, (String)object5, f, team, game2, 0.0, 0.0, (OpenedBet.Type)((Object)object4), null, 704, null);
                function1.invoke(object);
            }
        }
    }

    private static final void setTotalListener$lambda$7(WagerSet object, GamesAdapter object2, Team team, Game game2, View object3) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$wagerSet");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)team, (String)"$team");
        Intrinsics.checkNotNullParameter((Object)game2, (String)"$game");
        object3 = ((WagerSet)object).getTotalValue();
        if (object3 != null) {
            int n = ((Number)object3).intValue();
            Object object4 = object2.openBet;
            if (object4 != null) {
                GamesAdapter gamesAdapter2 = object2;
                WagerSet wagerSet = object;
                object2 = team.getName();
                String string2 = wagerSet.getFullTotalTitle();
                Object object5 = gamesAdapter2.game;
                if (object5 == null || (object5 = ((Game)object5).getTitle()) == null) {
                    object5 = game2.getTitle();
                }
                Function1<OpenedBet, Unit> function1 = object4;
                float f = n;
                object4 = OpenedBet.Type.TOTAL;
                object = new OpenedBet((String)object2, string2, (String)object5, f, team, game2, 0.0, 0.0, (OpenedBet.Type)((Object)object4), null, 704, null);
                function1.invoke(object);
            }
        }
    }

    private static final void setMoneyLineListener$lambda$9(WagerSet object, GamesAdapter object2, Team team, WagerView object3, Game game2, View object4) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$wagerSet");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)team, (String)"$team");
        Intrinsics.checkNotNullParameter((Object)object3, (String)"$this_setMoneyLineListener");
        Intrinsics.checkNotNullParameter((Object)game2, (String)"$game");
        object = ((WagerSet)object).getMoneyLine();
        if (object != null) {
            int n = ((Number)object).intValue();
            object4 = object2.openBet;
            if (object4 != null) {
                GamesAdapter gamesAdapter2 = object2;
                WagerView wagerView = object3;
                object3 = team.getName();
                String string2 = wagerView.getContext().getString(R.string.slr_odds_money_line);
                Object object5 = gamesAdapter2.game;
                if (object5 == null || (object5 = ((Game)object5).getTitle()) == null) {
                    object5 = game2.getTitle();
                }
                Function1<OpenedBet, Unit> function1 = object4;
                float f = n;
                object4 = OpenedBet.Type.MONEY_LINE;
                object2 = new OpenedBet((String)object3, string2, (String)object5, f, team, game2, 0.0, 0.0, (OpenedBet.Type)((Object)object4), null, 704, null);
                function1.invoke(object2);
            }
        }
    }

    private static final void setDrawMoneyLineListener$lambda$11(Integer n, GamesAdapter object, WagerView object2, Game game2, View function1) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"$this_setDrawMoneyLineListener");
        Intrinsics.checkNotNullParameter((Object)game2, (String)"$game");
        if (n != null) {
            ((Number)n).intValue();
            function1 = object.openBet;
            if (function1 != null) {
                GamesAdapter gamesAdapter2 = object;
                WagerView wagerView = object2;
                object2 = wagerView.getContext().getString(R.string.slr_odds_draw);
                String string2 = wagerView.getContext().getString(R.string.slr_odds_draw);
                Object object3 = gamesAdapter2.game;
                if (object3 == null || (object3 = ((Game)object3).getTitle()) == null) {
                    object3 = game2.getTitle();
                }
                Object object4 = object;
                float f = n.intValue();
                object = OpenedBet.Type.MONEY_LINE;
                ((OpenedBet)object4)((String)object2, string2, (String)object3, f, null, game2, 0.0, 0.0, (OpenedBet.Type)((Object)object), null, 704, null);
                function1.invoke(object4);
            }
        }
    }

    @NotNull
    public final List<OpenedBet> getOpenedBets() {
        return this.openedBets;
    }

    public final void setOpenedBets(@NotNull List<OpenedBet> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.openedBets = list2;
    }

    @Nullable
    public final Game getGame() {
        return this.game;
    }

    public final void setGame(@Nullable Game game2) {
        this.game = game2;
    }

    @NotNull
    public GameViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        GamesAdapter gamesAdapter2 = object;
        Object object = SlrItemOddsGameBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return gamesAdapter2.new GameViewHolder((SlrItemOddsGameBinding)object);
    }

    public void onBindViewHolder(@NotNull GameViewHolder gameViewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)gameViewHolder, (String)"holder");
        gameViewHolder.bind((Game)this.getItem(n));
    }

    public final void update(@NotNull List<Game> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"games");
        int n = 0;
        for (Object object : this.snapshot().getItems()) {
            Object var7_7;
            int n2;
            block8: {
                n2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (Game)object;
                for (Object t : list2) {
                    var7_7 = t;
                    if (!(((Game)t).getId() == ((Game)object).getId())) continue;
                    break block8;
                }
                var7_7 = null;
            }
            object = var7_7;
            if (object != null) {
                Object object2 = (Game)this.snapshot().get(n);
                if (object2 != null) {
                    ((Game)object2).setGameOdds(((Game)object).getGameOdds());
                }
                object2 = (Game)this.snapshot().get(n);
                if (object2 != null) {
                    ((Game)object2).setLive(((Game)object).isLive());
                }
                object2 = (Game)this.snapshot().get(n);
                if (object2 != null) {
                    ((Game)object2).setTeam1(((Game)object).getTeam1());
                }
                object2 = (Game)this.snapshot().get(n);
                if (object2 != null) {
                    ((Game)object2).setTeam2(((Game)object).getTeam2());
                }
                this.notifyItemChanged(n);
            }
            n = n2;
        }
    }

    public final void updateFirst(@NotNull Game game2) {
        Intrinsics.checkNotNullParameter((Object)game2, (String)"game");
        Game game3 = (Game)CollectionsKt.firstOrNull((List)this.snapshot().getItems());
        if (game3 != null) {
            game3.setLive(game2.isLive());
            this.notifyItemChanged(0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010 \u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010!\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/streamlayer/sdk/odds/adapters/GamesAdapter$GameViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lio/streamlayer/sdk/odds/adapters/SelectableBetViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemOddsGameBinding;", "(Lio/streamlayer/sdk/odds/adapters/GamesAdapter;Lio/streamlayer/sdk/databinding/SlrItemOddsGameBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemOddsGameBinding;", "lastGame", "Lio/streamlayer/sdk/model/odds/Game;", "bind", "", "game", "find", "Lio/streamlayer/sdk/odds/views/WagerView;", "openedBet", "Lio/streamlayer/sdk/odds/OpenedBet;", "getWager", "type", "Lio/streamlayer/sdk/odds/OpenedBet$Type;", "isMoneyLineFirst", "", "team", "Lio/streamlayer/sdk/model/odds/Team;", "select", "selected", "unselectAll", "removePointZero", "", "setupMoneyLine", "wagerSet", "Lio/streamlayer/sdk/model/odds/WagerSet;", "setupSpread", "setupTotal", "sdk_originalVonageRelease"})
    @SourceDebugExtension(value={"SMAP\nGamesAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GamesAdapter.kt\nio/streamlayer/sdk/odds/adapters/GamesAdapter$GameViewHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1855#2,2:282\n1855#2,2:285\n1#3:284\n*S KotlinDebug\n*F\n+ 1 GamesAdapter.kt\nio/streamlayer/sdk/odds/adapters/GamesAdapter$GameViewHolder\n*L\n108#1:282,2\n159#1:285,2\n*E\n"})
    public final class GameViewHolder
    extends RecyclerView.ViewHolder
    implements SelectableBetViewHolder {
        @NotNull
        private final SlrItemOddsGameBinding binding;
        @Nullable
        private Game lastGame;

        public GameViewHolder(SlrItemOddsGameBinding slrItemOddsGameBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemOddsGameBinding, (String)"binding");
            super((View)slrItemOddsGameBinding.getRoot());
            this.binding = slrItemOddsGameBinding;
        }

        private final boolean isMoneyLineFirst() {
            Game game2 = ((GameViewHolder)((Object)game2)).lastGame;
            return (game2 != null ? game2.getSport() : null) == OddsSport.SOCCER;
        }

        private final void setupSpread(WagerView wagerView, WagerSet wagerSet, Team team) {
            wagerView.setTitle(this.removePointZero(OtherExtensionsKt.toSignedString(wagerSet.getSpread())));
            Object object = wagerSet.getSpreadValue();
            object = object != null ? OtherExtensionsKt.toSignedString((Integer)object) : null;
            wagerView.setValue((String)object);
            boolean bl = wagerSet.getSpreadValue() == null;
            WagerView wagerView2 = wagerView;
            wagerView2.setNone(bl);
            wagerView2.setTitleColor("#FFFFFF");
            wagerView.setValueColor(GamesAdapter.this.textColor);
            wagerView.setNoneColor(GamesAdapter.this.textColor);
            wagerView.setPrimaryColor(GamesAdapter.this.primaryColor);
            Game game2 = this.lastGame;
            if (game2 != null) {
                GamesAdapter.this.setSpreadListener(wagerView, wagerSet, game2, team);
            }
        }

        private final void setupTotal(WagerView wagerView, WagerSet wagerSet, Team team) {
            wagerView.setTitle(this.removePointZero(wagerSet.getTotalTitle()));
            Object object = wagerSet.getTotalValue();
            object = object != null ? OtherExtensionsKt.toSignedString((Integer)object) : null;
            wagerView.setValue((String)object);
            boolean bl = wagerSet.getTotalValue() == null;
            WagerView wagerView2 = wagerView;
            wagerView2.setNone(bl);
            wagerView2.setTitleColor("#FFFFFF");
            wagerView.setValueColor(GamesAdapter.this.textColor);
            wagerView.setNoneColor(GamesAdapter.this.textColor);
            wagerView.setPrimaryColor(GamesAdapter.this.primaryColor);
            Game game2 = this.lastGame;
            if (game2 != null) {
                GamesAdapter.this.setTotalListener(wagerView, wagerSet, game2, team);
            }
        }

        private final void setupMoneyLine(WagerView wagerView, WagerSet wagerSet, Team team) {
            Object object = wagerSet.getMoneyLine();
            object = object != null ? OtherExtensionsKt.toSignedString((Integer)object) : null;
            WagerView wagerView2 = wagerView;
            wagerView2.setTitle((String)object);
            wagerView2.setValue(null);
            boolean bl = wagerSet.getMoneyLine() == null;
            wagerView.setNone(bl);
            wagerView.setTitleColor(GamesAdapter.this.textColor);
            wagerView.setNoneColor(GamesAdapter.this.textColor);
            wagerView.setPrimaryColor(GamesAdapter.this.primaryColor);
            Game game2 = this.lastGame;
            if (game2 != null) {
                GamesAdapter.this.setMoneyLineListener(wagerView, wagerSet, game2, team);
            }
        }

        private final String removePointZero(String string2) {
            if (StringsKt.endsWith$default((String)string2, (String)".0", (boolean)false, (int)2, null)) {
                string2 = StringsKt.replace$default((String)string2, (String)".0", (String)"", (boolean)false, (int)4, null);
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final WagerView getWager(OpenedBet.Type type2, boolean bl, Team team) {
            WagerView wagerView;
            Object object = this.lastGame;
            object = object != null ? ((Game)object).getTeam1() : null;
            if (Intrinsics.areEqual((Object)team, (Object)object)) {
                if (bl) {
                    int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n != 3) throw new NoWhenBranchMatchedException();
                            wagerView = this.binding.slWager11;
                        } else {
                            wagerView = this.binding.slWager13;
                        }
                    } else {
                        wagerView = this.binding.slWager12;
                    }
                } else {
                    int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n != 3) throw new NoWhenBranchMatchedException();
                            wagerView = this.binding.slWager13;
                        } else {
                            wagerView = this.binding.slWager12;
                        }
                    } else {
                        wagerView = this.binding.slWager11;
                    }
                }
            } else if (bl) {
                int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) throw new NoWhenBranchMatchedException();
                        wagerView = this.binding.slWager21;
                    } else {
                        wagerView = this.binding.slWager23;
                    }
                } else {
                    wagerView = this.binding.slWager22;
                }
            } else {
                int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) throw new NoWhenBranchMatchedException();
                        wagerView = this.binding.slWager23;
                    } else {
                        wagerView = this.binding.slWager22;
                    }
                } else {
                    wagerView = this.binding.slWager21;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)wagerView), (String)"if (team == lastGame?.te\u2026Wager23\n                }");
            return wagerView;
        }

        private final WagerView find(OpenedBet openedBet) {
            Object object = openedBet.getGame();
            object = object != null ? Integer.valueOf(((Game)object).getId()) : null;
            Object object2 = object3.lastGame;
            if (Intrinsics.areEqual((Object)object, (Object)(object2 = object2 != null ? Integer.valueOf(((Game)object2).getId()) : null))) {
                object = openedBet.getGame();
                object = object != null ? ((Game)object).getGameOdds() : null;
                object2 = object3.lastGame;
                if (Intrinsics.areEqual((Object)object, (Object)(object2 = object2 != null ? ((Game)object2).getGameOdds() : null))) {
                    WagerView wagerView;
                    if (Intrinsics.areEqual((Object)openedBet.getBetTitle(), (Object)object3.binding.getRoot().getContext().getString(R.string.slr_odds_draw))) {
                        return object3.binding.slWagerMoneyLineDraw;
                    }
                    object = openedBet.getTeam();
                    if (object != null) {
                        GameViewHolder gameViewHolder = object3;
                        Object object3 = openedBet.getType();
                        wagerView = gameViewHolder.getWager((OpenedBet.Type)((Object)object3), gameViewHolder.isMoneyLineFirst(), (Team)object);
                    } else {
                        wagerView = null;
                    }
                    return wagerView;
                }
            }
            return null;
        }

        private static final void bind$lambda$4$lambda$3$lambda$1(GamesAdapter gamesAdapter2, Game game2, View view2) {
            GamesAdapter gamesAdapter3 = gamesAdapter2;
            Intrinsics.checkNotNullParameter((Object)((Object)gamesAdapter3), (String)"this$0");
            gamesAdapter2 = gamesAdapter3.navigateToGame;
            if (gamesAdapter2 != null) {
                gamesAdapter2.invoke(game2);
            }
        }

        @NotNull
        public final SlrItemOddsGameBinding getBinding() {
            return this.binding;
        }

        public final void bind(@Nullable Game object) {
            Object object2;
            this.lastGame = object;
            if (object != null && (object2 = ((Game)object).getGameOdds()) != null) {
                GameViewHolder gameViewHolder = this;
                GamesAdapter gamesAdapter2 = gameViewHolder.GamesAdapter.this;
                SlrItemOddsGameBinding slrItemOddsGameBinding = gameViewHolder.binding;
                ConstraintLayout constraintLayout = slrItemOddsGameBinding.slTitleContainer;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slTitleContainer");
                boolean bl = ((Game)object).getTitle().length() > 0;
                SlrItemOddsGameBinding slrItemOddsGameBinding2 = slrItemOddsGameBinding;
                ViewExtensionsKt.visibleIf((View)constraintLayout, bl);
                slrItemOddsGameBinding2.slTitle.setText((CharSequence)((Game)object).getTitle());
                slrItemOddsGameBinding2.slTime.setText((CharSequence)((Game)object).getTime());
                TextView textView = slrItemOddsGameBinding2.slTime;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slTime");
                ViewExtensionsKt.visibleIf((View)textView, ((Game)object).isLive() ^ true);
                ImageView imageView2 = slrItemOddsGameBinding2.slTeamIcon1;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slTeamIcon1");
                ExtensionsKt.load(imageView2, ((Game)object).getTeam1().getIcon());
                slrItemOddsGameBinding2.slTeamName1.setText((CharSequence)((Game)object).getTeam1().getName());
                ImageView imageView3 = slrItemOddsGameBinding2.slTeamIcon2;
                Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"slTeamIcon2");
                ExtensionsKt.load(imageView3, ((Game)object).getTeam2().getIcon());
                slrItemOddsGameBinding2.slTeamName2.setText((CharSequence)((Game)object).getTeam2().getName());
                boolean bl2 = this.isMoneyLineFirst();
                Object object3 = OpenedBet.Type.MONEY_LINE;
                Object object4 = ((Game)object).getTeam1();
                object4 = this.getWager((OpenedBet.Type)((Object)object3), bl2, (Team)object4);
                Object object5 = object2.getWagerSet1();
                Object object6 = ((Game)object).getTeam1();
                this.setupMoneyLine((WagerView)((Object)object4), (WagerSet)object5, (Team)object6);
                object4 = OpenedBet.Type.SPREAD;
                object5 = ((Game)object).getTeam1();
                object5 = this.getWager((OpenedBet.Type)((Object)object4), bl2, (Team)object5);
                object6 = object2.getWagerSet1();
                Object object7 = ((Game)object).getTeam1();
                this.setupSpread((WagerView)((Object)object5), (WagerSet)object6, (Team)object7);
                object5 = OpenedBet.Type.TOTAL;
                object6 = ((Game)object).getTeam1();
                object6 = this.getWager((OpenedBet.Type)((Object)object5), bl2, (Team)object6);
                object7 = object2.getWagerSet1();
                Team team = ((Game)object).getTeam1();
                this.setupTotal((WagerView)((Object)object6), (WagerSet)object7, team);
                object6 = ((Game)object).getTeam2();
                object3 = this.getWager((OpenedBet.Type)((Object)object3), bl2, (Team)object6);
                object6 = object2.getWagerSet2();
                object7 = ((Game)object).getTeam2();
                this.setupMoneyLine((WagerView)((Object)object3), (WagerSet)object6, (Team)object7);
                object3 = ((Game)object).getTeam2();
                object3 = this.getWager((OpenedBet.Type)((Object)object4), bl2, (Team)object3);
                object4 = object2.getWagerSet2();
                object6 = ((Game)object).getTeam2();
                this.setupSpread((WagerView)((Object)object3), (WagerSet)object4, (Team)object6);
                object3 = ((Game)object).getTeam2();
                object3 = this.getWager((OpenedBet.Type)((Object)object5), bl2, (Team)object3);
                object4 = object2.getWagerSet2();
                object5 = ((Game)object).getTeam2();
                this.setupTotal((WagerView)((Object)object3), (WagerSet)object4, (Team)object5);
                if (bl2) {
                    SlrItemOddsGameBinding slrItemOddsGameBinding3 = slrItemOddsGameBinding;
                    slrItemOddsGameBinding3.slTitle1.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_money_line));
                    slrItemOddsGameBinding3.slTitle2.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_spread));
                    slrItemOddsGameBinding3.slTitle3.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_total));
                } else {
                    SlrItemOddsGameBinding slrItemOddsGameBinding4 = slrItemOddsGameBinding;
                    slrItemOddsGameBinding4.slTitle3.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_money_line));
                    slrItemOddsGameBinding4.slTitle1.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_spread));
                    slrItemOddsGameBinding4.slTitle2.setText((CharSequence)this.binding.getRoot().getContext().getString(R.string.slr_odds_total));
                }
                SlrItemOddsGameBinding slrItemOddsGameBinding5 = slrItemOddsGameBinding;
                View view2 = slrItemOddsGameBinding5.slDrawIcon;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"slDrawIcon");
                ViewExtensionsKt.visibleIf(view2, bl2);
                TextView textView2 = slrItemOddsGameBinding5.slDraw;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slDraw");
                ViewExtensionsKt.visibleIf((View)textView2, bl2);
                WagerView wagerView = slrItemOddsGameBinding5.slWagerMoneyLineDraw;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)wagerView), (String)"slWagerMoneyLineDraw");
                ViewExtensionsKt.visibleIf((View)wagerView, bl2);
                ImageView imageView4 = slrItemOddsGameBinding5.slArrow;
                Intrinsics.checkNotNullExpressionValue((Object)imageView4, (String)"slArrow");
                ViewExtensionsKt.visibleIf((View)imageView4, ((Game)object).getClickable());
                TextView textView3 = slrItemOddsGameBinding5.slLiveText;
                Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"slLiveText");
                ViewExtensionsKt.visibleIf((View)textView3, ((Game)object).isLive());
                View view3 = slrItemOddsGameBinding5.slLiveIcon;
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"slLiveIcon");
                ViewExtensionsKt.visibleIf(view3, ((Game)object).isLive());
                WagerView wagerView2 = slrItemOddsGameBinding5.slWagerMoneyLineDraw;
                object3 = object2.getDrawMoneyLine();
                object3 = object3 != null ? OtherExtensionsKt.toSignedString((Integer)object3) : null;
                GameOdds gameOdds = object2;
                SlrItemOddsGameBinding slrItemOddsGameBinding6 = slrItemOddsGameBinding;
                wagerView2.setTitle((String)object3);
                slrItemOddsGameBinding6.slWagerMoneyLineDraw.setValue(null);
                object2 = slrItemOddsGameBinding6.slWagerMoneyLineDraw;
                boolean bl3 = gameOdds.getDrawMoneyLine() == null;
                SlrItemOddsGameBinding slrItemOddsGameBinding7 = slrItemOddsGameBinding;
                ((WagerView)((Object)object2)).setNone(bl3);
                slrItemOddsGameBinding7.slWagerMoneyLineDraw.setTitleColor(gamesAdapter2.textColor);
                slrItemOddsGameBinding7.slWagerMoneyLineDraw.setNoneColor(gamesAdapter2.textColor);
                slrItemOddsGameBinding7.slWagerMoneyLineDraw.setPrimaryColor(gamesAdapter2.primaryColor);
                WagerView wagerView3 = slrItemOddsGameBinding7.slWagerMoneyLineDraw;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)wagerView3), (String)"slWagerMoneyLineDraw");
                gamesAdapter2.setDrawMoneyLineListener(wagerView3, ((Game)object).getGameOdds().getDrawMoneyLine(), (Game)object);
                if (((Game)object).getClickable()) {
                    slrItemOddsGameBinding.getRoot().setOnClickListener(arg_0 -> GameViewHolder.bind$lambda$4$lambda$3$lambda$1(gamesAdapter2, (Game)object, arg_0));
                }
                this.unselectAll();
                object = gamesAdapter2.getOpenedBets().iterator();
                while (object.hasNext()) {
                    object2 = this.find((OpenedBet)object.next());
                    if (object2 == null) continue;
                    ((WagerView)((Object)object2)).setWagerSelected(true);
                }
            }
        }

        @Override
        public void unselectAll() {
            Iterator iterator = ((GameViewHolder)((Object)iterator)).binding;
            WagerView[] wagerViewArray = new WagerView[7];
            WagerView[] wagerViewArray2 = wagerViewArray;
            wagerViewArray2[0] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager11;
            wagerViewArray2[1] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager12;
            wagerViewArray2[2] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager13;
            wagerViewArray2[3] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager21;
            wagerViewArray2[4] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager22;
            wagerViewArray2[5] = ((SlrItemOddsGameBinding)((Object)iterator)).slWager23;
            wagerViewArray[6] = ((SlrItemOddsGameBinding)((Object)iterator)).slWagerMoneyLineDraw;
            iterator = CollectionsKt.listOf((Object[])wagerViewArray).iterator();
            while (iterator.hasNext()) {
                ((WagerView)((Object)iterator.next())).setWagerSelected(false);
            }
        }

        @Override
        public void select(@NotNull OpenedBet openedBet, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)openedBet, (String)"openedBet");
            WagerView wagerView = ((GameViewHolder)((Object)wagerView)).find(openedBet);
            if (wagerView != null) {
                wagerView.setWagerSelected(bl);
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OpenedBet.Type.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[OpenedBet.Type.SPREAD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[OpenedBet.Type.TOTAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[OpenedBet.Type.MONEY_LINE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }
}

