/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrViewPercentageStatisticBinding;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ*\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u0010\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lio/streamlayer/common/views/SLRStatsPercentageView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/streamlayer/sdk/databinding/SlrViewPercentageStatisticBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrViewPercentageStatisticBinding;", "percentFormat", "Lkotlin/Function1;", "", "", "getPercentFormat", "()Lkotlin/jvm/functions/Function1;", "setPercentFormat", "(Lkotlin/jvm/functions/Function1;)V", "formatPercentage", "percentage", "setLeftPercentColor", "", "res", "setPercentage", "home", "away", "animate", "", "setProgress", "progressBar", "Landroid/widget/ProgressBar;", "value", "maxValue", "setRightPercentColor", "setTitle", "text", "sdk_originalVonageRelease"})
public final class SLRStatsPercentageView
extends ConstraintLayout {
    @NotNull
    private final SlrViewPercentageStatisticBinding binding;
    @Nullable
    private Function1<? super Double, String> percentFormat;

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context object, @Nullable AttributeSet attributeSet, int n) {
        Context context = object;
        SLRStatsPercentageView sLRStatsPercentageView = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Object object2 = SlrViewPercentageStatisticBinding.inflate(LayoutInflater.from((Context)object), (ViewGroup)object2, true);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inflate(LayoutInflater.from(context), this, true)");
        sLRStatsPercentageView.binding = object2;
        object = R.styleable.SLRStatsPercentageView;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.SLRStatsPercentageView, (String)"SLRStatsPercentageView");
        object = context.obtainStyledAttributes(attributeSet, (int[])object, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"obtainStyledAttributes(s\u2026efStyleAttr, defStyleRes)");
        ((SlrViewPercentageStatisticBinding)object2).slPercentageStatisticLabelTV.setText((CharSequence)object.getString(R.styleable.SLRStatsPercentageView_slrStatsPercentageLabel));
        object.recycle();
    }

    public /* synthetic */ SLRStatsPercentageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public static /* synthetic */ void setPercentage$default(SLRStatsPercentageView sLRStatsPercentageView, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setPercentage(d, d2, bl);
    }

    public static /* synthetic */ void setPercentage$default(SLRStatsPercentageView sLRStatsPercentageView, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setPercentage(n, n2, bl);
    }

    private final void setProgress(ProgressBar progressBar, int n, int n2, boolean bl) {
        ProgressBar progressBar2 = progressBar;
        progressBar2.setMax(n2 * 10);
        progressBar2.setProgress(0);
        int[] nArray = new int[2];
        Object object = nArray;
        object[0] = (SLRStatsPercentageView)false;
        nArray[1] = n * 10;
        object = ObjectAnimator.ofInt((Object)progressBar2, (String)"progress", (int[])object);
        long l = bl ? 2000L : 0L;
        Object object2 = object;
        object2.setDuration(l);
        object2.start();
    }

    static /* synthetic */ void setProgress$default(SLRStatsPercentageView sLRStatsPercentageView, ProgressBar progressBar, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        sLRStatsPercentageView.setProgress(progressBar, n, n2, bl);
    }

    private final String formatPercentage(double d) {
        Object object = String.format("%.3f", Arrays.copyOf(new Object[]{d}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
        int n = d < 1.0 ? 1 : 0;
        return StringsKt.drop((String)object, (int)n);
    }

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public SLRStatsPercentageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @NotNull
    public final SlrViewPercentageStatisticBinding getBinding() {
        return this.binding;
    }

    @Nullable
    public final Function1<Double, String> getPercentFormat() {
        return this.percentFormat;
    }

    public final void setPercentFormat(@Nullable Function1<? super Double, String> function1) {
        this.percentFormat = function1;
    }

    public final void setLeftPercentColor(@ColorRes int n) {
        ProgressBar progressBar = this.binding.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticLeftProgress");
        ViewExtensionsKt.setIndeterminateTintCompat(progressBar, ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public final void setLeftPercentColor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"res");
        ProgressBar progressBar = this.binding.slPercentageStatisticLeftProgress;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticLeftProgress");
            ViewExtensionsKt.setIndeterminateTintCompat(progressBar, Color.parseColor((String)string2));
        }
        catch (Exception exception) {
            SLRLog.INSTANCE.e("SLRStatsPercentageView", "Error parse color setLeftPercentColor " + string2, exception);
        }
    }

    public final void setRightPercentColor(@ColorRes int n) {
        ProgressBar progressBar = this.binding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticRightProgress");
        ViewExtensionsKt.setIndeterminateTintCompat(progressBar, ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public final void setRightPercentColor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"res");
        ProgressBar progressBar = this.binding.slPercentageStatisticRightProgress;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.slPercentageStatisticRightProgress");
            ViewExtensionsKt.setIndeterminateTintCompat(progressBar, Color.parseColor((String)string2));
        }
        catch (Exception exception) {
            SLRLog.INSTANCE.e("SLRStatsPercentageView", "Error parse color setRightPercentColor " + string2, exception);
        }
    }

    public final void setTitle(@Nullable String string2) {
        this.binding.slPercentageStatisticLabelTV.setText((CharSequence)string2);
    }

    public final void setPercentage(double d, double d2, boolean bl) {
        SLRStatsPercentageView sLRStatsPercentageView = this;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding = sLRStatsPercentageView.binding;
        TextView textView = slrViewPercentageStatisticBinding.slPercentageStatisticLeftTV;
        Object object = sLRStatsPercentageView.percentFormat;
        if (object == null || (object = (String)object.invoke((Object)d2)) == null) {
            object = this.formatPercentage(d2);
        }
        textView.setText(object);
        textView = slrViewPercentageStatisticBinding.slPercentageStatisticRightTV;
        object = this.percentFormat;
        if (object == null || (object = (String)object.invoke((Object)d)) == null) {
            object = this.formatPercentage(d);
        }
        textView.setText(object);
        double d3 = 100;
        int n = (int)((d2 + d) * d3);
        ProgressBar progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticLeftProgress");
        this.setProgress(progressBar, (int)(d2 * d3), n, bl);
        progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticRightProgress");
        this.setProgress(progressBar, (int)(d * d3), n, bl);
    }

    public final void setPercentage(int n, int n2, boolean bl) {
        SLRStatsPercentageView sLRStatsPercentageView = sLRStatsPercentageView3;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding = sLRStatsPercentageView.binding;
        SLRStatsPercentageView sLRStatsPercentageView2 = sLRStatsPercentageView3;
        SlrViewPercentageStatisticBinding slrViewPercentageStatisticBinding2 = slrViewPercentageStatisticBinding;
        slrViewPercentageStatisticBinding2.slPercentageStatisticLeftTV.setText((CharSequence)String.valueOf(n2));
        slrViewPercentageStatisticBinding2.slPercentageStatisticRightTV.setText((CharSequence)String.valueOf(n));
        SLRStatsPercentageView sLRStatsPercentageView3 = slrViewPercentageStatisticBinding2.slPercentageStatisticLeftProgress;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sLRStatsPercentageView3), (String)"slPercentageStatisticLeftProgress");
        int n3 = n2 + n;
        sLRStatsPercentageView2.setProgress((ProgressBar)sLRStatsPercentageView3, n2, n3, bl);
        ProgressBar progressBar = slrViewPercentageStatisticBinding.slPercentageStatisticRightProgress;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"slPercentageStatisticRightProgress");
        sLRStatsPercentageView.setProgress(progressBar, n, n3, bl);
    }
}

