/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.tooltips;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.animation.OvershootInterpolator;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ANIMATION_DURATION", "", "EXIT_ANIMATION_DURATION", "applyStyles", "Lio/streamlayer/common/views/tooltips/BubbleView;", "runEnterAnimation", "", "withEndAction", "Lkotlin/Function0;", "runExitAnimation", "animatorListener", "Landroid/animation/Animator$AnimatorListener;", "sdk_originalVonageRelease"})
public final class ViewTooltipHandlerKt {
    public static final long ANIMATION_DURATION = 1000L;
    public static final long EXIT_ANIMATION_DURATION = 400L;

    @NotNull
    public static final BubbleView applyStyles(@NotNull BubbleView bubbleView) {
        BubbleView bubbleView2 = bubbleView;
        Intrinsics.checkNotNullParameter((Object)((Object)bubbleView2), (String)"<this>");
        int n = bubbleView2.getContext().getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_content_margin);
        BubbleView bubbleView3 = bubbleView;
        int n2 = bubbleView3.getContext().getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_arrow_width);
        int n3 = bubbleView3.getContext().getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_corner_radius);
        bubbleView2.arrowHeight(bubbleView2.getContext().getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_arrow_height));
        bubbleView2.arrowWidth(n2);
        int n4 = n;
        bubbleView2.padding(n4, n4, n4, n4);
        bubbleView2.corner(n3);
        Context context = bubbleView2.getContext();
        Context context2 = bubbleView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        bubbleView2.color(ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrOverlayTooltipBackgroundColor, R.color.slr_primaryBlue)));
        return bubbleView2;
    }

    public static final void runEnterAnimation(@NotNull BubbleView bubbleView, @Nullable Function0<Unit> function0) {
        BubbleView bubbleView2 = bubbleView;
        Intrinsics.checkNotNullParameter((Object)((Object)bubbleView2), (String)"<this>");
        bubbleView2.setAlpha(0.0f);
        bubbleView2.setScaleX(0.0f);
        bubbleView2.setScaleY(0.0f);
        bubbleView2.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.2f)).setDuration(1000L).withEndAction(() -> ViewTooltipHandlerKt.runEnterAnimation$lambda$1(function0)).start();
    }

    public static /* synthetic */ void runEnterAnimation$default(BubbleView bubbleView, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        ViewTooltipHandlerKt.runEnterAnimation(bubbleView, (Function0<Unit>)function0);
    }

    public static final void runExitAnimation(@NotNull BubbleView bubbleView, @NotNull Animator.AnimatorListener animatorListener) {
        Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)animatorListener, (String)"animatorListener");
        bubbleView.animate().alpha(0.0f).setStartDelay(0L).setDuration(400L).setListener(animatorListener).start();
    }

    private static final void runEnterAnimation$lambda$1(Function0 function0) {
        if (function0 != null) {
            function0.invoke();
        }
    }
}

