/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.transition.ChangeBounds;
import androidx.transition.Transition;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.OtherUtilsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.SLRRoundedConstraintLayout;
import io.streamlayer.common.views.tools.AnimationTransitionUtilsKt;
import io.streamlayer.common.views.tools.DefaultTransitionListener;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.SLRTheme;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationChatBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCreateNewWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationJoinedToWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsBannerBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$hideAnimate$1$6$1$3$invoke$lambda$1$;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$showAnimate$1$1$1$1$6$invoke$lambda$1$;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.main.notifications.predictions.MastersKt;
import io.streamlayer.sdk.main.notifications.predictions.NativeKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.GamesSettings;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\f !\"#$%&'()*+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "resources", "Landroid/content/res/Resources;", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;Landroid/content/res/Resources;)V", "bottomMargin", "", "notificationViewsPool", "Ljava/util/LinkedList;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "overlayHeight", "getOverlayHeight", "()I", "setOverlayHeight", "(I)V", "overlayWidth", "getOverlayWidth", "setOverlayWidth", "startMargin", "touchListenerProvider", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$TouchListenerProvider;", "addToPool", "", "view", "clearPool", "parent", "Landroid/view/ViewGroup;", "getNotificationView", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "BaseNotificationView", "NotificationChatView", "NotificationCreateNewWatchPartyView", "NotificationCustomViewHolder", "NotificationFriendJoinToChatView", "NotificationJoinedToWatchPartyView", "NotificationPredictionsBannerView", "NotificationTouchListener", "NotificationTwitter", "NotificationView", "NotificationWatchPartyView", "TouchListenerProvider", "sdk_originalVonageRelease"})
public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final Resources resources;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private final int bottomMargin;
    private final int startMargin;
    private int overlayHeight;
    private int overlayWidth;
    @NotNull
    private final TouchListenerProvider touchListenerProvider;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2, @NotNull Resources resources) {
        NotificationViewsProvider notificationViewsProvider = this;
        NotificationViewsProvider notificationViewsProvider2 = this;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.listener = notificationViewAction2;
        notificationViewsProvider2.resources = resources;
        notificationViewsProvider2.notificationViewsPool = new LinkedList();
        this.bottomMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        notificationViewsProvider.startMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
        notificationViewsProvider.touchListenerProvider = new TouchListenerProvider();
    }

    public static final /* synthetic */ int access$getStartMargin$p(NotificationViewsProvider notificationViewsProvider) {
        return notificationViewsProvider.startMargin;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    public final int getOverlayWidth() {
        return this.overlayWidth;
    }

    public final void setOverlayWidth(int n) {
        this.overlayWidth = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification object2) {
        block13: {
            block15: {
                Object object3;
                block12: {
                    block14: {
                        Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
                        Intrinsics.checkNotNullParameter((Object)object2, (String)"notification");
                        object3 = LayoutInflater.from((Context)object.getContext());
                        switch (WhenMappings.$EnumSwitchMapping$1[((Notification)object2).getType().ordinal()]) {
                            default: {
                                if (!NotificationViewsKt.isLikePrediction(((Notification)object2).getType())) break block12;
                            }
                            case 8: {
                                NotificationCustomViewHolder notificationCustomViewHolder;
                                object2 = notificationCustomViewHolder;
                                object = SlrItemNotificationCustomBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                                notificationCustomViewHolder = (NotificationViewsProvider)this.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                                break block13;
                            }
                            case 7: {
                                NotificationTwitter notificationTwitter;
                                object2 = notificationTwitter;
                                object = SlrItemNotificationBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationTwitter = new NotificationTwitter((NotificationViewsProvider)this, (SlrItemNotificationBinding)object);
                                break block13;
                            }
                            case 6: {
                                NotificationPredictionsBannerView notificationPredictionsBannerView;
                                object2 = notificationPredictionsBannerView;
                                object = SlrPredictionsBannerBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationPredictionsBannerView = (NotificationViewsProvider)this.new NotificationPredictionsBannerView((SlrPredictionsBannerBinding)object);
                                break block13;
                            }
                            case 5: {
                                NotificationJoinedToWatchPartyView notificationJoinedToWatchPartyView;
                                object2 = notificationJoinedToWatchPartyView;
                                object = SlrItemNotificationJoinedToWatchPartyBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationJoinedToWatchPartyView = new NotificationJoinedToWatchPartyView((NotificationViewsProvider)this, (SlrItemNotificationJoinedToWatchPartyBinding)object);
                                break block13;
                            }
                            case 4: {
                                NotificationCreateNewWatchPartyView notificationCreateNewWatchPartyView;
                                object2 = notificationCreateNewWatchPartyView;
                                object = SlrItemNotificationCreateNewWatchPartyBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationCreateNewWatchPartyView = new NotificationCreateNewWatchPartyView((NotificationViewsProvider)this, (SlrItemNotificationCreateNewWatchPartyBinding)object);
                                break block13;
                            }
                            case 3: {
                                NotificationWatchPartyView notificationWatchPartyView;
                                object2 = notificationWatchPartyView;
                                object = SlrItemNotificationWatchPartyBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationWatchPartyView = new NotificationWatchPartyView((NotificationViewsProvider)this, (SlrItemNotificationWatchPartyBinding)object);
                                break block13;
                            }
                            case 2: {
                                NotificationChatView notificationChatView;
                                object2 = notificationChatView;
                                object = SlrItemNotificationChatBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                                notificationChatView = new NotificationChatView((NotificationViewsProvider)this, (SlrItemNotificationChatBinding)object);
                                break block13;
                            }
                            case 1: {
                                NotificationFriendJoinToChatView notificationFriendJoinToChatView;
                                object2 = notificationFriendJoinToChatView;
                                object = SlrItemNotificationBinding.inflate(object3, object, false);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                                notificationFriendJoinToChatView = (NotificationViewsProvider)this.new NotificationFriendJoinToChatView((SlrItemNotificationBinding)object);
                                break block13;
                            }
                            {
                                object3 = StreamLayer.INSTANCE.getTheme$sdk_originalVonageRelease().getNotificationsStyle();
                                if ((object3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object3.ordinal()]) != 1) break block14;
                            }
                        }
                        object2 = this = NativeKt.createPredictionsNotificationNative(((Notification)object2).getType(), object, ((NotificationViewsProvider)this).touchListenerProvider);
                        break block15;
                    }
                    object2 = this = MastersKt.createPredictionsNotificationMasters(((Notification)object2).getType(), object, ((NotificationViewsProvider)this).touchListenerProvider);
                    break block15;
                }
                if (((NotificationViewsProvider)this).notificationViewsPool.isEmpty()) {
                    NotificationView notificationView;
                    object2 = notificationView;
                    object = SlrItemNotificationBinding.inflate(object3, object, false);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                    notificationView = new NotificationView((NotificationViewsProvider)this, (SlrItemNotificationBinding)object);
                } else {
                    object2 = this = ((NotificationViewsProvider)this).notificationViewsPool.removeFirst();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                if (no\u2026          }\n            }");
        }
        return object2;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$TouchListenerProvider;", "", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "provide", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class TouchListenerProvider {
        @NotNull
        public final NotificationTouchListener provide(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            return new NotificationTouchListener(notification);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Landroid/view/View$OnTouchListener;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/Notification;)V", "dY", "", "getNotification", "()Lio/streamlayer/sdk/model/notifications/Notification;", "swipeThreshold", "y1", "y2", "onTouch", "", "view", "Landroid/view/View;", "motionEvent", "Landroid/view/MotionEvent;", "sdk_originalVonageRelease"})
    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        if (NotificationViewsKt.access$isClickable(this.notification)) {
                            NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                        }
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020\nH\u0016J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J \u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010&H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001b\u0010\u0016\u001a\u00020\u00178DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0016\u0010\u0018R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000eX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010\u0012\u00a8\u0006,"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "animationExpand", "", "getAnimationExpand", "()J", "animationShrink", "getAnimationShrink", "containerSize", "", "getContainerSize", "()I", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "isPortrait", "", "()Z", "isPortrait$delegate", "Lkotlin/Lazy;", "notificationView", "getNotificationView", "titleView", "getTitleView", "setTitleView", "getLandscapeWidth", "hideAnimate", "", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "onEnd", "Lkotlin/Function0;", "prepareView", "setConstraintParams", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "showAnimate", "sdk_originalVonageRelease"})
    public abstract class BaseNotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final Lazy isPortrait$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BaseNotificationView this$0;
            {
                this.this$0 = baseNotificationView;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Context context = this.this$0.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                return OtherExtensionsKt.isScreenPortrait(context);
            }
        });
        @Nullable
        private View iconView;
        @Nullable
        private final View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        private final int containerSize = ViewExtensionsKt.getDp(56.0f);
        private final long animationShrink;
        private final long animationExpand;

        public BaseNotificationView() {
            this.animationShrink = 300L;
            this.animationExpand = 400L;
        }

        private static final void prepareView$lambda$0(BaseNotificationView baseNotificationView) {
            BaseNotificationView baseNotificationView2 = baseNotificationView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationView2, (String)"this$0");
            View view2 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewExtensionsKt.invisible(view2);
        }

        private static final void showAnimate$lambda$2(ConstraintLayout constraintLayout, View view2, BaseNotificationView baseNotificationView, View view3, int n, Function0 function0) {
            Function1<ConstraintSet, Transition> function1;
            ConstraintLayout constraintLayout2 = constraintLayout;
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"$notificationView");
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view3, (String)"$iconView");
            ViewExtensionsKt.visible((View)constraintLayout2);
            Function1<ConstraintSet, Transition> function12 = function1;
            function1 = new Function1<ConstraintSet, Transition>(view2, baseNotificationView, constraintLayout, view3, n, (Function0<Unit>)function0){
                final /* synthetic */ View $notificationView;
                final /* synthetic */ BaseNotificationView this$0;
                final /* synthetic */ ConstraintLayout $root;
                final /* synthetic */ View $iconView;
                final /* synthetic */ int $widthNotification;
                final /* synthetic */ Function0<Unit> $onEnd;
                {
                    this.$notificationView = view2;
                    this.this$0 = baseNotificationView;
                    this.$root = constraintLayout;
                    this.$iconView = view3;
                    this.$widthNotification = n;
                    this.$onEnd = function0;
                    super(1);
                }

                @NotNull
                public final Transition invoke(@NotNull ConstraintSet constraintSet) {
                    ChangeBounds changeBounds;
                    Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"set");
                    constraintSet.constrainHeight(baseNotificationView.$notificationView.getId(), baseNotificationView.this$0.getContainerSize());
                    constraintSet.constrainWidth(baseNotificationView.$notificationView.getId(), baseNotificationView.this$0.getContainerSize());
                    constraintSet = changeBounds;
                    var v1 = baseNotificationView;
                    constraintSet();
                    var baseNotificationView = v1.this$0;
                    constraintSet = v1.$root;
                    View view2 = v1.$notificationView;
                    View view3 = v1.$iconView;
                    int n = v1.$widthNotification;
                    Function0<Unit> function0 = v1.$onEnd;
                    changeBounds.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                    changeBounds.setDuration(baseNotificationView.getAnimationShrink());
                    changeBounds.addListener((Transition.TransitionListener)new DefaultTransitionListener(baseNotificationView, (ConstraintLayout)constraintSet, view2, view3, n, function0){
                        final /* synthetic */ BaseNotificationView this$0;
                        final /* synthetic */ ConstraintLayout $root$inlined;
                        final /* synthetic */ View $notificationView$inlined;
                        final /* synthetic */ View $iconView$inlined;
                        final /* synthetic */ int $widthNotification$inlined;
                        final /* synthetic */ Function0 $onEnd$inlined;
                        {
                            this.this$0 = baseNotificationView;
                            this.$root$inlined = constraintLayout;
                            this.$notificationView$inlined = view2;
                            this.$iconView$inlined = view3;
                            this.$widthNotification$inlined = n;
                            this.$onEnd$inlined = function0;
                        }

                        public void onTransitionEnd(@NotNull Transition transition2) {
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
                            transition2 = this_.this$0.getTitleView();
                            if (transition2 != null) {
                                object = transition2.getLayoutParams();
                                if (object != null) {
                                    ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)object;
                                    layoutParams.endToEnd = 0;
                                    layoutParams.setMarginEnd(ViewExtensionsKt.getDp(8.0f));
                                    transition2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                                } else {
                                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                                }
                            }
                            if ((transition2 = this_.this$0.getDescriptionView()) != null) {
                                object = transition2.getLayoutParams();
                                if (object != null) {
                                    Transition transition3 = transition2;
                                    transition2 = (ConstraintLayout.LayoutParams)object;
                                    ((ConstraintLayout.LayoutParams)object).endToEnd = 0;
                                    transition3.setLayoutParams((ViewGroup.LayoutParams)transition2);
                                } else {
                                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                                }
                            }
                            if ((object = (transition2 = this_.$root$inlined).getLayoutParams()) != null) {
                                Transition transition4 = transition2;
                                transition2 = (ConstraintLayout.LayoutParams)object;
                                ((ConstraintLayout.LayoutParams)object).width = -2;
                                transition4.setLayoutParams((ViewGroup.LayoutParams)transition2);
                                transition2 = this_.$notificationView$inlined;
                                object = transition2.getLayoutParams();
                                if (object != null) {
                                    Transition transition5 = transition2;
                                    transition2 = (ConstraintLayout.LayoutParams)object;
                                    ((ConstraintLayout.LayoutParams)object).endToEnd = -1;
                                    transition5.setLayoutParams((ViewGroup.LayoutParams)transition2);
                                    transition2 = this_.$iconView$inlined;
                                    object = transition2.getLayoutParams();
                                    if (object != null) {
                                        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)object;
                                        layoutParams.endToEnd = -1;
                                        layoutParams.setMarginStart(ViewExtensionsKt.getDp(18.0f));
                                        transition2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                                        var v5 = this_;
                                        var this_ = v5.$notificationView$inlined;
                                        int n = v5.$widthNotification$inlined;
                                        object = v5.this$0;
                                        Function0 function0 = v5.$onEnd$inlined;
                                        AnimationTransitionUtilsKt.setAnimationTransition(this_.$root$inlined, (Function1<? super ConstraintSet, ? extends Transition>)new Function1<ConstraintSet, Transition>((View)this_, n, (BaseNotificationView)object, (Function0<Unit>)function0){
                                            final /* synthetic */ View $notificationView;
                                            final /* synthetic */ int $widthNotification;
                                            final /* synthetic */ BaseNotificationView this$0;
                                            final /* synthetic */ Function0<Unit> $onEnd;
                                            {
                                                this.$notificationView = view2;
                                                this.$widthNotification = n;
                                                this.this$0 = baseNotificationView;
                                                this.$onEnd = function0;
                                                super(1);
                                            }

                                            @NotNull
                                            public final Transition invoke(@NotNull ConstraintSet constraintSet) {
                                                Function0<Unit> function0;
                                                var v0 = baseNotificationView;
                                                Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"set");
                                                int n = v0.$notificationView.getId();
                                                constraintSet.constrainWidth(n, v0.$widthNotification);
                                                Function0<Unit> function02 = function0;
                                                var v2 = baseNotificationView;
                                                function02();
                                                BaseNotificationView baseNotificationView = v2.this$0;
                                                function02 = v2.$onEnd;
                                                function0.addListener((Transition.TransitionListener)new DefaultTransitionListener(function02){
                                                    final /* synthetic */ Function0 $onEnd$inlined;
                                                    {
                                                        this.$onEnd$inlined = function0;
                                                    }

                                                    public void onTransitionEnd(@NotNull Transition transition2) {
                                                        Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
                                                        BaseNotificationView$showAnimate$1$1$1$1$6$invoke$lambda$1$$inlined$doOnEnd$1 this_ = this_.$onEnd$inlined;
                                                        if (this_ != null) {
                                                            this_.invoke();
                                                        }
                                                    }

                                                    public void onTransitionStart(@NotNull Transition transition2) {
                                                        DefaultTransitionListener.DefaultImpls.onTransitionStart(this, transition2);
                                                    }

                                                    public void onTransitionCancel(@NotNull Transition transition2) {
                                                        DefaultTransitionListener.DefaultImpls.onTransitionCancel(this, transition2);
                                                    }

                                                    public void onTransitionPause(@NotNull Transition transition2) {
                                                        DefaultTransitionListener.DefaultImpls.onTransitionPause(this, transition2);
                                                    }

                                                    public void onTransitionResume(@NotNull Transition transition2) {
                                                        DefaultTransitionListener.DefaultImpls.onTransitionResume(this, transition2);
                                                    }
                                                });
                                                function0.setDuration(baseNotificationView.getAnimationExpand());
                                                function0.setStartDelay(100L);
                                                return function0;
                                            }
                                        });
                                        return;
                                    }
                                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                                }
                                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                            }
                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                        }

                        public void onTransitionStart(@NotNull Transition transition2) {
                            DefaultTransitionListener.DefaultImpls.onTransitionStart(this, transition2);
                        }

                        public void onTransitionCancel(@NotNull Transition transition2) {
                            DefaultTransitionListener.DefaultImpls.onTransitionCancel(this, transition2);
                        }

                        public void onTransitionPause(@NotNull Transition transition2) {
                            DefaultTransitionListener.DefaultImpls.onTransitionPause(this, transition2);
                        }

                        public void onTransitionResume(@NotNull Transition transition2) {
                            DefaultTransitionListener.DefaultImpls.onTransitionResume(this, transition2);
                        }
                    });
                    return changeBounds;
                }
            };
            AnimationTransitionUtilsKt.setAnimationTransition(constraintLayout2, (Function1<? super ConstraintSet, ? extends Transition>)function12);
        }

        private static final void showAnimate$lambda$8$lambda$4(View view2, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"$view");
            Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"it");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                Object object = valueAnimator.getAnimatedValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                layoutParams.width = (Integer)object;
                view2.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        protected final boolean isPortrait() {
            return (Boolean)this.isPortrait$delegate.getValue();
        }

        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        public final int getContainerSize() {
            return this.containerSize;
        }

        public final long getAnimationShrink() {
            return this.animationShrink;
        }

        public final long getAnimationExpand() {
            return this.animationExpand;
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> BaseNotificationView.prepareView$lambda$0(this));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), (float)ViewExtensionsKt.getDp(3.0f));
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n, NotificationViewsProvider.this.bottomMargin);
        }

        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
        }

        @Override
        public void hideAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            if (this.getIconView() != null && this.getNotificationView() != null) {
                View view2 = this.getBinding().getRoot();
                Intrinsics.checkNotNull((Object)view2, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
                constraintLayout = (ConstraintLayout)view2;
                View view3 = this.getNotificationView();
                Intrinsics.checkNotNull((Object)view3);
                AnimationTransitionUtilsKt.setAnimationTransition(constraintLayout, (Function1<? super ConstraintSet, ? extends Transition>)new Function1<ConstraintSet, Transition>(this, constraintLayout, view3, function0){
                    final /* synthetic */ BaseNotificationView this$0;
                    final /* synthetic */ ConstraintLayout $root;
                    final /* synthetic */ View $notificationView;
                    final /* synthetic */ Function0<Unit> $onEnd;
                    {
                        this.this$0 = baseNotificationView;
                        this.$root = constraintLayout;
                        this.$notificationView = view2;
                        this.$onEnd = function0;
                        super(1);
                    }

                    @NotNull
                    public final Transition invoke(@NotNull ConstraintSet constraintSet) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"set");
                        View view2 = baseNotificationView.this$0.getTitleView();
                        if (view2 != null) {
                            object = view2.getLayoutParams();
                            if (object != null) {
                                View view3 = view2;
                                view2 = (ConstraintLayout.LayoutParams)object;
                                ((ConstraintLayout.LayoutParams)object).endToEnd = -1;
                                view3.setLayoutParams((ViewGroup.LayoutParams)view2);
                            } else {
                                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                            }
                        }
                        if ((view2 = baseNotificationView.this$0.getDescriptionView()) != null) {
                            object = view2.getLayoutParams();
                            if (object != null) {
                                View view4 = view2;
                                view2 = (ConstraintLayout.LayoutParams)object;
                                ((ConstraintLayout.LayoutParams)object).endToEnd = -1;
                                view4.setLayoutParams((ViewGroup.LayoutParams)view2);
                            } else {
                                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                            }
                        }
                        if ((object = (view2 = baseNotificationView.$root).getLayoutParams()) != null) {
                            ((ConstraintLayout.LayoutParams)object).startToStart = -1;
                            view2.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)object));
                            view2 = baseNotificationView.this$0.getIconView();
                            Intrinsics.checkNotNull((Object)view2);
                            object = view2.getLayoutParams();
                            if (object != null) {
                                ChangeBounds changeBounds;
                                var v2 = baseNotificationView;
                                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)object;
                                layoutParams.setMarginStart(0);
                                layoutParams.setMarginEnd(0);
                                layoutParams.endToEnd = 0;
                                layoutParams.startToStart = 0;
                                view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                                view2 = v2.$notificationView;
                                object = v2.this$0;
                                NotificationsLayoutKt.setStartSide$default(constraintSet, view2.getId(), 0, 2, null);
                                NotificationsLayoutKt.setEndSide$default(constraintSet, view2.getId(), 0, 2, null);
                                int n = view2.getId();
                                constraintSet.constrainWidth(n, ((BaseNotificationView)object).getContainerSize());
                                n = view2.getId();
                                constraintSet.constrainHeight(n, ((BaseNotificationView)object).getContainerSize());
                                ChangeBounds changeBounds2 = changeBounds;
                                var v5 = baseNotificationView;
                                changeBounds2();
                                var baseNotificationView = v5.this$0;
                                changeBounds2 = v5.$root;
                                view2 = v5.$notificationView;
                                object = v5.$onEnd;
                                changeBounds.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                                changeBounds.setDuration(baseNotificationView.getAnimationExpand());
                                changeBounds.addListener((Transition.TransitionListener)new DefaultTransitionListener((ConstraintLayout)changeBounds2, view2, baseNotificationView, (Function0)object){
                                    final /* synthetic */ ConstraintLayout $root$inlined;
                                    final /* synthetic */ View $notificationView$inlined;
                                    final /* synthetic */ BaseNotificationView this$0;
                                    final /* synthetic */ Function0 $onEnd$inlined;
                                    {
                                        this.$root$inlined = constraintLayout;
                                        this.$notificationView$inlined = view2;
                                        this.this$0 = baseNotificationView;
                                        this.$onEnd$inlined = function0;
                                    }

                                    public void onTransitionEnd(@NotNull Transition object) {
                                        Intrinsics.checkNotNullParameter((Object)object, (String)"transition");
                                        object = this_.$root$inlined;
                                        ViewGroup.LayoutParams layoutParams = object.getLayoutParams();
                                        if (layoutParams != null) {
                                            ((ConstraintLayout.LayoutParams)layoutParams).width = this_.this$0.getContainerSize();
                                            ((ConstraintLayout.LayoutParams)layoutParams).height = this_.this$0.getContainerSize();
                                            object.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams));
                                            object = this_.$notificationView$inlined;
                                            layoutParams = object.getLayoutParams();
                                            if (layoutParams != null) {
                                                ((ConstraintLayout.LayoutParams)layoutParams).endToEnd = 0;
                                                object.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams));
                                                var v0 = this_;
                                                var this_ = v0.$notificationView$inlined;
                                                object = v0.this$0;
                                                layoutParams = v0.$root$inlined;
                                                Function0 function0 = v0.$onEnd$inlined;
                                                AnimationTransitionUtilsKt.setAnimationTransition(this_.$root$inlined, (Function1<? super ConstraintSet, ? extends Transition>)new Function1<ConstraintSet, Transition>((View)this_, (BaseNotificationView)object, (ConstraintLayout)layoutParams, (Function0<Unit>)function0){
                                                    final /* synthetic */ View $notificationView;
                                                    final /* synthetic */ BaseNotificationView this$0;
                                                    final /* synthetic */ ConstraintLayout $root;
                                                    final /* synthetic */ Function0<Unit> $onEnd;
                                                    {
                                                        this.$notificationView = view2;
                                                        this.this$0 = baseNotificationView;
                                                        this.$root = constraintLayout;
                                                        this.$onEnd = function0;
                                                        super(1);
                                                    }

                                                    @NotNull
                                                    public final Transition invoke(@NotNull ConstraintSet constraintSet) {
                                                        ChangeBounds changeBounds;
                                                        Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"set");
                                                        constraintSet.constrainHeight(baseNotificationView.$notificationView.getId(), 1);
                                                        constraintSet.constrainWidth(baseNotificationView.$notificationView.getId(), 1);
                                                        constraintSet = changeBounds;
                                                        var v1 = baseNotificationView;
                                                        constraintSet();
                                                        var baseNotificationView = v1.this$0;
                                                        constraintSet = v1.$root;
                                                        Function0<Unit> function0 = v1.$onEnd;
                                                        changeBounds.setDuration(baseNotificationView.getAnimationShrink());
                                                        changeBounds.addListener((Transition.TransitionListener)new DefaultTransitionListener((ConstraintLayout)constraintSet, function0){
                                                            final /* synthetic */ ConstraintLayout $root$inlined;
                                                            final /* synthetic */ Function0 $onEnd$inlined;
                                                            {
                                                                this.$root$inlined = constraintLayout;
                                                                this.$onEnd$inlined = function0;
                                                            }

                                                            public void onTransitionEnd(@NotNull Transition transition2) {
                                                                BaseNotificationView$hideAnimate$1$6$1$3$invoke$lambda$1$$inlined$doOnEnd$1 v0 = this_;
                                                                Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
                                                                ViewExtensionsKt.invisible((View)v0.$root$inlined);
                                                                BaseNotificationView$hideAnimate$1$6$1$3$invoke$lambda$1$$inlined$doOnEnd$1 this_ = v0.$onEnd$inlined;
                                                                if (this_ != null) {
                                                                    this_.invoke();
                                                                }
                                                            }

                                                            public void onTransitionStart(@NotNull Transition transition2) {
                                                                DefaultTransitionListener.DefaultImpls.onTransitionStart(this, transition2);
                                                            }

                                                            public void onTransitionCancel(@NotNull Transition transition2) {
                                                                DefaultTransitionListener.DefaultImpls.onTransitionCancel(this, transition2);
                                                            }

                                                            public void onTransitionPause(@NotNull Transition transition2) {
                                                                DefaultTransitionListener.DefaultImpls.onTransitionPause(this, transition2);
                                                            }

                                                            public void onTransitionResume(@NotNull Transition transition2) {
                                                                DefaultTransitionListener.DefaultImpls.onTransitionResume(this, transition2);
                                                            }
                                                        });
                                                        return changeBounds;
                                                    }
                                                });
                                                return;
                                            }
                                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                                        }
                                        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                                    }

                                    public void onTransitionStart(@NotNull Transition transition2) {
                                        DefaultTransitionListener.DefaultImpls.onTransitionStart(this, transition2);
                                    }

                                    public void onTransitionCancel(@NotNull Transition transition2) {
                                        DefaultTransitionListener.DefaultImpls.onTransitionCancel(this, transition2);
                                    }

                                    public void onTransitionPause(@NotNull Transition transition2) {
                                        DefaultTransitionListener.DefaultImpls.onTransitionPause(this, transition2);
                                    }

                                    public void onTransitionResume(@NotNull Transition transition2) {
                                        DefaultTransitionListener.DefaultImpls.onTransitionResume(this, transition2);
                                    }
                                });
                                return changeBounds;
                            }
                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                        }
                        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                    }
                });
            } else {
                NotificationsLayout.BaseNotificationView.DefaultImpls.hideAnimate(this, constraintLayout, function0);
            }
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            int n = ((BaseNotificationView)((Object)notificationViewsProvider)).isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : ((BaseNotificationView)((Object)notificationViewsProvider)).getLandscapeWidth();
            if (((BaseNotificationView)((Object)notificationViewsProvider)).getIconView() != null && ((BaseNotificationView)((Object)notificationViewsProvider)).getNotificationView() != null) {
                View view2 = notificationViewsProvider.getBinding().getRoot();
                Intrinsics.checkNotNull((Object)view2, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
                ConstraintLayout constraintLayout2 = (ConstraintLayout)view2;
                BaseNotificationView baseNotificationView = notificationViewsProvider;
                View view3 = baseNotificationView.getIconView();
                Intrinsics.checkNotNull((Object)view3);
                View view4 = baseNotificationView.getNotificationView();
                Intrinsics.checkNotNull((Object)view4);
                constraintLayout2.post(() -> BaseNotificationView.showAnimate$lambda$2(constraintLayout2, view4, (BaseNotificationView)((Object)notificationViewsProvider), view3, n, function0));
            } else {
                View view5 = notificationViewsProvider.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"binding.root");
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
                NotificationViewsProvider notificationViewsProvider = ((BaseNotificationView)((Object)notificationViewsProvider)).NotificationViewsProvider.this;
                valueAnimator.setDuration(400L);
                valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                valueAnimator.addUpdateListener(arg_0 -> BaseNotificationView.showAnimate$lambda$8$lambda$4(view5, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"showAnimate$lambda$8");
                valueAnimator.addListener(new Animator.AnimatorListener(view5){
                    final /* synthetic */ View $view$inlined;
                    {
                        this.$view$inlined = view2;
                    }

                    public void onAnimationRepeat(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }

                    public void onAnimationEnd(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }

                    public void onAnimationCancel(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        var v0 = this;
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                        ViewExtensionsKt.visible(v0.$view$inlined);
                        v0.$view$inlined.animate().alpha(1.0f).translationX(-20.0f).setStartDelay(200L).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(this.$view$inlined){
                            final /* synthetic */ View $view;
                            {
                                this.$view = view2;
                            }

                            public final void run() {
                                this.$view.animate().translationX(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                            }
                        }).start();
                    }
                });
                valueAnimator.addListener(new Animator.AnimatorListener(view5, function0, notificationViewsProvider){
                    final /* synthetic */ View $view$inlined;
                    final /* synthetic */ Function0 $onEnd$inlined;
                    final /* synthetic */ NotificationViewsProvider this$0;
                    {
                        this.$view$inlined = view2;
                        this.$onEnd$inlined = function0;
                        this.this$0 = notificationViewsProvider;
                    }

                    public void onAnimationRepeat(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }

                    public void onAnimationEnd(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                        animator = this.$view$inlined;
                        ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                        if (layoutParams != null) {
                            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                            int n = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                            int n2 = marginLayoutParams.topMargin;
                            int n3 = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                            int n4 = marginLayoutParams.bottomMargin;
                            marginLayoutParams.setMargins(n, n2, n3, n4);
                            animator.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                            Function0 function0 = this.$onEnd$inlined;
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    }

                    public void onAnimationCancel(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    }
                });
                valueAnimator.start();
            }
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationChatBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationChatView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationChatBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationChatView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationChatBinding slrItemNotificationChatBinding) {
            NotificationChatView notificationChatView = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationChatBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationChatView.binding = slrItemNotificationChatBinding;
            notificationChatView.iconView = notificationChatView.getBinding().slNotifIconIV;
            notificationChatView.notificationView = notificationChatView.getBinding().slNotification;
            notificationChatView.titleView = notificationChatView.getBinding().slNotifTitleTV;
            notificationChatView.descriptionView = notificationChatView.getBinding().slNotifDescriptionTV;
        }

        @Override
        @NotNull
        public SlrItemNotificationChatBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationChatView notificationChatView = slrItemNotificationChatBinding;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationChatBinding slrItemNotificationChatBinding = notificationChatView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationChatView.this$0;
            SlrItemNotificationChatBinding slrItemNotificationChatBinding2 = slrItemNotificationChatBinding;
            slrItemNotificationChatBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationChatBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            notificationChatView.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationWatchPartyView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationWatchPartyView.binding = slrItemNotificationWatchPartyBinding;
            notificationWatchPartyView.iconView = notificationWatchPartyView.getBinding().slNotifIconIV;
            notificationWatchPartyView.notificationView = notificationWatchPartyView.getBinding().slNotification;
            notificationWatchPartyView.titleView = notificationWatchPartyView.getBinding().slNotifTitleTV;
            notificationWatchPartyView.descriptionView = notificationWatchPartyView.getBinding().slNotifDescriptionTV;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            SpannableString spannableString;
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.this$0;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            CharSequence[] charSequenceArray = new CharSequence[2];
            charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)(notification.getTitle() + " ")));
            Object object = spannableString;
            spannableString = new SpannableString((CharSequence)slrItemNotificationWatchPartyBinding.getRoot().getContext().getString(R.string.slr_invited_you_to_a_watch_party));
            charSequenceArray[1] = object;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText(TextUtils.concat((CharSequence[])charSequenceArray));
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            try {
                AppCompatTextView appCompatTextView = slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV;
                Context context = slrItemNotificationWatchPartyBinding.getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"root.context");
                appCompatTextView.setTextColor(ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_twitter));
            }
            catch (Exception exception) {
                SLRLog.INSTANCE.d("NotificationsLayout", "WP text error");
            }
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                object = notification.getNotificationIcon();
                object = object != null ? ((NotificationIcon)object).getAvatarUrl() : null;
                Object object2 = notification.getNotificationIcon();
                object2 = object2 != null ? ((NotificationIcon)object2).getAvatarName() : null;
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, null, 2.28f, null, 44, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.dispose((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[NotificationType.WatchParty.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTwitter;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationTwitter
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationTwitter(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationBinding slrItemNotificationBinding) {
            NotificationTwitter notificationTwitter = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationTwitter.binding = slrItemNotificationBinding;
            notificationTwitter.iconView = notificationTwitter.getBinding().slNotifIconIV;
            notificationTwitter.notificationView = notificationTwitter.getBinding().slNotification;
            notificationTwitter.titleView = notificationTwitter.getBinding().slNotifTitleTV;
            notificationTwitter.descriptionView = notificationTwitter.getBinding().slNotifDescriptionTV;
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            StyleSpan styleSpan;
            SpannableStringBuilder spannableStringBuilder;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = ((NotificationTwitter)((Object)notificationViewsProvider)).getBinding();
            NotificationViewsProvider notificationViewsProvider = ((NotificationTwitter)((Object)notificationViewsProvider)).this$0;
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
            appCompatImageView.setImageResource(R.drawable.slr_ic_twitter);
            Context context = appCompatImageView.getContext();
            Context context2 = appCompatImageView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            ImageViewCompat.setImageTintList((ImageView)appCompatImageView, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrNotificationIconColor, R.color.slr_blue))));
            AppCompatImageView appCompatImageView2 = appCompatImageView = spannableStringBuilder;
            AppCompatImageView appCompatImageView3 = appCompatImageView;
            appCompatImageView3();
            appCompatImageView = styleSpan;
            styleSpan = new StyleSpan(1);
            int n = appCompatImageView3.length();
            appCompatImageView2.append((CharSequence)("@" + notification.getTitle()));
            int n2 = appCompatImageView2.length();
            appCompatImageView2.setSpan((Object)appCompatImageView, n, n2, 17);
            appCompatImageView = spannableStringBuilder.append((CharSequence)(" " + notification.getDescription()));
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifTitleTV;
            appCompatTextView2.setMaxLines(2);
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"bind$lambda$4$lambda$3");
            ViewGroup.LayoutParams layoutParams = appCompatTextView2.getLayoutParams();
            if (layoutParams != null) {
                AppCompatTextView appCompatTextView3 = appCompatTextView2;
                ((ConstraintLayout.LayoutParams)layoutParams).topToTop = 0;
                ((ConstraintLayout.LayoutParams)layoutParams).topMargin = 0;
                ((ConstraintLayout.LayoutParams)layoutParams).bottomMargin = 0;
                ((ConstraintLayout.LayoutParams)layoutParams).bottomToBottom = 0;
                ((ConstraintLayout.LayoutParams)layoutParams).bottomToTop = -1;
                appCompatTextView2.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams));
                appCompatTextView3.setText((CharSequence)appCompatImageView);
                appCompatTextView3.setTypeface(null, 0);
                slrItemNotificationBinding.getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0003J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0005J\u0014\u0010!\u001a\u00020\u0018*\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\""}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "clear", "getColor", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getIcon", "setPadding", "sdk_originalVonageRelease"})
    public class NotificationView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationBinding slrItemNotificationBinding) {
            NotificationView notificationView = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationView.binding = slrItemNotificationBinding;
            notificationView.iconView = notificationView.getBinding().slNotifIconIV;
            notificationView.notificationView = notificationView.getBinding().slNotification;
            notificationView.titleView = notificationView.getBinding().slNotifTitleTV;
            notificationView.descriptionView = notificationView.getBinding().slNotifDescriptionTV;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 15: 
                case 16: {
                    n = 0;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n = 17170445;
                    break;
                }
                case 5: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: 
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 2: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 1: {
                    Context context = this.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    n = ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_primaryBlue);
                }
            }
            return n;
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = this.this$0;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = notification.getDescription();
            boolean bl2 = object == null || object.length() == 0;
            bl2 ^= true;
            Object object2 = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifTitleTV");
            ViewGroup.LayoutParams layoutParams = object2.getLayoutParams();
            if (layoutParams != null) {
                layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                int n = bl2 ? 0 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.topToTop = n;
                n = bl2 ? ViewExtensionsKt.getDp(4.0f) : 0;
                layoutParams.topMargin = n;
                n = bl2 ? -1 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.bottomToBottom = n;
                object2.setLayoutParams(layoutParams);
                AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifDescriptionTV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifDescriptionTV");
                ViewExtensionsKt.visibleIf((View)appCompatTextView, bl2);
                Object object3 = notification.getNotificationIcon();
                if (object3 != null) {
                    if (((NotificationIcon)object3).getAvatarName() != null) {
                        object2 = slrItemNotificationBinding.slNotifIconIV;
                        NotificationIcon notificationIcon = object3;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = notificationIcon.getAvatarUrl();
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object2, (String)object3, notificationIcon.getAvatarName(), null, null, 0.0f, null, 60, null);
                    } else if (((NotificationIcon)object3).getAvatarUrl() != null) {
                        Function1<Boolean, Unit> function1;
                        AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                        object2 = appCompatImageView;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = ((NotificationIcon)object3).getAvatarUrl();
                        Intrinsics.checkNotNull((Object)object3);
                        object2 = this.getIcon(notification.getType());
                        Object object4 = object3;
                        object3 = function1;
                        function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                            final /* synthetic */ NotificationView this$0;
                            final /* synthetic */ SlrItemNotificationBinding $this_with;
                            final /* synthetic */ Notification $data;
                            {
                                this.this$0 = notificationView;
                                this.$this_with = slrItemNotificationBinding;
                                this.$data = notification;
                                super(1);
                            }

                            public final void invoke(boolean bl) {
                                if (!bl) {
                                    AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                    this.this$0.setPadding((View)appCompatImageView, this.$data.getType());
                                }
                            }
                        };
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object4, false, (Integer)object2, (Function1)object3, 2, null);
                    }
                    slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                } else {
                    SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"bind$lambda$4$lambda$3$lambda$2");
                    CoilExtensionsKt.dispose((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(@NotNull ImageView imageView2) {
                            Intrinsics.checkNotNullParameter((Object)imageView2, (String)"$this$dispose");
                            imageView2.setImageResource(this.this$0.getIcon(this.$data.getType()));
                        }
                    });
                    this.setPadding((View)slrItemNotificationBinding, notification.getType());
                    slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                  \u2026      }\n                }");
                }
                this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        protected final void setPadding(@NotNull View view2, @NotNull NotificationType notificationType) {
            int n;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        protected final int getIcon(@NotNull NotificationType notificationType) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 5: 
                case 6: 
                case 14: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    n = 0;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_friends_arriving;
                    break;
                }
                case 2: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[NotificationType.Chat.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Twitter.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.JoinToChat.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.WaveReply.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.CreateNewWatchParty.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.JoinedToWatchParty.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Poll.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Trivia.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Prediction.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.PredictionResult.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.PredictionOnboarding.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Factoid.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.FactoidTweet.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.WatchParty.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Unset.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[NotificationType.Custom.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCreateNewWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCreateNewWatchPartyBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationCreateNewWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCreateNewWatchPartyBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationCreateNewWatchPartyView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationCreateNewWatchPartyBinding slrItemNotificationCreateNewWatchPartyBinding) {
            NotificationCreateNewWatchPartyView notificationCreateNewWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCreateNewWatchPartyBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationCreateNewWatchPartyView.binding = slrItemNotificationCreateNewWatchPartyBinding;
            notificationCreateNewWatchPartyView.iconView = notificationCreateNewWatchPartyView.getBinding().slNotifIconIV;
            notificationCreateNewWatchPartyView.notificationView = notificationCreateNewWatchPartyView.getBinding().slNotification;
            notificationCreateNewWatchPartyView.titleView = notificationCreateNewWatchPartyView.getBinding().slNotifTitleTV;
            notificationCreateNewWatchPartyView.descriptionView = notificationCreateNewWatchPartyView.getBinding().slNotifDescriptionTV;
        }

        @Override
        @NotNull
        public SlrItemNotificationCreateNewWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)this.this$0.new NotificationTouchListener(notification));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\tX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationJoinedToWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationJoinedToWatchPartyBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationJoinedToWatchPartyBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationJoinedToWatchPartyBinding;", "descriptionView", "Landroid/view/View;", "getDescriptionView", "()Landroid/view/View;", "setDescriptionView", "(Landroid/view/View;)V", "iconView", "getIconView", "setIconView", "notificationView", "getNotificationView", "setNotificationView", "titleView", "getTitleView", "setTitleView", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationJoinedToWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationJoinedToWatchPartyBinding binding;
        @Nullable
        private View iconView;
        @Nullable
        private View notificationView;
        @Nullable
        private View titleView;
        @Nullable
        private View descriptionView;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationJoinedToWatchPartyView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationJoinedToWatchPartyBinding slrItemNotificationJoinedToWatchPartyBinding) {
            NotificationJoinedToWatchPartyView notificationJoinedToWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationJoinedToWatchPartyBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            notificationJoinedToWatchPartyView.binding = slrItemNotificationJoinedToWatchPartyBinding;
            notificationJoinedToWatchPartyView.iconView = notificationJoinedToWatchPartyView.getBinding().slNotifIconIV;
            notificationJoinedToWatchPartyView.notificationView = notificationJoinedToWatchPartyView.getBinding().slNotification;
            notificationJoinedToWatchPartyView.titleView = notificationJoinedToWatchPartyView.getBinding().slNotifTitleTV;
        }

        @Override
        @NotNull
        public SlrItemNotificationJoinedToWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        @Nullable
        protected View getIconView() {
            return this.iconView;
        }

        @Override
        protected void setIconView(@Nullable View view2) {
            this.iconView = view2;
        }

        @Override
        @Nullable
        public View getNotificationView() {
            return this.notificationView;
        }

        public void setNotificationView(@Nullable View view2) {
            this.notificationView = view2;
        }

        @Override
        @Nullable
        protected View getTitleView() {
            return this.titleView;
        }

        @Override
        protected void setTitleView(@Nullable View view2) {
            this.titleView = view2;
        }

        @Override
        @Nullable
        protected View getDescriptionView() {
            return this.descriptionView;
        }

        @Override
        protected void setDescriptionView(@Nullable View view2) {
            this.descriptionView = view2;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)this.this$0.new NotificationTouchListener(notification));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFriendJoinToChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "bind", "", "item", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationFriendJoinToChatView
    extends NotificationView {
        public NotificationFriendJoinToChatView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(NotificationViewsProvider.this, slrItemNotificationBinding);
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = notificationViewsProvider;
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"item");
            super.bind(notification2);
            SlrItemNotificationBinding slrItemNotificationBinding = notificationFriendJoinToChatView.getBinding();
            NotificationViewsProvider notificationViewsProvider = ((NotificationFriendJoinToChatView)((Object)notificationViewsProvider)).NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifIconIV.setImageResource(R.drawable.slr_ic_friends_arriving);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewGroup.LayoutParams layoutParams = appCompatTextView.getLayoutParams();
            if (layoutParams != null) {
                SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding;
                ((ConstraintLayout.LayoutParams)layoutParams).topToTop = 0;
                ((ConstraintLayout.LayoutParams)layoutParams).bottomToBottom = slrItemNotificationBinding.slNotifDescriptionTV.getId();
                appCompatTextView.setLayoutParams((ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams));
                slrItemNotificationBinding2.slNotifTitleTV.setText((CharSequence)notificationViewsProvider.resources.getString(R.string.slr_messaging_chat_friend_joined_title_template, new Object[]{notification.getTitle()}));
                slrItemNotificationBinding2.slNotifDescriptionTV.setText(R.string.slr_messaging_chat_friend_joined_template);
                AppCompatTextView appCompatTextView2 = slrItemNotificationBinding2.slNotifDescriptionTV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
                ViewExtensionsKt.visible((View)appCompatTextView2);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsBannerView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "getLandscapeWidth", "", "setConstraintParams", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "sdk_originalVonageRelease"})
    public final class NotificationPredictionsBannerView
    extends BaseNotificationView {
        @NotNull
        private final SlrPredictionsBannerBinding binding;

        public NotificationPredictionsBannerView(SlrPredictionsBannerBinding slrPredictionsBannerBinding) {
            Intrinsics.checkNotNullParameter((Object)slrPredictionsBannerBinding, (String)"binding");
            this.binding = slrPredictionsBannerBinding;
        }

        private static final void bind$lambda$5$lambda$3(SlrPredictionsBannerBinding object, NotificationViewsProvider notificationViewsProvider, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            SLRRoundedConstraintLayout sLRRoundedConstraintLayout = object.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sLRRoundedConstraintLayout), (String)"root");
            ViewExtensionsKt.invisible((View)sLRRoundedConstraintLayout);
            NotificationsLayout.NotificationViewAction notificationViewAction2 = notificationViewsProvider.listener;
            object = object.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"root");
            notificationViewAction2.onExpand(notification, (View)object);
        }

        private static final void bind$lambda$5$lambda$4(SlrPredictionsBannerBinding object, NotificationViewsProvider notificationViewsProvider, Notification notification, View view2) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            SLRRoundedConstraintLayout sLRRoundedConstraintLayout = object.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sLRRoundedConstraintLayout), (String)"root");
            ViewExtensionsKt.invisible((View)sLRRoundedConstraintLayout);
            NotificationsLayout.NotificationViewAction notificationViewAction2 = notificationViewsProvider.listener;
            object = object.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"root");
            notificationViewAction2.onHide(notification, (View)object);
        }

        @Override
        @NotNull
        public SlrPredictionsBannerBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrPredictionsBannerBinding slrPredictionsBannerBinding = notificationPredictionsBannerView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationPredictionsBannerView.NotificationViewsProvider.this;
            Object object = GamesSettings.OnboardingNotification.Companion.deserialize(notification.getDataJson());
            if (object != null) {
                SlrPredictionsBannerBinding slrPredictionsBannerBinding2 = slrPredictionsBannerBinding;
                slrPredictionsBannerBinding2.slTitle.setText((CharSequence)((GamesSettings.OnboardingNotification)object).getTitle());
                slrPredictionsBannerBinding2.slDescription.setText((CharSequence)((GamesSettings.OnboardingNotification)object).getSubtitle());
                ImageView imageView2 = slrPredictionsBannerBinding2.slMainIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slMainIcon");
                ExtensionsKt.load(imageView2, ((GamesSettings.OnboardingNotification)object).getMainIcon());
                boolean bl = ((GamesSettings.OnboardingNotification)object).getSponsorIcon().length() > 0;
                if (bl) {
                    ImageView imageView3 = slrPredictionsBannerBinding.slSponsorIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"slSponsorIcon");
                    ExtensionsKt.load(imageView3, ((GamesSettings.OnboardingNotification)object).getSponsorIcon());
                } else {
                    TextView textView = slrPredictionsBannerBinding.slSponsorText;
                    String string2 = ((GamesSettings.OnboardingNotification)object).getSponsorHeader().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    textView.setText((CharSequence)string2);
                }
                SlrPredictionsBannerBinding slrPredictionsBannerBinding3 = slrPredictionsBannerBinding;
                ImageView imageView4 = slrPredictionsBannerBinding3.slSponsorIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView4, (String)"slSponsorIcon");
                ViewExtensionsKt.visibleIf((View)imageView4, bl);
                TextView textView = slrPredictionsBannerBinding3.slPresents;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slPresents");
                ViewExtensionsKt.visibleIf((View)textView, bl);
                TextView textView2 = slrPredictionsBannerBinding3.slSponsorText;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slSponsorText");
                ViewExtensionsKt.visibleIf((View)textView2, bl ^ true);
                String string3 = ((GamesSettings.OnboardingNotification)object).getBackground();
                if (!(string3 == null || string3.length() == 0)) {
                    ImageView imageView5 = slrPredictionsBannerBinding.slBackground;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView5, (String)"slBackground");
                    ExtensionsKt.load(imageView5, ((GamesSettings.OnboardingNotification)object).getBackground());
                }
                GamesSettings.OnboardingNotification onboardingNotification = object;
                try {
                    object = Result.constructor-impl((Object)Color.parseColor((String)onboardingNotification.getPrimaryColor()));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object)) {
                    object = null;
                }
                if ((object = (Integer)object) != null) {
                    SlrPredictionsBannerBinding slrPredictionsBannerBinding4 = slrPredictionsBannerBinding;
                    int n = ((Number)object).intValue();
                    Drawable drawable2 = slrPredictionsBannerBinding4.slPlay.getBackground();
                    Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    ((GradientDrawable)drawable2).setTint(n);
                    ImageViewCompat.setImageTintList((ImageView)slrPredictionsBannerBinding4.slBackground, (ColorStateList)ColorStateList.valueOf((int)n));
                }
            }
            SlrPredictionsBannerBinding slrPredictionsBannerBinding5 = slrPredictionsBannerBinding;
            this.getBinding().getRoot().setOnTouchListener(notificationViewsProvider.new NotificationTouchListener(notification));
            slrPredictionsBannerBinding5.slPlay.setOnClickListener(arg_0 -> NotificationPredictionsBannerView.bind$lambda$5$lambda$3(slrPredictionsBannerBinding, notificationViewsProvider, notification, arg_0));
            slrPredictionsBannerBinding5.slClose.setOnClickListener(arg_0 -> NotificationPredictionsBannerView.bind$lambda$5$lambda$4(slrPredictionsBannerBinding, notificationViewsProvider, notification, arg_0));
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_onboarding_landscape_width);
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout object, @NotNull ConstraintSet constraintSet) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            NotificationPredictionsBannerView notificationPredictionsBannerView2 = this;
            Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            object = notificationPredictionsBannerView2.NotificationViewsProvider.this;
            constraintSet.setTranslationZ(notificationPredictionsBannerView2.getBinding().getRoot().getId(), 30.0f);
            int n = notificationPredictionsBannerView.getBinding().getRoot().getId();
            int n2 = notificationPredictionsBannerView.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
            NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n3 = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n3, ((NotificationViewsProvider)object).bottomMargin);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCustomViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_originalVonageRelease"})
    public final class NotificationCustomViewHolder
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            Object object = this.getBinding().getRoot().getContext();
            NotificationBuilder notificationBuilder = notification.getCustomBuilder();
            if (notificationBuilder != null) {
                NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
                Object object2 = LayoutInflater.from((Context)object);
                if (notificationBuilder.getLayoutId() != null) {
                    Integer n = notificationBuilder.getLayoutId();
                    Intrinsics.checkNotNull((Object)n);
                    object = object2.inflate(n.intValue(), (ViewGroup)this.getBinding().getRoot(), false);
                } else {
                    object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)this.getBinding().getRoot(), false);
                    object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                    object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                    Integer n = notificationBuilder.getIconBackgroundColor();
                    if (n != null) {
                        int n2 = n;
                        object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                    }
                    if ((object = notificationBuilder.getIconUrl()) != null) {
                        AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                    }
                    object = this.getBinding().getRoot();
                }
                Context context = object;
                this.getBinding().getRoot().addView((View)object);
                context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                ViewGroup.LayoutParams layoutParams = context.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                ((FrameLayout.LayoutParams)layoutParams).gravity = 80;
                context.setLayoutParams((ViewGroup.LayoutParams)((FrameLayout.LayoutParams)layoutParams));
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view");
                notificationBuilder.bindView((View)context);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SLRTheme.NotificationsStyle.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[SLRTheme.NotificationsStyle.DESIGN_NUMBER_TWO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[NotificationType.values().length];
            nArray2 = nArray3;
            try {
                nArray3[NotificationType.JoinToChat.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Chat.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.WatchParty.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.CreateNewWatchParty.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.JoinedToWatchParty.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.PredictionOnboarding.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Twitter.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Custom.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

