/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.tooltips;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Paint;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.session.PromoTooltipType;
import io.streamlayer.common.views.SLRMenuButton;
import io.streamlayer.common.views.SLRRippleView;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.common.views.tooltips.ViewTooltipHandler;
import io.streamlayer.common.views.tooltips.ViewTooltipHandlerKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.tooltips.MenuButtonTooltip;
import io.streamlayer.sdk.main.tooltips.MenuButtonViewTooltipContentView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/main/tooltips/MenuButtonTooltip;", "Lio/streamlayer/common/views/tooltips/ViewTooltipHandler;", "view", "Lio/streamlayer/common/views/SLRMenuButton;", "rippleView", "Lio/streamlayer/common/views/SLRRippleView;", "(Lio/streamlayer/common/views/SLRMenuButton;Lio/streamlayer/common/views/SLRRippleView;)V", "_isTooltipVisible", "", "bubbleView", "Lio/streamlayer/common/views/tooltips/BubbleView;", "onTooltipCompleted", "Lkotlin/Function0;", "", "getOnTooltipCompleted", "()Lkotlin/jvm/functions/Function0;", "setOnTooltipCompleted", "(Lkotlin/jvm/functions/Function0;)V", "type", "Lio/streamlayer/common/session/PromoTooltipType;", "getType", "()Lio/streamlayer/common/session/PromoTooltipType;", "buildTooltipAnimation", "Lio/streamlayer/common/views/tooltips/BubbleView$Animation;", "hideTooltip", "onAnimationEnd", "isTooltipVisible", "showTooltip", "parentView", "Landroidx/constraintlayout/widget/ConstraintLayout;", "sdk_originalVonageRelease"})
public final class MenuButtonTooltip
implements ViewTooltipHandler {
    @NotNull
    private final SLRMenuButton view;
    @NotNull
    private final SLRRippleView rippleView;
    @Nullable
    private BubbleView bubbleView;
    @NotNull
    private final PromoTooltipType type;
    @Nullable
    private Function0<Unit> onTooltipCompleted;
    private boolean _isTooltipVisible;

    public MenuButtonTooltip(@NotNull SLRMenuButton sLRMenuButton, @NotNull SLRRippleView sLRRippleView) {
        MenuButtonTooltip menuButtonTooltip = this;
        Intrinsics.checkNotNullParameter((Object)((Object)sLRMenuButton), (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)sLRRippleView), (String)"rippleView");
        this.view = sLRMenuButton;
        menuButtonTooltip.rippleView = sLRRippleView;
        menuButtonTooltip.type = PromoTooltipType.MAIN_MENU;
    }

    private final BubbleView.Animation buildTooltipAnimation() {
        return new BubbleView.Animation(){
            private final float translationXValue;
            {
                this.translationXValue = ViewExtensionsKt.getDp(24.0f);
            }

            public final float getTranslationXValue() {
                return this.translationXValue;
            }

            public void animateEnter(@NotNull BubbleView bubbleView) {
                BubbleView bubbleView2 = bubbleView;
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView2), (String)"view");
                float f = bubbleView2.getTranslationX();
                bubbleView.setAlpha(0.0f);
                bubbleView2.setTranslationX(f + this.translationXValue);
                bubbleView2.animate().translationX(f).alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(1000L).start();
            }

            public void animateExit(@NotNull BubbleView bubbleView, @NotNull Animator.AnimatorListener animatorListener) {
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"view");
                Intrinsics.checkNotNullParameter((Object)animatorListener, (String)"animatorListener");
                bubbleView.animate().translationX(bubbleView.getTranslationX() + this.translationXValue).alpha(0.0f).setStartDelay(0L).setDuration(400L).setListener(animatorListener).start();
            }
        };
    }

    private static final void showTooltip$lambda$1$lambda$0(MenuButtonTooltip function0, View view2) {
        Function0<Unit> function02 = function0;
        Intrinsics.checkNotNullParameter((Object)function02, (String)"this$0");
        function0 = function02.getOnTooltipCompleted();
        if (function0 != null) {
            function0.invoke();
        }
    }

    private static final void showTooltip$lambda$2(MenuButtonTooltip menuButtonTooltip) {
        MenuButtonTooltip menuButtonTooltip2 = menuButtonTooltip;
        Intrinsics.checkNotNullParameter((Object)menuButtonTooltip2, (String)"this$0");
        SLRRippleView.repeatRipple$default(menuButtonTooltip2.rippleView, 0L, 0L, 3, null);
    }

    public static final /* synthetic */ SLRMenuButton access$getView$p(MenuButtonTooltip menuButtonTooltip) {
        return menuButtonTooltip.view;
    }

    @Override
    @NotNull
    public PromoTooltipType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Function0<Unit> getOnTooltipCompleted() {
        return this.onTooltipCompleted;
    }

    @Override
    public void setOnTooltipCompleted(@Nullable Function0<Unit> function0) {
        this.onTooltipCompleted = function0;
    }

    @Override
    public boolean isTooltipVisible() {
        return this._isTooltipVisible;
    }

    @Override
    public void showTooltip(@NotNull ConstraintLayout object) {
        Function1<BubbleView, Unit> function1;
        BubbleView bubbleView;
        Intrinsics.checkNotNullParameter((Object)object, (String)"parentView");
        if (this.isTooltipVisible()) {
            return;
        }
        MenuButtonTooltip menuButtonTooltip = this;
        menuButtonTooltip._isTooltipVisible = true;
        new Paint(1).setColor(0);
        Context context = menuButtonTooltip.view.getContext();
        BubbleView bubbleView2 = bubbleView;
        ConstraintLayout constraintLayout = object;
        BubbleView bubbleView3 = bubbleView2;
        BubbleView bubbleView4 = bubbleView2;
        BubbleView bubbleView5 = bubbleView2;
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        bubbleView5(context2, null, 0, 6, null);
        ViewTooltipHandlerKt.applyStyles(bubbleView5);
        Context context3 = this.view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"view.context");
        BubbleView.customView$default(bubbleView5, (View)new MenuButtonViewTooltipContentView(context3, null, 0, 6, null), 0, 0, 6, null);
        bubbleView4.tooltipAnimation(this.buildTooltipAnimation());
        bubbleView4.position(BubbleView.Position.LEFT);
        bubbleView3.setOnClickListener(arg_0 -> MenuButtonTooltip.showTooltip$lambda$1$lambda$0(this, arg_0));
        this.bubbleView = bubbleView3;
        Intrinsics.checkNotNull((Object)((Object)bubbleView2));
        object = this.view;
        bubbleView2 = function1;
        function1 = new Function1<BubbleView, Unit>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ MenuButtonTooltip this$0;
            {
                this.$context = context;
                this.this$0 = menuButtonTooltip;
                super(1);
            }

            public final void invoke(@NotNull BubbleView object) {
                BubbleView bubbleView = object;
                Intrinsics.checkNotNullParameter((Object)((Object)bubbleView), (String)"it");
                ViewGroup.LayoutParams layoutParams = bubbleView.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                showTooltip.2 v2 = this_;
                showTooltip.2 this_ = v2.$context;
                object = v2.this$0;
                ((ConstraintLayout.LayoutParams)layoutParams).setMarginEnd(this_.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_distance_between_view));
                ((ConstraintLayout.LayoutParams)layoutParams).endToStart = MenuButtonTooltip.access$getView$p((MenuButtonTooltip)object).getId();
                ((ConstraintLayout.LayoutParams)layoutParams).topToTop = MenuButtonTooltip.access$getView$p((MenuButtonTooltip)object).getId();
                ((ConstraintLayout.LayoutParams)layoutParams).bottomToBottom = MenuButtonTooltip.access$getView$p((MenuButtonTooltip)object).getId();
                bubbleView.postInvalidate();
                bubbleView.requestLayout();
            }
        };
        bubbleView.show((ViewGroup)constraintLayout, (View)object, (Function1<? super BubbleView, Unit>)bubbleView2);
        ViewExtensionsKt.visible((View)menuButtonTooltip.rippleView);
        menuButtonTooltip.rippleView.postDelayed(() -> MenuButtonTooltip.showTooltip$lambda$2(this), 500L);
    }

    @Override
    public void hideTooltip(@Nullable Function0<Unit> function0) {
        if (!((MenuButtonTooltip)((Object)bubbleView)).isTooltipVisible()) {
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        MenuButtonTooltip menuButtonTooltip = bubbleView;
        menuButtonTooltip._isTooltipVisible = false;
        menuButtonTooltip.rippleView.stopRipple();
        ViewExtensionsKt.invisible((View)menuButtonTooltip.rippleView);
        BubbleView bubbleView = menuButtonTooltip.bubbleView;
        if (bubbleView != null) {
            bubbleView.close(function0);
        }
    }
}

