/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.predictions.leaderboard;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.paging.PagingDataAdapter;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import coil.ImageLoader;
import coil.request.ImageRequest;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.AcronymDrawable;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.databinding.SlrPredictionsLeaderboardInviteBtnBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsLeaderboardItemBinding;
import io.streamlayer.sdk.model.predictions.LeaderboardLeader;
import io.streamlayer.sdk.predictions.leaderboard.ItemViewType;
import io.streamlayer.sdk.predictions.leaderboard.LeadersComparator;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0019\u001aB7\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/sdk/predictions/leaderboard/LeaderboardAdapter;", "Landroidx/paging/PagingDataAdapter;", "Lio/streamlayer/sdk/model/predictions/LeaderboardLeader;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "primaryColor", "Lkotlin/Function0;", "", "selectLeader", "Lkotlin/Function1;", "", "share", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "isOver", "", "()Z", "setOver", "(Z)V", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "InviteViewHolder", "LeaderItemViewHolder", "sdk_originalVonageRelease"})
public final class LeaderboardAdapter
extends PagingDataAdapter<LeaderboardLeader, RecyclerView.ViewHolder> {
    @NotNull
    private final Function0<Integer> primaryColor;
    @NotNull
    private final Function1<LeaderboardLeader, Unit> selectLeader;
    @NotNull
    private final Function0<Unit> share;
    private boolean isOver;

    public LeaderboardAdapter(@NotNull Function0<Integer> function0, @NotNull Function1<? super LeaderboardLeader, Unit> function1, @NotNull Function0<Unit> function02) {
        Intrinsics.checkNotNullParameter(function0, (String)"primaryColor");
        Intrinsics.checkNotNullParameter(function1, (String)"selectLeader");
        Intrinsics.checkNotNullParameter(function02, (String)"share");
        super((DiffUtil.ItemCallback)LeadersComparator.INSTANCE, null, null, 6, null);
        this.primaryColor = function0;
        this.selectLeader = function1;
        this.share = function02;
    }

    public final boolean isOver() {
        return this.isOver;
    }

    public final void setOver(boolean bl) {
        this.isOver = bl;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Object object;
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n == ItemViewType.LEADER.ordinal()) {
            LeaderItemViewHolder leaderItemViewHolder;
            viewHolder = leaderItemViewHolder;
            LeaderboardAdapter leaderboardAdapter = object;
            object = SlrPredictionsLeaderboardItemBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            leaderItemViewHolder = leaderboardAdapter.new LeaderItemViewHolder((SlrPredictionsLeaderboardItemBinding)object);
        } else {
            InviteViewHolder inviteViewHolder;
            viewHolder = inviteViewHolder;
            LeaderboardAdapter leaderboardAdapter = object;
            object = SlrPredictionsLeaderboardInviteBtnBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            inviteViewHolder = leaderboardAdapter.new InviteViewHolder((SlrPredictionsLeaderboardInviteBtnBinding)object);
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof LeaderItemViewHolder) {
            ((LeaderItemViewHolder)viewHolder).bind((LeaderboardLeader)this.getItem(n));
        } else if (viewHolder instanceof InviteViewHolder) {
            ((InviteViewHolder)viewHolder).bind();
        }
    }

    public int getItemViewType(int n) {
        return (this = (LeaderboardLeader)this.getItem(n)) != null && ((LeaderboardLeader)this).isEmpty() ? ItemViewType.INVITE.ordinal() : ItemViewType.LEADER.ordinal();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/sdk/predictions/leaderboard/LeaderboardAdapter$LeaderItemViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsLeaderboardItemBinding;", "(Lio/streamlayer/sdk/predictions/leaderboard/LeaderboardAdapter;Lio/streamlayer/sdk/databinding/SlrPredictionsLeaderboardItemBinding;)V", "leader", "Lio/streamlayer/sdk/model/predictions/LeaderboardLeader;", "getLeader", "()Lio/streamlayer/sdk/model/predictions/LeaderboardLeader;", "setLeader", "(Lio/streamlayer/sdk/model/predictions/LeaderboardLeader;)V", "bind", "", "updateScore", "score", "", "sdk_originalVonageRelease"})
    public final class LeaderItemViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrPredictionsLeaderboardItemBinding binding;
        @Nullable
        private LeaderboardLeader leader;

        public LeaderItemViewHolder(SlrPredictionsLeaderboardItemBinding slrPredictionsLeaderboardItemBinding) {
            Intrinsics.checkNotNullParameter((Object)slrPredictionsLeaderboardItemBinding, (String)"binding");
            super((View)slrPredictionsLeaderboardItemBinding.getRoot());
            this.binding = slrPredictionsLeaderboardItemBinding;
        }

        private static final void bind$lambda$0(LeaderboardAdapter leaderboardAdapter, LeaderboardLeader leaderboardLeader, View view2) {
            LeaderboardAdapter leaderboardAdapter2 = leaderboardAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)leaderboardAdapter2), (String)"this$0");
            leaderboardAdapter2.selectLeader.invoke((Object)leaderboardLeader);
        }

        @Nullable
        public final LeaderboardLeader getLeader() {
            return this.leader;
        }

        public final void setLeader(@Nullable LeaderboardLeader leaderboardLeader) {
            this.leader = leaderboardLeader;
        }

        /*
         * WARNING - void declaration
         */
        public final void bind(@Nullable LeaderboardLeader leaderboardLeader) {
            block16: {
                void var3_21;
                void var3_18;
                void var3_15;
                ConstraintLayout constraintLayout;
                block14: {
                    Boolean bl;
                    block15: {
                        block13: {
                            AcronymDrawable acronymDrawable;
                            void var3_8;
                            void bl2;
                            this.leader = leaderboardLeader;
                            constraintLayout = this.binding.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                            if (leaderboardLeader != null) {
                                boolean bl22 = true;
                            } else {
                                boolean object = false;
                            }
                            ViewExtensionsKt.visibleIf((View)constraintLayout, (boolean)bl2);
                            if (leaderboardLeader == null) {
                                return;
                            }
                            LeaderItemViewHolder leaderItemViewHolder = this;
                            ConstraintLayout constraintLayout2 = leaderItemViewHolder.binding.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.root");
                            ViewExtensionsKt.visible((View)constraintLayout2);
                            leaderItemViewHolder.binding.getRoot().setOnClickListener(arg_0 -> LeaderItemViewHolder.bind$lambda$0(LeaderboardAdapter.this, leaderboardLeader, arg_0));
                            ImageView imageView2 = leaderItemViewHolder.binding.slStar;
                            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slStar");
                            ViewExtensionsKt.visibleIf((View)imageView2, leaderboardLeader.getHasStar());
                            constraintLayout = leaderItemViewHolder.binding.slPts;
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slPts");
                            if (leaderboardLeader.getRank() == 1) {
                                boolean bl3 = true;
                            } else {
                                boolean bl4 = false;
                            }
                            LeaderboardLeader leaderboardLeader2 = leaderboardLeader;
                            LeaderItemViewHolder leaderItemViewHolder2 = this;
                            ViewExtensionsKt.visibleIf((View)constraintLayout, (boolean)var3_8);
                            leaderItemViewHolder2.binding.slUserName.setText((CharSequence)leaderboardLeader.getName());
                            constraintLayout = leaderItemViewHolder2.binding.slUserIcon;
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slUserIcon");
                            String string2 = leaderboardLeader2.getIcon();
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout.getContext(), (String)"context");
                            ImageLoader imageLoader = (ImageLoader)StreamLayer.INSTANCE.getKoin$sdk_originalVonageRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ImageLoader.class), null, null);
                            Context context = constraintLayout.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                            constraintLayout = new ImageRequest.Builder(context).data((Object)string2).target((ImageView)constraintLayout);
                            String string3 = leaderboardLeader2.getName();
                            if (string3 == null) {
                                string3 = "";
                            }
                            ConstraintLayout constraintLayout3 = constraintLayout;
                            AcronymDrawable acronymDrawable2 = acronymDrawable;
                            constraintLayout = this.binding.getRoot().getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root.context");
                            acronymDrawable2(string3, (Context)constraintLayout, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, 4092, null);
                            constraintLayout3.error((Drawable)acronymDrawable2);
                            imageLoader.enqueue(constraintLayout3.build());
                            constraintLayout = this.binding.slChange;
                            bl = leaderboardLeader.getUp();
                            if (!Intrinsics.areEqual((Object)bl, (Object)Boolean.TRUE)) break block13;
                            int n = R.drawable.slr_ic_leaderboard_up;
                            break block14;
                        }
                        if (!Intrinsics.areEqual((Object)bl, (Object)Boolean.FALSE)) break block15;
                        int n = R.drawable.slr_ic_leaderboard_down;
                        break block14;
                    }
                    if (bl != null) break block16;
                    int n = R.drawable.slr_ic_leaderboard_equal;
                }
                LeaderItemViewHolder leaderItemViewHolder = this;
                constraintLayout.setImageResource((int)var3_15);
                ImageView imageView3 = leaderItemViewHolder.binding.slChange;
                Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"binding.slChange");
                ViewExtensionsKt.visibleIf((View)imageView3, false);
                constraintLayout = leaderItemViewHolder.binding.slWinner;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slWinner");
                if (leaderItemViewHolder.LeaderboardAdapter.this.isOver() && leaderboardLeader.getRank() == 1) {
                    boolean bl = true;
                } else {
                    boolean bl = false;
                }
                LeaderItemViewHolder leaderItemViewHolder3 = this;
                ViewExtensionsKt.visibleIf((View)constraintLayout, (boolean)var3_18);
                constraintLayout = leaderItemViewHolder3.binding.slRank;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slRank");
                if (leaderItemViewHolder3.LeaderboardAdapter.this.isOver() && leaderboardLeader.getRank() == 1) {
                    boolean bl = true;
                } else {
                    boolean bl = false;
                }
                ViewExtensionsKt.invisibleIf((View)constraintLayout, (boolean)var3_21);
                this.binding.slRank.setText((CharSequence)String.valueOf(leaderboardLeader.getRank()));
                this.updateScore(leaderboardLeader.getScore());
                return;
            }
            throw new NoWhenBranchMatchedException();
        }

        public final void updateScore(int n) {
            this.binding.slScore.setText((CharSequence)new DecimalFormat("#,###").format((Object)n));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/predictions/leaderboard/LeaderboardAdapter$InviteViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsLeaderboardInviteBtnBinding;", "(Lio/streamlayer/sdk/predictions/leaderboard/LeaderboardAdapter;Lio/streamlayer/sdk/databinding/SlrPredictionsLeaderboardInviteBtnBinding;)V", "bind", "", "sdk_originalVonageRelease"})
    public final class InviteViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrPredictionsLeaderboardInviteBtnBinding binding;

        public InviteViewHolder(SlrPredictionsLeaderboardInviteBtnBinding slrPredictionsLeaderboardInviteBtnBinding) {
            Intrinsics.checkNotNullParameter((Object)slrPredictionsLeaderboardInviteBtnBinding, (String)"binding");
            super((View)slrPredictionsLeaderboardInviteBtnBinding.getRoot());
            this.binding = slrPredictionsLeaderboardInviteBtnBinding;
        }

        private static final void bind$lambda$1(LeaderboardAdapter leaderboardAdapter, View view2) {
            LeaderboardAdapter leaderboardAdapter2 = leaderboardAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)leaderboardAdapter2), (String)"this$0");
            leaderboardAdapter2.share.invoke();
        }

        public final void bind() {
            Integer n = (Integer)LeaderboardAdapter.this.primaryColor.invoke();
            if (n != null) {
                int n2 = n;
                Drawable drawable2 = this.binding.slInviteButton.getBackground();
                Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                ((GradientDrawable)drawable2).setTint(n2);
            }
            this.binding.slInviteButton.setOnClickListener(arg_0 -> InviteViewHolder.bind$lambda$1(LeaderboardAdapter.this, arg_0));
        }
    }
}

