/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.repository.notifications.NotificationDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class NotificationDao_Impl
implements NotificationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Notification> __insertionAdapterOfNotification;
    private final Converters __converters;
    private final EntityInsertionAdapter<Notification> __insertionAdapterOfNotification_1;
    private final EntityDeletionOrUpdateAdapter<Notification> __deletionAdapterOfNotification;
    private final EntityDeletionOrUpdateAdapter<Notification> __updateAdapterOfNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNotification;
    private final SharedSQLiteStatement __preparedStmtOfSafeDeleteAllNotifications;

    public NotificationDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        EntityDeletionOrUpdateAdapter<Notification> entityDeletionOrUpdateAdapter;
        EntityDeletionOrUpdateAdapter<Notification> entityDeletionOrUpdateAdapter2;
        EntityInsertionAdapter<Notification> entityInsertionAdapter;
        EntityInsertionAdapter<Notification> entityInsertionAdapter2;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter2;
        entityInsertionAdapter2 = new EntityInsertionAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `Notification` (`id`,`title`,`description`,`type`,`date`,`sourceUniqueId`,`dataJson`,`meta`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification object) {
                if (((Notification)object).getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = ((Notification)object).getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
                if (((Notification)object).getTitle() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, ((Notification)object).getTitle());
                }
                if (((Notification)object).getDescription() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, ((Notification)object).getDescription());
                }
                Object object2 = object3.NotificationDao_Impl.this.__converters.notificationTypeToString(((Notification)object).getType());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object2);
                }
                object2 = object3.NotificationDao_Impl.this.__converters.dateToString(((Notification)object).getDate());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l = (Long)object2;
                    supportSQLiteStatement.bindLong(5, l);
                }
                if (((Notification)object).getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, ((Notification)object).getSourceUniqueId());
                }
                if (((Notification)object).getDataJson() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, ((Notification)object).getDataJson());
                }
                object = ((Notification)object).getNotificationIcon();
                if (object != null) {
                    Object object3 = object3.NotificationDao_Impl.this.__converters.stringMapToString(((NotificationIcon)object).getMeta());
                    if (object3 == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object3);
                    }
                } else {
                    supportSQLiteStatement.bindNull(8);
                }
            }
        };
        this.__insertionAdapterOfNotification = converters2;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Notification` (`id`,`title`,`description`,`type`,`date`,`sourceUniqueId`,`dataJson`,`meta`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification object) {
                if (((Notification)object).getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = ((Notification)object).getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
                if (((Notification)object).getTitle() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, ((Notification)object).getTitle());
                }
                if (((Notification)object).getDescription() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, ((Notification)object).getDescription());
                }
                Object object2 = object3.NotificationDao_Impl.this.__converters.notificationTypeToString(((Notification)object).getType());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object2);
                }
                object2 = object3.NotificationDao_Impl.this.__converters.dateToString(((Notification)object).getDate());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l = (Long)object2;
                    supportSQLiteStatement.bindLong(5, l);
                }
                if (((Notification)object).getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, ((Notification)object).getSourceUniqueId());
                }
                if (((Notification)object).getDataJson() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, ((Notification)object).getDataJson());
                }
                object = ((Notification)object).getNotificationIcon();
                if (object != null) {
                    Object object3 = object3.NotificationDao_Impl.this.__converters.stringMapToString(((NotificationIcon)object).getMeta());
                    if (object3 == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object3);
                    }
                } else {
                    supportSQLiteStatement.bindNull(8);
                }
            }
        };
        this.__insertionAdapterOfNotification_1 = converters2;
        converters2 = entityDeletionOrUpdateAdapter2;
        entityDeletionOrUpdateAdapter2 = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `Notification` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
            }
        };
        this.__deletionAdapterOfNotification = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `Notification` SET `id` = ?,`title` = ?,`description` = ?,`type` = ?,`date` = ?,`sourceUniqueId` = ?,`dataJson` = ?,`meta` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getDescription());
                }
                Object object = object2.NotificationDao_Impl.this.__converters.notificationTypeToString(notification.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                object = object2.NotificationDao_Impl.this.__converters.dateToString(notification.getDate());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    long l = (Long)object;
                    supportSQLiteStatement.bindLong(5, l);
                }
                if (notification.getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, notification.getSourceUniqueId());
                }
                if (notification.getDataJson() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, notification.getDataJson());
                }
                NotificationIcon notificationIcon = notification.getNotificationIcon();
                if (notificationIcon != null) {
                    Object object2 = object2.NotificationDao_Impl.this.__converters.stringMapToString(notificationIcon.getMeta());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object2);
                    }
                } else {
                    supportSQLiteStatement.bindNull(8);
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(9, l);
                }
            }
        };
        this.__updateAdapterOfNotification = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification WHERE sourceUniqueId = ?";
            }
        };
        this.__preparedStmtOfDeleteNotification = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification";
            }
        };
        this.__preparedStmtOfSafeDeleteAllNotifications = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void saveNotifications(List<Notification> list2) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__insertionAdapterOfNotification.insert(list2);
            notificationDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public long saveNotification(Notification notification) {
        long l;
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            l = notificationDao_Impl.__insertionAdapterOfNotification_1.insertAndReturnId((Object)notification);
            NotificationDao_Impl notificationDao_Impl2 = this;
            notificationDao_Impl2.__db.setTransactionSuccessful();
            notificationDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public Object deleteNotifications(final List<Notification> list2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                7 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handleMultiple((Iterable)list2);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                NotificationDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteNotification(final Notification notification, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                8 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handle((Object)notification);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                NotificationDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public void updateNotifications(List<Notification> list2) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__updateAdapterOfNotification.handleMultiple(list2);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteNotification(String string2) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = notificationDao_Impl.__preparedStmtOfDeleteNotification.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        NotificationDao_Impl notificationDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            NotificationDao_Impl notificationDao_Impl3 = this;
            notificationDao_Impl3.__db.endTransaction();
            notificationDao_Impl3.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
            throw throwable;
        }
        notificationDao_Impl2.__db.setTransactionSuccessful();
        notificationDao_Impl2.__db.endTransaction();
        notificationDao_Impl2.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
    }

    @Override
    public void safeDeleteAllNotifications() {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = notificationDao_Impl.__preparedStmtOfSafeDeleteAllNotifications.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            NotificationDao_Impl notificationDao_Impl2 = this;
            notificationDao_Impl2.__db.endTransaction();
            notificationDao_Impl2.__preparedStmtOfSafeDeleteAllNotifications.release(supportSQLiteStatement);
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
        notificationDao_Impl.__preparedStmtOfSafeDeleteAllNotifications.release(supportSQLiteStatement);
    }

    @Override
    public Flow<List<Notification>> getNotifications() {
        Callable<List<Notification>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT `meta`, `Notification`.`id` AS `id`, `Notification`.`title` AS `title`, `Notification`.`description` AS `description`, `Notification`.`type` AS `type`, `Notification`.`date` AS `date`, `Notification`.`sourceUniqueId` AS `sourceUniqueId`, `Notification`.`dataJson` AS `dataJson` FROM Notification ORDER BY Notification.id DESC, Notification.date DESC", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Notification";
        Callable<List<Notification>> callable2 = callable;
        callable = new Callable<List<Notification>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<Notification> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)NotificationDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = v0;
                try {
                    v0 = new ArrayList<Notification>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block42: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block37: {
                                                            block36: {
                                                                block35: {
                                                                    block34: {
                                                                        block33: {
                                                                            block30: {
                                                                                block32: {
                                                                                    block31: {
                                                                                        block29: {
                                                                                            block28: {
                                                                                                if (!var1_1.isNull(1)) break block28;
                                                                                                var3_3 = null;
                                                                                                break block29;
                                                                                            }
                                                                                            var3_3 = var1_1.getLong(1);
                                                                                        }
                                                                                        if (var1_1.isNull(0)) break block30;
                                                                                        if (!var1_1.isNull(0)) break block31;
                                                                                        var4_4 = null;
                                                                                        break block32;
                                                                                    }
                                                                                    var4_4 = var1_1.getString(0);
                                                                                }
                                                                                var4_4 = NotificationDao_Impl.this.__converters.stringToStringMap((String)var4_4);
                                                                                if (var4_4 == null) ** GOTO lbl34
                                                                                var5_5 = v2;
                                                                                v2 = new NotificationIcon(var4_4);
                                                                                break block33;
lbl34:
                                                                                // 1 sources

                                                                                throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
                                                                            }
                                                                            var5_5 = null;
                                                                        }
                                                                        v3 = var1_1;
                                                                        var4_4 = v4;
                                                                        v4 = new Notification((Long)var3_3);
                                                                        if (!v3.isNull(2)) break block34;
                                                                        var3_3 = null;
                                                                        break block35;
                                                                    }
                                                                    var3_3 = var1_1.getString(2);
                                                                }
                                                                var4_4.setTitle((String)var3_3);
                                                                if (!var1_1.isNull(3)) break block36;
                                                                var3_3 = null;
                                                                break block37;
                                                            }
                                                            var3_3 = var1_1.getString(3);
                                                        }
                                                        var4_4.setDescription((String)var3_3);
                                                        if (!var1_1.isNull(4)) break block38;
                                                        var3_3 = null;
                                                        break block39;
                                                    }
                                                    var3_3 = var1_1.getString(4);
                                                }
                                                var4_4.setType(NotificationDao_Impl.this.__converters.stringToNotificationType((String)var3_3));
                                                if (!var1_1.isNull(5)) break block40;
                                                var3_3 = null;
                                                break block41;
                                            }
                                            var3_3 = var1_1.getLong(5);
                                        }
                                        var3_3 = NotificationDao_Impl.this.__converters.timestampToDate((Long)var3_3);
                                        if (var3_3 == null) break block42;
                                        var4_4.setDate((Date)var3_3);
                                        if (!var1_1.isNull(6)) break block43;
                                        var3_3 = null;
                                        break block44;
                                    }
                                    var3_3 = var1_1.getString(6);
                                }
                                var4_4.setSourceUniqueId((String)var3_3);
                                if (!var1_1.isNull(7)) break block45;
                                var3_3 = null;
                                break block46;
                            }
                            var3_3 = var1_1.getString(7);
                        }
                        v5 = var4_4;
                        v5.setDataJson((String)var3_3);
                        v5.setNotificationIcon(var5_5);
                        var2_2.add((Notification)v5);
                        continue;
                    }
                    throw new IllegalStateException("Expected non-null java.util.Date, but it was null.");
                }
lbl108:
                // 1 sources

                var1_1.close();
                return var2_2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Notification getNotification(String string2) {
        Notification notification;
        RoomSQLiteQuery roomSQLiteQuery;
        block54: {
            block35: {
                NotificationIcon notificationIcon;
                block53: {
                    Object object;
                    int n;
                    block52: {
                        block51: {
                            int n2;
                            block50: {
                                Object object2;
                                block49: {
                                    int n3;
                                    block48: {
                                        block47: {
                                            int n4;
                                            block46: {
                                                block45: {
                                                    int n5;
                                                    block44: {
                                                        block43: {
                                                            int n6;
                                                            block42: {
                                                                Notification notification2;
                                                                block41: {
                                                                    block38: {
                                                                        NotificationIcon notificationIcon2;
                                                                        Object object3;
                                                                        block40: {
                                                                            int n7;
                                                                            block39: {
                                                                                block37: {
                                                                                    int n8;
                                                                                    block36: {
                                                                                        roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Notification WHERE sourceUniqueId = ?", (int)1);
                                                                                        n8 = 1;
                                                                                        if (string2 == null) {
                                                                                            roomSQLiteQuery.bindNull(n8);
                                                                                        } else {
                                                                                            roomSQLiteQuery.bindString(n8, string2);
                                                                                        }
                                                                                        NotificationDao_Impl notificationDao_Impl = object;
                                                                                        notificationDao_Impl.__db.assertNotSuspendingTransaction();
                                                                                        string2 = DBUtil.query((RoomDatabase)notificationDao_Impl.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                                                        try {
                                                                                            n8 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"id");
                                                                                        }
                                                                                        catch (Throwable throwable) {
                                                                                            string2.close();
                                                                                            roomSQLiteQuery.release();
                                                                                            throw throwable;
                                                                                        }
                                                                                        n6 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"title");
                                                                                        n5 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"description");
                                                                                        n4 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"type");
                                                                                        n3 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"date");
                                                                                        n2 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"sourceUniqueId");
                                                                                        n = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"dataJson");
                                                                                        n7 = CursorUtil.getColumnIndexOrThrow((Cursor)string2, (String)"meta");
                                                                                        if (!string2.moveToFirst()) break block35;
                                                                                        if (!string2.isNull(n8)) break block36;
                                                                                        object2 = null;
                                                                                        break block37;
                                                                                    }
                                                                                    object2 = string2.getLong(n8);
                                                                                }
                                                                                if (string2.isNull(n7)) break block38;
                                                                                if (!string2.isNull(n7)) break block39;
                                                                                object3 = null;
                                                                                break block40;
                                                                            }
                                                                            object3 = string2.getString(n7);
                                                                        }
                                                                        object3 = ((NotificationDao_Impl)object).__converters.stringToStringMap((String)object3);
                                                                        if (object3 == null) throw new IllegalStateException("Expected non-null java.util.Map<java.lang.String, java.lang.String>, but it was null.");
                                                                        notificationIcon = notificationIcon2;
                                                                        notificationIcon2 = new NotificationIcon((Map<String, String>)object3);
                                                                        break block41;
                                                                    }
                                                                    notificationIcon = null;
                                                                }
                                                                String string3 = string2;
                                                                int n9 = n6;
                                                                notification = notification2;
                                                                notification2 = new Notification((Long)object2);
                                                                if (!string3.isNull(n9)) break block42;
                                                                object2 = null;
                                                                break block43;
                                                            }
                                                            object2 = string2.getString(n6);
                                                        }
                                                        notification.setTitle((String)object2);
                                                        if (!string2.isNull(n5)) break block44;
                                                        object2 = null;
                                                        break block45;
                                                    }
                                                    object2 = string2.getString(n5);
                                                }
                                                notification.setDescription((String)object2);
                                                if (!string2.isNull(n4)) break block46;
                                                object2 = null;
                                                break block47;
                                            }
                                            object2 = string2.getString(n4);
                                        }
                                        notification.setType(((NotificationDao_Impl)object).__converters.stringToNotificationType((String)object2));
                                        if (!string2.isNull(n3)) break block48;
                                        object2 = null;
                                        break block49;
                                    }
                                    object2 = string2.getLong(n3);
                                }
                                object = ((NotificationDao_Impl)object).__converters.timestampToDate((Long)object2);
                                if (object == null) throw new IllegalStateException("Expected non-null java.util.Date, but it was null.");
                                notification.setDate((Date)object);
                                if (!string2.isNull(n2)) break block50;
                                object = null;
                                break block51;
                            }
                            object = string2.getString(n2);
                        }
                        notification.setSourceUniqueId((String)object);
                        if (!string2.isNull(n)) break block52;
                        object = null;
                        break block53;
                    }
                    object = string2.getString(n);
                }
                Notification notification3 = notification;
                notification3.setDataJson((String)object);
                notification3.setNotificationIcon(notificationIcon);
                break block54;
            }
            notification = null;
        }
        string2.close();
        roomSQLiteQuery.release();
        return notification;
    }

    @Override
    public void deleteNotificationsByType(List<? extends NotificationType> object) {
        Object object2 = object;
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("DELETE FROM Notification WHERE type in (");
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)object.size());
        stringBuilder.append(")");
        object = stringBuilder.toString();
        object = notificationDao_Impl.__db.compileStatement((String)object);
        int n = 1;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            NotificationType notificationType = (NotificationType)((Object)iterator.next());
            String object22 = this.__converters.notificationTypeToString(notificationType);
            if (object22 == null) {
                object.bindNull(n);
            } else {
                object.bindString(n, object22);
            }
            ++n;
        }
        NotificationDao_Impl notificationDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            object.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl2.__db.setTransactionSuccessful();
        notificationDao_Impl2.__db.endTransaction();
    }

    @Override
    public void deleteAllNotifications() {
        NotificationDao.DefaultImpls.deleteAllNotifications(this);
    }
}

