/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemStatisticsScheduleBinding;
import io.streamlayer.sdk.model.sports.EventSchedule;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.baseball.BaseballEventScore;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\f\u001a\u00020\bH\u0016J\u001c\u0010\r\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0014\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter$ViewHolder;", "()V", "items", "", "Lio/streamlayer/sdk/model/sports/EventSchedule;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "listItems", "", "ViewHolder", "sdk_originalVonageRelease"})
public final class BaseballScoresAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private final List<EventSchedule> items;

    public BaseballScoresAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    public final void setItems(@NotNull List<EventSchedule> list2) {
        BaseballScoresAdapter baseballScoresAdapter = this;
        Intrinsics.checkNotNullParameter(list2, (String)"listItems");
        baseballScoresAdapter.items.clear();
        baseballScoresAdapter.items.addAll(list2);
        baseballScoresAdapter.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        BaseballScoresAdapter baseballScoresAdapter = object;
        Object object = SlrItemStatisticsScheduleBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return baseballScoresAdapter.new ViewHolder((SlrItemStatisticsScheduleBinding)object);
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        viewHolder.bind(this.items.get(n));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemStatisticsScheduleBinding;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;Lio/streamlayer/sdk/databinding/SlrItemStatisticsScheduleBinding;)V", "bind", "", "data", "Lio/streamlayer/sdk/model/sports/EventSchedule;", "sdk_originalVonageRelease"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemStatisticsScheduleBinding binding;

        public ViewHolder(SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsScheduleBinding, (String)"binding");
            super((View)slrItemStatisticsScheduleBinding.getRoot());
            this.binding = slrItemStatisticsScheduleBinding;
        }

        public final void bind(@NotNull EventSchedule object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"data");
            SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding = ((ViewHolder)((Object)slrItemStatisticsScheduleBinding)).binding;
            EventTeam eventTeam = ((EventSchedule)object).getEventSummary().getHomeTeam();
            ImageView imageView2 = slrItemStatisticsScheduleBinding.slScheduleTeamHomeLogo;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slScheduleTeamHomeLogo");
            ViewExtensionsKt.loadUrl$default(imageView2, eventTeam.getLogo(), false, null, null, 12, null);
            slrItemStatisticsScheduleBinding.slScheduleTeamHomeName.setText((CharSequence)eventTeam.getName());
            Object object2 = slrItemStatisticsScheduleBinding.slScheduleTeamHomePointer;
            int n = eventTeam.isWinner() ? 0 : 4;
            SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding2 = slrItemStatisticsScheduleBinding;
            object2.setVisibility(n);
            EventTeam eventTeam2 = ((EventSchedule)object).getEventSummary().getAwayTeam();
            ImageView imageView3 = slrItemStatisticsScheduleBinding2.slScheduleTeamAwayLogo;
            Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"slScheduleTeamAwayLogo");
            ViewExtensionsKt.loadUrl$default(imageView3, eventTeam2.getLogo(), false, null, null, 12, null);
            slrItemStatisticsScheduleBinding2.slScheduleTeamAwayName.setText((CharSequence)eventTeam2.getName());
            object2 = slrItemStatisticsScheduleBinding2.slScheduleTeamAwayPointer;
            int n2 = eventTeam2.isWinner() ? 0 : 4;
            object2.setVisibility(n2);
            Object object3 = ((EventSchedule)object).getEventSummary();
            object2 = EventStatus.Overtime;
            if (((EventSummary)object3).getStatus() == object2) {
                SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding3 = slrItemStatisticsScheduleBinding;
                slrItemStatisticsScheduleBinding3.slScheduleExtraBottom.setVisibility(8);
                slrItemStatisticsScheduleBinding3.slScheduleExtraTop.setText(R.string.slr_statistics_scores_final);
            } else {
                slrItemStatisticsScheduleBinding.slScheduleExtraBottom.setVisibility(0);
            }
            TextView textView = slrItemStatisticsScheduleBinding.slScheduleExtraBottom;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slScheduleExtraBottom");
            boolean bl = ((EventSummary)object3).getStatus() != object2;
            ViewExtensionsKt.visibleIf((View)textView, bl);
            if (((EventSummary)object3).getStatus() == EventStatus.Postgame) {
                object3 = ((EventSchedule)object).getBaseballEventScore();
                if (object3 != null) {
                    Object object4 = object3;
                    object3 = ((BaseballEventScore)object3).getHomeTeamRecord();
                    object3 = ((TeamRecord)object3).getWins() + "-" + ((TeamRecord)object3).getLosses();
                    TextView textView2 = slrItemStatisticsScheduleBinding.slScheduleTeamHomePoints;
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"slScheduleTeamHomePoints");
                    textView2.setText((CharSequence)object3);
                    object3 = ((BaseballEventScore)object4).getAwayTeamRecord();
                    object3 = ((TeamRecord)object3).getWins() + "-" + ((TeamRecord)object3).getLosses();
                    TextView textView3 = slrItemStatisticsScheduleBinding.slScheduleTeamAwayPoints;
                    Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"slScheduleTeamAwayPoints");
                    textView3.setText((CharSequence)object3);
                }
            } else {
                SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding4 = slrItemStatisticsScheduleBinding;
                slrItemStatisticsScheduleBinding4.slScheduleTeamHomePoints.setText((CharSequence)String.valueOf(((EventSummary)object3).getHomeScore()));
                slrItemStatisticsScheduleBinding4.slScheduleTeamAwayPoints.setText((CharSequence)String.valueOf(((EventSummary)object3).getAwayScore()));
            }
            if ((object3 = ((EventSchedule)object).getBaseballEventScore()) != null) {
                if (((BaseballEventScore)object3).getDelayed()) {
                    SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding5 = slrItemStatisticsScheduleBinding;
                    slrItemStatisticsScheduleBinding5.slScheduleExtraTop.setText((CharSequence)((BaseballEventScore)object3).getReasonForDelay());
                    slrItemStatisticsScheduleBinding5.slScheduleExtraTop.setBackgroundResource(R.drawable.slr_shape_rect_rounded_2);
                    slrItemStatisticsScheduleBinding5.slScheduleExtraTop.setBackgroundTintList(ContextCompat.getColorStateList((Context)slrItemStatisticsScheduleBinding.getRoot().getContext(), (int)R.color.slr_red700));
                } else {
                    slrItemStatisticsScheduleBinding.slScheduleExtraTop.setBackground(null);
                    object = ((BaseballEventScore)object3).getInningDivision() + " " + ((EventSchedule)object).getEventSummary().getEventTime().getPeriod();
                    TextView textView4 = slrItemStatisticsScheduleBinding.slScheduleExtraTop;
                    Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"slScheduleExtraTop");
                    textView4.setText((CharSequence)object);
                }
                SlrItemStatisticsScheduleBinding slrItemStatisticsScheduleBinding6 = slrItemStatisticsScheduleBinding;
                slrItemStatisticsScheduleBinding6.slScheduleExtraBottom.setText((CharSequence)slrItemStatisticsScheduleBinding.getRoot().getContext().getString(R.string.slr_statistics_scores_outs, new Object[]{((BaseballEventScore)object3).getOuts()}));
                ImageView imageView4 = slrItemStatisticsScheduleBinding6.slScheduleSportIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView4, (String)"slScheduleSportIcon");
                CoilExtensionsKt.dispose$default(imageView4, null, 1, null);
                if (((BaseballEventScore)object3).getTakenBases() >= 3) {
                    slrItemStatisticsScheduleBinding.slScheduleSportIcon.setImageResource(R.drawable.slr_ic_baseball_bases_3);
                } else if (((BaseballEventScore)object3).getTakenBases() == 2) {
                    slrItemStatisticsScheduleBinding.slScheduleSportIcon.setImageResource(R.drawable.slr_ic_baseball_bases_2);
                } else if (((BaseballEventScore)object3).getTakenBases() == 1) {
                    slrItemStatisticsScheduleBinding.slScheduleSportIcon.setImageResource(R.drawable.slr_ic_baseball_bases_1);
                } else {
                    slrItemStatisticsScheduleBinding.slScheduleSportIcon.setImageDrawable(null);
                }
            }
        }
    }
}

