/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common.model;

import com.streamlayer.sports.events.ScheduleResponseData;
import io.streamlayer.common.utils.DateUtil;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventsKt;
import io.streamlayer.sdk.statistics.common.model.GameStatus;
import io.streamlayer.sdk.statistics.common.model.ScoreGame;
import io.streamlayer.sdk.statistics.common.model.ScoreGameStatus;
import io.streamlayer.sdk.statistics.common.model.ScoresScheduleDate;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u00a8\u0006\n"}, d2={"toDomainScore", "Lio/streamlayer/sdk/statistics/common/model/ScoreGame;", "Lcom/streamlayer/sports/events/ScheduleResponseData;", "Lio/streamlayer/sdk/model/sports/EventScheduleProto;", "toGameStatus", "Lio/streamlayer/sdk/statistics/common/model/ScoreGameStatus;", "Lio/streamlayer/sdk/model/sports/EventStatus;", "toScoresScheduleDate", "Lio/streamlayer/sdk/statistics/common/model/ScoresScheduleDate;", "", "sdk_originalVonageRelease"})
public final class ModelsKt {
    @NotNull
    public static final ScoresScheduleDate toScoresScheduleDate(@NotNull String object) {
        ScoresScheduleDate scoresScheduleDate;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        DateUtil dateUtil = DateUtil.INSTANCE;
        Cloneable cloneable = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)cloneable, (String)"getTimeZone(\"GMT\")");
        cloneable = dateUtil.fromString((String)object, (TimeZone)cloneable);
        object = DateUtil.fromString$default(dateUtil, (String)object, null, 2, null);
        String string2 = ScoresScheduleDate.Companion.getScoresGameSDF().format((Date)cloneable);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ScoresScheduleDate.scoresGameSDF.format(localDate)");
        List list2 = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        String string3 = (String)list2.get(0);
        String string4 = (String)list2.get(1);
        long l = cloneable != null ? ((Date)cloneable).getTime() : 0L;
        object = dateUtil.getRequestDateFormat().format((Date)object).toString();
        if (cloneable == null) {
            Date date;
            cloneable = date;
            date = new Date();
        }
        ScoresScheduleDate scoresScheduleDate2 = scoresScheduleDate;
        scoresScheduleDate2(string3, string4, l, (String)object, (Date)cloneable, false);
        return scoresScheduleDate2;
    }

    @NotNull
    public static final ScoreGame toDomainScore(@NotNull ScheduleResponseData object) {
        ScheduleResponseData scheduleResponseData = object;
        Intrinsics.checkNotNullParameter((Object)scheduleResponseData, (String)"<this>");
        String string2 = scheduleResponseData.getAttributes().getSummary().getLeague();
        String string3 = scheduleResponseData.getAttributes().getSummary().getHomeTeam().getName();
        String string4 = scheduleResponseData.getAttributes().getSummary().getHomeTeam().getLogo();
        String string5 = scheduleResponseData.getAttributes().getSummary().getAwayTeam().getName();
        String string6 = scheduleResponseData.getAttributes().getSummary().getAwayTeam().getLogo();
        int n = scheduleResponseData.getAttributes().getSummary().getScoreHome();
        int n2 = scheduleResponseData.getAttributes().getSummary().getScoreAway();
        com.streamlayer.sports.common.EventStatus eventStatus = scheduleResponseData.getAttributes().getSummary().getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)eventStatus, (String)"attributes.summary.status");
        ScoreGameStatus scoreGameStatus = ModelsKt.toGameStatus(EventsKt.toDomain(eventStatus));
        String string7 = null;
        DateUtil dateUtil = DateUtil.INSTANCE;
        String string8 = object.getAttributes().getSummary().getScheduled();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attributes.summary.scheduled");
        object = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTimeZone(\"GMT\")");
        object = dateUtil.fromString(string8, (TimeZone)object);
        if (object == null) {
            Date date;
            object = date;
            date = new Date(0L);
        }
        object = dateUtil.toShort((Date)object);
        GameStatus gameStatus = new GameStatus(scoreGameStatus, string7, (String)object);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"league");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"logo");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"logo");
        return new ScoreGame(string2, string3, string5, string4, string6, n, n2, gameStatus);
    }

    private static final ScoreGameStatus toGameStatus(EventStatus eventStatus) {
        ScoreGameStatus scoreGameStatus;
        switch (WhenMappings.$EnumSwitchMapping$0[eventStatus.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 8: {
                scoreGameStatus = null;
                break;
            }
            case 6: 
            case 7: {
                scoreGameStatus = ScoreGameStatus.PASSED;
                break;
            }
            case 4: 
            case 5: {
                scoreGameStatus = ScoreGameStatus.INCOMING;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                scoreGameStatus = ScoreGameStatus.LIVE;
            }
        }
        return scoreGameStatus;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventStatus.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[EventStatus.Shootouts.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Overtime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Active.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Break.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Pregame.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Postgame.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Cancelled.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[EventStatus.Unset.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

