/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.SLRVideoPlayerView;
import io.streamlayer.sdk.databinding.SlrItemTweetBinding;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.twitter.Input;
import io.streamlayer.sdk.twitter.TweetLocation;
import io.streamlayer.sdk.twitter.TweetUI;
import io.streamlayer.sdk.twitter.view.TweetBaseView;
import io.streamlayer.sdk.twitter.view.TweetView;
import io.streamlayer.sdk.twitter.view.internal.format.TweetFormatter;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoController;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002+,B\u008f\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012%\u0010\u0007\u001a!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bj\u0002`\u000e\u0012#\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\b\u0012\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0014\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dJ\u001c\u0010\"\u001a\u00020\r2\n\u0010#\u001a\u00060\u0002R\u00020\u00002\u0006\u0010$\u001a\u00020\u001dH\u0016J\u001c\u0010%\u001a\u00060\u0002R\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001dH\u0016J\u0014\u0010)\u001a\u00020\r2\n\u0010#\u001a\u00060\u0002R\u00020\u0000H\u0016J\u0014\u0010*\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fR-\u0010\u0007\u001a!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;", "tweetFormatter", "Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;", "tweetVideoController", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;", "interactionListener", "Lkotlin/Function1;", "Lio/streamlayer/sdk/model/analytics/InteractionActionType;", "Lkotlin/ParameterName;", "name", "actionType", "", "Lio/streamlayer/sdk/repository/analytics/InteractionListener;", "videoPlayerViewBuilder", "Landroid/content/Context;", "context", "Lio/streamlayer/sdk/SLRVideoPlayerView;", "showPopup", "Lkotlin/Function2;", "Lio/streamlayer/sdk/twitter/TweetUI;", "Lio/streamlayer/sdk/twitter/TweetLocation;", "showPhotoFullScreen", "Lio/streamlayer/sdk/twitter/Input;", "(Lio/streamlayer/sdk/twitter/view/internal/format/TweetFormatter;Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoController;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "items", "", "getItemCount", "", "getItems", "", "startPosition", "endPosition", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "setItems", "TweetsDiffUtil", "ViewHolder", "sdk_originalVonageRelease"})
public final class TweetsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private final TweetFormatter tweetFormatter;
    @NotNull
    private final TweetVideoController tweetVideoController;
    @NotNull
    private final Function1<InteractionActionType, Unit> interactionListener;
    @NotNull
    private final Function1<Context, SLRVideoPlayerView> videoPlayerViewBuilder;
    @NotNull
    private final Function2<TweetUI, TweetLocation, Unit> showPopup;
    @NotNull
    private final Function1<Input, Unit> showPhotoFullScreen;
    @NotNull
    private final List<TweetUI> items;

    public TweetsAdapter(@NotNull TweetFormatter tweetFormatter, @NotNull TweetVideoController tweetVideoController2, @NotNull Function1<? super InteractionActionType, Unit> function1, @NotNull Function1<? super Context, ? extends SLRVideoPlayerView> function12, @NotNull Function2<? super TweetUI, ? super TweetLocation, Unit> function2, @NotNull Function1<? super Input, Unit> function13) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)tweetFormatter, (String)"tweetFormatter");
        Intrinsics.checkNotNullParameter((Object)tweetVideoController2, (String)"tweetVideoController");
        Intrinsics.checkNotNullParameter(function1, (String)"interactionListener");
        Intrinsics.checkNotNullParameter(function12, (String)"videoPlayerViewBuilder");
        Intrinsics.checkNotNullParameter(function2, (String)"showPopup");
        Intrinsics.checkNotNullParameter(function13, (String)"showPhotoFullScreen");
        object.tweetFormatter = tweetFormatter;
        object.tweetVideoController = tweetVideoController2;
        object.interactionListener = function1;
        object.videoPlayerViewBuilder = function12;
        object.showPopup = function2;
        object.showPhotoFullScreen = function13;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        TweetsAdapter tweetsAdapter2 = object;
        Object object = SlrItemTweetBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return tweetsAdapter2.new ViewHolder((SlrItemTweetBinding)object);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        viewHolder.bind(this.items.get(n));
    }

    public void onViewRecycled(@NotNull ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)viewHolder);
        viewHolder.release();
    }

    public final void setItems(@NotNull List<TweetUI> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"items");
        TweetsAdapter tweetsAdapter2 = this;
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)tweetsAdapter2.new TweetsDiffUtil(tweetsAdapter2.items, list2));
        TweetsAdapter tweetsAdapter3 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(TweetsDiffUtil(this.items, items))");
        tweetsAdapter3.items.clear();
        tweetsAdapter3.items.addAll(list2);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)tweetsAdapter3);
    }

    @NotNull
    public final List<TweetUI> getItems(int n, int n2) {
        return n >= 0 && n < this.items.size() && n2 <= this.items.size() ? this.items.subList(n, n2) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemTweetBinding;", "(Lio/streamlayer/sdk/twitter/TweetsAdapter;Lio/streamlayer/sdk/databinding/SlrItemTweetBinding;)V", "bind", "", "item", "Lio/streamlayer/sdk/twitter/TweetUI;", "release", "sdk_originalVonageRelease"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemTweetBinding binding;

        public ViewHolder(SlrItemTweetBinding slrItemTweetBinding) {
            Intrinsics.checkNotNullParameter((Object)slrItemTweetBinding, (String)"binding");
            super((View)slrItemTweetBinding.getRoot());
            ((ViewHolder)((Object)tweetView)).binding = slrItemTweetBinding;
            TweetView tweetView = slrItemTweetBinding.getRoot();
            tweetView.setInteractionListener((Function1<? super InteractionActionType, Unit>)((ViewHolder)((Object)tweetView)).TweetsAdapter.this.interactionListener);
            tweetView.setVideoController(((ViewHolder)((Object)tweetView)).TweetsAdapter.this.tweetVideoController);
            tweetView.setVideoPlayerViewBuilder((Function1<? super Context, ? extends SLRVideoPlayerView>)((ViewHolder)((Object)tweetView)).TweetsAdapter.this.videoPlayerViewBuilder);
            Context context = tweetView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (!OtherExtensionsKt.isScreenPortrait(context)) {
                TweetView tweetView2 = tweetView;
                tweetView2.setBackground(ContextCompat.getDrawable((Context)tweetView2.getContext(), (int)R.drawable.slr_shape_rect_rounded_8));
                tweetView2.setBackgroundTintList(ContextCompat.getColorStateList((Context)tweetView2.getContext(), (int)R.color.slr_tweet_bg_landscape));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView2), (String)"_init_$lambda$0");
                int n = ViewExtensionsKt.getDp(8.0f);
                tweetView2.setPadding(n, n, n, n);
            } else {
                TweetView tweetView3 = tweetView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView3), (String)"_init_$lambda$0");
                int n = ViewExtensionsKt.getDp(16.0f);
                tweetView3.setPadding(n, n, n, n);
            }
            tweetView.setShowPhotoFullScreen((Function1<? super Input, Unit>)((ViewHolder)((Object)tweetView)).TweetsAdapter.this.showPhotoFullScreen);
        }

        private static final void bind$lambda$1(TweetsAdapter tweetsAdapter2, TweetUI tweetUI, ViewHolder viewHolder, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)tweetsAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)tweetUI, (String)"$item");
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"this$1");
            tweetsAdapter2.showPopup.invoke((Object)tweetUI, (Object)viewHolder.binding.getRoot().getTweetLocation());
        }

        public final void bind(@NotNull TweetUI tweetUI) {
            ViewHolder viewHolder = this;
            Intrinsics.checkNotNullParameter((Object)tweetUI, (String)"item");
            TweetView tweetView = viewHolder.binding.getRoot();
            Object object = tweetView;
            TweetUI tweetUI2 = tweetUI;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.root");
            object = tweetUI2.getTweet();
            TweetVideo tweetVideo = tweetUI2.getVideo();
            TweetBaseView.showTweet$default(tweetView, (Tweet)object, tweetVideo, TweetsAdapter.this.tweetFormatter, null, 8, null);
            viewHolder.binding.getRoot().setOnClickListener(arg_0 -> ViewHolder.bind$lambda$1(TweetsAdapter.this, tweetUI, this, arg_0));
        }

        public final void release() {
            this.binding.getRoot().release();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/twitter/TweetsAdapter$TweetsDiffUtil;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lio/streamlayer/sdk/twitter/TweetUI;", "newItems", "(Lio/streamlayer/sdk/twitter/TweetsAdapter;Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_originalVonageRelease"})
    public final class TweetsDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<TweetUI> oldItems;
        @NotNull
        private final List<TweetUI> newItems;

        public TweetsDiffUtil(@NotNull List<TweetUI> list2, List<TweetUI> list3) {
            Intrinsics.checkNotNullParameter(list2, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list3, (String)"newItems");
            this.oldItems = list2;
            this.newItems = list3;
        }

        public boolean areItemsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI)).newItems.get(n2);
            return Intrinsics.areEqual((Object)((TweetsDiffUtil)((Object)tweetUI)).oldItems.get(n).getTweet().getId(), (Object)tweetUI.getTweet().getId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI2)).oldItems.get(n);
            TweetUI tweetUI2 = ((TweetsDiffUtil)((Object)tweetUI2)).newItems.get(n2);
            return Intrinsics.areEqual((Object)tweetUI.getTweet(), (Object)tweetUI2.getTweet()) && Intrinsics.areEqual((Object)tweetUI.getVideo(), (Object)tweetUI2.getVideo());
        }
    }
}

