/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.contentprovider;

import android.content.Context;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.SparseArray;
import androidx.annotation.RequiresPermission;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import io.streamlayer.common.data.contentprovider.ContactsProvider;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.contact.PhoneContact;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/Session;", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;)V", "fetchContacts", "", "Lio/streamlayer/sdk/model/contact/PhoneContact;", "Companion", "sdk_originalVonageRelease"})
public final class ContactsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] projection = new String[]{"mimetype", "contact_id", "display_name", "photo_uri", "starred", "account_type", "data1", "data2", "contact_last_updated_timestamp"};
    @NotNull
    private static final String selection = "mimetype in (?, ?) AND has_phone_number = '1'";
    @NotNull
    private static final String[] selectionArgs = new String[]{"vnd.android.cursor.item/email_v2", "vnd.android.cursor.item/phone_v2"};
    @NotNull
    private static final String sortOrder = "sort_key_alt";
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;

    public ContactsProvider(@NotNull Context context, @NotNull Session session2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.context = context;
        this.session = session2;
    }

    private static final int fetchContacts$lambda$1(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NotNull
    public final List<PhoneContact> fetchContacts() {
        SparseArray sparseArray;
        ArrayList<PhoneContact> arrayList;
        ArrayList<PhoneContact> arrayList2 = arrayList;
        arrayList = new ArrayList<PhoneContact>();
        Uri uri = ContactsContract.Data.CONTENT_URI;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"CONTENT_URI");
        uri = this.context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (uri == null) {
            return CollectionsKt.emptyList();
        }
        ContactsProvider contactsProvider = this;
        Uri uri2 = uri;
        int n = uri2.getColumnIndex("mimetype");
        int n2 = uri2.getColumnIndex("contact_id");
        int n3 = uri2.getColumnIndex("display_name");
        int n4 = uri2.getColumnIndex("data1");
        int n5 = uri2.getColumnIndex("photo_uri");
        int n6 = uri2.getColumnIndex("data2");
        int n7 = uri2.getColumnIndex("account_type");
        int n8 = uri2.getColumnIndex("contact_last_updated_timestamp");
        SparseArray sparseArray2 = sparseArray;
        sparseArray = new SparseArray();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Object object = contactsProvider.session.getUser();
        if (contactsProvider.session.isLoggedIn() && object != null && StringsKt.isBlank((CharSequence)((User)object).getUsername()) ^ true) {
            PhoneNumberUtil phoneNumberUtil2 = phoneNumberUtil;
            Object object2 = object;
            try {
                object = Result.constructor-impl((Object)phoneNumberUtil2.parse((CharSequence)("+" + ((User)object2).getUsername()), ""));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            object = (object = (Phonenumber.PhoneNumber)object) != null && phoneNumberUtil.isValidNumber((Phonenumber.PhoneNumber)object) ? phoneNumberUtil.getRegionCodeForCountryCode(object.getCountryCode()) : Locale.getDefault().getCountry();
        } else {
            object = Locale.getDefault().getCountry();
        }
        while (uri.moveToNext()) {
            List list2;
            String string2;
            Object object3;
            block16: {
                int n9 = uri.getInt(n2);
                object3 = uri.getString(n5);
                String string3 = uri.getString(n3);
                String string4 = uri.getString(n7);
                uri.getInt(n6);
                string2 = uri.getString(n4);
                long l = uri.getLong(n8);
                PhoneContact phoneContact = (PhoneContact)sparseArray2.get(n9);
                if (phoneContact == null) {
                    PhoneContact phoneContact2;
                    phoneContact = phoneContact2;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contactName");
                    phoneContact2 = new PhoneContact(n9, string3, (String)object3, string4, l, null, null, 96, null);
                    sparseArray2.put(n9, (Object)phoneContact);
                    arrayList2.add(phoneContact);
                } else if (l > phoneContact.getLocallyUpdatedAt()) {
                    phoneContact.setLocallyUpdatedAt(l);
                }
                PhoneContact phoneContact3 = phoneContact;
                List<String> list3 = phoneContact3.getPhoneNumbers();
                Intrinsics.checkNotNull(list3, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
                list2 = TypeIntrinsics.asMutableList(list3);
                List<String> list4 = phoneContact3.getEmails();
                Intrinsics.checkNotNull(list4, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
                object3 = TypeIntrinsics.asMutableList(list4);
                string3 = uri.getString(n);
                if (Intrinsics.areEqual((Object)string3, (Object)"vnd.android.cursor.item/email_v2")) {
                    String string5 = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"contactData");
                    object3.add(string5);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string3, (Object)"vnd.android.cursor.item/phone_v2")) continue;
                try {
                    PhoneNumberUtil phoneNumberUtil3 = phoneNumberUtil;
                    object3 = phoneNumberUtil3.parse((CharSequence)string2, (String)object);
                    if (!phoneNumberUtil3.isValidNumber((Phonenumber.PhoneNumber)object3)) break block16;
                }
                catch (NumberParseException numberParseException) {
                    String string6 = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"contactData");
                    object3 = (String)object + StringsKt.removePrefix((String)string6, (CharSequence)"0");
                    if (list2.contains(object3)) continue;
                    list2.add(object3);
                    continue;
                }
                if (list2.contains(object3 = phoneNumberUtil.format((Phonenumber.PhoneNumber)object3, PhoneNumberUtil.PhoneNumberFormat.E164))) continue;
                Object object4 = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"phoneE164");
                list2.add(object4);
                continue;
            }
            String string7 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"contactData");
            object3 = (String)object + StringsKt.removePrefix((String)string7, (CharSequence)"0");
            if (list2.contains(object3)) continue;
            list2.add(object3);
        }
        uri.close();
        try {
            CollectionsKt.sortWith(arrayList2, (arg_0, arg_1) -> ContactsProvider.fetchContacts$lambda$1(fetchContacts.1.INSTANCE, arg_0, arg_1));
        }
        catch (Throwable throwable) {
            SLRLog.INSTANCE.i("ContactsProvider", "sort phone contacts is failed: " + throwable.getLocalizedMessage());
        }
        return arrayList2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider$Companion;", "", "()V", "projection", "", "", "[Ljava/lang/String;", "selection", "selectionArgs", "sortOrder", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

