/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.data.workes.OnPushMessageWorker;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.JsonUtilKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0011J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/Session;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;)V", "clearNotifications", "", "topicId", "", "getNotificationTag", "id", "handlePushMessage", "data", "", "showSystemNotification", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "payload", "Lio/streamlayer/sdk/model/deeplink/Payload;", "groupKey", "updateSummary", "pendingIntent", "Landroid/app/PendingIntent;", "Companion", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nPushNotificationsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushNotificationsService.kt\nio/streamlayer/common/data/notifications/PushNotificationsService\n+ 2 JsonUtil.kt\nio/streamlayer/common/utils/JsonUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 6 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n+ 7 OneTimeWorkRequest.kt\nandroidx/work/OneTimeWorkRequestKt\n+ 8 Data.kt\nandroidx/work/DataKt\n*L\n1#1,200:1\n36#2,2:201\n38#2,6:207\n36#2,2:213\n38#2,6:219\n1#3:203\n1#3:215\n1#3:225\n123#4:204\n123#4:216\n32#5:205\n32#5:217\n80#6:206\n80#6:218\n29#7:226\n31#8,5:227\n*S KotlinDebug\n*F\n+ 1 PushNotificationsService.kt\nio/streamlayer/common/data/notifications/PushNotificationsService\n*L\n65#1:201,2\n65#1:207,6\n72#1:213,2\n72#1:219,6\n65#1:203\n72#1:215\n65#1:204\n72#1:216\n65#1:205\n72#1:217\n65#1:206\n72#1:218\n129#1:226\n131#1:227,5\n*E\n"})
public final class PushNotificationsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final MessagingRepo messagingRepo;

    public PushNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull MessagingRepo messagingRepo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)messagingRepo, (String)"messagingRepo");
        this.context = context;
        this.session = session2;
        this.messagingRepo = messagingRepo;
    }

    private final void showSystemNotification(Notification notification, Payload payload, String string2) {
        Long l = notification.getId();
        int n = l != null ? (int)l.longValue() : notification.hashCode();
        Context context = ((PushNotificationsService)((Object)string3)).context;
        DeepLinkRoute deepLinkRoute = DeepLinkRoute.MAIN;
        Uri uri = NotificationKt.deepLink(notification);
        payload = DeepLinkHandler.INSTANCE.buildDeepLinkIntent$sdk_originalVonageRelease(context, deepLinkRoute, uri, payload);
        int n2 = Build.VERSION.SDK_INT >= 31 ? 0xC000000 : 0x8000000;
        payload = PendingIntent.getActivity((Context)((PushNotificationsService)((Object)string3)).context, (int)n, (Intent)payload, (int)n2);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(((PushNotificationsService)((Object)string3)).context, "streamlayer_high").setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)((PushNotificationsService)((Object)string3)).context, (int)R.color.slr_push_color)).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, Notific\u2026notification.description)");
        if (payload != null) {
            builder.setContentIntent((PendingIntent)payload);
        }
        if (string2 != null) {
            builder.setGroup(((PushNotificationsService)((Object)string3)).context.getPackageName() + "." + string2);
        }
        PushNotificationsService pushNotificationsService = string3;
        pushNotificationsService.updateSummary(notification, string2, (PendingIntent)payload);
        String string3 = ((PushNotificationsService)((Object)string3)).getNotificationTag(NotificationUtilKt.fromMessageSourceId(notification.getSourceUniqueId()));
        notification = builder.build();
        NotificationManagerCompat.from((Context)pushNotificationsService.context).notify(string3, n, (android.app.Notification)notification);
    }

    static /* synthetic */ void showSystemNotification$default(PushNotificationsService pushNotificationsService, Notification notification, Payload payload, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            payload = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        pushNotificationsService.showSystemNotification(notification, payload, string2);
    }

    private final void updateSummary(Notification object, String string2, PendingIntent pendingIntent) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(pushNotificationsService2.context, "streamlayer_high").setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)pushNotificationsService2.context, (int)R.color.slr_push_color)).setGroupSummary(true).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)((Notification)object).getTitle()).setContentText((CharSequence)((Notification)object).getDescription()).setGroupAlertBehavior(2).setOnlyAlertOnce(true);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, Notific\u2026  .setOnlyAlertOnce(true)");
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (string2 != null) {
            builder.setGroup(pushNotificationsService2.context.getPackageName() + "." + string2);
        }
        PushNotificationsService pushNotificationsService = pushNotificationsService2;
        PushNotificationsService pushNotificationsService2 = NotificationManagerCompat.from((Context)pushNotificationsService2.context);
        object = pushNotificationsService.getNotificationTag(NotificationUtilKt.fromMessageSourceId(((Notification)object).getSourceUniqueId()));
        int n = string2 != null ? string2.hashCode() : 0;
        PushNotificationsService pushNotificationsService3 = pushNotificationsService2;
        pushNotificationsService2 = builder.build();
        pushNotificationsService3.notify((String)object, n, (android.app.Notification)pushNotificationsService2);
    }

    static /* synthetic */ void updateSummary$default(PushNotificationsService pushNotificationsService, Notification notification, String string2, PendingIntent pendingIntent, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        pushNotificationsService.updateSummary(notification, string2, pendingIntent);
    }

    private final String getNotificationTag(String string2) {
        return this.context.getPackageName() + "StreamLayer_" + string2;
    }

    public final void handlePushMessage(@NotNull Map<String, String> map2) {
        Data.Builder builder;
        OneTimeWorkRequest.Builder builder2;
        Object object;
        Pair[] pairArray;
        Object object2;
        Object object3;
        Object object4;
        block39: {
            block36: {
                block38: {
                    block37: {
                        Object object5;
                        block35: {
                            block32: {
                                block34: {
                                    block33: {
                                        Intrinsics.checkNotNullParameter(map2, (String)"data");
                                        if (!pushNotificationsService.session.isLoggedIn()) {
                                            return;
                                        }
                                        object4 = map2.get("category");
                                        if (!(Intrinsics.areEqual((Object)object4, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object4, (Object)"sl_watch_party"))) break block32;
                                        object3 = JsonUtilKt.getJson();
                                        object2 = map2.get("extra");
                                        if (object2 == null) break block33;
                                        Json json = object3;
                                        Json json2 = json;
                                        Json json3 = json;
                                        try {
                                            KSerializer kSerializer = SerializersKt.serializer((SerializersModule)json2.getSerializersModule(), (KType)Reflection.typeOf(ChatMessage.class));
                                            Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                                            object3 = Result.constructor-impl((Object)json3.decodeFromString((DeserializationStrategy)kSerializer, (String)object2));
                                        }
                                        catch (Throwable throwable) {
                                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                        }
                                        object5 = Result.exceptionOrNull-impl((Object)object3);
                                        if (object5 != null && object2.length() > 0) {
                                            SLRLog.INSTANCE.w("JsonUtil", "json parsing exception:  " + (String)object2);
                                            ((Throwable)object5).printStackTrace();
                                        }
                                        if (!Result.isFailure-impl((Object)object3)) break block34;
                                    }
                                    object3 = null;
                                }
                                object3 = (ChatMessage)object3;
                                break block35;
                            }
                            object3 = null;
                        }
                        if (!(Intrinsics.areEqual((Object)object4, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object4, (Object)"sl_watch_party"))) break block36;
                        object2 = JsonUtilKt.getJson();
                        object5 = map2.get("extra");
                        if (object5 == null) break block37;
                        String string2 = object2;
                        String string3 = string2;
                        String string4 = string2;
                        try {
                            KSerializer kSerializer = SerializersKt.serializer((SerializersModule)string3.getSerializersModule(), (KType)Reflection.typeOf(ChatMessageHeadPayload.class));
                            Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                            object2 = Result.constructor-impl((Object)string4.decodeFromString((DeserializationStrategy)kSerializer, (String)object5));
                        }
                        catch (Throwable throwable) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        pairArray = Result.exceptionOrNull-impl((Object)object2);
                        if (pairArray != null && object5.length() > 0) {
                            SLRLog.INSTANCE.w("JsonUtil", "json parsing exception:  " + (String)object5);
                            pairArray.printStackTrace();
                        }
                        if (!Result.isFailure-impl((Object)object2)) break block38;
                    }
                    object2 = null;
                }
                object2 = (ChatMessageHeadPayload)object2;
                break block39;
            }
            object2 = null;
        }
        object4 = Intrinsics.areEqual((Object)object4, (Object)"sl_chat") ? NotificationType.Chat : (Intrinsics.areEqual((Object)object4, (Object)"sl_watch_party") ? NotificationType.WatchParty : NotificationType.Unset);
        int n = object3 instanceof ChatMessage;
        if (n != 0) {
            pairArray = NotificationUtilKt.toNotification((ChatMessage)object3, (NotificationType)((Object)object4));
            object = WhenMappings.$EnumSwitchMapping$0[((Enum)object4).ordinal()] == 1 ? Long.valueOf((long)((ChatMessage)object3).getTopicId().hashCode() + (long)((ChatMessage)object3).getSeqId()) : Long.valueOf(((ChatMessage)object3).getTopicId().hashCode());
            pairArray.setId((Long)object);
        } else {
            Notification notification;
            pairArray = notification;
            notification = new Notification(null, null, null, (NotificationType)((Object)object4), null, null, null, null, 247, null);
        }
        if (object2 instanceof ChatMessageHeadPayload) {
            if (ChatMessageKt.isWave((ChatMessageHeadPayload)object2)) {
                Object object6 = object2;
                object = ((ChatMessageHeadPayload)object6).getHead();
                object = object != null ? ((ChatMessageHead)object).getEventId() : null;
                object2 = new Payload.Wave((String)object);
            } else {
                Payload.Notification notification;
                object2 = notification;
                notification = new Payload.Notification((NotificationType)((Object)object4), false, 2, null);
            }
        } else {
            object2 = null;
        }
        object = n != 0 ? ((ChatMessage)object3).getTopicId() : "general_group";
        Object object7 = map2.get("title");
        if (object7 != null) {
            pairArray.setTitle((String)object7);
        }
        if ((object7 = map2.get("body")) != null) {
            pairArray.setDescription((String)object7);
        }
        object7 = SLRLog.INSTANCE;
        ((SLRLog)object7).i("PushNotificationsService", "handlePush " + map2);
        if (n != 0 && object4 == NotificationType.Chat) {
            if (TopicKt.isP2PTopic(((ChatMessage)object3).getTopicId())) {
                return;
            }
            if (TopicKt.isGroupTopic(((ChatMessage)object3).getTopicId()) && ((ChatMessage)object3).getSeqId() == 0) {
                return;
            }
            map2 = ((ChatMessage)object3).getHead();
            if (map2 != null && map2.containsKey("x-slr-subtype")) {
                map2 = ((ChatMessage)object3).getHead();
                map2 = map2 != null ? map2.get("x-slr-subtype") : null;
                if (Intrinsics.areEqual(map2, (Object)"left_chat")) {
                    pairArray.setDescription(pushNotificationsService.context.getString(R.string.slr_chat_user_left, new Object[]{pairArray.getTitle()}));
                } else if (Intrinsics.areEqual((Object)map2, (Object)"join_chat")) {
                    pairArray.setDescription(pushNotificationsService.context.getString(R.string.slr_chat_user_joined, new Object[]{pairArray.getTitle()}));
                }
            }
        }
        NotificationUtil notificationUtil = NotificationUtil.INSTANCE;
        boolean bl = notificationUtil.isAppInForeground();
        boolean bl2 = notificationUtil.isNotificationEnabled$sdk_originalVonageRelease(pushNotificationsService.session, (Notification)pairArray) && !bl;
        Boolean bl3 = pushNotificationsService.messagingRepo.isTopicMuted((String)object);
        boolean bl4 = bl3 != null ? bl3 : false;
        ((SLRLog)object7).i("PushNotificationsService", "isMuted " + bl4);
        if (bl2 && !bl4) {
            pushNotificationsService.showSystemNotification((Notification)pairArray, (Payload)object2, (String)object);
        }
        int n2 = n;
        PushNotificationsService pushNotificationsService = WorkManager.getInstance((Context)pushNotificationsService.context);
        object2 = builder2;
        builder2 = new OneTimeWorkRequest.Builder(OnPushMessageWorker.class);
        n = 4;
        Pair[] pairArray2 = new Pair[4];
        pairArray = pairArray2;
        pairArray[0] = TuplesKt.to((Object)"need_send_analytics", (Object)bl2);
        pairArray2[1] = TuplesKt.to((Object)"notification_type", (Object)((Enum)object4).name());
        int n3 = 2;
        object = "topic_id";
        object3 = n2 != 0 ? ((ChatMessage)object3).getTopicId() : null;
        pairArray[n3] = TuplesKt.to((Object)object, (Object)object3);
        pairArray[3] = TuplesKt.to((Object)"is_app_in_foreground", (Object)bl);
        Data.Builder builder3 = builder;
        builder = new Data.Builder();
        for (n3 = 0; n3 < n; ++n3) {
            Pair pair = pairArray[n3];
            object3 = (String)pair.getFirst();
            builder3.put((String)object3, pair.getSecond());
        }
        Object object8 = object2;
        Data data = builder3.build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
        object8.setInputData(data);
        pushNotificationsService.enqueue(object8.build());
    }

    public final void clearNotifications(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        String string3 = ((PushNotificationsService)((Object)string3)).getNotificationTag(string2);
        NotificationManagerCompat.from((Context)((PushNotificationsService)((Object)string3)).context).cancel(string3, string2.hashCode());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[NotificationType.Chat.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService$Companion;", "", "()V", "isStreamLayerPush", "", "data", "", "", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean isStreamLayerPush(@NotNull Map<String, String> map2) {
            Map<String, String> map3 = map2;
            Intrinsics.checkNotNullParameter(map3, (String)"data");
            return map3.containsKey("category") && ArraysKt.contains((Object[])new String[]{"sl_chat", "sl_watch_party"}, (Object)map2.get("category"));
        }
    }
}

