/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.video;

import android.content.Context;
import android.view.View;
import com.opentok.android.AudioDeviceManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.OpenTokConfig;
import com.opentok.android.OpentokError;
import com.opentok.android.Publisher;
import com.opentok.android.PublisherKit;
import com.opentok.android.Session;
import com.opentok.android.Stream;
import com.opentok.android.Subscriber;
import com.opentok.android.SubscriberKit;
import com.opentok.android.TextureVideoRendererFactoryKt;
import com.opentok.android.VideoUtils;
import com.streamlayer.providers.vonage.GenerateRequest;
import com.streamlayer.providers.vonage.GenerateResponse;
import com.streamlayer.providers.vonage.VonageProviderGrpc;
import io.grpc.CallOptions;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusException;
import io.streamlayer.common.data.grpc.GrpcExtensionsKt;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.video.ConnectionData;
import io.streamlayer.common.data.video.VideoCall;
import io.streamlayer.common.data.video.VideoCallProvider;
import io.streamlayer.common.data.video.VideoCallProviderImpl;
import io.streamlayer.common.data.video.VideoQuality;
import io.streamlayer.common.data.video.VideoRenderer;
import io.streamlayer.common.data.video.vonage.SlAdvancedAudioDevice;
import io.streamlayer.common.dispatcher.CoroutineDispatcherProvider;
import io.streamlayer.common.extensions.ResultExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.JsonUtilKt;
import io.streamlayer.common.utils.PermissionsUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KType;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0018\u00010\u000fR\u00020\u0000H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl;", "Lio/streamlayer/common/data/video/VideoCallProvider;", "context", "Landroid/content/Context;", "slSession", "Lio/streamlayer/common/session/Session;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "dispatcherProvider", "Lio/streamlayer/common/dispatcher/CoroutineDispatcherProvider;", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/common/data/grpc/GrpcService;Lio/streamlayer/common/dispatcher/CoroutineDispatcherProvider;)V", "audioDevice", "Lio/streamlayer/common/data/video/vonage/SlAdvancedAudioDevice;", "videoCalls", "", "Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;", "create", "Lio/streamlayer/common/data/video/VideoCall;", "disconnect", "", "disconnectCalls", "callToIgnore", "release", "call", "tryConnect", "Lio/streamlayer/common/data/video/VideoCall$ConnectAttempt;", "topicId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "VonageVideoCall", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nVonageVideoCallApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VonageVideoCallApi.kt\nio/streamlayer/common/data/video/VideoCallProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1855#2,2:458\n*S KotlinDebug\n*F\n+ 1 VonageVideoCallApi.kt\nio/streamlayer/common/data/video/VideoCallProviderImpl\n*L\n83#1:458,2\n*E\n"})
public final class VideoCallProviderImpl
implements VideoCallProvider {
    @NotNull
    private final Context context;
    @NotNull
    private final io.streamlayer.common.session.Session slSession;
    @NotNull
    private final GrpcService grpcService;
    @NotNull
    private final CoroutineDispatcherProvider dispatcherProvider;
    @NotNull
    private final List<VonageVideoCall> videoCalls;
    @NotNull
    private final SlAdvancedAudioDevice audioDevice;

    public VideoCallProviderImpl(@NotNull Context context, @NotNull io.streamlayer.common.session.Session session2, @NotNull GrpcService grpcService, @NotNull CoroutineDispatcherProvider coroutineDispatcherProvider) {
        SlAdvancedAudioDevice slAdvancedAudioDevice;
        VideoCallProviderImpl videoCallProviderImpl = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"slSession");
        Intrinsics.checkNotNullParameter((Object)grpcService, (String)"grpcService");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcherProvider, (String)"dispatcherProvider");
        object.context = context;
        object.slSession = session2;
        object.grpcService = grpcService;
        videoCallProviderImpl.dispatcherProvider = coroutineDispatcherProvider;
        videoCallProviderImpl.videoCalls = new ArrayList<VonageVideoCall>();
        Object object = slAdvancedAudioDevice;
        videoCallProviderImpl.audioDevice = new SlAdvancedAudioDevice(context);
        OpenTokConfig.setPreferH264Codec((OpenTokConfig.PreferH264)OpenTokConfig.PreferH264.ENABLE);
        if (AudioDeviceManager.getAudioDevice() == null) {
            AudioDeviceManager.setAudioDevice((BaseAudioDevice)object);
        }
    }

    private final void disconnectCalls(VonageVideoCall vonageVideoCall) {
        SLRLog.INSTANCE.i("VonageVideoCall", "disconnectCalls " + ((VideoCallProviderImpl)this).videoCalls + " " + vonageVideoCall);
        for (VonageVideoCall vonageVideoCall2 : ((VideoCallProviderImpl)this).videoCalls) {
            if (Intrinsics.areEqual((Object)vonageVideoCall2, (Object)vonageVideoCall)) continue;
            vonageVideoCall2.forceDisconnect$sdk_originalVonageRelease();
        }
    }

    static /* synthetic */ void disconnectCalls$default(VideoCallProviderImpl videoCallProviderImpl, VonageVideoCall vonageVideoCall, int n, Object object) {
        if ((n & 1) != 0) {
            vonageVideoCall = null;
        }
        videoCallProviderImpl.disconnectCalls(vonageVideoCall);
    }

    private final Object tryConnect(String string2, Continuation<? super VideoCall.ConnectAttempt> continuation) {
        return BuildersKt.withContext((CoroutineContext)this.dispatcherProvider.getIo(), (Function2)new Function2<CoroutineScope, Continuation<? super VideoCall.ConnectAttempt>, Object>(string2, this, null){
            int label;
            final /* synthetic */ String $topicId;
            final /* synthetic */ VideoCallProviderImpl this$0;
            {
                this.$topicId = string2;
                this.this$0 = videoCallProviderImpl;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var0_8;
                void var0_3;
                Object object2;
                int n;
                Object object3;
                block12: {
                    object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    n = this.label;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        ResultKt.throwOnFailure((Object)object2);
                        break block12;
                    }
                    tryConnect.2 v0 = this;
                    ResultKt.throwOnFailure((Object)object2);
                    object2 = v0.$topicId;
                    // empty try
                    object2 = (GenerateRequest)GenerateRequest.newBuilder().setTopicId((String)object2).build();
                    ManagedChannel managedChannel2 = VideoCallProviderImpl.access$getGrpcService$p(v0.this$0).getManagedChannel();
                    tryConnect.2 v2 = this;
                    MethodDescriptor methodDescriptor = VonageProviderGrpc.getGenerateMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGenerateMethod()");
                    CallOptions callOptions = null;
                    Metadata metadata = null;
                    int n2 = 24;
                    Object var7_18 = null;
                    v2.label = 1;
                    object2 = GrpcExtensionsKt.unaryRpc$default((io.grpc.Channel)managedChannel2, methodDescriptor, object2, callOptions, metadata, (Continuation)this, n2, var7_18);
                    if (object2 != object3) break block12;
                    return object3;
                }
                try {
                    Object object4 = Result.constructor-impl((Object)((GenerateResponse)object2));
                }
                catch (Throwable throwable) {
                    Object object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = Result.exceptionOrNull-impl((Object)var0_3);
                if (object2 != null) {
                    SLRLog.INSTANCE.e("ResultExtensions", ((Throwable)object2).getMessage(), (Throwable)object2);
                }
                object2 = Result.isFailure-impl((Object)var0_3) ? null : var0_3;
                if ((object2 = (GenerateResponse)object2) != null) {
                    VideoCall.ConnectAttempt.Success success;
                    VideoCall.ConnectAttempt.Success success2 = success;
                    Object object6 = object2;
                    object2 = object6.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.apiKey");
                    object3 = object6.getSessionId();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.sessionId");
                    String string2 = object6.getToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.token");
                    success = new VideoCall.ConnectAttempt.Success((String)object2, (String)object3, string2);
                    return var0_8;
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)var0_3);
                if (throwable == null) {
                    VideoCall.ConnectAttempt.Failure failure;
                    VideoCall.ConnectAttempt.Failure failure2 = failure;
                    failure = new VideoCall.ConnectAttempt.Failure(false, "Unknown error during requesting token");
                    return var0_8;
                }
                Throwable throwable2 = throwable;
                Intrinsics.checkNotNull((Object)throwable2, (String)"null cannot be cast to non-null type io.grpc.StatusException");
                object2 = ((StatusException)throwable2).getTrailers();
                object3 = Metadata.Key.of((String)"code", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                if (object2.containsKey((Metadata.Key)object3) && (object2 = (String)object2.get((Metadata.Key)object3)) != null) {
                    Object object7 = object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(keyHTTPCode)");
                    object2 = Boxing.boxInt((int)Integer.parseInt((String)object7));
                } else {
                    object2 = null;
                }
                n = 5;
                boolean bl = object2 != null && (Integer)object2 == n;
                Object object8 = object3 = new VideoCall.ConnectAttempt.Failure(bl, ResultExtensionsKt.toErrorMessage(throwable));
                return var0_8;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                var v0 = object2;
                Object object2 = v0.$topicId;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super VideoCall.ConnectAttempt> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }, continuation);
    }

    public static final /* synthetic */ Object access$tryConnect(VideoCallProviderImpl videoCallProviderImpl, String string2, Continuation continuation) {
        return videoCallProviderImpl.tryConnect(string2, (Continuation<? super VideoCall.ConnectAttempt>)continuation);
    }

    public static final /* synthetic */ GrpcService access$getGrpcService$p(VideoCallProviderImpl videoCallProviderImpl) {
        return videoCallProviderImpl.grpcService;
    }

    public static final /* synthetic */ void access$disconnectCalls(VideoCallProviderImpl videoCallProviderImpl, VonageVideoCall vonageVideoCall) {
        videoCallProviderImpl.disconnectCalls(vonageVideoCall);
    }

    @Override
    @NotNull
    public VideoCall create() {
        VonageVideoCall vonageVideoCall;
        VonageVideoCall vonageVideoCall2 = vonageVideoCall;
        vonageVideoCall2();
        this.videoCalls.add(vonageVideoCall2);
        SLRLog.INSTANCE.i("VonageVideoCall", "create " + vonageVideoCall2);
        return vonageVideoCall;
    }

    @Override
    public void release(@NotNull VideoCall videoCall) {
        VideoCall videoCall2 = videoCall;
        Intrinsics.checkNotNullParameter((Object)videoCall2, (String)"call");
        videoCall2.disconnect(true);
        TypeIntrinsics.asMutableCollection(this.videoCalls).remove(videoCall);
        SLRLog.INSTANCE.i("VonageVideoCall", "release " + videoCall);
    }

    @Override
    public void disconnect() {
        VideoCallProviderImpl.disconnectCalls$default(this, null, 1, null);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0004GHIJB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0019\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0016J\r\u0010,\u001a\u00020 H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\u0017H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020+H\u0016J\b\u00101\u001a\u00020 H\u0002J \u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u0017H\u0002J\b\u00106\u001a\u00020+H\u0016J\b\u00107\u001a\u00020+H\u0016J\b\u00100\u001a\u00020+H\u0016J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u0007H\u0016J+\u0010<\u001a\u00020 2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020 0>H\u0016J+\u0010A\u001a\u00020 2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020 0>H\u0016J \u0010B\u001a\u00020 *\u00020C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0>H\u0002J\u000e\u0010E\u001a\u0004\u0018\u00010F*\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;", "Lio/streamlayer/common/data/video/VideoCall;", "(Lio/streamlayer/common/data/video/VideoCallProviderImpl;)V", "_events", "Lkotlinx/coroutines/channels/Channel;", "Lio/streamlayer/common/data/video/VideoCall$Event;", "currentQuality", "Lio/streamlayer/common/data/video/VideoQuality;", "events", "Lkotlinx/coroutines/flow/Flow;", "getEvents", "()Lkotlinx/coroutines/flow/Flow;", "isSendAudioEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSendVideoEnabled", "publisher", "Lcom/opentok/android/Publisher;", "publisherListener", "Lcom/opentok/android/PublisherKit$PublisherListener;", "sessionListener", "Lcom/opentok/android/Session$SessionListener;", "subscriberStreams", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/opentok/android/Subscriber;", "vadCache", "", "vadJob", "Lkotlinx/coroutines/Job;", "vonageSession", "Lcom/opentok/android/Session;", "cancelVad", "", "connect", "Lio/streamlayer/common/data/video/VideoCall$ConnectAttempt;", "topicId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "create", "Lio/streamlayer/common/data/video/VideoRenderer;", "context", "Landroid/content/Context;", "disconnect", "isReleased", "", "forceDisconnect", "forceDisconnect$sdk_originalVonageRelease", "getLocalUserId", "init", "isVideoEnabled", "initPublisher", "initializeSession", "apiKey", "sessionId", "token", "isAudioEnabled", "isConnected", "proceedVad", "userId", "setVideoQuality", "quality", "toggleCamera", "onChange", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "toggleMicrophone", "getConnectionDataId", "Lcom/opentok/android/Stream;", "block", "parseData", "Lio/streamlayer/common/data/video/ConnectionData;", "PublisherAudioListener", "SubscriberAudioListener", "SubscriberStreamListener", "SubscriberVideoListener", "sdk_originalVonageRelease"})
    @SourceDebugExtension(value={"SMAP\nVonageVideoCallApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VonageVideoCallApi.kt\nio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JsonUtil.kt\nio/streamlayer/common/utils/JsonUtilKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 6 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 7 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,457:1\n1855#2,2:458\n1855#2,2:460\n1#3:462\n1#3:465\n36#4,2:463\n38#4,6:469\n123#5:466\n32#6:467\n80#7:468\n*S KotlinDebug\n*F\n+ 1 VonageVideoCallApi.kt\nio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall\n*L\n243#1:458,2\n288#1:460,2\n381#1:465\n381#1:463,2\n381#1:469,6\n381#1:466\n381#1:467\n381#1:468\n*E\n"})
    public final class VonageVideoCall
    implements VideoCall {
        @NotNull
        private final ConcurrentHashMap<String, Subscriber> subscriberStreams = new ConcurrentHashMap();
        @NotNull
        private final Channel<VideoCall.Event> _events;
        @NotNull
        private final Flow<VideoCall.Event> events;
        @Nullable
        private Publisher publisher;
        @NotNull
        private final AtomicBoolean isSendVideoEnabled;
        @NotNull
        private final AtomicBoolean isSendAudioEnabled;
        @NotNull
        private VideoQuality currentQuality;
        @NotNull
        private final ConcurrentHashMap<String, Long> vadCache;
        @Nullable
        private Job vadJob;
        @Nullable
        private Session vonageSession;
        @NotNull
        private final PublisherKit.PublisherListener publisherListener;
        @NotNull
        private final Session.SessionListener sessionListener;

        public VonageVideoCall() {
            Channel channel;
            this._events = channel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
            this.events = FlowKt.receiveAsFlow((ReceiveChannel)channel);
            this.isSendVideoEnabled = new AtomicBoolean(true);
            this.isSendAudioEnabled = new AtomicBoolean(true);
            this.currentQuality = VideoQuality.MEDIUM;
            this.vadCache = new ConcurrentHashMap();
            this.publisherListener = new PublisherKit.PublisherListener(){

                public void onStreamCreated(@NotNull PublisherKit publisherKit, @NotNull Stream stream) {
                    Intrinsics.checkNotNullParameter((Object)publisherKit, (String)"publisherKit");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    SLRLog.INSTANCE.d("VonageVideoCall", "onStreamCreated: Publisher Stream Created. Own stream " + stream.getStreamId());
                }

                public void onStreamDestroyed(@NotNull PublisherKit publisherKit, @NotNull Stream stream) {
                    Intrinsics.checkNotNullParameter((Object)publisherKit, (String)"publisherKit");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    SLRLog.INSTANCE.d("VonageVideoCall", "onStreamDestroyed: Publisher Stream Destroyed. Own stream " + stream.getStreamId());
                }

                public void onError(@NotNull PublisherKit publisherKit, @NotNull OpentokError opentokError) {
                    Intrinsics.checkNotNullParameter((Object)publisherKit, (String)"publisherKit");
                    Intrinsics.checkNotNullParameter((Object)opentokError, (String)"error");
                    OpentokError opentokError2 = opentokError;
                    publisherListener.1 this_ = opentokError2.getErrorDomain();
                    SLRLog.INSTANCE.e("VonageVideoCall", "PublisherKit onError: " + opentokError.getErrorCode() + " " + (OpentokError.Domain)this_ + " " + opentokError2.getMessage() + " ");
                }
            };
            this.sessionListener = new Session.SessionListener(this, VideoCallProviderImpl.this){
                final /* synthetic */ VonageVideoCall this$0;
                final /* synthetic */ VideoCallProviderImpl this$1;
                {
                    this.this$0 = vonageVideoCall;
                    this.this$1 = videoCallProviderImpl;
                }

                public void onConnected(@NotNull Session session2) {
                    Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                    SLRLog.INSTANCE.i("VonageVideoCall", "onConnected: Connected to session: " + session2.getSessionId());
                    Publisher publisher = VonageVideoCall.access$getPublisher$p(this.this$0);
                    if (publisher != null) {
                        session2.publish((PublisherKit)publisher);
                    }
                    VonageVideoCall.access$get_events$p(this.this$0).trySend-JP2dKIU((Object)VideoCall.Event.Connected.INSTANCE);
                }

                public void onDisconnected(@NotNull Session session2) {
                    Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                    SLRLog.INSTANCE.i("VonageVideoCall", "onDisconnected: Disconnected from session: " + session2.getSessionId());
                    VonageVideoCall.access$get_events$p(this.this$0).trySend-JP2dKIU((Object)new VideoCall.Event.Disconnected(false));
                }

                public void onStreamReceived(@NotNull Session session2, @NotNull Stream stream) {
                    Function1<String, Unit> function1;
                    Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    String string2 = session2.getSessionId();
                    String string3 = stream.getName();
                    SLRLog.INSTANCE.i("VonageVideoCall", "onStreamReceived: " + stream.getStreamId() + " in session: " + string2 + " name=" + string3 + " data=" + stream.getConnection().getData());
                    string2 = function1;
                    var v1 = vonageVideoCall;
                    var vonageVideoCall = v1.this$0;
                    function1 = new Function1<String, Unit>(vonageVideoCall, v1.this$1, stream, session2){
                        final /* synthetic */ VonageVideoCall this$0;
                        final /* synthetic */ VideoCallProviderImpl this$1;
                        final /* synthetic */ Stream $stream;
                        final /* synthetic */ Session $session;
                        {
                            this.this$0 = vonageVideoCall;
                            this.this$1 = videoCallProviderImpl;
                            this.$stream = stream;
                            this.$session = session2;
                            super(1);
                        }

                        public final void invoke(@NotNull String string2) {
                            Intrinsics.checkNotNullParameter((Object)string2, (String)"slUserId");
                            if (Intrinsics.areEqual((Object)string2, (Object)VonageVideoCall.access$getLocalUserId(this.this$0))) {
                                return;
                            }
                            sessionListener.onStreamReceived.1 v0 = this;
                            VideoCallProviderImpl.access$getAudioDevice$p(v0.this$1).saveStreamVolume();
                            VideoCallProviderImpl.access$getAudioDevice$p(v0.this$1).initRenderer();
                            VideoCallProviderImpl.access$getAudioDevice$p(v0.this$1).setCommunicationMode();
                            sessionListener.onStreamReceived.1 v1 = this;
                            Context context = VideoCallProviderImpl.access$getContext$p(v1.this$1);
                            context = new Subscriber.Builder(context, v1.$stream).build();
                            sessionListener.onStreamReceived.1 v2 = this;
                            VonageVideoCall vonageVideoCall = v2.this$0;
                            Session session2 = v2.$session;
                            context.getRenderer().setStyle("STYLE_VIDEO_SCALE", "STYLE_VIDEO_FILL");
                            context.setVideoListener((SubscriberKit.VideoListener)vonageVideoCall.new SubscriberVideoListener(string2));
                            SLRLog.INSTANCE.i("VonageVideoCall", "onStreamReceived: slUserId " + string2 + " hasAudio " + context.getStream().hasAudio());
                            if (!context.getStream().hasAudio()) {
                                VonageVideoCall.access$get_events$p(vonageVideoCall).trySend-JP2dKIU((Object)new VideoCall.Event.ContactAudioMuted(string2, true));
                            }
                            Context context2 = context;
                            context2.setStreamListener((SubscriberKit.StreamListener)vonageVideoCall.new SubscriberStreamListener(string2));
                            context2.setAudioLevelListener((SubscriberKit.AudioLevelListener)vonageVideoCall.new SubscriberAudioListener(string2));
                            session2.subscribe((SubscriberKit)context2);
                            ConcurrentHashMap concurrentHashMap = VonageVideoCall.access$getSubscriberStreams$p(vonageVideoCall);
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this");
                            concurrentHashMap.put(string2, context);
                            VonageVideoCall.access$get_events$p(this.this$0).trySend-JP2dKIU((Object)new VideoCall.Event.ContactAdded(string2));
                        }
                    };
                    VonageVideoCall.access$getConnectionDataId(vonageVideoCall.this$0, stream, (Function1)string2);
                }

                public void onStreamDropped(@NotNull Session object, @NotNull Stream stream) {
                    Function1<String, Unit> function1;
                    Stream stream2 = stream;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)stream2, (String)"stream");
                    String cfr_ignored_0 = "onStreamDropped:  " + stream2.getStreamId() + " in session: " + object.getSessionId();
                    object = function1;
                    function1 = new Function1<String, Unit>(this.this$0){
                        final /* synthetic */ VonageVideoCall this$0;
                        {
                            this.this$0 = vonageVideoCall;
                            super(1);
                        }

                        public final void invoke(@NotNull String string2) {
                            sessionListener.onStreamDropped.1 v0 = this;
                            Intrinsics.checkNotNullParameter((Object)string2, (String)"slUserId");
                            String cfr_ignored_0 = "onStreamDropped:  subscriberStreams " + VonageVideoCall.access$getSubscriberStreams$p(v0.this$0);
                            if ((Subscriber)VonageVideoCall.access$getSubscriberStreams$p(v0.this$0).get(string2) == null) {
                                return;
                            }
                            String cfr_ignored_1 = "onStreamDropped:  slUserId " + string2;
                            if (!Intrinsics.areEqual((Object)string2, (Object)VonageVideoCall.access$getLocalUserId(this.this$0))) {
                                sessionListener.onStreamDropped.1 v1 = this;
                                VonageVideoCall.access$getSubscriberStreams$p(v1.this$0).remove(string2);
                                VonageVideoCall.access$get_events$p(v1.this$0).trySend-JP2dKIU((Object)new VideoCall.Event.ContactRemoved(string2));
                            }
                        }
                    };
                    VonageVideoCall.access$getConnectionDataId(this.this$0, stream, (Function1)object);
                }

                public void onError(@Nullable Session object, @Nullable OpentokError object2) {
                    sessionListener.1 this_ = object2 != null ? object2.getErrorCode() : null;
                    object = object2 != null ? object2.getErrorDomain() : null;
                    object2 = object2 != null ? object2.getMessage() : null;
                    String cfr_ignored_0 = "Session error: " + (OpentokError.ErrorCode)this_ + " " + (OpentokError.Domain)object + " " + (String)object2;
                }
            };
        }

        private final void initPublisher() {
            Publisher publisher;
            Publisher publisher2 = publisher = new Publisher.Builder(VideoCallProviderImpl.this.context).renderer(TextureVideoRendererFactoryKt.buildTextureVideoRenderer(VideoCallProviderImpl.this.context)).frameRate(Publisher.CameraCaptureFrameRate.FPS_30).resolution(Publisher.CameraCaptureResolution.MEDIUM).build();
            VonageVideoCall vonageVideoCall = this;
            Object object = vonageVideoCall.VideoCallProviderImpl.this;
            publisher2.setPublisherListener(vonageVideoCall.publisherListener);
            publisher2.getRenderer().setStyle("STYLE_VIDEO_SCALE", "STYLE_VIDEO_FILL");
            publisher.setPublishVideo(this.isSendVideoEnabled.get());
            publisher.setPublishAudio(this.isSendAudioEnabled.get());
            this._events.trySend-JP2dKIU((Object)VideoCall.Event.Initialized.INSTANCE);
            object = ((VideoCallProviderImpl)object).slSession.getUser();
            if (object != null && (object = ((User)object).getId()) != null) {
                PublisherAudioListener publisherAudioListener;
                PublisherAudioListener publisherAudioListener2 = publisherAudioListener;
                publisherAudioListener = new PublisherAudioListener((String)object);
                publisher.setAudioLevelListener((PublisherKit.AudioLevelListener)publisherAudioListener2);
            }
            this.publisher = publisher;
        }

        private final void proceedVad(String string2) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            VonageVideoCall vonageVideoCall = this;
            vonageVideoCall.vadCache.put(string2, System.currentTimeMillis());
            string2 = vonageVideoCall.vadJob;
            if (string2 != null && string2.isActive()) {
                return;
            }
            string2 = this.vadJob;
            if (string2 != null) {
                Job.DefaultImpls.cancel$default((Job)string2, null, (int)1, null);
            }
            string2 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ VonageVideoCall this$0;
                {
                    this.this$0 = vonageVideoCall;
                    super(2, continuation);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block10: {
                        block11: {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            var3_3 = this.label;
                            if (var3_3 == 0) break block10;
                            if (var3_3 != 1) break block11;
                            v0 = var1_1;
                            var1_1 = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)v0);
                            ** GOTO lbl46
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    ResultKt.throwOnFailure((Object)var1_1);
                    var1_1 = (CoroutineScope)this.L$0;
                    while (true) {
                        block12: {
                            block14: {
                                block13: {
                                    if (!CoroutineScopeKt.isActive((CoroutineScope)var1_1)) {
                                        return Unit.INSTANCE;
                                    }
                                    var3_4 = VonageVideoCall.access$getVadCache$p(this.this$0).entrySet().iterator();
                                    if (!var3_4.hasNext()) {
                                        var3_4 = null;
                                    } else {
                                        v1 = var3_4;
                                        var4_5 /* !! */  = v1.next();
                                        if (!v1.hasNext()) lbl-1000:
                                        // 2 sources

                                        {
                                            while (true) {
                                                var3_4 = var4_5 /* !! */ ;
                                                break;
                                            }
                                        } else {
                                            var5_6 = ((Number)((Map.Entry)var4_5 /* !! */ ).getValue()).longValue();
                                            do {
                                                if (var5_6 >= (var8_8 = ((Number)((Map.Entry)(var7_7 = var3_4.next())).getValue()).longValue())) continue;
                                                var4_5 /* !! */  = var7_7;
                                                var5_6 = var8_8;
                                            } while (var3_4.hasNext());
                                            ** continue;
                                        }
                                    }
                                    var3_4 = (Map.Entry)var3_4;
                                    if (var3_4 == null) break block12;
                                    var4_5 /* !! */  = this.this$0;
                                    if (((Number)var3_4.getValue()).longValue() >= System.currentTimeMillis() - 800L) {
                                        v2 = this;
                                        VonageVideoCall.access$get_events$p(var4_5 /* !! */ ).trySend-JP2dKIU((Object)new VideoCall.Event.ActiveSpeakerChanged((String)var3_4.getKey()));
                                        v2.L$0 = var1_1;
                                        v2.label = 1;
                                        if (DelayKt.delay((long)800L, (Continuation)this) == var2_2) {
                                            return var2_2;
                                        } else {
                                            ** GOTO lbl46
                                        }
                                    }
                                    break block13;
lbl46:
                                    // 3 sources

                                    v3 /* !! */  = Unit.INSTANCE;
                                    break block14;
                                }
                                v3 /* !! */  = VonageVideoCall.access$getVadCache$p(var4_5 /* !! */ ).remove(var3_4.getKey());
                            }
                            if (v3 /* !! */  != null) continue;
                        }
                        v4 = this.this$0;
                        VonageVideoCall.access$get_events$p(v4).trySend-JP2dKIU((Object)new VideoCall.Event.ActiveSpeakerChanged(null));
                        VonageVideoCall.access$cancelVad(v4);
                    }
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    new /* invalid duplicate definition of identical inner class */.L$0 = object;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            };
            this.vadJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)VideoCallProviderImpl.this.dispatcherProvider.getDefault()), null, null, (Function2)string2, (int)3, null);
        }

        private final void cancelVad() {
            Job job = this.vadJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.vadCache.clear();
        }

        private final String getLocalUserId() {
            Object object = ((VonageVideoCall)object).VideoCallProviderImpl.this.slSession.getUser();
            if (object == null || (object = ((User)object).getId()) == null) {
                object = "";
            }
            return object;
        }

        private final void initializeSession(String string2, String object, String string3) {
            SLRLog.INSTANCE.i("VonageVideoCall", "initializeSession apiKey=" + string2 + " sessionId=" + (String)object + " token=" + string3);
            string2 = new Session.Builder(((VonageVideoCall)((Object)videoCallProviderImpl)).VideoCallProviderImpl.this.context, string2, (String)object).sessionOptions(new Session.SessionOptions(){

                public boolean useTextureViews() {
                    return true;
                }
            }).build();
            VonageVideoCall vonageVideoCall = videoCallProviderImpl;
            VideoCallProviderImpl videoCallProviderImpl = ((VonageVideoCall)((Object)videoCallProviderImpl)).VideoCallProviderImpl.this;
            vonageVideoCall.vonageSession = string2;
            string2.setSessionListener(vonageVideoCall.sessionListener);
            object = PermissionsUtil.INSTANCE;
            if (((PermissionsUtil)object).hasReadPhoneStatePermission$sdk_originalVonageRelease(videoCallProviderImpl.context) && ((PermissionsUtil)object).hasBluetoothConnectPermission$sdk_originalVonageRelease(videoCallProviderImpl.context)) {
                videoCallProviderImpl.audioDevice.startObserveSettings();
            }
            string2.connect(string3);
        }

        private final void getConnectionDataId(Stream stream, Function1<? super String, Unit> function1) {
            String string2 = stream.getConnection().getData();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.data");
            ConnectionData connectionData = ((VonageVideoCall)((Object)connectionData)).parseData(string2);
            if (connectionData != null) {
                function1.invoke((Object)connectionData.getSlUserId());
            }
        }

        private final ConnectionData parseData(String string2) {
            block8: {
                Object object;
                block7: {
                    object = JsonUtilKt.getJson();
                    if (string2 == null) break block7;
                    VonageVideoCall vonageVideoCall = object;
                    VonageVideoCall vonageVideoCall2 = vonageVideoCall;
                    VonageVideoCall vonageVideoCall3 = vonageVideoCall;
                    try {
                        KSerializer kSerializer = SerializersKt.serializer((SerializersModule)vonageVideoCall2.getSerializersModule(), (KType)Reflection.typeOf(ConnectionData.class));
                        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        object = Result.constructor-impl((Object)vonageVideoCall3.decodeFromString((DeserializationStrategy)kSerializer, string2));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null && string2.length() > 0) {
                        SLRLog.INSTANCE.w("JsonUtil", "json parsing exception:  " + string2);
                        throwable.printStackTrace();
                    }
                    if (!Result.isFailure-impl((Object)object)) break block8;
                }
                object = null;
            }
            return (ConnectionData)object;
        }

        public static final /* synthetic */ String access$getLocalUserId(VonageVideoCall vonageVideoCall) {
            return vonageVideoCall.getLocalUserId();
        }

        public static final /* synthetic */ Publisher access$getPublisher$p(VonageVideoCall vonageVideoCall) {
            return vonageVideoCall.publisher;
        }

        public static final /* synthetic */ ConcurrentHashMap access$getVadCache$p(VonageVideoCall vonageVideoCall) {
            return vonageVideoCall.vadCache;
        }

        public static final /* synthetic */ void access$cancelVad(VonageVideoCall vonageVideoCall) {
            vonageVideoCall.cancelVad();
        }

        public static final /* synthetic */ void access$getConnectionDataId(VonageVideoCall vonageVideoCall, Stream stream, Function1 function1) {
            vonageVideoCall.getConnectionDataId(stream, (Function1<? super String, Unit>)function1);
        }

        @Override
        @NotNull
        public Flow<VideoCall.Event> getEvents() {
            return this.events;
        }

        @Override
        public boolean isConnected() {
            Object object = ((VonageVideoCall)object).vonageSession;
            object = object != null && (object = object.getConnection()) != null ? object.getConnectionId() : null;
            boolean bl = object != null;
            SLRLog.INSTANCE.i("VonageVideoCall", "connectionId=" + (String)object + " isConnected=" + bl);
            return bl;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @Nullable
        public Object connect(@NotNull String var1_1, @NotNull Continuation<? super VideoCall.ConnectAttempt> var2_2) {
            block10: {
                block9: {
                    block8: {
                        if (!(var2_2 instanceof connect.1)) ** GOTO lbl-1000
                        var3_3 /* !! */  = var2_2;
                        var4_4 = var3_3 /* !! */ .label;
                        if ((var4_4 & -2147483648) != 0) {
                            var3_3 /* !! */ .label = var4_4 - -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 /* !! */  = v0;
                            v0 = new ContinuationImpl((VonageVideoCall)this, (Continuation<? super connect.1>)var2_2){
                                Object L$0;
                                /* synthetic */ Object result;
                                final /* synthetic */ VonageVideoCall this$0;
                                int label;
                                {
                                    this.this$0 = vonageVideoCall;
                                    super(continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    connect.1 v0 = this;
                                    v0.result = object;
                                    v0.label |= Integer.MIN_VALUE;
                                    return v0.this$0.connect(null, (Continuation<? super VideoCall.ConnectAttempt>)this);
                                }
                            };
                        }
                        v1 = var3_3 /* !! */ ;
                        var2_2 = v1.result;
                        var4_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        var5_6 = v1.label;
                        if (var5_6 == 0) ** GOTO lbl19
                        if (var5_6 == 1) {
                            this = (VonageVideoCall)var3_3 /* !! */ .L$0;
                            ResultKt.throwOnFailure(var2_2);
                        } else {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
lbl19:
                            // 1 sources

                            v2 = this;
                            ResultKt.throwOnFailure(var2_2);
                            VideoCallProviderImpl.access$disconnectCalls(v2.VideoCallProviderImpl.this, (VonageVideoCall)this);
                            SLRLog.INSTANCE.i("VonageVideoCall", "requestToken " + (String)var1_1);
                            v3 = var3_3 /* !! */ ;
                            v3.L$0 = this;
                            v3.label = 1;
                            var2_2 = VideoCallProviderImpl.access$tryConnect(v2.VideoCallProviderImpl.this, (String)var1_1, (Continuation)var3_3 /* !! */ );
                            if (var2_2 == var4_5) {
                                return var4_5;
                            }
                        }
                        var1_1 = (VideoCall.ConnectAttempt)var2_2;
                        if (!(var1_1 instanceof VideoCall.ConnectAttempt.Success)) break block8;
                        v4 = this;
                        this = SLRLog.INSTANCE;
                        v5 = (VideoCall.ConnectAttempt.Success)var1_1;
                        var2_2 = v5;
                        v6 = this;
                        v7 = var2_2;
                        this = v7.getSessionId();
                        v6.i("VonageVideoCall", "tryConnect success: apiKey=" + var2_2.getApiKey() + " sessionId=" + (String)this + " token=" + v7.getSessionToken());
                        this = v5.getApiKey();
                        var2_2 = v5.getSessionId();
                        var3_3 /* !! */  = v5.getSessionToken();
                        v4.initializeSession((String)this, (String)var2_2, (String)var3_3 /* !! */ );
                        break block9;
                    }
                    if (!(var1_1 instanceof VideoCall.ConnectAttempt.Failure)) break block10;
                    this = (VideoCall.ConnectAttempt.Failure)var1_1;
                    SLRLog.INSTANCE.i("VonageVideoCall", "tryConnect failure: isWpFull=" + this.isWpFull() + " error=" + this.getError());
                }
                return var1_1;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public void init(boolean bl) {
            VonageVideoCall vonageVideoCall = this;
            vonageVideoCall.isSendVideoEnabled.set(bl);
            vonageVideoCall.isSendAudioEnabled.set(true);
            vonageVideoCall.currentQuality = VideoQuality.MEDIUM;
            vonageVideoCall.initPublisher();
        }

        @Override
        public void disconnect(boolean bl) {
            SLRLog sLRLog = SLRLog.INSTANCE;
            Object object = "VonageVideoCall";
            Object object2 = this.vonageSession;
            object2 = "disconnect: " + (object2 != null && (object2 = object2.getConnection()) != null ? object2.getConnectionId() : null) + " isReleased=" + bl;
            sLRLog.i((String)object, (String)object2);
            sLRLog = this.vonageSession;
            if (sLRLog != null) {
                VonageVideoCall vonageVideoCall = this;
                object = vonageVideoCall.VideoCallProviderImpl.this;
                object2 = vonageVideoCall.publisher;
                if (object2 != null) {
                    sLRLog.unpublish((PublisherKit)object2);
                    if (bl) {
                        this.publisher = null;
                    }
                }
                Collection<Subscriber> collection = this.subscriberStreams.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"subscriberStreams.values");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    sLRLog.unsubscribe((SubscriberKit)((Subscriber)iterator.next()));
                }
                SLRLog sLRLog2 = sLRLog;
                this.subscriberStreams.clear();
                sLRLog2.setSessionListener(null);
                sLRLog2.disconnect();
                this.vonageSession = null;
                ((VideoCallProviderImpl)object).audioDevice.destroyRenderer();
                this.cancelVad();
            }
        }

        public final void forceDisconnect$sdk_originalVonageRelease() {
            SLRLog sLRLog = SLRLog.INSTANCE;
            String string2 = "VonageVideoCall";
            Object object = this.vonageSession;
            object = "forceDisconnect: " + (object != null && (object = object.getConnection()) != null ? object.getConnectionId() : null);
            sLRLog.i(string2, (String)object);
            boolean bl = this.vonageSession != null;
            this.disconnect(true);
            if (bl) {
                this._events.trySend-JP2dKIU((Object)new VideoCall.Event.Disconnected(true));
            }
        }

        @Override
        public void toggleCamera(@NotNull Function1<? super Boolean, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"onChange");
            Publisher publisher = this.publisher;
            if (publisher != null) {
                boolean bl = this.isSendVideoEnabled.get() ^ true;
                this.isSendVideoEnabled.set(bl);
                publisher.setPublishVideo(bl);
                SLRLog.INSTANCE.i("VonageVideoCall", "toggleMicrophone: publishVideo " + bl);
                function1.invoke((Object)bl);
            }
        }

        @Override
        public boolean isVideoEnabled() {
            return this.isSendVideoEnabled.get();
        }

        @Override
        public void toggleMicrophone(@NotNull Function1<? super Boolean, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"onChange");
            Publisher publisher = this.publisher;
            if (publisher != null) {
                boolean bl = this.isSendAudioEnabled.get() ^ true;
                this.isSendAudioEnabled.set(bl);
                publisher.setPublishAudio(bl);
                SLRLog.INSTANCE.i("VonageVideoCall", "toggleMicrophone: publishAudio " + bl);
                function1.invoke((Object)bl);
            }
        }

        @Override
        public boolean isAudioEnabled() {
            return this.isSendAudioEnabled.get();
        }

        @Override
        public void setVideoQuality(@NotNull VideoQuality videoQuality) {
            Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"quality");
            SLRLog.INSTANCE.i("VonageVideoCall", "setVideoQuality: current=" + this.currentQuality + " new=" + videoQuality);
            if (this.currentQuality == videoQuality) {
                return;
            }
            Collection<Subscriber> collection = this.subscriberStreams.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"subscriberStreams.values");
            for (Subscriber subscriber : collection) {
                VideoQuality videoQuality2 = VideoQuality.MEDIUM;
                float f = videoQuality == videoQuality2 ? 30.0f : 15.0f;
                subscriber.setPreferredFrameRate(f);
                if (videoQuality == videoQuality2) {
                    VideoUtils.Size size;
                    videoQuality2 = size;
                    size = new VideoUtils.Size(480, 640);
                } else {
                    VideoUtils.Size size;
                    videoQuality2 = size;
                    size = new VideoUtils.Size(240, 320);
                }
                subscriber.setPreferredResolution((VideoUtils.Size)videoQuality2);
            }
            this.currentQuality = videoQuality;
        }

        @Override
        @NotNull
        public VideoRenderer create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new VideoRenderer(this){
                @Nullable
                private View _view;
                final /* synthetic */ VonageVideoCall this$0;
                {
                    this.this$0 = vonageVideoCall;
                }

                @Nullable
                public final View get_view() {
                    return this._view;
                }

                public final void set_view(@Nullable View view2) {
                    this._view = view2;
                }

                @Nullable
                public View getView() {
                    return this._view;
                }

                /*
                 * Unable to fully structure code
                 */
                public void show(@NotNull String var1_1) {
                    block3: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"userId");
                            var2_2 = Intrinsics.areEqual((Object)var1_1, (Object)VonageVideoCall.access$getLocalUserId(this.this$0));
                            if (!var2_2) break block2;
                            var3_3 = VonageVideoCall.access$getPublisher$p(this.this$0);
                            if (var3_3 == null) ** GOTO lbl-1000
                            var3_3 = var3_3.getView();
                            break block3;
                        }
                        var3_3 = (Subscriber)VonageVideoCall.access$getSubscriberStreams$p(this.this$0).get(var1_1);
                        if (var3_3 != null) {
                            var3_3 = var3_3.getView();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var3_3 = null;
                        }
                    }
                    this._view = var3_3;
                    SLRLog.INSTANCE.i("VonageVideoCall", "show userId: " + var1_1 + " isLocal: " + var2_2 + " " + (View)var3_3);
                }

                public void hide() {
                    create.render.1 this_ = this_._view;
                    if (this_ != null) {
                        ViewExtensionsKt.gone((View)this_);
                    }
                }
            };
        }

        @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall$PublisherAudioListener;", "Lcom/opentok/android/PublisherKit$AudioLevelListener;", "id", "", "(Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "onAudioLevelUpdated", "", "p0", "Lcom/opentok/android/PublisherKit;", "p1", "", "sdk_originalVonageRelease"})
        public final class PublisherAudioListener
        implements PublisherKit.AudioLevelListener {
            @NotNull
            private final String id;

            public PublisherAudioListener(String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
                this.id = string2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public void onAudioLevelUpdated(@Nullable PublisherKit publisherKit, float f) {
                if (f >= 0.2f && VonageVideoCall.this.subscriberStreams.isEmpty() ^ true) {
                    VonageVideoCall.this.proceedVad(this.id);
                }
            }
        }

        @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall$SubscriberVideoListener;", "Lcom/opentok/android/SubscriberKit$VideoListener;", "id", "", "(Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "onVideoDataReceived", "", "p0", "Lcom/opentok/android/SubscriberKit;", "onVideoDisableWarning", "onVideoDisableWarningLifted", "onVideoDisabled", "p1", "onVideoEnabled", "sdk_originalVonageRelease"})
        public final class SubscriberVideoListener
        implements SubscriberKit.VideoListener {
            @NotNull
            private final String id;

            public SubscriberVideoListener(String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
                this.id = string2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public void onVideoDataReceived(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onVideoDataReceived " + this.id + " p0 " + subscriberKit);
                VonageVideoCall.this._events.trySend-JP2dKIU((Object)new VideoCall.Event.VideoAdded(this.id));
            }

            public void onVideoDisabled(@Nullable SubscriberKit subscriberKit, @Nullable String string2) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onVideoDisabled " + this.id + " p0 " + string2);
                VonageVideoCall.this._events.trySend-JP2dKIU((Object)new VideoCall.Event.VideoRemoved(this.id));
            }

            public void onVideoEnabled(@Nullable SubscriberKit subscriberKit, @Nullable String string2) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onVideoEnabled " + this.id + " p0 " + string2);
                VonageVideoCall.this._events.trySend-JP2dKIU((Object)new VideoCall.Event.VideoAdded(this.id));
            }

            public void onVideoDisableWarning(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onVideoDisableWarning " + this.id + " p0 " + subscriberKit);
            }

            public void onVideoDisableWarningLifted(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onVideoDisableWarning " + this.id + " p0 " + subscriberKit);
            }
        }

        @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall$SubscriberStreamListener;", "Lcom/opentok/android/SubscriberKit$StreamListener;", "id", "", "(Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "onAudioDisabled", "", "p0", "Lcom/opentok/android/SubscriberKit;", "onAudioEnabled", "onDisconnected", "onReconnected", "sdk_originalVonageRelease"})
        public final class SubscriberStreamListener
        implements SubscriberKit.StreamListener {
            @NotNull
            private final String id;

            public SubscriberStreamListener(String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
                this.id = string2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public void onReconnected(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onReconnected " + this.id + " " + subscriberKit);
            }

            public void onDisconnected(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onDisconnected " + this.id + " " + subscriberKit);
            }

            public void onAudioDisabled(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onAudioDisabled " + this.id + " " + subscriberKit);
                VonageVideoCall.this._events.trySend-JP2dKIU((Object)new VideoCall.Event.ContactAudioMuted(this.id, true));
            }

            public void onAudioEnabled(@Nullable SubscriberKit subscriberKit) {
                SLRLog.INSTANCE.d("VonageVideoCall", "onAudioEnabled " + this.id + " " + subscriberKit);
                VonageVideoCall.this._events.trySend-JP2dKIU((Object)new VideoCall.Event.ContactAudioMuted(this.id, false));
            }
        }

        @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall$SubscriberAudioListener;", "Lcom/opentok/android/SubscriberKit$AudioLevelListener;", "id", "", "(Lio/streamlayer/common/data/video/VideoCallProviderImpl$VonageVideoCall;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "onAudioLevelUpdated", "", "p0", "Lcom/opentok/android/SubscriberKit;", "p1", "", "sdk_originalVonageRelease"})
        public final class SubscriberAudioListener
        implements SubscriberKit.AudioLevelListener {
            @NotNull
            private final String id;

            public SubscriberAudioListener(String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"id");
                this.id = string2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public void onAudioLevelUpdated(@Nullable SubscriberKit subscriberKit, float f) {
                if (f >= 0.2f) {
                    VonageVideoCall.this.proceedVad(this.id);
                }
            }
        }
    }
}

