/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.utils;

import android.content.Context;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lio/streamlayer/common/utils/UserUtil;", "", "()V", "getAcronymFromName", "", "name", "getColorFromName", "", "context", "Landroid/content/Context;", "getFirstName", "getInitialsFromName", "getRandomAvatarColor", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nUserUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserUtil.kt\nio/streamlayer/common/utils/UserUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,59:1\n151#2,6:60\n151#2,6:66\n151#2,6:72\n*S KotlinDebug\n*F\n+ 1 UserUtil.kt\nio/streamlayer/common/utils/UserUtil\n*L\n33#1:60,6\n46#1:66,6\n56#1:72,6\n*E\n"})
public final class UserUtil {
    @NotNull
    public static final UserUtil INSTANCE = new UserUtil();

    private UserUtil() {
    }

    @ColorInt
    public final int getColorFromName(@NotNull Context context, @NotNull String string2) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"name");
        int n = ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrAvatarColors, R.array.slr_avatar_colors);
        int[] nArray = context2.getResources().getIntArray(n);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"context.resources.getIntArray(avatarColorsResId)");
        return nArray[Math.abs(string2.hashCode() * 3557) % (nArray.length - 1)];
    }

    @ColorInt
    public final int getRandomAvatarColor(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int n = ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrAvatarColors, R.array.slr_avatar_colors);
        int[] nArray = context2.getResources().getIntArray(n);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"context.resources.getIntArray(avatarColorsResId)");
        Integer n2 = ArraysKt.randomOrNull((int[])nArray, (Random)Random.Default);
        return n2 != null ? n2 : ContextCompat.getColor((Context)context, (int)R.color.slr_blue500_alpha_50);
    }

    @Nullable
    public final String getAcronymFromName(@Nullable String string2) {
        int n;
        Object object;
        block6: {
            if (string2 == null) {
                return null;
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            int n2 = object.length();
            for (n = 0; n < n2; ++n) {
                if (!(object.charAt(n) == ' ')) {
                    continue;
                }
                break block6;
            }
            n = -1;
        }
        if (n != -1 && ((String)object).length() >= 3) {
            char c = ((String)object).charAt(0);
            String string3 = ((String)object).substring(n + 1, n + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = c + string3;
        } else if (((String)object).length() >= 2) {
            object = ((String)object).substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        String string4 = ((String)object).toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase()");
        return string4;
    }

    @Nullable
    public final String getInitialsFromName(@Nullable String string2) {
        int n;
        int n2;
        Object object;
        block4: {
            if (string2 == null) {
                return null;
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            n2 = object.length();
            for (n = 0; n < n2; ++n) {
                if (!(object.charAt(n) == ' ')) {
                    continue;
                }
                break block4;
            }
            n = -1;
        }
        if (n != -1 && n < ((String)object).length() - 2) {
            n2 = n + 1;
            String string3 = ((String)object).substring(0, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = ((String)object).substring(n2, n + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string4.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toUpperCase()");
            object = string3 + (String)object + ".";
        }
        return object;
    }

    @Nullable
    public final String getFirstName(@Nullable String string2) {
        int n;
        Object object;
        block4: {
            if (string2 == null) {
                return null;
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            int n2 = object.length();
            for (n = 0; n < n2; ++n) {
                if (!(object.charAt(n) == ' ')) {
                    continue;
                }
                break block4;
            }
            n = -1;
        }
        if (n != -1 && n < ((String)object).length() - 1) {
            object = ((String)object).substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return object;
    }
}

