/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrViewEventInfoBinding;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/views/EventTeamsInfoView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lio/streamlayer/sdk/databinding/SlrViewEventInfoBinding;", "setInfo", "", "eventSummary", "Lio/streamlayer/sdk/model/sports/EventSummary;", "sdk_originalVonageRelease"})
public final class EventTeamsInfoView
extends ConstraintLayout {
    @NotNull
    private final SlrViewEventInfoBinding binding;

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        SlrViewEventInfoBinding slrViewEventInfoBinding = SlrViewEventInfoBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)slrViewEventInfoBinding, (String)"inflate(LayoutInflater.from(context), this)");
        this.binding = slrViewEventInfoBinding;
    }

    public /* synthetic */ EventTeamsInfoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public EventTeamsInfoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public final void setInfo(@NotNull EventSummary eventSummary2) {
        EventSummary eventSummary3 = eventSummary2;
        Intrinsics.checkNotNullParameter((Object)eventSummary3, (String)"eventSummary");
        EventTeam eventTeam = eventSummary3.getHomeTeam();
        EventTeam eventTeam2 = eventSummary3.getAwayTeam();
        int n = eventSummary3.getHomeScore();
        int n2 = eventSummary3.getAwayScore();
        SlrViewEventInfoBinding slrViewEventInfoBinding = this.binding;
        slrViewEventInfoBinding.slEventInfoLeftTeamNameTV.setText((CharSequence)eventTeam.getAlias());
        ImageView imageView2 = slrViewEventInfoBinding.slEventInfoLeftTeamLogoIV;
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slEventInfoLeftTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView2, eventTeam.getLogo(), false, null, null, 14, null);
        slrViewEventInfoBinding.slEventInfoRightTeamNameTV.setText((CharSequence)eventTeam2.getAlias());
        ImageView imageView3 = slrViewEventInfoBinding.slEventInfoRightTeamLogoIV;
        Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"slEventInfoRightTeamLogoIV");
        ViewExtensionsKt.loadUrl$default(imageView3, eventTeam2.getLogo(), false, null, null, 14, null);
        if (eventSummary2.getStatus() == EventStatus.Active) {
            SlrViewEventInfoBinding slrViewEventInfoBinding2 = slrViewEventInfoBinding;
            slrViewEventInfoBinding2.slEventInfoCurrentPhaseTV.setText((CharSequence)this.getContext().getString(R.string.slr_s_qtr, new Object[]{OtherExtensionsKt.toOrdinalString(eventSummary2.getPeriodsCount())}));
            slrViewEventInfoBinding2.slEventInfoCurrentPhaseTV.setBackground(null);
        } else {
            SlrViewEventInfoBinding slrViewEventInfoBinding3 = slrViewEventInfoBinding;
            slrViewEventInfoBinding3.slEventInfoCurrentPhaseTV.setText((CharSequence)"VS");
            slrViewEventInfoBinding3.slEventInfoCurrentPhaseTV.setBackgroundResource(R.drawable.slr_bg_versus_text);
        }
        SlrViewEventInfoBinding slrViewEventInfoBinding4 = slrViewEventInfoBinding;
        slrViewEventInfoBinding4.slEventInfoLeftScoreTV.setText((CharSequence)String.valueOf(n));
        slrViewEventInfoBinding4.slEventInfoRightScoreTV.setText((CharSequence)String.valueOf(n2));
    }
}

