/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.alphavideoview;

import android.graphics.Color;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.alphavideoview.GLTextureView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Locale;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020\bH\u0002J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J \u00101\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005H\u0016J\u001c\u00104\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020/H\u0016J\b\u00109\u001a\u00020\u000fH\u0002J\u000e\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyRenderer;", "Lio/streamlayer/common/views/alphavideoview/GLTextureView$Renderer;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "()V", "aPositionHandle", "", "aTextureHandle", "chromaKeyFragmentShader", "", "colorToReplace", "", "mVPMatrix", "onSurfacePrepareListener", "Lkotlin/Function1;", "Landroid/graphics/SurfaceTexture;", "", "getOnSurfacePrepareListener", "()Lkotlin/jvm/functions/Function1;", "setOnSurfacePrepareListener", "(Lkotlin/jvm/functions/Function1;)V", "program", "quadVertices", "Ljava/nio/FloatBuffer;", "quadVerticesData", "sTMatrix", "similarity", "", "smoothness", "spill", "surface", "textureID", "uMVPMatrixHandle", "uSTMatrixHandle", "updateSurface", "", "vertexShader", "checkForGlError", "op", "createProgram", "vertexSource", "fragmentSource", "getShader", "loadShader", "shaderType", "source", "onDrawFrame", "glUnused", "Ljavax/microedition/khronos/opengles/GL10;", "onFrameAvailable", "onSurfaceChanged", "width", "height", "onSurfaceCreated", "config", "Ljavax/microedition/khronos/egl/EGLConfig;", "onSurfaceDestroyed", "gl", "prepareSurface", "setBackgroundColor", "color", "Companion", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nChromaKeyRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromaKeyRenderer.kt\nio/streamlayer/common/views/alphavideoview/ChromaKeyRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1#2:260\n*E\n"})
public final class ChromaKeyRenderer
implements GLTextureView.Renderer,
SurfaceTexture.OnFrameAvailableListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "ChromaKeyRenderer";
    private static final int COLOR_MAX_VALUE = 255;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int QUAD_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int QUAD_VERTICES_DATA_POS_OFFSET = 0;
    private static final int QUAD_VERTICES_DATA_UV_OFFSET = 3;
    private static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    @NotNull
    private final float[] quadVerticesData;
    @NotNull
    private final FloatBuffer quadVertices;
    @NotNull
    private final String vertexShader;
    @NotNull
    private final String chromaKeyFragmentShader;
    @Nullable
    private Function1<? super SurfaceTexture, Unit> onSurfacePrepareListener;
    @NotNull
    private final float[] mVPMatrix;
    @NotNull
    private final float[] sTMatrix;
    private int program;
    private int textureID;
    private int uMVPMatrixHandle;
    private int uSTMatrixHandle;
    private int aPositionHandle;
    private int aTextureHandle;
    @Nullable
    private SurfaceTexture surface;
    private boolean updateSurface;
    @NotNull
    private float[] colorToReplace;
    private final float similarity;
    private final float spill;
    private final float smoothness;

    public ChromaKeyRenderer() {
        float[] fArray = new float[20];
        float[] fArray2 = fArray;
        fArray[0] = -1.0f;
        fArray[1] = -1.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = -1.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        fArray[9] = 0.0f;
        fArray[10] = -1.0f;
        fArray[11] = 1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 1.0f;
        fArray[15] = 1.0f;
        fArray[16] = 1.0f;
        fArray[17] = 0.0f;
        fArray[18] = 1.0f;
        fArray[19] = 1.0f;
        this.quadVerticesData = fArray;
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"allocateDirect(quadVerti\u2026eOrder()).asFloatBuffer()");
        this.quadVertices = floatBuffer;
        this.vertexShader = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
        this.chromaKeyFragmentShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying vec2 vTextureCoord;\nvec2 RGBtoUV(vec3 rgb) {\n    return vec2(\n        rgb.r * -0.169 + rgb.g * -0.331 + rgb.b *  0.5    + 0.5,\n        rgb.r *  0.5   + rgb.g * -0.419 + rgb.b * -0.081  + 0.5\n    ); }\nvec4 ProcessChromaKey(vec2 texCoord) {\n  float red = %f;\n  float green = %f;\n  float blue = %f;\n  float similarity = %f;\n  float smoothness = %f;\n  float spill = %f;\n   vec4 rgba = texture2D(sTexture, vTextureCoord);\n   float chromaDist = distance(RGBtoUV(texture2D(sTexture, vTextureCoord).rgb), RGBtoUV(vec3(red,green,blue)));\n   float baseMask = chromaDist - similarity;\n   float fullMask = pow(clamp(baseMask / smoothness, 0.0, 1.0), 1.5);\n   rgba.a = fullMask;\n   float spillVal = pow(clamp(baseMask / spill, 0.0, 1.0), 1.5);\n   float desat = clamp(rgba.r * 0.2126 + rgba.g * 0.7152 + rgba.b * 0.0722, 0.0, 1.0);\n   rgba.rgb = mix(vec3(desat, desat, desat), rgba.rgb, spillVal);\n   return rgba;    }\nvoid main(void) {\n    vec2 texCoord = vec2(gl_FragCoord.x/0.5, 1.0 - (gl_FragCoord.y/0.5));\n    gl_FragColor = ProcessChromaKey(texCoord);\n}";
        this.mVPMatrix = new float[16];
        float[] fArray3 = new float[16];
        ChromaKeyRenderer chromaKeyRenderer = this;
        chromaKeyRenderer.sTMatrix = fArray3;
        chromaKeyRenderer.colorToReplace = new float[]{0.0f, 0.0f, 0.0f};
        chromaKeyRenderer.similarity = 0.17f;
        chromaKeyRenderer.spill = 0.35f;
        chromaKeyRenderer.smoothness = 0.19f;
        floatBuffer.put(fArray2).position(0);
        Matrix.setIdentityM((float[])fArray3, (int)0);
    }

    private final void prepareSurface() {
        SurfaceTexture surfaceTexture;
        int n;
        ChromaKeyRenderer chromaKeyRenderer = this;
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        chromaKeyRenderer.textureID = n = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n);
        chromaKeyRenderer.checkForGlError("glBindTexture textureID");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)36197, (int)10243, (float)33071.0f);
        SurfaceTexture surfaceTexture2 = surfaceTexture;
        surfaceTexture2(this.textureID);
        surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        Function1<? super SurfaceTexture, Unit> function1 = chromaKeyRenderer.onSurfacePrepareListener;
        if (function1 != null) {
            function1.invoke((Object)surfaceTexture2);
        }
        this.surface = surfaceTexture2;
    }

    private final int loadShader(int n, String object) {
        int n2 = GLES20.glCreateShader((int)n);
        if (n2 != 0) {
            int n3 = n2;
            GLES20.glShaderSource((int)n3, (String)object);
            GLES20.glCompileShader((int)n3);
            int[] nArray = new int[1];
            object = nArray;
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])object, (int)0);
            if (nArray[0] == 0) {
                SLRLog sLRLog = SLRLog.INSTANCE;
                sLRLog.e(TAG, "Could not compile shader " + n + ":");
                String string2 = GLES20.glGetShaderInfoLog((int)n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"glGetShaderInfoLog(shader)");
                sLRLog.e(TAG, string2);
                GLES20.glDeleteShader((int)n2);
                n2 = 0;
            }
        }
        return n2;
    }

    private final int createProgram(String string2, String string3) {
        int n = ((ChromaKeyRenderer)object).loadShader(35633, string2);
        if (n == 0) {
            return 0;
        }
        int n2 = ((ChromaKeyRenderer)object).loadShader(35632, string3);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            ((ChromaKeyRenderer)object).checkForGlError("glAttachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            ((ChromaKeyRenderer)object).checkForGlError("glAttachShader");
            GLES20.glLinkProgram((int)n3);
            int[] nArray = new int[1];
            Object object = nArray;
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])object, (int)0);
            if (nArray[0] != 1) {
                SLRLog sLRLog = SLRLog.INSTANCE;
                sLRLog.e(TAG, "Could not link program: ");
                object = GLES20.glGetProgramInfoLog((int)n3);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"glGetProgramInfoLog(program)");
                sLRLog.e(TAG, (String)object);
                GLES20.glDeleteProgram((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    private final String getShader() {
        Object[] objectArray = new Object[6];
        Object object = objectArray;
        object[0] = Float.valueOf(this.colorToReplace[0]);
        object[1] = Float.valueOf(this.colorToReplace[1]);
        object[2] = Float.valueOf(this.colorToReplace[2]);
        object[3] = Float.valueOf(this.similarity);
        object[4] = Float.valueOf(this.smoothness);
        objectArray[5] = Float.valueOf(this.spill);
        object = String.format(Locale.ENGLISH, this.chromaKeyFragmentShader, Arrays.copyOf(objectArray, 6));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(locale, format, *args)");
        SLRLog.INSTANCE.d(TAG, "getShader " + (String)object + " \ncolorToReplace " + this.colorToReplace);
        return object;
    }

    private final void checkForGlError(String string2) {
        int n = GLES20.glGetError();
        if (n == 0) {
            return;
        }
        SLRLog.INSTANCE.e(TAG, string2 + ": glError " + n);
        throw new RuntimeException(string2 + ": glError " + n);
    }

    @Nullable
    public final Function1<SurfaceTexture, Unit> getOnSurfacePrepareListener() {
        return this.onSurfacePrepareListener;
    }

    public final void setOnSurfacePrepareListener(@Nullable Function1<? super SurfaceTexture, Unit> function1) {
        this.onSurfacePrepareListener = function1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onDrawFrame(@NotNull GL10 object) {
        ChromaKeyRenderer chromaKeyRenderer = object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"glUnused");
        synchronized (chromaKeyRenderer) {
            if (chromaKeyRenderer.updateSurface) {
                SurfaceTexture surfaceTexture = ((ChromaKeyRenderer)object2).surface;
                if (surfaceTexture != null) {
                    surfaceTexture.updateTexImage();
                    surfaceTexture.getTransformMatrix(((ChromaKeyRenderer)object2).sTMatrix);
                }
                ((ChromaKeyRenderer)object2).updateSurface = false;
            }
            ChromaKeyRenderer chromaKeyRenderer2 = object2;
            ChromaKeyRenderer chromaKeyRenderer3 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer4 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer5 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer6 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer7 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer8 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer9 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer10 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer11 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer12 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer13 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer14 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer15 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer16 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer17 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer18 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer19 = chromaKeyRenderer2;
            ChromaKeyRenderer chromaKeyRenderer20 = chromaKeyRenderer2;
            GLES20.glClear((int)16640);
            GLES20.glEnable((int)3042);
            GLES20.glBlendFunc((int)770, (int)771);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glUseProgram((int)chromaKeyRenderer18.program);
            chromaKeyRenderer19.checkForGlError("glUseProgram");
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)36197, (int)chromaKeyRenderer20.textureID);
            chromaKeyRenderer15.quadVertices.position(0);
            FloatBuffer floatBuffer = ((ChromaKeyRenderer)object2).quadVertices;
            GLES20.glVertexAttribPointer((int)chromaKeyRenderer16.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer);
            chromaKeyRenderer13.checkForGlError("glVertexAttribPointer maPosition");
            GLES20.glEnableVertexAttribArray((int)chromaKeyRenderer14.aPositionHandle);
            chromaKeyRenderer11.checkForGlError("glEnableVertexAttribArray aPositionHandle");
            chromaKeyRenderer12.quadVertices.position(3);
            FloatBuffer floatBuffer2 = ((ChromaKeyRenderer)object2).quadVertices;
            GLES20.glVertexAttribPointer((int)chromaKeyRenderer9.aTextureHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)floatBuffer2);
            chromaKeyRenderer10.checkForGlError("glVertexAttribPointer aTextureHandle");
            GLES20.glEnableVertexAttribArray((int)chromaKeyRenderer7.aTextureHandle);
            chromaKeyRenderer8.checkForGlError("glEnableVertexAttribArray aTextureHandle");
            Matrix.setIdentityM((float[])chromaKeyRenderer5.mVPMatrix, (int)0);
            float[] fArray = ((ChromaKeyRenderer)object2).mVPMatrix;
            GLES20.glUniformMatrix4fv((int)chromaKeyRenderer6.uMVPMatrixHandle, (int)1, (boolean)false, (float[])fArray, (int)0);
            Object object2 = ((ChromaKeyRenderer)object2).sTMatrix;
            GLES20.glUniformMatrix4fv((int)chromaKeyRenderer3.uSTMatrixHandle, (int)1, (boolean)false, (float[])object2, (int)0);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            chromaKeyRenderer4.checkForGlError("glDrawArrays");
            GLES20.glFinish();
            return;
        }
    }

    @Override
    public void onSurfaceCreated(@Nullable GL10 object, @Nullable EGLConfig eGLConfig) {
        int n;
        ChromaKeyRenderer chromaKeyRenderer = this;
        object = chromaKeyRenderer.vertexShader;
        this.program = n = chromaKeyRenderer.createProgram((String)object, chromaKeyRenderer.getShader());
        if (n == 0) {
            return;
        }
        ChromaKeyRenderer chromaKeyRenderer2 = this;
        chromaKeyRenderer2.aPositionHandle = GLES20.glGetAttribLocation((int)n, (String)"aPosition");
        chromaKeyRenderer2.checkForGlError("glGetAttribLocation aPosition");
        if (chromaKeyRenderer2.aPositionHandle != -1) {
            ChromaKeyRenderer chromaKeyRenderer3 = this;
            chromaKeyRenderer3.aTextureHandle = GLES20.glGetAttribLocation((int)chromaKeyRenderer3.program, (String)"aTextureCoord");
            chromaKeyRenderer3.checkForGlError("glGetAttribLocation aTextureCoord");
            if (chromaKeyRenderer3.aTextureHandle != -1) {
                ChromaKeyRenderer chromaKeyRenderer4 = this;
                chromaKeyRenderer4.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)chromaKeyRenderer4.program, (String)"uMVPMatrix");
                chromaKeyRenderer4.checkForGlError("glGetUniformLocation uMVPMatrix");
                if (chromaKeyRenderer4.uMVPMatrixHandle != -1) {
                    ChromaKeyRenderer chromaKeyRenderer5 = this;
                    chromaKeyRenderer5.uSTMatrixHandle = GLES20.glGetUniformLocation((int)chromaKeyRenderer5.program, (String)"uSTMatrix");
                    chromaKeyRenderer5.checkForGlError("glGetUniformLocation uSTMatrix");
                    if (chromaKeyRenderer5.uSTMatrixHandle != -1) {
                        this.prepareSurface();
                        return;
                    }
                    throw new RuntimeException("Could not get attrib location for uSTMatrix");
                }
                throw new RuntimeException("Could not get attrib location for uMVPMatrix");
            }
            throw new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        throw new RuntimeException("Could not get attrib location for aPosition");
    }

    @Override
    public void onSurfaceDestroyed(@NotNull GL10 gL10) {
        Intrinsics.checkNotNullParameter((Object)gL10, (String)"gl");
    }

    @Override
    public void onSurfaceChanged(@NotNull GL10 gL10, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)gL10, (String)"glUnused");
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
    }

    public void onFrameAvailable(@NotNull SurfaceTexture surfaceTexture) {
        ChromaKeyRenderer chromaKeyRenderer = this;
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surface");
        synchronized (chromaKeyRenderer) {
            chromaKeyRenderer.updateSurface = true;
            return;
        }
    }

    public final void setBackgroundColor(int n) {
        ChromaKeyRenderer chromaKeyRenderer = object;
        float[] fArray = new float[3];
        Object object = fArray;
        float f = 255;
        object[0] = (float)Color.red((int)n) / f;
        object[1] = (float)Color.green((int)n) / f;
        fArray[2] = (float)Color.blue((int)n) / f;
        chromaKeyRenderer.colorToReplace = fArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/streamlayer/common/views/alphavideoview/ChromaKeyRenderer$Companion;", "", "()V", "COLOR_MAX_VALUE", "", "FLOAT_SIZE_BYTES", "GL_TEXTURE_EXTERNAL_OES", "QUAD_VERTICES_DATA_POS_OFFSET", "QUAD_VERTICES_DATA_STRIDE_BYTES", "QUAD_VERTICES_DATA_UV_OFFSET", "TAG", "", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

