/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import io.streamlayer.common.utils.JsonUtilKt;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.deeplink.ReferralLink;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tJ%\u0010\u001e\u001a\u00020\u0007*\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u001fJ\f\u0010 \u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/streamlayer/sdk/deeplink/DeepLinkHandler;", "", "()V", "DEEP_LINK_PAYLOAD_DATA", "", "DEEP_LINK_URI_DATA", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "route", "Lio/streamlayer/sdk/deeplink/DeepLinkRoute;", "destinationUri", "Landroid/net/Uri;", "payload", "Lio/streamlayer/sdk/model/deeplink/Payload;", "buildDeepLinkIntent$sdk_originalVonageRelease", "getDeepLink", "Lio/streamlayer/sdk/model/deeplink/DeepLink;", "intent", "getInvite", "Lio/streamlayer/sdk/model/deeplink/InviteData;", "json", "handleDeepLink", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "handleInvite", "", "data", "applyDeepLink", "applyDeepLink$sdk_originalVonageRelease", "clearDeeplink", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nDeepLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepLinkHandler.kt\nio/streamlayer/sdk/deeplink/DeepLinkHandler\n+ 2 JsonUtil.kt\nio/streamlayer/common/utils/JsonUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 6 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,115:1\n36#2,2:116\n38#2,6:122\n1#3:118\n123#4:119\n32#5:120\n80#6:121\n*S KotlinDebug\n*F\n+ 1 DeepLinkHandler.kt\nio/streamlayer/sdk/deeplink/DeepLinkHandler\n*L\n64#1:116,2\n64#1:122,6\n64#1:118\n64#1:119\n64#1:120\n64#1:121\n*E\n"})
public final class DeepLinkHandler {
    @NotNull
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();
    @NotNull
    private static final String DEEP_LINK_URI_DATA = "slr_deep_link_uri_data";
    @NotNull
    private static final String DEEP_LINK_PAYLOAD_DATA = "slr_deep_link_payload_data";

    private DeepLinkHandler() {
    }

    private final DeepLink getDeepLink(Intent intent) {
        DeepLink deepLink;
        DeepLinkHandler deepLinkHandler = (Uri)intent.getParcelableExtra(DEEP_LINK_URI_DATA);
        if (deepLinkHandler != null) {
            DeepLink deepLink2;
            deepLink = deepLink2;
            deepLink2 = new DeepLink((Uri)deepLinkHandler, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
        } else {
            deepLink = null;
        }
        return deepLink;
    }

    private final Intent clearDeeplink(Intent intent) {
        Intent intent2 = intent;
        intent2.removeExtra(DEEP_LINK_URI_DATA);
        intent2.removeExtra(DEEP_LINK_PAYLOAD_DATA);
        return intent2;
    }

    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull FragmentActivity object) {
        FragmentActivity fragmentActivity = object;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"activity");
        Object object2 = InterfacesKt.findSdkHost(fragmentActivity);
        if (object2 != null) {
            boolean bl;
            object = INSTANCE;
            DeepLink deepLink = ((DeepLinkHandler)object).getDeepLink(intent);
            if (deepLink != null) {
                SLRLog sLRLog = SLRLog.INSTANCE;
                String string2 = "DeepLinkHandler";
                Uri uri = intent.getData();
                boolean bl2 = Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer");
                Object object3 = object2;
                DeepLink deepLink2 = deepLink;
                object2 = deepLink2.getUri();
                sLRLog.i(string2, "processDeepLink  hasSdkSchema=" + bl2 + " " + (Uri)object2 + " " + deepLink2.getPayload());
                super.clearDeeplink(intent);
                object3.processDeepLink(deepLink);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        throw new IllegalStateException("StreamLayerFragment is not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        Json json = JsonUtilKt.getJson();
        Json json2 = json;
        Json json3 = json;
        try {
            KSerializer kSerializer = SerializersKt.serializer((SerializersModule)json2.getSerializersModule(), (KType)Reflection.typeOf(ReferralLink.class));
            Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            object = Result.constructor-impl((Object)json3.decodeFromString((DeserializationStrategy)kSerializer, string2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null && string2.length() > 0) {
            SLRLog.INSTANCE.w("JsonUtil", "json parsing exception:  " + string2);
            throwable.printStackTrace();
        }
        if (Result.isFailure-impl((Object)object)) {
            object = null;
        }
        return (object = (ReferralLink)object) != null ? ((ReferralLink)object).getData() : null;
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SLRLog.INSTANCE.i("DeepLinkHandler", "handleReferralLink link=" + inviteData);
        if (Intrinsics.areEqual((Object)inviteData.getGamification(), (Object)Boolean.TRUE)) {
            Payload.Gamification gamification;
            DeepLinkHandler deepLinkHandler = object;
            object = DeepLinkRoute.MAIN;
            Payload.Gamification gamification2 = gamification;
            gamification = new Payload.Gamification(inviteData);
            object = deepLinkHandler.buildDeepLinkIntent$sdk_originalVonageRelease(context, (DeepLinkRoute)((Object)object), NavigationUtils.INSTANCE.buildGamificationDeepLink(), gamification2);
        } else {
            Payload.Invite invite2;
            DeepLinkHandler deepLinkHandler = object;
            object = DeepLinkRoute.INVITE;
            Payload.Invite invite3 = invite2;
            invite2 = new Payload.Invite(inviteData);
            object = deepLinkHandler.buildDeepLinkIntent$sdk_originalVonageRelease(context, (DeepLinkRoute)((Object)object), NavigationUtils.INSTANCE.buildInviteDeepLink(), invite3);
        }
        context.startActivity((Intent)object);
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalVonageRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)deepLinkRoute), (String)"route");
        return this.applyDeepLink$sdk_originalVonageRelease(new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue()))), uri, payload);
    }

    @NotNull
    public final Intent applyDeepLink$sdk_originalVonageRelease(@NotNull Intent intent, @Nullable Uri uri, @Nullable Payload payload) {
        Intent intent2 = intent;
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"<this>");
        intent2.putExtra(DEEP_LINK_URI_DATA, (Parcelable)uri);
        intent2.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent2;
    }
}

