/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.social;

import com.streamlayer.social.TweetExtendedMedia;
import com.streamlayer.social.TweetHashtags;
import com.streamlayer.social.TweetMediaVideoInfo;
import com.streamlayer.social.TweetMetadata;
import com.streamlayer.social.TweetUrls;
import com.streamlayer.social.TweetUserMentions;
import io.streamlayer.common.utils.DateUtil;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetData;
import io.streamlayer.sdk.model.social.TweetEntities;
import io.streamlayer.sdk.model.social.TweetExtendedEntities;
import io.streamlayer.sdk.model.social.TweetHashtag;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.model.social.TweetMediaVideoInfo;
import io.streamlayer.sdk.model.social.TweetMediaVideoVariant;
import io.streamlayer.sdk.model.social.TweetMetaData;
import io.streamlayer.sdk.model.social.TweetSymbol;
import io.streamlayer.sdk.model.social.TweetUrl;
import io.streamlayer.sdk.model.social.TweetUserMention;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00a0\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\tH\u0000\u001a\u0010\u0010\u0006\u001a\u00020\n*\u00060\u000bj\u0002`\fH\u0000\u001a\u0010\u0010\u0006\u001a\u00020\r*\u00060\u000ej\u0002`\u000fH\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0010*\u00060\u0011j\u0002`\u0012H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\r*\u00060\u0013j\u0002`\u0014H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0015*\u00060\u0016j\u0002`\u0017H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u001b*\u00060\u001cj\u0002`\u001dH\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0005*\u00060\u001ej\u0002`\u001fH\u0000\u001a\u0010\u0010\u0006\u001a\u00020 *\u00060!j\u0002`\"H\u0000\u001a\u0010\u0010\u0006\u001a\u00020#*\u00060$j\u0002`%H\u0000\u001a\u0010\u0010\u0006\u001a\u00020&*\u00060'j\u0002`(H\u0000*\f\b\u0000\u0010)\"\u00020\b2\u00020\b*\f\b\u0000\u0010*\"\u00020\u000b2\u00020\u000b*\f\b\u0000\u0010+\"\u00020\u000e2\u00020\u000e*\f\b\u0000\u0010,\"\u00020\u00112\u00020\u0011*\f\b\u0000\u0010-\"\u00020\u00132\u00020\u0013*\f\b\u0000\u0010.\"\u00020\u00162\u00020\u0016*\f\b\u0000\u0010/\"\u00020\u00192\u00020\u0019*\f\b\u0000\u00100\"\u00020\u001c2\u00020\u001c*\f\b\u0000\u00101\"\u00020\u001e2\u00020\u001e*\f\b\u0000\u00102\"\u00020!2\u00020!*\f\b\u0000\u00103\"\u00020$2\u00020$*\f\b\u0000\u00104\"\u00020'2\u00020'\u00a8\u00065"}, d2={"geTweetAccountUrl", "", "url", "toData", "Lio/streamlayer/sdk/model/social/TweetData;", "Lio/streamlayer/sdk/model/social/Tweet;", "toDomain", "Lio/streamlayer/sdk/model/social/TweetEntities;", "Lcom/streamlayer/social/TweetMetadata$TweetEntities;", "Lio/streamlayer/sdk/model/social/TweetEntitiesProto;", "Lio/streamlayer/sdk/model/social/TweetExtendedEntities;", "Lcom/streamlayer/social/TweetMetadata$TweetExtendedEntities;", "Lio/streamlayer/sdk/model/social/TweetExtendedEntitiesProto;", "Lio/streamlayer/sdk/model/social/TweetMedia;", "Lcom/streamlayer/social/TweetExtendedMedia;", "Lio/streamlayer/sdk/model/social/TweetExtendedMediaProto;", "Lio/streamlayer/sdk/model/social/TweetHashtag;", "Lcom/streamlayer/social/TweetHashtags;", "Lio/streamlayer/sdk/model/social/TweetHashtagsProto;", "Lcom/streamlayer/social/TweetMedia;", "Lio/streamlayer/sdk/model/social/TweetMediaProto;", "Lio/streamlayer/sdk/model/social/TweetMediaVideoInfo;", "Lcom/streamlayer/social/TweetMediaVideoInfo;", "Lio/streamlayer/sdk/model/social/TweetMediaVideoInfoProto;", "Lio/streamlayer/sdk/model/social/TweetMediaVideoVariant;", "Lcom/streamlayer/social/TweetMediaVideoInfo$TweetVideoVariants;", "Lio/streamlayer/sdk/model/social/TweetMediaVideoVariantsProto;", "Lio/streamlayer/sdk/model/social/TweetMetaData;", "Lcom/streamlayer/social/TweetMetadata;", "Lio/streamlayer/sdk/model/social/TweetMetaDataProto;", "Lcom/streamlayer/social/Tweet;", "Lio/streamlayer/sdk/model/social/TweetProto;", "Lio/streamlayer/sdk/model/social/TweetSymbol;", "Lcom/streamlayer/social/TweetSymbol;", "Lio/streamlayer/sdk/model/social/TweetSymbolProto;", "Lio/streamlayer/sdk/model/social/TweetUrl;", "Lcom/streamlayer/social/TweetUrls;", "Lio/streamlayer/sdk/model/social/TweetUrlsProto;", "Lio/streamlayer/sdk/model/social/TweetUserMention;", "Lcom/streamlayer/social/TweetUserMentions;", "Lio/streamlayer/sdk/model/social/TweetUserMentionsProto;", "TweetEntitiesProto", "TweetExtendedEntitiesProto", "TweetExtendedMediaProto", "TweetHashtagsProto", "TweetMediaProto", "TweetMediaVideoInfoProto", "TweetMediaVideoVariantsProto", "TweetMetaDataProto", "TweetProto", "TweetSymbolProto", "TweetUrlsProto", "TweetUserMentionsProto", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nTwitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Twitter.kt\nio/streamlayer/sdk/model/social/TwitterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1549#2:203\n1620#2,3:204\n1549#2:207\n1620#2,3:208\n1549#2:211\n1620#2,3:212\n1549#2:215\n1620#2,3:216\n1549#2:219\n1620#2,3:220\n1549#2:223\n1620#2,3:224\n1549#2:227\n1620#2,3:228\n*S KotlinDebug\n*F\n+ 1 Twitter.kt\nio/streamlayer/sdk/model/social/TwitterKt\n*L\n127#1:203\n127#1:204,3\n128#1:207\n128#1:208,3\n129#1:211\n129#1:212,3\n130#1:215\n130#1:216,3\n131#1:219\n131#1:220,3\n136#1:223\n136#1:224,3\n199#1:227\n199#1:228,3\n*E\n"})
public final class TwitterKt {
    @NotNull
    public static final TweetData toData(@NotNull Tweet object) {
        Tweet tweet = object;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"<this>");
        String string2 = tweet.getId();
        Date date = tweet.getDate();
        if (date == null) {
            Date date2;
            date = date2;
            date2 = new Date();
        }
        Object object2 = object;
        ((TweetData)object2)(string2, date);
        return object2;
    }

    @NotNull
    public static final Tweet toDomain(@NotNull com.streamlayer.social.Tweet object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.social.Tweet tweet = object;
        Object object2 = tweet.getMeta().getIdStr();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"meta.idStr");
        object = DateUtil.INSTANCE.fromTwitterStringToDate(object.getDate());
        String string2 = tweet.getText();
        TweetMetadata tweetMetadata = tweet.getMeta();
        Intrinsics.checkNotNullExpressionValue((Object)tweetMetadata, (String)"meta");
        object2 = TwitterKt.toDomain(tweetMetadata);
        return new Tweet((String)object2, (Date)object, string2, (TweetMetaData)object2);
    }

    @NotNull
    public static final TweetMetaData toDomain(@NotNull TweetMetadata object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        TweetMetadata tweetMetadata = object;
        object = tweetMetadata.getAccount();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"account");
        String string2 = tweetMetadata.getAccountId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"accountId");
        String string3 = tweetMetadata.getAccountImage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"accountImage");
        String string4 = TwitterKt.geTweetAccountUrl(string3);
        TweetMetadata.TweetEntities tweetEntities = tweetMetadata.getEntities();
        Intrinsics.checkNotNullExpressionValue((Object)tweetEntities, (String)"entities");
        TweetEntities tweetEntities2 = TwitterKt.toDomain(tweetEntities);
        TweetMetadata.TweetExtendedEntities tweetExtendedEntities = tweetMetadata.getExtendedEntities();
        Intrinsics.checkNotNullExpressionValue((Object)tweetExtendedEntities, (String)"extendedEntities");
        TweetExtendedEntities tweetExtendedEntities2 = TwitterKt.toDomain(tweetExtendedEntities);
        long l = tweetMetadata.getFavoriteCount();
        long l2 = tweetMetadata.getRetweetCount();
        boolean bl = tweetMetadata.getAccountVerified();
        return new TweetMetaData((String)object, string2, string4, tweetEntities2, tweetExtendedEntities2, l, l2, bl);
    }

    @NotNull
    public static final TweetEntities toDomain(@NotNull TweetMetadata.TweetEntities object) {
        ArrayList arrayList;
        ArrayList<TweetUserMention> arrayList2;
        ArrayList<TweetMedia> arrayList3;
        ArrayList<TweetHashtag> arrayList4;
        ArrayList<TweetUrl> arrayList5;
        TweetMetadata.TweetEntities tweetEntities = object;
        Intrinsics.checkNotNullParameter((Object)tweetEntities, (String)"<this>");
        Object object2 = tweetEntities.getUrlsList();
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        ArrayList<TweetUrl> arrayList6 = arrayList5;
        arrayList5 = new ArrayList<TweetUrl>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            TweetUrls tweetUrls = (TweetUrls)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetUrls, (String)"it");
            arrayList6.add(TwitterKt.toDomain(tweetUrls));
        }
        object2 = object.getHashtagsList();
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        ArrayList<TweetHashtag> arrayList7 = arrayList4;
        arrayList4 = new ArrayList<TweetHashtag>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            TweetHashtags tweetHashtags = (TweetHashtags)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetHashtags, (String)"it");
            arrayList7.add(TwitterKt.toDomain(tweetHashtags));
        }
        object2 = object.getMediaList();
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        ArrayList<TweetMedia> arrayList8 = arrayList3;
        arrayList3 = new ArrayList<TweetMedia>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.social.TweetMedia tweetMedia = (com.streamlayer.social.TweetMedia)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetMedia, (String)"it");
            arrayList8.add(TwitterKt.toDomain(tweetMedia));
        }
        object2 = object.getUserMentionsList();
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        ArrayList<TweetUserMention> arrayList9 = arrayList2;
        arrayList2 = new ArrayList<TweetUserMention>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            TweetUserMentions tweetUserMentions = (TweetUserMentions)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetUserMentions, (String)"it");
            arrayList9.add(TwitterKt.toDomain(tweetUserMentions));
        }
        if ((object = object.getSymbolsList()) == null) {
            object = CollectionsKt.emptyList();
        }
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.social.TweetSymbol tweetSymbol = (com.streamlayer.social.TweetSymbol)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetSymbol, (String)"it");
            object2.add(TwitterKt.toDomain(tweetSymbol));
        }
        return new TweetEntities(arrayList6, arrayList7, arrayList8, arrayList9, (List<TweetSymbol>)object2);
    }

    @NotNull
    public static final TweetExtendedEntities toDomain(@NotNull TweetMetadata.TweetExtendedEntities object) {
        ArrayList<TweetMedia> arrayList;
        TweetMetadata.TweetExtendedEntities tweetExtendedEntities = object;
        Intrinsics.checkNotNullParameter((Object)tweetExtendedEntities, (String)"<this>");
        object = tweetExtendedEntities.getMediaList();
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        ArrayList<TweetMedia> arrayList2 = arrayList;
        arrayList = new ArrayList<TweetMedia>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TweetExtendedMedia tweetExtendedMedia = (TweetExtendedMedia)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetExtendedMedia, (String)"it");
            arrayList2.add(TwitterKt.toDomain(tweetExtendedMedia));
        }
        return new TweetExtendedEntities(arrayList2);
    }

    @NotNull
    public static final TweetUrl toDomain(@NotNull TweetUrls object) {
        TweetUrls tweetUrls = object;
        Intrinsics.checkNotNullParameter((Object)tweetUrls, (String)"<this>");
        String string2 = tweetUrls.getUrl();
        String string3 = tweetUrls.getDisplayUrl();
        String string4 = tweetUrls.getExpandedUrl();
        List list2 = tweetUrls.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Object object2 = object;
        object2(string2, string3, string4, list2);
        return object2;
    }

    @NotNull
    public static final TweetHashtag toDomain(@NotNull TweetHashtags object) {
        TweetHashtags tweetHashtags = object;
        Intrinsics.checkNotNullParameter((Object)tweetHashtags, (String)"<this>");
        String string2 = tweetHashtags.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
        List list2 = tweetHashtags.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Object object2 = object;
        object2(string2, list2);
        return object2;
    }

    @NotNull
    public static final TweetMedia toDomain(@NotNull com.streamlayer.social.TweetMedia object) {
        com.streamlayer.social.TweetMedia tweetMedia = object;
        Intrinsics.checkNotNullParameter((Object)tweetMedia, (String)"<this>");
        object = tweetMedia.getIdStr();
        String string2 = tweetMedia.getType();
        String string3 = tweetMedia.getUrl();
        String string4 = tweetMedia.getMediaUrlHttps();
        String string5 = tweetMedia.getDisplayUrl();
        List list2 = tweetMedia.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"idStr");
        return new TweetMedia((String)object, string2, string3, string5, string4, list2, null);
    }

    @NotNull
    public static final TweetMedia toDomain(@NotNull TweetExtendedMedia object) {
        TweetExtendedMedia tweetExtendedMedia = object;
        Intrinsics.checkNotNullParameter((Object)tweetExtendedMedia, (String)"<this>");
        String string2 = tweetExtendedMedia.getIdStr();
        String string3 = tweetExtendedMedia.getType();
        String string4 = tweetExtendedMedia.getUrl();
        String string5 = tweetExtendedMedia.getMediaUrlHttps();
        String string6 = tweetExtendedMedia.getDisplayUrl();
        List list2 = tweetExtendedMedia.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        com.streamlayer.social.TweetMediaVideoInfo tweetMediaVideoInfo = object.getVideoInfo();
        Intrinsics.checkNotNullExpressionValue((Object)tweetMediaVideoInfo, (String)"videoInfo");
        object = TwitterKt.toDomain(tweetMediaVideoInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idStr");
        return new TweetMedia(string2, string3, string4, string6, string5, list2, (TweetMediaVideoInfo)object);
    }

    @NotNull
    public static final TweetUserMention toDomain(@NotNull TweetUserMentions object) {
        TweetUserMentions tweetUserMentions = object;
        Intrinsics.checkNotNullParameter((Object)tweetUserMentions, (String)"<this>");
        String string2 = tweetUserMentions.getIdStr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idStr");
        String string3 = tweetUserMentions.getName();
        String string4 = tweetUserMentions.getScreenName();
        List list2 = tweetUserMentions.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Object object2 = object;
        object2(string2, string3, string4, list2);
        return object2;
    }

    @NotNull
    public static final TweetSymbol toDomain(@NotNull com.streamlayer.social.TweetSymbol object) {
        com.streamlayer.social.TweetSymbol tweetSymbol = object;
        Intrinsics.checkNotNullParameter((Object)tweetSymbol, (String)"<this>");
        String string2 = tweetSymbol.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
        List list2 = tweetSymbol.getIndicesList();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Object object2 = object;
        object2(string2, list2);
        return object2;
    }

    @NotNull
    public static final TweetMediaVideoVariant toDomain(@NotNull TweetMediaVideoInfo.TweetVideoVariants tweetVideoVariants) {
        Intrinsics.checkNotNullParameter((Object)tweetVideoVariants, (String)"<this>");
        TweetMediaVideoInfo.TweetVideoVariants tweetVideoVariants2 = tweetVideoVariants;
        int n = tweetVideoVariants2.getBitrate();
        String string2 = tweetVideoVariants2.getContentType();
        String string3 = tweetVideoVariants2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url");
        return new TweetMediaVideoVariant(n, string2, string3);
    }

    @NotNull
    public static final TweetMediaVideoInfo toDomain(@NotNull com.streamlayer.social.TweetMediaVideoInfo tweetMediaVideoInfo) {
        ArrayList<TweetMediaVideoVariant> arrayList;
        com.streamlayer.social.TweetMediaVideoInfo tweetMediaVideoInfo2 = tweetMediaVideoInfo;
        Intrinsics.checkNotNullParameter((Object)tweetMediaVideoInfo2, (String)"<this>");
        int n = tweetMediaVideoInfo2.getDurationMillis();
        Object object = tweetMediaVideoInfo2.getVariantsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variantsList");
        ArrayList<TweetMediaVideoVariant> arrayList2 = arrayList;
        arrayList = new ArrayList<TweetMediaVideoVariant>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TweetMediaVideoInfo.TweetVideoVariants tweetVideoVariants = (TweetMediaVideoInfo.TweetVideoVariants)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)tweetVideoVariants, (String)"it");
            arrayList2.add(TwitterKt.toDomain(tweetVideoVariants));
        }
        return new TweetMediaVideoInfo(n, arrayList2);
    }

    @NotNull
    public static final String geTweetAccountUrl(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"url");
        return StringsKt.replace$default((String)string3, (String)"_normal", (String)"_reasonably_small", (boolean)false, (int)4, null);
    }
}

