/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.watchparty;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.calls.WatchParty;
import io.streamlayer.sdk.model.calls.WatchPartyOwnerRelation;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantsRelation;
import io.streamlayer.sdk.model.calls.WatchPartyRelation;
import io.streamlayer.sdk.model.calls.WatchPartyStatus;
import io.streamlayer.sdk.model.calls.WatchPartyType;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicPrivateData;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.watchparty.WatchPartyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;

public final class WatchPartyDao_Impl
implements WatchPartyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WatchPartyStatus> __insertionAdapterOfWatchPartyStatus;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<WatchPartyStatus> __updateAdapterOfWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateWatchPartyStatusParticipated;
    private final SharedSQLiteStatement __preparedStmtOfDeleteWatchPartyStatus;
    private final SharedSQLiteStatement __preparedStmtOfDeleteTopic;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantsCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatParticipantCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChatOwnerCrossRef;
    private final SharedSQLiteStatement __preparedStmtOfSetWatchPartyPrivate;
    private final SharedSQLiteStatement __preparedStmtOfHidePublicWatchParties;

    public WatchPartyDao_Impl(RoomDatabase roomDatabase) {
        SharedSQLiteStatement sharedSQLiteStatement;
        SharedSQLiteStatement sharedSQLiteStatement2;
        SharedSQLiteStatement sharedSQLiteStatement3;
        SharedSQLiteStatement sharedSQLiteStatement4;
        SharedSQLiteStatement sharedSQLiteStatement5;
        SharedSQLiteStatement sharedSQLiteStatement6;
        SharedSQLiteStatement sharedSQLiteStatement7;
        SharedSQLiteStatement sharedSQLiteStatement8;
        EntityDeletionOrUpdateAdapter<WatchPartyStatus> entityDeletionOrUpdateAdapter;
        EntityInsertionAdapter<WatchPartyStatus> entityInsertionAdapter;
        Converters converters;
        Converters converters2 = converters;
        converters = new Converters();
        this.__converters = converters2;
        this.__db = roomDatabase;
        converters2 = entityInsertionAdapter;
        entityInsertionAdapter = new EntityInsertionAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WatchPartyStatus` (`chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
            }
        };
        this.__insertionAdapterOfWatchPartyStatus = converters2;
        converters2 = entityDeletionOrUpdateAdapter;
        entityDeletionOrUpdateAdapter = new EntityDeletionOrUpdateAdapter<WatchPartyStatus>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `WatchPartyStatus` SET `chatId` = ?,`participantStatuses` = ?,`isPrivate` = ?,`isParticipated` = ?,`type` = ? WHERE `chatId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WatchPartyStatus watchPartyStatus) {
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, watchPartyStatus.getChatId());
                }
                String string2 = WatchPartyDao_Impl.this.__converters.participantStatusesToString(watchPartyStatus.getParticipantStatuses());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                long l = (long)watchPartyStatus.isPrivate();
                supportSQLiteStatement.bindLong(3, l);
                l = (long)watchPartyStatus.isParticipated();
                supportSQLiteStatement.bindLong(4, l);
                if (watchPartyStatus.getType() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyStatus.getType()));
                }
                if (watchPartyStatus.getChatId() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, watchPartyStatus.getChatId());
                }
            }
        };
        this.__updateAdapterOfWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement8;
        sharedSQLiteStatement8 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isParticipated=1 WHERE WatchPartyStatus.chatId = ?";
            }
        };
        this.__preparedStmtOfUpdateWatchPartyStatusParticipated = converters2;
        converters2 = sharedSQLiteStatement7;
        sharedSQLiteStatement7 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM WatchPartyStatus WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteWatchPartyStatus = converters2;
        converters2 = sharedSQLiteStatement6;
        sharedSQLiteStatement6 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Topic WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteTopic = converters2;
        converters2 = sharedSQLiteStatement5;
        sharedSQLiteStatement5 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantsCrossRef = converters2;
        converters2 = sharedSQLiteStatement4;
        sharedSQLiteStatement4 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatParticipantCrossRef WHERE chatId=? AND chatUserId=?";
            }
        };
        this.__preparedStmtOfDeleteChatParticipantCrossRef = converters2;
        converters2 = sharedSQLiteStatement3;
        sharedSQLiteStatement3 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatOwnerCrossRef WHERE chatId=?";
            }
        };
        this.__preparedStmtOfDeleteChatOwnerCrossRef = converters2;
        converters2 = sharedSQLiteStatement2;
        sharedSQLiteStatement2 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=? WHERE chatId = ?";
            }
        };
        this.__preparedStmtOfSetWatchPartyPrivate = converters2;
        converters2 = sharedSQLiteStatement;
        sharedSQLiteStatement = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "UPDATE WatchPartyStatus SET isPrivate=1 WHERE type =? AND isParticipated=0";
            }
        };
        this.__preparedStmtOfHidePublicWatchParties = converters2;
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __WatchPartyType_enumToString(WatchPartyType watchPartyType) {
        if (watchPartyType == null) {
            return null;
        }
        int n = 29.$SwitchMap$io$streamlayer$sdk$model$calls$WatchPartyType[watchPartyType.ordinal()];
        if (n != 1) {
            if (n == 2) {
                return "REGULAR";
            }
            throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)watchPartyType));
        }
        return "PUBLIC";
    }

    private WatchPartyType __WatchPartyType_stringToEnum(String string2) {
        if (string2 == null) {
            return null;
        }
        if (!string2.equals("PUBLIC")) {
            if (string2.equals("REGULAR")) {
                return WatchPartyType.REGULAR;
            }
            throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + string2);
        }
        return WatchPartyType.PUBLIC;
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                String string2 = (String)arrayMap.keyAt(i);
                set2.put(string2, (ArrayList)arrayMap.valueAt(i));
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, ArrayList<TinodeContact>>)set2);
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, ArrayList<TinodeContact>>)set2);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`bypassId` AS `bypassId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`lastSeenTime` AS `lastSeenTime`,`TinodeContact`.`want` AS `want`,`TinodeContact`.`given` AS `given`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string3 : set2) {
            if (string3 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string3);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        while (true) {
            TinodeContact tinodeContact;
            Object object;
            Comparable<Long> comparable;
            String string4;
            String string5;
            boolean bl;
            String string6;
            String string7;
            Object object2;
            Object object3;
            String string3;
            block52: {
                Access access;
                String string8;
                block56: {
                    block55: {
                        block54: {
                            block53: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                block39: {
                                                                                    block38: {
                                                                                        block37: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            object3 = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(10));
                                                                                            if (object3 == null) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block37;
                                                                                            object2 = null;
                                                                                            break block38;
                                                                                        }
                                                                                        object2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block39;
                                                                                    string3 = null;
                                                                                    break block40;
                                                                                }
                                                                                string3 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block41;
                                                                            string7 = null;
                                                                            break block42;
                                                                        }
                                                                        string7 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block43;
                                                                    string6 = null;
                                                                    break block44;
                                                                }
                                                                string6 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block45;
                                                            string5 = null;
                                                            break block46;
                                                        }
                                                        string5 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block47;
                                                    string4 = null;
                                                    break block48;
                                                }
                                                string4 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block49;
                                            comparable = null;
                                            break block50;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block51;
                                    if (!roomSQLiteQuery.isNull(9)) break block51;
                                    object = null;
                                    break block52;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block53;
                                object = null;
                                break block54;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block55;
                        string8 = null;
                        break block56;
                    }
                    string8 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string8);
                object = access2;
            }
            ArrayList arrayList = object3;
            object3 = tinodeContact;
            tinodeContact = new TinodeContact((String)object2, string3, string7, string6, bl, string5, string4, (Date)comparable, (Access)object);
            arrayList.add(object3);
        }
        roomSQLiteQuery.close();
        return;
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, TinodeContact> arrayMap) {
        Set set2 = arrayMap.keySet();
        if (set2.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set2 = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                ArrayMap arrayMap3;
                set2.put((String)arrayMap.keyAt(i), null);
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, TinodeContact>)set2);
                arrayMap.putAll((Map)((Object)set2));
                set2 = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, TinodeContact>)set2);
                arrayMap.putAll((Map)((Object)set2));
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`bypassId` AS `bypassId`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`photoData` AS `photoData`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`lastSeenTime` AS `lastSeenTime`,`TinodeContact`.`want` AS `want`,`TinodeContact`.`given` AS `given`,_junction.`chatId` FROM `ChatOwnerCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set2.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string2 : set2) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string2);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        while (true) {
            TinodeContact tinodeContact;
            Object object;
            Comparable<Long> comparable;
            String string3;
            String string4;
            boolean bl;
            String string5;
            String string6;
            Object object2;
            Object object3;
            String string2;
            block53: {
                Access access;
                String string7;
                block57: {
                    block56: {
                        block55: {
                            block54: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block47: {
                                                        block46: {
                                                            block45: {
                                                                block44: {
                                                                    block43: {
                                                                        block42: {
                                                                            block41: {
                                                                                block40: {
                                                                                    block39: {
                                                                                        block38: {
                                                                                            if (!roomSQLiteQuery.moveToNext()) break;
                                                                                            ArrayMap<String, TinodeContact> arrayMap4 = arrayMap;
                                                                                            object3 = roomSQLiteQuery.getString(10);
                                                                                            if (!arrayMap4.containsKey(object3)) continue;
                                                                                            if (!roomSQLiteQuery.isNull(0)) break block38;
                                                                                            object2 = null;
                                                                                            break block39;
                                                                                        }
                                                                                        object2 = roomSQLiteQuery.getString(0);
                                                                                    }
                                                                                    if (!roomSQLiteQuery.isNull(1)) break block40;
                                                                                    string2 = null;
                                                                                    break block41;
                                                                                }
                                                                                string2 = roomSQLiteQuery.getString(1);
                                                                            }
                                                                            if (!roomSQLiteQuery.isNull(2)) break block42;
                                                                            string6 = null;
                                                                            break block43;
                                                                        }
                                                                        string6 = roomSQLiteQuery.getString(2);
                                                                    }
                                                                    if (!roomSQLiteQuery.isNull(3)) break block44;
                                                                    string5 = null;
                                                                    break block45;
                                                                }
                                                                string5 = roomSQLiteQuery.getString(3);
                                                            }
                                                            bl = roomSQLiteQuery.getInt(4) != 0;
                                                            if (!roomSQLiteQuery.isNull(5)) break block46;
                                                            string4 = null;
                                                            break block47;
                                                        }
                                                        string4 = roomSQLiteQuery.getString(5);
                                                    }
                                                    if (!roomSQLiteQuery.isNull(6)) break block48;
                                                    string3 = null;
                                                    break block49;
                                                }
                                                string3 = roomSQLiteQuery.getString(6);
                                            }
                                            if (!roomSQLiteQuery.isNull(7)) break block50;
                                            comparable = null;
                                            break block51;
                                        }
                                        comparable = roomSQLiteQuery.getLong(7);
                                    }
                                    RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
                                    comparable = this.__converters.timestampToDate((Long)comparable);
                                    if (!roomSQLiteQuery2.isNull(8)) break block52;
                                    if (!roomSQLiteQuery.isNull(9)) break block52;
                                    object = null;
                                    break block53;
                                }
                                if (!roomSQLiteQuery.isNull(8)) break block54;
                                object = null;
                                break block55;
                            }
                            object = roomSQLiteQuery.getString(8);
                        }
                        if (!roomSQLiteQuery.isNull(9)) break block56;
                        string7 = null;
                        break block57;
                    }
                    string7 = roomSQLiteQuery.getString(9);
                }
                Access access2 = access;
                access = new Access((String)object, string7);
                object = access2;
            }
            ArrayMap<String, TinodeContact> arrayMap5 = arrayMap;
            String string8 = object3;
            object3 = tinodeContact;
            tinodeContact = new TinodeContact((String)object2, string2, string6, string5, bl, string4, string3, (Date)comparable, (Access)object);
            arrayMap5.put((Object)string8, object3);
        }
        roomSQLiteQuery.close();
        return;
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
    }

    private void __fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus(ArrayMap<String, WatchPartyStatus> arrayMap) {
        RoomSQLiteQuery roomSQLiteQuery;
        block25: {
            int n;
            block24: {
                Set set2 = arrayMap.keySet();
                if (set2.isEmpty()) {
                    return;
                }
                if (arrayMap.size() > 999) {
                    ArrayMap arrayMap2;
                    set2 = arrayMap2;
                    arrayMap2 = new ArrayMap(999);
                    int n2 = 0;
                    int n3 = arrayMap.size();
                    for (int i = 0; i < n3; ++i) {
                        ArrayMap arrayMap3;
                        set2.put((String)arrayMap.keyAt(i), null);
                        if (++n2 != 999) continue;
                        this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set2);
                        arrayMap.putAll((Map)((Object)set2));
                        set2 = arrayMap3;
                        arrayMap3 = new ArrayMap(999);
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)set2);
                        arrayMap.putAll((Map)((Object)set2));
                    }
                    return;
                }
                StringBuilder stringBuilder = StringUtil.newStringBuilder();
                stringBuilder.append("SELECT `chatId`,`participantStatuses`,`isPrivate`,`isParticipated`,`type` FROM `WatchPartyStatus` WHERE `chatId` IN (");
                int n4 = set2.size();
                StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
                stringBuilder.append(")");
                roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
                n = 1;
                for (String string2 : set2) {
                    if (string2 == null) {
                        roomSQLiteQuery.bindNull(n);
                    } else {
                        roomSQLiteQuery.bindString(n, string2);
                    }
                    ++n;
                }
                roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatId");
                if (n != -1) break block24;
                roomSQLiteQuery.close();
                return;
            }
            while (true) {
                WatchPartyStatus watchPartyStatus;
                Object object;
                Object object2;
                String string2;
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                if (!roomSQLiteQuery.moveToNext()) break block25;
                                ArrayMap<String, WatchPartyStatus> arrayMap4 = arrayMap;
                                object2 = roomSQLiteQuery.getString(n);
                                if (!arrayMap4.containsKey(object2)) continue;
                                if (!roomSQLiteQuery.isNull(0)) break block26;
                                string2 = null;
                                break block27;
                            }
                            string2 = roomSQLiteQuery.getString(0);
                        }
                        if (!roomSQLiteQuery.isNull(1)) break block28;
                        object = null;
                        break block29;
                    }
                    object = roomSQLiteQuery.getString(1);
                }
                object = this.__converters.stringToParticipantStatuses((String)object);
                if (object == null) break;
                boolean bl = roomSQLiteQuery.getInt(2) != 0;
                boolean bl2 = roomSQLiteQuery.getInt(3) != 0;
                ArrayMap<String, WatchPartyStatus> arrayMap5 = arrayMap;
                Object object3 = object2;
                object2 = this.__WatchPartyType_stringToEnum(roomSQLiteQuery.getString(4));
                WatchPartyStatus watchPartyStatus2 = watchPartyStatus;
                watchPartyStatus = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, bl, bl2, (WatchPartyType)((Object)object2));
                arrayMap5.put(object3, (Object)watchPartyStatus2);
            }
            try {
                throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
            }
            catch (Throwable throwable) {
                roomSQLiteQuery.close();
                throw throwable;
            }
        }
        roomSQLiteQuery.close();
    }

    @Override
    public Object saveWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                Unit unit;
                11 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__insertionAdapterOfWatchPartyStatus.insert((Object)watchPartyStatus);
                    v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object updateWatchPartyStatus(final WatchPartyStatus watchPartyStatus, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                12 v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    v0.WatchPartyDao_Impl.this.__updateAdapterOfWatchPartyStatus.handle((Object)watchPartyStatus);
                }
                catch (Throwable throwable) {
                    WatchPartyDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                WatchPartyDao_Impl.this.__db.endTransaction();
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchParty(String string2, Continuation<? super Unit> continuation2) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, continuation -> WatchPartyDao.DefaultImpls.deleteWatchParty(this, string2, (Continuation<? super Unit>)continuation), continuation2);
    }

    @Override
    public Object updateWatchPartyStatusParticipated(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                13 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    13 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                13 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfUpdateWatchPartyStatusParticipated.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteWatchPartyStatus(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                14 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    14 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                14 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteWatchPartyStatus.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteTopic(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                15 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    15 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                15 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteTopic.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantsCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                16 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    16 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                16 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantsCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatParticipantCrossRef(final String string2, final String string3, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                17 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                n = 2;
                string22 = string3;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    17 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                17 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatParticipantCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object deleteChatOwnerCrossRef(final String string2, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                18 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.acquire();
                int n = 1;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    18 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                18 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfDeleteChatOwnerCrossRef.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object setWatchPartyPrivate(final String string2, final boolean bl, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                19 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.acquire();
                supportSQLiteStatement.bindLong(1, (long)bl);
                int n = 2;
                String string22 = v0.string2;
                if (string22 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, string22);
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    19 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                19 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfSetWatchPartyPrivate.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Object hidePublicWatchParties(final WatchPartyType watchPartyType, Continuation<? super Unit> continuation) {
        Callable<Unit> callable;
        Callable<Unit> callable2 = callable;
        callable = new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                20 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.acquire();
                int n = 1;
                WatchPartyType watchPartyType2 = v0.watchPartyType;
                if (watchPartyType2 == null) {
                    supportSQLiteStatement.bindNull(n);
                } else {
                    supportSQLiteStatement.bindString(n, WatchPartyDao_Impl.this.__WatchPartyType_enumToString(watchPartyType2));
                }
                WatchPartyDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    20 v2 = this;
                    v2.WatchPartyDao_Impl.this.__db.endTransaction();
                    v2.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                    throw throwable;
                }
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                Unit unit = Unit.INSTANCE;
                20 v4 = this;
                v4.WatchPartyDao_Impl.this.__db.endTransaction();
                v4.WatchPartyDao_Impl.this.__preparedStmtOfHidePublicWatchParties.release(supportSQLiteStatement);
                return unit;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)callable2, continuation);
    }

    @Override
    public Flow<WatchPartyStatus> observeWatchPartyStatus(String stringArray) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "WatchPartyStatus";
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_14;
                        void var4_10;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int n3;
                                block23: {
                                    int n4;
                                    block22: {
                                        block21: {
                                            int n5;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    throw throwable;
                                                }
                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n5)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n5);
                                        }
                                        if (!cursor.isNull(n4)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n4);
                                }
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (object == null) throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
                                if (cursor.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_10, (boolean)var5_14, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                return watchPartyStatus;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Object getWatchPartyStatus(String string2, Continuation<? super WatchPartyStatus> continuation) {
        Callable<WatchPartyStatus> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WatchPartyStatus WHERE WatchPartyStatus.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<WatchPartyStatus> callable2 = callable;
        callable = new Callable<WatchPartyStatus>(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public WatchPartyStatus call() throws Exception {
                WatchPartyStatus watchPartyStatus;
                Cursor cursor;
                block26: {
                    block19: {
                        void var5_13;
                        void var4_9;
                        WatchPartyStatus watchPartyStatus2;
                        Object object;
                        String string2;
                        int n;
                        block25: {
                            int n2;
                            block24: {
                                int n3;
                                block23: {
                                    int n4;
                                    block22: {
                                        block21: {
                                            int n5;
                                            block20: {
                                                cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                                try {
                                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"chatId");
                                                }
                                                catch (Throwable throwable) {
                                                    cursor.close();
                                                    roomSQLiteQuery.release();
                                                    throw throwable;
                                                }
                                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"participantStatuses");
                                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPrivate");
                                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isParticipated");
                                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                                if (!cursor.moveToFirst()) break block19;
                                                if (!cursor.isNull(n5)) break block20;
                                                string2 = null;
                                                break block21;
                                            }
                                            string2 = cursor.getString(n5);
                                        }
                                        if (!cursor.isNull(n4)) break block22;
                                        object = null;
                                        break block23;
                                    }
                                    object = cursor.getString(n4);
                                }
                                object = WatchPartyDao_Impl.this.__converters.stringToParticipantStatuses((String)object);
                                if (object == null) throw new IllegalStateException("Expected non-null java.util.List<io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus>, but it was null.");
                                if (cursor.getInt(n3) != 0) {
                                    boolean bl = true;
                                    break block24;
                                }
                                boolean bl = false;
                            }
                            if (cursor.getInt(n2) != 0) {
                                boolean bl = true;
                                break block25;
                            }
                            boolean bl = false;
                        }
                        WatchPartyType watchPartyType = WatchPartyDao_Impl.this.__WatchPartyType_stringToEnum(cursor.getString(n));
                        watchPartyStatus = watchPartyStatus2;
                        watchPartyStatus2 = new WatchPartyStatus(string2, (List<WatchPartyParticipantStatus>)object, (boolean)var4_9, (boolean)var5_13, watchPartyType);
                        break block26;
                    }
                    watchPartyStatus = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return watchPartyStatus;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object getWatchPartyOwner(String string2, Continuation<? super String> continuation) {
        Callable<String> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatOwnerCrossRef.chatUserId FROM ChatOwnerCrossRef WHERE ChatOwnerCrossRef.chatId = ?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<String> callable2 = callable;
        callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String string2;
                Cursor cursor;
                block5: {
                    block4: {
                        cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!cursor.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            roomSQLiteQuery.release();
                            throw throwable;
                        }
                        if (cursor.isNull(0)) break block4;
                        string2 = cursor.getString(0);
                        break block5;
                    }
                    string2 = null;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return string2;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Object isParticipatedInPublicParty(String string2, Continuation<? super Boolean> continuation) {
        Callable<Boolean> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT WatchPartyStatus.isParticipated FROM WatchPartyStatus WHERE WatchPartyStatus.chatId =?", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        string2 = DBUtil.createCancellationSignal();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                Cursor cursor = DBUtil.query((RoomDatabase)WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    Boolean bl2;
                    if (cursor.moveToFirst()) {
                        boolean bl3 = cursor.getInt(0) != 0;
                        bl2 = bl3;
                    } else {
                        bl2 = Boolean.FALSE;
                    }
                    bl = bl2;
                }
                catch (Throwable throwable) {
                    cursor.close();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                cursor.close();
                roomSQLiteQuery.release();
                return bl;
            }
        };
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)string2, (Callable)callable2, continuation);
    }

    @Override
    public Flow<List<WatchPartyRelation>> getWatchPartiesRelation() {
        Callable<List<WatchPartyRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT `Topic`.`chatId` AS `chatId`, `Topic`.`name` AS `name`, `Topic`.`seq` AS `seq`, `Topic`.`readSeq` AS `readSeq`, `Topic`.`recvSeq` AS `recvSeq`, `Topic`.`updatedAt` AS `updatedAt`, `Topic`.`touchedAt` AS `touchedAt`, `Topic`.`type` AS `type`, `Topic`.`watchPartyStreamId` AS `watchPartyStreamId`, `Topic`.`watchPartyStreamName` AS `watchPartyStreamName`, `Topic`.`want` AS `want`, `Topic`.`given` AS `given`, `Topic`.`mute` AS `mute` FROM Topic WHERE type = 1 ORDER BY Topic.updatedAt DESC", (int)0);
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatOwnerCrossRef";
        stringArray[3] = "WatchPartyStatus";
        stringArray[4] = "Topic";
        Callable<List<WatchPartyRelation>> callable2 = callable;
        callable = new Callable<List<WatchPartyRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<WatchPartyRelation> call() throws Exception {
                v0 = this;
                v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)v0.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = v1;
                v1 = new ArrayMap();
                var3_4 = v2;
                v2 = new ArrayMap();
                var4_5 = v3;
                v3 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block58: {
                        v4 = var2_2;
                        var5_6 = var1_1.getString(0);
                        if ((ArrayList)v4.get(var5_6) != null) break block58;
                        v5 = var2_2;
                        v6 = var5_6;
                        var5_6 = v7;
                        v7 = new ArrayList<E>();
                        v5.put((Object)v6, var5_6);
                    }
                    v8 = var4_5;
                    v9 = var1_1;
                    var3_4.put((Object)var1_1.getString(0), null);
                    v8.put((Object)v9.getString(0), null);
                    continue;
                }
lbl39:
                // 2 sources

                v10 = this;
                v11 = v10;
                v12 = v10;
                v13 = v10;
                var1_1.moveToPosition(-1);
                v12.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
                v13.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, TinodeContact>)var3_4);
                v11.WatchPartyDao_Impl.this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)var4_5);
                var5_6 = v14;
                v14 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block78: {
                        block77: {
                            block76: {
                                block75: {
                                    block74: {
                                        block73: {
                                            block68: {
                                                block72: {
                                                    block71: {
                                                        block70: {
                                                            block69: {
                                                                block67: {
                                                                    block66: {
                                                                        block65: {
                                                                            block64: {
                                                                                block63: {
                                                                                    block62: {
                                                                                        block61: {
                                                                                            block60: {
                                                                                                block59: {
                                                                                                    if (!var1_1.isNull(0)) break block59;
                                                                                                    var6_7 = null;
                                                                                                    break block60;
                                                                                                }
                                                                                                var6_7 = var1_1.getString(0);
                                                                                            }
                                                                                            if (!var1_1.isNull(1)) break block61;
                                                                                            var7_8 = null;
                                                                                            break block62;
                                                                                        }
                                                                                        var7_8 = var1_1.getString(1);
                                                                                    }
                                                                                    v15 = var1_1;
                                                                                    v16 = v15;
                                                                                    v17 = v15;
                                                                                    v18 = v15;
                                                                                    var8_10 = v15.getInt(2);
                                                                                    var9_11 = v16.getInt(3);
                                                                                    var10_12 = v17.getInt(4);
                                                                                    if (!v18.isNull(5)) break block63;
                                                                                    var11_13 /* !! */  = null;
                                                                                    break block64;
                                                                                }
                                                                                var11_13 /* !! */  = var1_1.getLong(5);
                                                                            }
                                                                            v19 = var1_1;
                                                                            var11_13 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var11_13 /* !! */ );
                                                                            if (!v19.isNull(6)) break block65;
                                                                            var12_14 /* !! */  = null;
                                                                            break block66;
                                                                        }
                                                                        var12_14 /* !! */  = var1_1.getLong(6);
                                                                    }
                                                                    v20 = var1_1;
                                                                    v21 = this;
                                                                    v22 = var1_1;
                                                                    var12_14 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var12_14 /* !! */ );
                                                                    var13_16 = v22.getInt(7);
                                                                    var13_15 = v21.WatchPartyDao_Impl.this.__converters.intToTopicType(var13_16);
                                                                    if (!v20.isNull(10)) break block67;
                                                                    if (!var1_1.isNull(11)) break block67;
                                                                    var14_17 = null;
                                                                    break block68;
                                                                }
                                                                if (!var1_1.isNull(10)) break block69;
                                                                var14_17 = null;
                                                                break block70;
                                                            }
                                                            var14_17 = var1_1.getString(10);
                                                        }
                                                        if (!var1_1.isNull(11)) break block71;
                                                        var15_18 = null;
                                                        break block72;
                                                    }
                                                    var15_18 = var1_1.getString(11);
                                                }
                                                var16_21 = v23;
                                                v23 = new Access((String)var14_17, (String)var15_18);
                                                var14_17 = var16_21;
                                            }
                                            if (var1_1.isNull(12)) break block73;
                                            var15_19 = var1_1.getInt(12) != 0;
                                            var16_21 = v24;
                                            v24 = new TopicPrivateData(var15_19);
                                            break block74;
                                        }
                                        var16_21 = null;
                                    }
                                    v25 = var1_1;
                                    var15_18 = v26;
                                    v26 = new Topic((String)var6_7, (String)var7_8, var8_10, var9_11, var10_12, (Date)var11_13 /* !! */ , (Date)var12_14 /* !! */ , (Access)var14_17, var13_15, (TopicPrivateData)var16_21);
                                    if (!v25.isNull(8)) break block75;
                                    var6_7 = null;
                                    break block76;
                                }
                                var6_7 = var1_1.getString(8);
                            }
                            var15_18.setWatchPartyStreamId((String)var6_7);
                            if (!var1_1.isNull(9)) break block77;
                            var6_7 = null;
                            break block78;
                        }
                        var6_7 = var1_1.getString(9);
                    }
                    var15_18.setWatchPartyStreamName((String)var6_7);
                    var6_7 = (ArrayList)var2_2.get((Object)var1_1.getString(0));
                    if (var6_7 != null) ** GOTO lbl174
                    var6_7 = v27;
                    v27 = new ArrayList<E>();
lbl174:
                    // 2 sources

                    v28 = var5_6;
                    v29 = var4_5;
                    v30 = var1_1;
                    var7_8 = (TinodeContact)var3_4.get((Object)var1_1.getString(0));
                    var8_9 = (WatchPartyStatus)v29.get((Object)v30.getString(0));
                    v28.add(new WatchPartyRelation((Topic)var15_18, (List<TinodeContact>)var6_7, (TinodeContact)var7_8, var8_9));
                    continue;
                }
lbl185:
                // 2 sources

                v31 = var5_6;
                v32 = this;
                v33 = var1_1;
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                v33.close();
                {
                    catch (Throwable v34) {
                        WatchPartyDao_Impl.this.__db.endTransaction();
                        throw v34;
                    }
                }
                v32.WatchPartyDao_Impl.this.__db.endTransaction();
                return v31;
                catch (Throwable var2_3) {
                    var1_1.close();
                    throw var2_3;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyRelation> observeWatchPartyRelation(String stringArray) {
        Callable<WatchPartyRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[5];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatOwnerCrossRef";
        stringArray2[3] = "WatchPartyStatus";
        stringArray2[4] = "Topic";
        Callable<WatchPartyRelation> callable2 = callable;
        callable = new Callable<WatchPartyRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyRelation call() throws Exception {
                block92: {
                    block71: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        block87: {
                                            block86: {
                                                block81: {
                                                    block85: {
                                                        block84: {
                                                            block83: {
                                                                block82: {
                                                                    block80: {
                                                                        block79: {
                                                                            block78: {
                                                                                block77: {
                                                                                    block76: {
                                                                                        block75: {
                                                                                            block74: {
                                                                                                block73: {
                                                                                                    block72: {
                                                                                                        v0 = this;
                                                                                                        v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                                                                                                        var1_1 = DBUtil.query((RoomDatabase)v0.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                        var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                        var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                        var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                        var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                        var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                        var10_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                        var11_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamName");
                                                                                                        var12_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                        var13_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                        var14_26 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                        var15_28 = v1;
                                                                                                        v1 = new ArrayMap();
                                                                                                        var16_29 = v2;
                                                                                                        v2 = new ArrayMap();
                                                                                                        var17_30 = v3;
                                                                                                        v3 = new ArrayMap();
                                                                                                        ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                        // 1 sources

                                                                                                        {
                                                                                                            block70: {
                                                                                                                v4 = var15_28;
                                                                                                                var18_31 = var1_1.getString(var2_2);
                                                                                                                if ((ArrayList)v4.get(var18_31) != null) break block70;
                                                                                                                v5 = var15_28;
                                                                                                                v6 = var18_31;
                                                                                                                var18_31 = v7;
                                                                                                                v7 = new ArrayList<E>();
                                                                                                                v5.put((Object)v6, var18_31);
                                                                                                            }
                                                                                                            v8 = var17_30;
                                                                                                            v9 = var1_1;
                                                                                                            v10 = var2_2;
                                                                                                            var16_29.put((Object)var1_1.getString(var2_2), null);
                                                                                                            v8.put((Object)v9.getString(v10), null);
                                                                                                            continue;
                                                                                                        }
lbl66:
                                                                                                        // 2 sources

                                                                                                        v11 = var1_1;
                                                                                                        v12 = this;
                                                                                                        v13 = v12;
                                                                                                        v14 = v12;
                                                                                                        v15 = v12;
                                                                                                        var1_1.moveToPosition(-1);
                                                                                                        v14.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, ArrayList<TinodeContact>>)var15_28);
                                                                                                        v15.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, TinodeContact>)var16_29);
                                                                                                        v13.WatchPartyDao_Impl.this.__fetchRelationshipWatchPartyStatusAsioStreamlayerSdkModelCallsWatchPartyStatus((ArrayMap<String, WatchPartyStatus>)var17_30);
                                                                                                        if (!v11.moveToFirst()) break block71;
                                                                                                        if (!var1_1.isNull(var2_2)) break block72;
                                                                                                        var18_31 = null;
                                                                                                        break block73;
                                                                                                    }
                                                                                                    var18_31 = var1_1.getString(var2_2);
                                                                                                }
                                                                                                if (!var1_1.isNull(var3_5)) break block74;
                                                                                                var3_6 = null;
                                                                                                break block75;
                                                                                            }
                                                                                            var3_6 = var1_1.getString(var3_5);
                                                                                        }
                                                                                        v16 = var1_1;
                                                                                        v17 = var7_12;
                                                                                        v18 = var1_1;
                                                                                        v19 = var6_11;
                                                                                        v20 = var1_1;
                                                                                        v21 = var5_9;
                                                                                        var4_7 = var1_1.getInt(var4_7);
                                                                                        var5_9 = v20.getInt(v21);
                                                                                        var6_11 = v18.getInt(v19);
                                                                                        if (!v16.isNull(v17)) break block76;
                                                                                        var7_13 /* !! */  = null;
                                                                                        break block77;
                                                                                    }
                                                                                    var7_13 /* !! */  = var1_1.getLong(var7_12);
                                                                                }
                                                                                v22 = var1_1;
                                                                                v23 = var8_14;
                                                                                var7_13 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var7_13 /* !! */ );
                                                                                if (!v22.isNull(v23)) break block78;
                                                                                var8_15 /* !! */  = null;
                                                                                break block79;
                                                                            }
                                                                            var8_15 /* !! */  = var1_1.getLong(var8_14);
                                                                        }
                                                                        v24 = var1_1;
                                                                        v25 = var12_20;
                                                                        v26 = this;
                                                                        v27 = var1_1;
                                                                        v28 = var9_16;
                                                                        var8_15 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var8_15 /* !! */ );
                                                                        var9_16 = v27.getInt(v28);
                                                                        var9_17 = v26.WatchPartyDao_Impl.this.__converters.intToTopicType(var9_16);
                                                                        if (!v24.isNull(v25)) break block80;
                                                                        if (!var1_1.isNull(var13_22)) break block80;
                                                                        var12_21 = null;
                                                                        break block81;
                                                                    }
                                                                    if (!var1_1.isNull(var12_20)) break block82;
                                                                    var12_21 = null;
                                                                    break block83;
                                                                }
                                                                var12_21 = var1_1.getString(var12_20);
                                                            }
                                                            if (!var1_1.isNull(var13_22)) break block84;
                                                            var13_23 = null;
                                                            break block85;
                                                        }
                                                        var13_23 = var1_1.getString(var13_22);
                                                    }
                                                    var19_32 = v29;
                                                    v29 = new Access((String)var12_21, var13_23);
                                                    var12_21 = var19_32;
                                                }
                                                if (var1_1.isNull(var14_26)) break block86;
                                                var13_24 = var1_1.getInt(var14_26) != 0;
                                                var14_27 = v30;
                                                v30 = new TopicPrivateData(var13_24);
                                                break block87;
                                            }
                                            var14_27 = null;
                                        }
                                        v31 = var1_1;
                                        v32 = var10_18;
                                        var13_25 = v33;
                                        v33 = new Topic((String)var18_31, (String)var3_6, var4_7, var5_9, var6_11, (Date)var7_13 /* !! */ , (Date)var8_15 /* !! */ , (Access)var12_21, var9_17, var14_27);
                                        if (!v31.isNull(v32)) break block88;
                                        var3_6 = null;
                                        break block89;
                                    }
                                    var3_6 = var1_1.getString(var10_18);
                                }
                                var13_25.setWatchPartyStreamId((String)var3_6);
                                if (!var1_1.isNull(var11_19)) break block90;
                                var3_6 = null;
                                break block91;
                            }
                            var3_6 = var1_1.getString(var11_19);
                        }
                        var13_25.setWatchPartyStreamName((String)var3_6);
                        var3_6 = (ArrayList)var15_28.get((Object)var1_1.getString(var2_2));
                        if (var3_6 != null) ** GOTO lbl205
                        var3_6 = v34;
                        v34 = new ArrayList<E>();
lbl205:
                        // 2 sources

                        v35 = var17_30;
                        v36 = var1_1;
                        v37 = var2_2;
                        var2_3 = (TinodeContact)var16_29.get((Object)var1_1.getString(var2_2));
                        var4_8 = (WatchPartyStatus)v35.get((Object)v36.getString(v37));
                        var5_10 = v38;
                        v38 = new WatchPartyRelation(var13_25, (List<TinodeContact>)var3_6, var2_3, var4_8);
                        break block92;
                    }
                    var5_10 = null;
                }
                v39 = var5_10;
                v40 = this;
                v41 = var1_1;
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                v41.close();
                {
                    catch (Throwable v42) {
                        WatchPartyDao_Impl.this.__db.endTransaction();
                        throw v42;
                    }
                }
                v40.WatchPartyDao_Impl.this.__db.endTransaction();
                return v39;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyOwnerRelation> getWatchPartyOwnerRelation(String stringArray) {
        Callable<WatchPartyOwnerRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[3];
        stringArray = stringArray2;
        stringArray2[0] = "ChatOwnerCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "Topic";
        Callable<WatchPartyOwnerRelation> callable2 = callable;
        callable = new Callable<WatchPartyOwnerRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyOwnerRelation call() throws Exception {
                block81: {
                    block60: {
                        block80: {
                            block79: {
                                block78: {
                                    block77: {
                                        block76: {
                                            block75: {
                                                block70: {
                                                    block74: {
                                                        block73: {
                                                            block72: {
                                                                block71: {
                                                                    block69: {
                                                                        block68: {
                                                                            block67: {
                                                                                block66: {
                                                                                    block65: {
                                                                                        block64: {
                                                                                            block63: {
                                                                                                block62: {
                                                                                                    block61: {
                                                                                                        v0 = this;
                                                                                                        v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                                                                                                        var1_1 = DBUtil.query((RoomDatabase)v0.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                        var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                        var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                        var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                        var6_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                        var7_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                        var8_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                        var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                        var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                        var11_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamName");
                                                                                                        var12_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                        var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                        var14_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                        var15_26 = v1;
                                                                                                        v1 = new ArrayMap();
                                                                                                        ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                        // 1 sources

                                                                                                        {
                                                                                                            var15_26.put((Object)var1_1.getString(var2_2), null);
                                                                                                            continue;
                                                                                                        }
lbl40:
                                                                                                        // 2 sources

                                                                                                        v2 = var1_1;
                                                                                                        v3 = this;
                                                                                                        var1_1.moveToPosition(-1);
                                                                                                        v3.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, TinodeContact>)var15_26);
                                                                                                        if (!v2.moveToFirst()) break block60;
                                                                                                        if (!var1_1.isNull(var2_2)) break block61;
                                                                                                        var16_27 = null;
                                                                                                        break block62;
                                                                                                    }
                                                                                                    var16_27 = var1_1.getString(var2_2);
                                                                                                }
                                                                                                if (!var1_1.isNull(var3_5)) break block63;
                                                                                                var3_6 = null;
                                                                                                break block64;
                                                                                            }
                                                                                            var3_6 = var1_1.getString(var3_5);
                                                                                        }
                                                                                        v4 = var1_1;
                                                                                        v5 = var7_10;
                                                                                        v6 = var1_1;
                                                                                        v7 = var6_9;
                                                                                        v8 = var1_1;
                                                                                        v9 = var5_8;
                                                                                        var4_7 = var1_1.getInt(var4_7);
                                                                                        var5_8 = v8.getInt(v9);
                                                                                        var6_9 = v6.getInt(v7);
                                                                                        if (!v4.isNull(v5)) break block65;
                                                                                        var7_11 /* !! */  = null;
                                                                                        break block66;
                                                                                    }
                                                                                    var7_11 /* !! */  = var1_1.getLong(var7_10);
                                                                                }
                                                                                v10 = var1_1;
                                                                                v11 = var8_12;
                                                                                var7_11 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var7_11 /* !! */ );
                                                                                if (!v10.isNull(v11)) break block67;
                                                                                var8_13 /* !! */  = null;
                                                                                break block68;
                                                                            }
                                                                            var8_13 /* !! */  = var1_1.getLong(var8_12);
                                                                        }
                                                                        v12 = var1_1;
                                                                        v13 = var12_18;
                                                                        v14 = this;
                                                                        v15 = var1_1;
                                                                        v16 = var9_14;
                                                                        var8_13 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var8_13 /* !! */ );
                                                                        var9_14 = v15.getInt(v16);
                                                                        var9_15 = v14.WatchPartyDao_Impl.this.__converters.intToTopicType(var9_14);
                                                                        if (!v12.isNull(v13)) break block69;
                                                                        if (!var1_1.isNull(var13_20)) break block69;
                                                                        var12_19 = null;
                                                                        break block70;
                                                                    }
                                                                    if (!var1_1.isNull(var12_18)) break block71;
                                                                    var12_19 = null;
                                                                    break block72;
                                                                }
                                                                var12_19 = var1_1.getString(var12_18);
                                                            }
                                                            if (!var1_1.isNull(var13_20)) break block73;
                                                            var13_21 = null;
                                                            break block74;
                                                        }
                                                        var13_21 = var1_1.getString(var13_20);
                                                    }
                                                    var17_28 = v17;
                                                    v17 = new Access((String)var12_19, var13_21);
                                                    var12_19 = var17_28;
                                                }
                                                if (var1_1.isNull(var14_24)) break block75;
                                                var13_22 = var1_1.getInt(var14_24) != 0;
                                                var14_25 = v18;
                                                v18 = new TopicPrivateData(var13_22);
                                                break block76;
                                            }
                                            var14_25 = null;
                                        }
                                        v19 = var1_1;
                                        v20 = var10_16;
                                        var13_23 = v21;
                                        v21 = new Topic(var16_27, (String)var3_6, var4_7, var5_8, var6_9, (Date)var7_11 /* !! */ , (Date)var8_13 /* !! */ , (Access)var12_19, var9_15, var14_25);
                                        if (!v19.isNull(v20)) break block77;
                                        var3_6 = null;
                                        break block78;
                                    }
                                    var3_6 = var1_1.getString(var10_16);
                                }
                                var13_23.setWatchPartyStreamId((String)var3_6);
                                if (!var1_1.isNull(var11_17)) break block79;
                                var3_6 = null;
                                break block80;
                            }
                            var3_6 = var1_1.getString(var11_17);
                        }
                        var13_23.setWatchPartyStreamName((String)var3_6);
                        var2_3 = (TinodeContact)var15_26.get((Object)var1_1.getString(var2_2));
                        var3_6 = v22;
                        v22 = new WatchPartyOwnerRelation(var13_23, var2_3);
                        break block81;
                    }
                    var3_6 = null;
                }
                v23 = var3_6;
                v24 = this;
                v25 = var1_1;
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        WatchPartyDao_Impl.this.__db.endTransaction();
                        throw v26;
                    }
                }
                v24.WatchPartyDao_Impl.this.__db.endTransaction();
                return v23;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<WatchPartyParticipantsRelation> getWatchPartyParticipantsRelation(String stringArray) {
        Callable<WatchPartyParticipantsRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Topic WHERE Topic.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[3];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "Topic";
        Callable<WatchPartyParticipantsRelation> callable2 = callable;
        callable = new Callable<WatchPartyParticipantsRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public WatchPartyParticipantsRelation call() throws Exception {
                block86: {
                    block64: {
                        block85: {
                            block84: {
                                block83: {
                                    block82: {
                                        block81: {
                                            block80: {
                                                block79: {
                                                    block74: {
                                                        block78: {
                                                            block77: {
                                                                block76: {
                                                                    block75: {
                                                                        block73: {
                                                                            block72: {
                                                                                block71: {
                                                                                    block70: {
                                                                                        block69: {
                                                                                            block68: {
                                                                                                block67: {
                                                                                                    block66: {
                                                                                                        block65: {
                                                                                                            v0 = this;
                                                                                                            v0.WatchPartyDao_Impl.this.__db.beginTransaction();
                                                                                                            var1_1 = DBUtil.query((RoomDatabase)v0.WatchPartyDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                                                                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                                                                            var3_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                                                                            var4_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                                                                            var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                                                                            var6_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                                                                            var7_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                                                                            var8_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"touchedAt");
                                                                                                            var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                                                                                            var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamId");
                                                                                                            var11_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"watchPartyStreamName");
                                                                                                            var12_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"want");
                                                                                                            var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"given");
                                                                                                            var14_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"mute");
                                                                                                            var15_26 = v1;
                                                                                                            v1 = new ArrayMap();
                                                                                                            ** while (var1_1.moveToNext())
lbl-1000:
                                                                                                            // 1 sources

                                                                                                            {
                                                                                                                v2 = var15_26;
                                                                                                                var16_27 = var1_1.getString(var2_2);
                                                                                                                if ((ArrayList)v2.get(var16_27) != null) continue;
                                                                                                                v3 = var15_26;
                                                                                                                v4 = var16_27;
                                                                                                                var16_27 = v5;
                                                                                                                v5 = new ArrayList<E>();
                                                                                                                v3.put((Object)v4, var16_27);
                                                                                                                continue;
                                                                                                            }
lbl50:
                                                                                                            // 2 sources

                                                                                                            v6 = var1_1;
                                                                                                            v7 = this;
                                                                                                            var1_1.moveToPosition(-1);
                                                                                                            v7.WatchPartyDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, ArrayList<TinodeContact>>)var15_26);
                                                                                                            if (!v6.moveToFirst()) break block64;
                                                                                                            if (!var1_1.isNull(var2_2)) break block65;
                                                                                                            var16_27 = null;
                                                                                                            break block66;
                                                                                                        }
                                                                                                        var16_27 = var1_1.getString(var2_2);
                                                                                                    }
                                                                                                    if (!var1_1.isNull(var3_5)) break block67;
                                                                                                    var3_6 = null;
                                                                                                    break block68;
                                                                                                }
                                                                                                var3_6 = var1_1.getString(var3_5);
                                                                                            }
                                                                                            v8 = var1_1;
                                                                                            v9 = var7_10;
                                                                                            v10 = var1_1;
                                                                                            v11 = var6_9;
                                                                                            v12 = var1_1;
                                                                                            v13 = var5_8;
                                                                                            var4_7 = var1_1.getInt(var4_7);
                                                                                            var5_8 = v12.getInt(v13);
                                                                                            var6_9 = v10.getInt(v11);
                                                                                            if (!v8.isNull(v9)) break block69;
                                                                                            var7_11 /* !! */  = null;
                                                                                            break block70;
                                                                                        }
                                                                                        var7_11 /* !! */  = var1_1.getLong(var7_10);
                                                                                    }
                                                                                    v14 = var1_1;
                                                                                    v15 = var8_12;
                                                                                    var7_11 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var7_11 /* !! */ );
                                                                                    if (!v14.isNull(v15)) break block71;
                                                                                    var8_13 /* !! */  = null;
                                                                                    break block72;
                                                                                }
                                                                                var8_13 /* !! */  = var1_1.getLong(var8_12);
                                                                            }
                                                                            v16 = var1_1;
                                                                            v17 = var12_18;
                                                                            v18 = this;
                                                                            v19 = var1_1;
                                                                            v20 = var9_14;
                                                                            var8_13 /* !! */  = WatchPartyDao_Impl.this.__converters.timestampToDate(var8_13 /* !! */ );
                                                                            var9_14 = v19.getInt(v20);
                                                                            var9_15 = v18.WatchPartyDao_Impl.this.__converters.intToTopicType(var9_14);
                                                                            if (!v16.isNull(v17)) break block73;
                                                                            if (!var1_1.isNull(var13_20)) break block73;
                                                                            var12_19 = null;
                                                                            break block74;
                                                                        }
                                                                        if (!var1_1.isNull(var12_18)) break block75;
                                                                        var12_19 = null;
                                                                        break block76;
                                                                    }
                                                                    var12_19 = var1_1.getString(var12_18);
                                                                }
                                                                if (!var1_1.isNull(var13_20)) break block77;
                                                                var13_21 = null;
                                                                break block78;
                                                            }
                                                            var13_21 = var1_1.getString(var13_20);
                                                        }
                                                        var17_28 = v21;
                                                        v21 = new Access((String)var12_19, var13_21);
                                                        var12_19 = var17_28;
                                                    }
                                                    if (var1_1.isNull(var14_24)) break block79;
                                                    var13_22 = var1_1.getInt(var14_24) != 0;
                                                    var14_25 = v22;
                                                    v22 = new TopicPrivateData(var13_22);
                                                    break block80;
                                                }
                                                var14_25 = null;
                                            }
                                            v23 = var1_1;
                                            v24 = var10_16;
                                            var13_23 = v25;
                                            v25 = new Topic((String)var16_27, (String)var3_6, var4_7, var5_8, var6_9, (Date)var7_11 /* !! */ , (Date)var8_13 /* !! */ , (Access)var12_19, var9_15, var14_25);
                                            if (!v23.isNull(v24)) break block81;
                                            var3_6 = null;
                                            break block82;
                                        }
                                        var3_6 = var1_1.getString(var10_16);
                                    }
                                    var13_23.setWatchPartyStreamId((String)var3_6);
                                    if (!var1_1.isNull(var11_17)) break block83;
                                    var3_6 = null;
                                    break block84;
                                }
                                var3_6 = var1_1.getString(var11_17);
                            }
                            var13_23.setWatchPartyStreamName((String)var3_6);
                            var2_3 = (ArrayList)var15_26.get((Object)var1_1.getString(var2_2));
                            if (var2_3 != null) break block85;
                            var2_3 = v26;
                            v26 = new ArrayList<E>();
                        }
                        var3_6 = v27;
                        v27 = new WatchPartyParticipantsRelation(var13_23, var2_3);
                        break block86;
                    }
                    var3_6 = null;
                }
                v28 = var3_6;
                v29 = this;
                v30 = var1_1;
                WatchPartyDao_Impl.this.__db.setTransactionSuccessful();
                v30.close();
                {
                    catch (Throwable v31) {
                        WatchPartyDao_Impl.this.__db.endTransaction();
                        throw v31;
                    }
                }
                v29.WatchPartyDao_Impl.this.__db.endTransaction();
                return v28;
                catch (Throwable var2_4) {
                    var1_1.close();
                    throw var2_4;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Flow<List<WatchParty>> observeWatchParties(Function1<? super WatchPartyRelation, WatchParty> function1) {
        return WatchPartyDao.DefaultImpls.observeWatchParties(this, function1);
    }

    @Override
    public Flow<WatchPartyOwnerRelation> observeWatchPartyOwner(String string2) {
        return WatchPartyDao.DefaultImpls.observeWatchPartyOwner(this, string2);
    }

    @Override
    public Flow<WatchPartyParticipantsRelation> observeWatchPartyParticipants(String string2) {
        return WatchPartyDao.DefaultImpls.observeWatchPartyParticipants(this, string2);
    }
}

