/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemStatisticsStandingLabelsBinding;
import io.streamlayer.sdk.databinding.SlrItemStatisticsStandingValuesBinding;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamStanding;
import io.streamlayer.sdk.statistics.common.SectionViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\u000e2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00070\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "type", "Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;", "(Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;)V", "data", "", "", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "map", "", "", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "Companion", "StandingViewHolder", "Type", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nStandingsAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandingsAdapter.kt\nio/streamlayer/sdk/statistics/common/StandingsAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,117:1\n215#2,2:118\n*S KotlinDebug\n*F\n+ 1 StandingsAdapter.kt\nio/streamlayer/sdk/statistics/common/StandingsAdapter\n*L\n30#1:118,2\n*E\n"})
public final class StandingsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_SECTION = 0;
    private static final int TYPE_ITEM = 1;
    @NotNull
    private final Type type;
    @NotNull
    private List<? extends Object> data;

    public StandingsAdapter(@NotNull Type type2) {
        StandingsAdapter standingsAdapter = this;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        standingsAdapter.type = type2;
        standingsAdapter.data = CollectionsKt.emptyList();
    }

    public final void setData(@NotNull Map<String, ? extends List<? extends TeamStandings>> object) {
        ArrayList arrayList;
        Map<String, ? extends List<? extends TeamStandings>> map2 = object;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        object = arrayList;
        arrayList = new ArrayList();
        Iterator<Map.Entry<String, ? extends List<? extends TeamStandings>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object;
            Map.Entry<String, ? extends List<? extends TeamStandings>> entry = iterator.next();
            Object object3 = entry;
            object3 = object3.getValue();
            object2.add(entry.getKey());
            object2.addAll(object3);
        }
        this.data = object;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.data.get(n);
                    if (!(object instanceof String)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof TeamStandings)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported item type at data[" + n + "]");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        void var2_3;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"parent");
        if (var2_3 != false) {
            StandingViewHolder standingViewHolder;
            if (var2_3 != true) throw new RuntimeException("Unsupported viewType: " + (int)var2_3);
            viewHolder = standingViewHolder;
            SlrItemStatisticsStandingValuesBinding slrItemStatisticsStandingValuesBinding = SlrItemStatisticsStandingValuesBinding.inflate(LayoutInflater.from((Context)var1_2.getContext()), (ViewGroup)var1_2, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsStandingValuesBinding, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            standingViewHolder = new StandingViewHolder(slrItemStatisticsStandingValuesBinding);
            return viewHolder;
        } else {
            SectionViewHolder sectionViewHolder;
            viewHolder = sectionViewHolder;
            SlrItemStatisticsStandingLabelsBinding slrItemStatisticsStandingLabelsBinding = SlrItemStatisticsStandingLabelsBinding.inflate(LayoutInflater.from((Context)var1_2.getContext()), (ViewGroup)var1_2, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsStandingLabelsBinding, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
            sectionViewHolder = new SectionViewHolder(slrItemStatisticsStandingLabelsBinding);
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof SectionViewHolder && object instanceof String) {
            ((SectionViewHolder)viewHolder).bind((String)object);
        } else if (viewHolder instanceof StandingViewHolder && object instanceof TeamStandings) {
            ((StandingViewHolder)viewHolder).bind((TeamStandings)object);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Type;", "", "(Ljava/lang/String;I)V", "Baseball", "Basketball", "sdk_originalVonageRelease"})
    public static enum Type {
        Baseball,
        Basketball;

    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$StandingViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemStatisticsStandingValuesBinding;", "(Lio/streamlayer/sdk/statistics/common/StandingsAdapter;Lio/streamlayer/sdk/databinding/SlrItemStatisticsStandingValuesBinding;)V", "percentageFormat", "", "bind", "", "standings", "Lio/streamlayer/sdk/model/sports/TeamStandings;", "formatPercentage", "percentage", "", "sdk_originalVonageRelease"})
    public final class StandingViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemStatisticsStandingValuesBinding binding;
        @NotNull
        private final String percentageFormat;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StandingViewHolder(SlrItemStatisticsStandingValuesBinding slrItemStatisticsStandingValuesBinding) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsStandingValuesBinding, (String)"binding");
            super((View)slrItemStatisticsStandingValuesBinding.getRoot());
            this.binding = slrItemStatisticsStandingValuesBinding;
            int n = WhenMappings.$EnumSwitchMapping$0[StandingsAdapter.this.type.ordinal()];
            if (n != 1) {
                if (n != 2) throw new NoWhenBranchMatchedException();
                string2 = "%.1f";
            } else {
                string2 = "%.3f";
            }
            this.percentageFormat = string2;
        }

        private final String formatPercentage(double d) {
            Object object = String.format(object.percentageFormat, Arrays.copyOf(new Object[]{d}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
            int n = d < 1.0 ? 1 : 0;
            return StringsKt.drop((String)object, (int)n);
        }

        public final void bind(@NotNull TeamStandings object) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"standings");
            SlrItemStatisticsStandingValuesBinding slrItemStatisticsStandingValuesBinding = ((StandingViewHolder)((Object)object2)).binding;
            slrItemStatisticsStandingValuesBinding.slStandingsTeamName.setText((CharSequence)object.getTeamName());
            ImageView imageView2 = slrItemStatisticsStandingValuesBinding.slStandingsTeamIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slStandingsTeamIcon");
            ViewExtensionsKt.loadUrl$default(imageView2, object.getTeamIcon(), false, R.drawable.slr_ic_team_placeholder, null, 8, null);
            slrItemStatisticsStandingValuesBinding.slStandingsValueWins.setText((CharSequence)String.valueOf(object.getWins()));
            slrItemStatisticsStandingValuesBinding.slStandingsValueLosses.setText((CharSequence)String.valueOf(object.getLosses()));
            slrItemStatisticsStandingValuesBinding.slStandingsValuePercentage.setText((CharSequence)((StandingViewHolder)((Object)object2)).formatPercentage(object.getPercentage()));
            slrItemStatisticsStandingValuesBinding.slStandingsValueGamesBehind.setText((CharSequence)String.valueOf(object.getGamesBehind()));
            if (object instanceof BasketballTeamStanding) {
                TeamStandings teamStandings = object;
                object2 = slrItemStatisticsStandingValuesBinding.slStandingsValueStreak;
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n2 = 0;
                BasketballTeamStanding basketballTeamStanding = (BasketballTeamStanding)teamStandings;
                Object object3 = StringsKt.firstOrNull((CharSequence)basketballTeamStanding.getStreak().getKind());
                object3 = object3 != null ? Character.valueOf(Character.toUpperCase(((Character)object3).charValue())) : "";
                objectArray[n2] = object3;
                objectArray[1] = basketballTeamStanding.getStreak().getLength();
                String string2 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                object2.setText((CharSequence)string2);
            } else if (object instanceof BaseballTeamStanding) {
                AppCompatTextView appCompatTextView = slrItemStatisticsStandingValuesBinding.slStandingsValueStreak;
                Object[] objectArray = new Object[2];
                object2 = (BaseballTeamStanding)object;
                objectArray[0] = ((BaseballTeamStanding)object2).getStreak().getWins();
                objectArray[1] = ((BaseballTeamStanding)object2).getStreak().getLosses();
                String string3 = String.format("%d - %d", Arrays.copyOf(objectArray, 2));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                appCompatTextView.setText((CharSequence)string3);
            } else if (object instanceof HockeyTeamStanding) {
                Object object4 = object;
                object2 = slrItemStatisticsStandingValuesBinding.slStandingsValueStreak;
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n3 = 0;
                HockeyTeamStanding hockeyTeamStanding = (HockeyTeamStanding)object4;
                Object object5 = StringsKt.firstOrNull((CharSequence)hockeyTeamStanding.getStreak().getKind());
                object5 = object5 != null ? Character.valueOf(Character.toUpperCase(((Character)object5).charValue())) : "";
                objectArray[n3] = object5;
                objectArray[1] = hockeyTeamStanding.getStreak().getLength();
                String string4 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
                object2.setText((CharSequence)string4);
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                int[] nArray2 = nArray;
                try {
                    nArray[Type.Basketball.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray2[Type.Baseball.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray2;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/statistics/common/StandingsAdapter$Companion;", "", "()V", "TYPE_ITEM", "", "TYPE_SECTION", "sdk_originalVonageRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

