/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.TranslateAnimation;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleKt;
import androidx.lifecycle.ViewKt;
import androidx.transition.ChangeBounds;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.viewbinding.ViewBinding;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.tools.DefaultTransitionListener;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010&\n\u0002\b\u000e*\u0002\u001b6\b\u0000\u0018\u00002\u00020\u0001:\u0003cdeB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001f2\u0018\u0010<\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020$0#0=H\u0002J\u0016\u0010>\u001a\u00020&2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0@H\u0002J\u0018\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020DH\u0002J\u0012\u0010E\u001a\u00020&2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001f0@J(\u0010I\u001a\u00020&2\u001e\u0010J\u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020$0#0!H\u0002J\u0010\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020\u001fH\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010$2\u0006\u0010L\u001a\u00020\u001fH\u0002J\u0006\u0010N\u001a\u00020\u0007J\u000e\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u0007J\u0010\u0010Q\u001a\u00020&2\u0006\u0010R\u001a\u00020\u0013H\u0002J\u0018\u0010S\u001a\u00020&2\u0006\u0010B\u001a\u00020G2\u0006\u0010L\u001a\u00020\u001fH\u0002J\b\u0010T\u001a\u00020\u0013H\u0002J\b\u0010U\u001a\u00020&H\u0014J(\u0010V\u001a\u00020&2\u001e\u0010W\u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020$0#0XH\u0002J\u0016\u0010Y\u001a\u00020&2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0@H\u0002J\u0018\u0010Z\u001a\u00020&2\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010[\u001a\u00020$H\u0002J\u0018\u0010\\\u001a\u00020&2\u0006\u0010L\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020GH\u0002J\b\u0010]\u001a\u00020&H\u0002J\u0014\u0010^\u001a\u00020&2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0@J\u000e\u0010_\u001a\u00020&2\u0006\u0010`\u001a\u00020\u0013J&\u0010a\u001a\u00020&*\u00020:2\u0018\u0010<\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020$0#0=H\u0002J\f\u0010b\u001a\u00020\u0013*\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020$0#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\r\"\u0004\b(\u0010\u000fR\u001a\u0010)\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107\u00a8\u0006f"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsLayout;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bottomMargin", "getOverlayHeight", "Lkotlin/Function0;", "getGetOverlayHeight", "()Lkotlin/jvm/functions/Function0;", "setGetOverlayHeight", "(Lkotlin/jvm/functions/Function0;)V", "hideNotificationsPath", "", "isPortrait", "", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationsInteractionListener;", "getListener", "()Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationsInteractionListener;", "setListener", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationsInteractionListener;)V", "notificationViewAction", "io/streamlayer/sdk/main/notifications/NotificationsLayout$notificationViewAction$1", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$notificationViewAction$1;", "notificationsSet", "Ljava/util/TreeSet;", "Lio/streamlayer/sdk/model/notifications/Notification;", "notificationsViews", "Ljava/util/SortedMap;", "", "Lkotlin/Pair;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "onChildAdded", "", "getOnChildAdded", "setOnChildAdded", "onScreen", "getOnScreen", "()Z", "setOnScreen", "(Z)V", "showedNotificationsIds", "", "startMargin", "timerJob", "Lkotlinx/coroutines/Job;", "viewProvider", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "viewsComparator", "io/streamlayer/sdk/main/notifications/NotificationsLayout$viewsComparator$1", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$viewsComparator$1;", "addNotificationToLayout", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "item", "notificationsToAnimate", "", "addNotifications", "notifications", "", "addToPoolOrRemoveNotificationsView", "view", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "addView", "child", "Landroid/view/View;", "clearInviteDeleteJoinNotifications", "clearNotificationsStackViews", "map", "dismissNotification", "notification", "getNotificationView", "getTooltipBottomMargin", "getTooltipRightMargin", "bubbleWidth", "hideAllNotifications", "animate", "hideNotification", "notifyAllNotificationsDismissed", "onDetachedFromWindow", "removeNotification", "it", "", "removeNotifications", "showNotification", "baseView", "showNotificationExpand", "startDismissTimer", "update", "visible", "show", "animateNotificationsAppear", "shouldAnimateOnExpand", "BaseNotificationView", "NotificationViewAction", "NotificationsInteractionListener", "sdk_originalVonageRelease"})
@SourceDebugExtension(value={"SMAP\nNotificationsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsLayout.kt\nio/streamlayer/sdk/main/notifications/NotificationsLayout\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Animator.kt\nandroidx/core/animation/AnimatorKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,596:1\n483#2,7:597\n215#3,2:604\n215#3,2:612\n215#3,2:645\n215#3:647\n216#3:654\n215#3,2:655\n766#4:606\n857#4,2:607\n766#4:609\n857#4,2:610\n1045#4:657\n766#4:658\n857#4,2:659\n1855#4,2:661\n43#5:614\n95#5,14:615\n32#5:629\n95#5,14:630\n1#6:644\n329#7,4:648\n392#7,2:652\n315#7:663\n329#7,4:664\n316#7:668\n*S KotlinDebug\n*F\n+ 1 NotificationsLayout.kt\nio/streamlayer/sdk/main/notifications/NotificationsLayout\n*L\n127#1:597,7\n133#1:604,2\n147#1:612,2\n352#1:645,2\n429#1:647\n429#1:654\n507#1:655,2\n140#1:606\n140#1:607,2\n141#1:609\n141#1:610,2\n165#1:657\n165#1:658\n165#1:659,2\n165#1:661,2\n245#1:614\n245#1:615,14\n251#1:629\n251#1:630,14\n438#1:648,4\n446#1:652,2\n241#1:663\n241#1:664,4\n241#1:668\n*E\n"})
public final class NotificationsLayout
extends ConstraintLayout {
    private final int bottomMargin;
    private final int startMargin;
    private final float hideNotificationsPath;
    private final boolean isPortrait;
    @Nullable
    private Job timerJob;
    @Nullable
    private Function0<Unit> onChildAdded;
    @Nullable
    private Function0<Integer> getOverlayHeight;
    @NotNull
    private final TreeSet<Notification> notificationsSet;
    @NotNull
    private final viewsComparator.1 viewsComparator;
    @NotNull
    private final SortedMap<Long, Pair<Notification, BaseNotificationView>> notificationsViews;
    @NotNull
    private final Set<Long> showedNotificationsIds;
    @NotNull
    private final notificationViewAction.1 notificationViewAction;
    @NotNull
    private final NotificationViewsProvider viewProvider;
    @Nullable
    private NotificationsInteractionListener listener;
    private boolean onScreen;

    @JvmOverloads
    public NotificationsLayout(@NotNull Context object, @Nullable AttributeSet attributeSet, int n) {
        NotificationViewAction notificationViewAction2;
        Comparator<Long> comparator;
        Context context = object;
        NotificationsLayout notificationsLayout = this;
        NotificationsLayout notificationsLayout2 = this;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        notificationsLayout2.bottomMargin = notificationsLayout2.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        notificationsLayout2.startMargin = notificationsLayout2.getResources().getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
        notificationsLayout2.hideNotificationsPath = ViewExtensionsKt.getDp(130.0f);
        notificationsLayout.isPortrait = OtherExtensionsKt.isScreenPortrait(object);
        notificationsLayout.notificationsSet = new TreeSet<Notification>(new Comparator<Notification>(){

            public int compare(@Nullable Notification notification, @Nullable Notification notification2) {
                if (notification != null && notification2 != null) {
                    Long l = notification2.getId();
                    Intrinsics.checkNotNull((Object)l);
                    long l2 = l;
                    Long l3 = notification.getId();
                    Intrinsics.checkNotNull((Object)l3);
                    return Intrinsics.compare((long)l2, (long)l3);
                }
                return 0;
            }
        });
        object = comparator;
        notificationsLayout.viewsComparator = new Comparator<Long>(){

            public int compare(@Nullable Long l, @Nullable Long l2) {
                if (l != null && l2 != null) {
                    return Intrinsics.compare((long)l2, (long)l);
                }
                return 0;
            }
        };
        notificationsLayout.notificationsViews = new TreeMap<Long, Pair<Notification, BaseNotificationView>>((Comparator<Long>)object);
        notificationsLayout.showedNotificationsIds = new LinkedHashSet<Long>();
        object = notificationViewAction2;
        notificationsLayout.notificationViewAction = new NotificationViewAction(this){
            final /* synthetic */ NotificationsLayout this$0;
            {
                this.this$0 = notificationsLayout;
            }

            public void onExpand(@NotNull Notification notification, @NotNull View view2) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
                NotificationsLayout.access$showNotificationExpand(this.this$0, notification, view2);
            }

            public void onHide(@NotNull Notification notification, @NotNull View view2) {
                notificationViewAction.1 v0 = notificationsInteractionListener;
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
                NotificationsLayout.access$getNotificationsSet$p(v0.this$0).remove(notification);
                NotificationsLayout.access$hideNotification(v0.this$0, view2, notification);
                NotificationsInteractionListener notificationsInteractionListener = v0.this$0.getListener();
                if (notificationsInteractionListener != null) {
                    notificationsInteractionListener.onNotificationDismissed(notification, true);
                }
            }

            public void hideAll() {
                NotificationsLayout.access$hideAllNotifications(this.this$0, true);
            }
        };
        Object object2 = object;
        object = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resources");
        notificationsLayout.viewProvider = new NotificationViewsProvider((NotificationViewAction)object2, (Resources)object);
        notificationsLayout.onScreen = true;
        int n2 = OtherExtensionsKt.isScreenPortrait(context) ? this.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small) : 0;
        this.setPadding(n2, 0, this.getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin_small), 0);
    }

    public /* synthetic */ NotificationsLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void removeNotification(Map.Entry<Long, ? extends Pair<Notification, ? extends BaseNotificationView>> entry) {
        NotificationsLayout notificationsLayout = this;
        notificationsLayout.notificationsViews.remove(entry.getKey());
        notificationsLayout.showedNotificationsIds.remove(entry.getKey());
        this.removeView(((BaseNotificationView)entry.getValue().getSecond()).getBinding().getRoot());
    }

    private final void removeNotifications(List<Notification> list2) {
        for (Map.Entry entry : MapsKt.toMap(this.notificationsViews).entrySet()) {
            if (!list2.contains(((Pair)entry.getValue()).getFirst())) continue;
            NotificationsLayout notificationsLayout = this;
            notificationsLayout.notificationsViews.remove(entry.getKey());
            notificationsLayout.notificationsSet.remove(((Pair)entry.getValue()).getFirst());
            notificationsLayout.showedNotificationsIds.remove(entry.getKey());
            this.removeView(((BaseNotificationView)((Pair)entry.getValue()).getSecond()).getBinding().getRoot());
        }
    }

    private final void addNotifications(List<Notification> list2) {
        if (list2.isEmpty()) {
            return;
        }
        NotificationsLayout notificationsLayout = this;
        NotificationsLayout notificationsLayout2 = this;
        notificationsLayout2.visible(true);
        notificationsLayout2.notificationsSet.addAll(list2);
        notificationsLayout.post(() -> NotificationsLayout.addNotifications$lambda$8(notificationsLayout, list2));
    }

    private final BaseNotificationView getNotificationView(Notification notification) {
        Object object;
        NotificationsLayout notificationsLayout = object;
        try {
            BaseNotificationView baseNotificationView = notificationsLayout.viewProvider.getNotificationView((ViewGroup)object, notification);
            SLRLog.INSTANCE.i("NotificationsLayout", "getNotificationView success type=" + notification.getType());
            object = Result.constructor-impl((Object)baseNotificationView);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (Result.exceptionOrNull-impl((Object)object) != null) {
            SLRLog.INSTANCE.i("NotificationsLayout", "getNotificationView error notification=" + notification);
        }
        if (Result.isFailure-impl((Object)object)) {
            object = null;
        }
        return (BaseNotificationView)object;
    }

    private final void showNotificationExpand(Notification notification, View view2) {
        Function0<Unit> function0;
        ConstraintSet constraintSet;
        Object object = constraintSet;
        View view3 = view2;
        object();
        Intrinsics.checkNotNull((Object)view3, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout");
        object = (ConstraintLayout)view3;
        constraintSet.clone((ConstraintLayout)object);
        constraintSet.connect(R.id.slNotifIconIV, 4, 0, 4);
        constraintSet.connect(R.id.slNotifTitleTV, 3, R.id.slNotifIconIV, 3);
        constraintSet.applyTo((ConstraintLayout)object);
        object = function0;
        function0 = new Function0<Unit>((NotificationsLayout)((Object)notificationsInteractionListener), view2, notification){
            final /* synthetic */ NotificationsLayout this$0;
            final /* synthetic */ View $view;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = notificationsLayout;
                this.$view = view2;
                this.$notification = notification;
                super(0);
            }

            public final void invoke() {
                showNotificationExpand.doOnEnd.1 v0 = this;
                v0.this$0.removeView(this.$view);
                NotificationsLayout.access$getNotificationsViews$p(v0.this$0).remove(this.$notification.getId());
                NotificationsLayout.access$getNotificationsSet$p(v0.this$0).remove(this.$notification);
                NotificationsLayout.access$hideAllNotifications(v0.this$0, false);
                v0.this$0.visible(false);
            }
        };
        if (((NotificationsLayout)((Object)notificationsInteractionListener)).shouldAnimateOnExpand(notification)) {
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = view2.getHeight();
            int n = 1;
            Function0<Integer> function02 = ((NotificationsLayout)((Object)notificationsInteractionListener)).getOverlayHeight;
            int n2 = function02 != null ? ((Number)function02.invoke()).intValue() : 0;
            nArray2[n] = n2;
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])nArray2);
            valueAnimator.setDuration(350L);
            valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            valueAnimator.addUpdateListener(arg_0 -> NotificationsLayout.showNotificationExpand$lambda$19$lambda$15(view2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"showNotificationExpand$lambda$19");
            valueAnimator.addListener(new Animator.AnimatorListener(view2){
                final /* synthetic */ View $view$inlined;
                {
                    this.$view$inlined = view2;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    this.$view$inlined.animate().alpha(0.0f).setDuration(350L).start();
                }
            });
            valueAnimator.addListener(new Animator.AnimatorListener((Function0)object){
                final /* synthetic */ Function0 $doOnEnd$inlined;
                {
                    this.$doOnEnd$inlined = function0;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    this.$doOnEnd$inlined.invoke();
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }
            });
            valueAnimator.start();
            view2.postDelayed(() -> NotificationsLayout.showNotificationExpand$lambda$19$lambda$18((NotificationsLayout)((Object)notificationsInteractionListener), notification), 175L);
        } else {
            NotificationsInteractionListener notificationsInteractionListener = ((NotificationsLayout)((Object)notificationsInteractionListener)).listener;
            if (notificationsInteractionListener != null) {
                notificationsInteractionListener.onNotificationClick(notification);
            }
            object.invoke();
        }
    }

    private final boolean shouldAnimateOnExpand(Notification notification) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return OtherExtensionsKt.isScreenPortrait(context) || !NotificationKt.isQuestion(notification.getType()) && notification.getType() != NotificationType.PredictionResult;
    }

    private final void showNotification(Notification notification, BaseNotificationView baseNotificationView) {
        ConstraintSet constraintSet;
        ConstraintSet constraintSet2 = constraintSet;
        NotificationsLayout notificationsLayout = this;
        constraintSet2();
        constraintSet2.clone((ConstraintLayout)this);
        baseNotificationView.setConstraintParams(this, constraintSet2);
        ChangeBounds changeBounds = new ChangeBounds();
        changeBounds.setDuration(0L);
        TransitionManager.beginDelayedTransition((ViewGroup)notificationsLayout, (Transition)changeBounds);
        constraintSet.applyTo((ConstraintLayout)notificationsLayout);
        baseNotificationView.getBinding().getRoot().post(() -> NotificationsLayout.showNotification$lambda$22(notification, baseNotificationView, this));
    }

    private final void animateNotificationsAppear(ConstraintSet constraintSet, List<Pair<Notification, BaseNotificationView>> list2) {
        DefaultTransitionListener defaultTransitionListener;
        AnticipateOvershootInterpolator anticipateOvershootInterpolator;
        ChangeBounds changeBounds;
        ConstraintSet constraintSet2 = constraintSet;
        constraintSet = changeBounds;
        Object object = anticipateOvershootInterpolator;
        anticipateOvershootInterpolator = new AnticipateOvershootInterpolator(1.0f);
        new ChangeBounds().setInterpolator((TimeInterpolator)object);
        constraintSet.setStartDelay(100L);
        constraintSet.setDuration(350L);
        object = defaultTransitionListener;
        defaultTransitionListener = new DefaultTransitionListener(list2, this){
            final /* synthetic */ List<Pair<Notification, BaseNotificationView>> $notificationsToAnimate;
            final /* synthetic */ NotificationsLayout this$0;
            {
                this.$notificationsToAnimate = list2;
                this.this$0 = notificationsLayout;
            }

            public void onTransitionEnd(@NotNull Transition object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"transition");
                object = this.this$0;
                for (Pair pair : this.$notificationsToAnimate) {
                    NotificationsLayout.access$showNotification((NotificationsLayout)((Object)object), (Notification)pair.getFirst(), (BaseNotificationView)pair.getSecond());
                }
                this.$notificationsToAnimate.clear();
            }

            public void onTransitionStart(@NotNull Transition transition2) {
                DefaultTransitionListener.DefaultImpls.onTransitionStart(this, transition2);
            }

            public void onTransitionCancel(@NotNull Transition transition2) {
                DefaultTransitionListener.DefaultImpls.onTransitionCancel(this, transition2);
            }

            public void onTransitionPause(@NotNull Transition transition2) {
                DefaultTransitionListener.DefaultImpls.onTransitionPause(this, transition2);
            }

            public void onTransitionResume(@NotNull Transition transition2) {
                DefaultTransitionListener.DefaultImpls.onTransitionResume(this, transition2);
            }
        };
        constraintSet.addListener((Transition.TransitionListener)object);
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)constraintSet);
        constraintSet2.applyTo((ConstraintLayout)this);
    }

    private final void addToPoolOrRemoveNotificationsView(BaseNotificationView baseNotificationView, NotificationType notificationType) {
        baseNotificationView.clear();
        int n = WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()];
        if (n != 8 && n != 9) {
            this.removeView(baseNotificationView.getBinding().getRoot());
        } else {
            ConstraintSet constraintSet;
            View view2 = baseNotificationView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.binding.root");
            ViewExtensionsKt.gone(view2);
            ConstraintSet constraintSet2 = constraintSet;
            constraintSet2();
            constraintSet2.clone((ConstraintLayout)this);
            constraintSet2.clear(baseNotificationView.getBinding().getRoot().getId(), 4);
            constraintSet2.clear(baseNotificationView.getBinding().getRoot().getId(), 7);
            constraintSet2.clear(baseNotificationView.getBinding().getRoot().getId(), 6);
            constraintSet.applyTo((ConstraintLayout)this);
            this.viewProvider.addToPool(baseNotificationView);
        }
    }

    private final void hideNotification(View view2, Notification notification) {
        float f = NotificationKt.isQuestion(notification.getType()) ? 0.0f : -this.hideNotificationsPath;
        view2.animate().translationYBy(f).alpha(0.0f).setDuration(350L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(() -> NotificationsLayout.hideNotification$lambda$26(view2, this, notification)).start();
    }

    private final void hideAllNotifications(boolean bl) {
        int n = 0;
        for (Map.Entry entry : this.notificationsViews.entrySet()) {
            Function0<Boolean> function0;
            Long cfr_ignored_0 = (Long)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            Function0<Boolean> function02 = function0;
            function0 = new Function0<Boolean>((Pair<Notification, ? extends BaseNotificationView>)pair, this){
                final /* synthetic */ Pair<Notification, BaseNotificationView> $pair;
                final /* synthetic */ NotificationsLayout this$0;
                {
                    this.$pair = pair;
                    this.this$0 = notificationsLayout;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    hideAllNotifications.1.removeNotification.1 v0 = this;
                    View view2 = ((BaseNotificationView)v0.$pair.getSecond()).getBinding().getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"pair.second.binding.root");
                    ViewExtensionsKt.gone(view2);
                    NotificationsLayout.access$getNotificationsSet$p(v0.this$0).remove(this.$pair.getFirst());
                    v0.this$0.removeView(((BaseNotificationView)this.$pair.getSecond()).getBinding().getRoot());
                    return NotificationsLayout.access$notifyAllNotificationsDismissed(v0.this$0);
                }
            };
            if (bl) {
                AnimationSet animationSet;
                Pair pair2 = pair;
                pair = animationSet;
                pair(true);
                animationSet.setStartOffset((long)(n * 150));
                animationSet.setDuration(350L);
                animationSet.addAnimation((Animation)new AlphaAnimation(1.0f, 0.0f));
                float f = this.hideNotificationsPath;
                animationSet.addAnimation((Animation)new TranslateAnimation(0.0f, 0.0f, 0.0f, f));
                animationSet.setAnimationListener(new Animation.AnimationListener(function02){
                    final /* synthetic */ Function0<Boolean> $removeNotification;
                    {
                        this.$removeNotification = function0;
                    }

                    public void onAnimationStart(@Nullable Animation animation) {
                    }

                    public void onAnimationEnd(@Nullable Animation animation) {
                        this.$removeNotification.invoke();
                    }

                    public void onAnimationRepeat(@Nullable Animation animation) {
                    }
                });
                ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().startAnimation((Animation)pair);
                ++n;
                continue;
            }
            function02.invoke();
        }
    }

    private final void clearNotificationsStackViews(SortedMap<Long, Pair<Notification, BaseNotificationView>> sortedMap) {
        if (!sortedMap.isEmpty() && sortedMap.size() >= 4) {
            SortedMap<Long, Pair<Notification, BaseNotificationView>> sortedMap2 = sortedMap;
            Long l = sortedMap2.lastKey();
            Pair pair = (Pair)sortedMap2.get(l);
            if (pair == null) {
                return;
            }
            SortedMap<Long, Pair<Notification, BaseNotificationView>> sortedMap3 = sortedMap;
            Pair pair2 = (Pair)sortedMap3.get(sortedMap3.firstKey());
            if (!NotificationKt.isQuestion(((Notification)pair.getFirst()).getType()) || pair2 != null && ((Notification)pair2.getFirst()).isSourceSame(((Notification)pair.getFirst()).getSourceUniqueId())) {
                this.addToPoolOrRemoveNotificationsView((BaseNotificationView)pair.getSecond(), ((Notification)pair.getFirst()).getType());
                this.dismissNotification((Notification)pair.getFirst());
            }
            sortedMap.remove(l);
            this.clearNotificationsStackViews(sortedMap);
            return;
        }
    }

    private final void dismissNotification(Notification notification) {
        NotificationsLayout notificationsLayout = notificationsInteractionListener;
        notificationsLayout.notificationsViews.remove(notification.getId());
        notificationsLayout.notificationsSet.remove(notification);
        NotificationsInteractionListener notificationsInteractionListener = notificationsLayout.listener;
        if (notificationsInteractionListener != null) {
            notificationsInteractionListener.onNotificationDismissed(notification, false);
        }
    }

    private final void addNotificationToLayout(ConstraintSet object, Notification notification, List<Pair<Notification, BaseNotificationView>> pair) {
        SLRLog.INSTANCE.i("NotificationsLayout", "show notification " + notification);
        Long l = notification.getId();
        Intrinsics.checkNotNull((Object)l);
        object3.showedNotificationsIds.add(l);
        if (!(NotificationViewsKt.isLikePrediction(notification.getType()) || notification.getType() == NotificationType.WaveReply)) {
            if (object3.notificationsViews.isEmpty() ^ true) {
                SortedMap<Long, Pair<Notification, BaseNotificationView>> sortedMap = object3.notificationsViews;
                Object object2 = (Pair)sortedMap.get(sortedMap.firstKey());
                if (object2 != null && (object2 = (Notification)object2.getFirst()) != null && ((Notification)object2).isSourceSame(notification.getSourceUniqueId())) {
                    NotificationsLayout notificationsLayout = object3;
                    object = notificationsLayout.notificationsViews.firstKey();
                    if ((object = (Pair)notificationsLayout.notificationsViews.get(object)) != null) {
                        Long l2 = ((Notification)object.getFirst()).getId();
                        Intrinsics.checkNotNull((Object)l2);
                        long l3 = l2;
                        Long l4 = notification.getId();
                        Intrinsics.checkNotNull((Object)l4);
                        if (l3 > l4) {
                            return;
                        }
                        NotificationsLayout notificationsLayout2 = object3;
                        ((BaseNotificationView)object.getSecond()).bind(notification);
                        Object object3 = notification.getId();
                        object3.notificationsViews.put((Long)object3, (Pair<Notification, BaseNotificationView>)TuplesKt.to((Object)notification, (Object)object.getSecond()));
                        notificationsLayout2.dismissNotification((Notification)object.getFirst());
                    }
                    return;
                }
            }
            int n = 1;
            Iterator iterator = object3.notificationsViews.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair2 = (Pair)iterator.next().getValue();
                if (NotificationViewsKt.isLikePrediction(((Notification)pair2.getFirst()).getType()) || ((Notification)pair2.getFirst()).getType() == NotificationType.JoinToChat) continue;
                if (n < 3) {
                    int n2;
                    object.setTranslationZ(((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getId(), ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getTranslationZ() - (float)(n * ViewExtensionsKt.getDp(1.0f)));
                    View view2 = ((BaseNotificationView)pair2.getSecond()).getNotificationView();
                    if (view2 != null) {
                        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                        if (layoutParams != null) {
                            ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
                            layoutParams2.width -= n * object3.startMargin + ViewExtensionsKt.getDp(2.0f);
                            view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                        } else {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                        }
                    }
                    if (object3.isPortrait) {
                        n2 = ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getId();
                        NotificationsLayoutKt.setStartSide((ConstraintSet)object, n2, n * object3.startMargin);
                        n2 = ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getId();
                        NotificationsLayoutKt.setEndSide((ConstraintSet)object, n2, n * object3.startMargin);
                    } else {
                        View view3 = ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"pair.second.binding.root");
                        view2 = view3.getLayoutParams();
                        n2 = view2 instanceof ViewGroup.MarginLayoutParams ? MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)view2)) : 0;
                        NotificationsLayoutKt.setEndSide((ConstraintSet)object, ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getId(), n2 += n * object3.startMargin);
                    }
                    NotificationsLayoutKt.setBottomSide((ConstraintSet)object, ((BaseNotificationView)pair2.getSecond()).getBinding().getRoot().getId(), object3.bottomMargin - n * ViewExtensionsKt.getDp(2.0f));
                }
                ++n;
            }
        }
        if ((object = object3.getNotificationView(notification)) != null) {
            Pair pair3;
            View view4 = object.getBinding().getRoot();
            if (!view4.isAttachedToWindow()) {
                View view5 = view4;
                view5.setId(ViewCompat.generateViewId());
                Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"addNotificationToLayout$lambda$35$lambda$34");
                ViewExtensionsKt.invisible(view5);
                object3.addView(view5);
            }
            Pair pair4 = pair;
            object.bind(notification);
            object.prepareView((ConstraintLayout)object3);
            pair = pair3;
            pair((Object)notification, object);
            Long l5 = notification.getId();
            Intrinsics.checkNotNull((Object)l5);
            object3.notificationsViews.put(l5, (Pair<Notification, BaseNotificationView>)pair);
            pair4.add(pair3);
        }
    }

    private final void startDismissTimer() {
        Object object = this.timerJob;
        if (object != null) {
            Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
        }
        if ((object = ViewKt.findViewTreeLifecycleOwner((View)this)) != null && (object = object.getLifecycle()) != null && (object = LifecycleKt.getCoroutineScope((Lifecycle)object)) != null) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Job job = object;
            object = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ NotificationsLayout this$0;
                {
                    this.this$0 = notificationsLayout;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    block15: {
                        Object object2;
                        block14: {
                            long l;
                            var object3;
                            block12: {
                                block13: {
                                    object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    int n = object3.label;
                                    if (n == 0) break block12;
                                    if (n != 1) break block13;
                                    object3 = (NotificationsLayout)((Object)object3.L$0);
                                    ResultKt.throwOnFailure((Object)object);
                                    break block14;
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            ResultKt.throwOnFailure((Object)object);
                            object = (Notification)NotificationsLayout.access$getNotificationsSet$p(object3.this$0).last();
                            if (object == null) break block15;
                            Object object4 = object;
                            object = object3.this$0;
                            switch (startDismissTimer.WhenMappings.$EnumSwitchMapping$0[((Notification)object4).getType().ordinal()]) {
                                default: {
                                    l = 8000L;
                                    break;
                                }
                                case 6: {
                                    l = 120000L;
                                    break;
                                }
                                case 4: {
                                    l = 17000L;
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: 
                                case 5: {
                                    l = 60000L;
                                }
                            }
                            object3.L$0 = object;
                            object3.label = 1;
                            if (DelayKt.delay((long)l, (Continuation)object3) == object2) {
                                return object2;
                            }
                            object3 = object;
                        }
                        if (NotificationsLayout.access$getNotificationsSet$p((NotificationsLayout)((Object)object3)).size() > 0) {
                            Object object5 = object3;
                            object = (Notification)NotificationsLayout.access$getNotificationsSet$p((NotificationsLayout)((Object)object5)).pollLast();
                            SortedMap sortedMap = NotificationsLayout.access$getNotificationsViews$p((NotificationsLayout)((Object)object5));
                            Long l = ((Notification)object).getId();
                            Intrinsics.checkNotNull((Object)l);
                            object2 = (Pair)sortedMap.remove(l);
                            if (object2 != null) {
                                Function0<Unit> function0;
                                Function0<Unit> function02 = function0;
                                function0 = new Function0<Unit>((NotificationsLayout)((Object)object3), (Pair<Notification, ? extends BaseNotificationView>)object2, (Notification)object){
                                    final /* synthetic */ NotificationsLayout this$0;
                                    final /* synthetic */ Pair<Notification, BaseNotificationView> $pair;
                                    final /* synthetic */ Notification $lastNotification;
                                    {
                                        this.this$0 = notificationsLayout;
                                        this.$pair = pair;
                                        this.$lastNotification = notification;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        startDismissTimer.1.1.1 v0 = object2;
                                        NotificationsLayout notificationsLayout = v0.this$0;
                                        startDismissTimer.1.1.1 v2 = object2;
                                        Object object = ((BaseNotificationView)v2.$pair.getSecond()).getBinding().getRoot();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second.binding.root");
                                        Notification notification = v2.$lastNotification;
                                        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"lastNotification");
                                        NotificationsLayout.access$hideNotification(notificationsLayout, (View)object, notification);
                                        object = v0.this$0.getListener();
                                        if (object != null) {
                                            Object object2 = object2.$lastNotification;
                                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"lastNotification");
                                            object.onNotificationDismissed((Notification)object2, false);
                                        }
                                    }
                                };
                                ((BaseNotificationView)object2.getSecond()).hideAnimate((ConstraintLayout)object3, function02);
                            }
                            if (NotificationsLayout.access$getNotificationsSet$p((NotificationsLayout)((Object)object3)).size() != 0) {
                                NotificationsLayout.access$startDismissTimer((NotificationsLayout)((Object)object3));
                            }
                        }
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            };
            object = BuildersKt.launch$default((CoroutineScope)job, null, null, (Function2)object, (int)3, null);
        } else {
            object = null;
        }
        this.timerJob = object;
    }

    private final boolean notifyAllNotificationsDismissed() {
        boolean bl = this.notificationsSet.isEmpty();
        if (bl) {
            NotificationsInteractionListener notificationsInteractionListener = this.listener;
            if (notificationsInteractionListener != null) {
                notificationsInteractionListener.onAllNotificationsDismissed();
            }
            NotificationsLayout notificationsLayout = this;
            notificationsLayout.visible(false);
            notificationsLayout.viewProvider.clearPool((ViewGroup)this);
            for (Map.Entry entry : notificationsLayout.notificationsViews.entrySet()) {
                Long cfr_ignored_0 = (Long)entry.getKey();
                this.removeView(((BaseNotificationView)((Pair)entry.getValue()).getSecond()).getBinding().getRoot());
            }
            this.notificationsViews.clear();
        }
        return bl;
    }

    @JvmOverloads
    public NotificationsLayout(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public NotificationsLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void addNotifications$lambda$8(NotificationsLayout notificationsLayout, List list2) {
        ArrayList arrayList;
        ConstraintSet constraintSet;
        ArrayList arrayList2;
        List list3 = list2;
        Intrinsics.checkNotNullParameter((Object)((Object)notificationsLayout), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)list3, (String)"$notifications");
        list2 = arrayList2;
        arrayList2 = new ArrayList();
        ConstraintSet constraintSet2 = constraintSet;
        constraintSet2();
        constraintSet.clone((ConstraintLayout)notificationsLayout);
        Object object = arrayList;
        arrayList = new ArrayList();
        for (Object t : CollectionsKt.sortedWith((Iterable)list3, new Comparator(){

            public final int compare(T t, T t2) {
                return ComparisonsKt.compareValues((Comparable)((Notification)t).getId(), (Comparable)((Notification)t2).getId());
            }
        })) {
            Notification notification = (Notification)t;
            Set<Long> set2 = notificationsLayout.showedNotificationsIds;
            Long l = notification.getId();
            Intrinsics.checkNotNull((Object)l);
            if (!(set2.contains(l) ^ true)) continue;
            object.add(t);
        }
        object = object.iterator();
        while (object.hasNext()) {
            Notification notification = (Notification)object.next();
            if (CollectionsKt.contains(notificationsLayout.showedNotificationsIds, (Object)notification.getId())) continue;
            notificationsLayout.addNotificationToLayout(constraintSet2, notification, list2);
        }
        NotificationsLayout notificationsLayout2 = notificationsLayout;
        notificationsLayout2.animateNotificationsAppear(constraintSet2, list2);
        notificationsLayout2.startDismissTimer();
    }

    private static final void showNotificationExpand$lambda$19$lambda$15(View view2, ValueAnimator valueAnimator) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"it");
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (layoutParams != null) {
            Object object = valueAnimator.getAnimatedValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            layoutParams.height = (Integer)object;
            view2.setLayoutParams(layoutParams);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
    }

    private static final void showNotificationExpand$lambda$19$lambda$18(NotificationsLayout object, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"$notification");
        object = ((NotificationsLayout)((Object)object)).listener;
        if (object != null) {
            object.onNotificationClick(notification);
        }
    }

    private static final void showNotification$lambda$22(Notification notification, BaseNotificationView baseNotificationView, NotificationsLayout notificationsLayout) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"$baseView");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationsLayout), (String)"this$0");
        switch (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()]) {
            default: {
                Function0<Unit> function0;
                notification = function0;
                function0 = new Function0<Unit>(notificationsLayout){
                    final /* synthetic */ NotificationsLayout this$0;
                    {
                        this.this$0 = notificationsLayout;
                        super(0);
                    }

                    public final void invoke() {
                        LinkedHashMap<Map.Entry<K, V>, V> linkedHashMap;
                        NotificationsLayout notificationsLayout = this.this$0;
                        LinkedHashMap<Map.Entry<K, V>, V> linkedHashMap2 = linkedHashMap;
                        linkedHashMap = new LinkedHashMap<Map.Entry<K, V>, V>();
                        for (Map.Entry<K, V> entry : NotificationsLayout.access$getNotificationsViews$p(notificationsLayout).entrySet()) {
                            if (!(NotificationViewsKt.isLikePrediction(((Notification)((Pair)entry.getValue()).getFirst()).getType()) ^ true)) continue;
                            Map.Entry<K, V> entry2 = entry;
                            entry = entry2.getKey();
                            ((AbstractMap)linkedHashMap2).put(entry, entry2.getValue());
                        }
                        NotificationsLayout.access$clearNotificationsStackViews(notificationsLayout, MapsKt.toSortedMap(linkedHashMap2, (Comparator)NotificationsLayout.access$getViewsComparator$p(this.this$0)));
                    }
                };
                baseNotificationView.showAnimate(notificationsLayout, (Function0<Unit>)notification);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                BaseNotificationView.DefaultImpls.showAnimate$default(baseNotificationView, notificationsLayout, null, 2, null);
            }
        }
    }

    private static final void hideNotification$lambda$26(View view2, NotificationsLayout notificationsLayout, Notification notification) {
        NotificationsLayout notificationsLayout2 = notificationsLayout;
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)notificationsLayout), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"$notification");
        ViewExtensionsKt.invisible(view3);
        notificationsLayout2.removeView(view3);
        notificationsLayout2.notificationsViews.remove(notification.getId());
        notificationsLayout2.notifyAllNotificationsDismissed();
    }

    public static final /* synthetic */ SortedMap access$getNotificationsViews$p(NotificationsLayout notificationsLayout) {
        return notificationsLayout.notificationsViews;
    }

    public static final /* synthetic */ TreeSet access$getNotificationsSet$p(NotificationsLayout notificationsLayout) {
        return notificationsLayout.notificationsSet;
    }

    public static final /* synthetic */ void access$hideAllNotifications(NotificationsLayout notificationsLayout, boolean bl) {
        notificationsLayout.hideAllNotifications(bl);
    }

    public static final /* synthetic */ void access$hideNotification(NotificationsLayout notificationsLayout, View view2, Notification notification) {
        notificationsLayout.hideNotification(view2, notification);
    }

    public static final /* synthetic */ void access$startDismissTimer(NotificationsLayout notificationsLayout) {
        notificationsLayout.startDismissTimer();
    }

    public static final /* synthetic */ void access$clearNotificationsStackViews(NotificationsLayout notificationsLayout, SortedMap sortedMap) {
        notificationsLayout.clearNotificationsStackViews(sortedMap);
    }

    public static final /* synthetic */ viewsComparator.1 access$getViewsComparator$p(NotificationsLayout notificationsLayout) {
        return notificationsLayout.viewsComparator;
    }

    public static final /* synthetic */ void access$showNotification(NotificationsLayout notificationsLayout, Notification notification, BaseNotificationView baseNotificationView) {
        notificationsLayout.showNotification(notification, baseNotificationView);
    }

    public static final /* synthetic */ boolean access$notifyAllNotificationsDismissed(NotificationsLayout notificationsLayout) {
        return notificationsLayout.notifyAllNotificationsDismissed();
    }

    public static final /* synthetic */ void access$showNotificationExpand(NotificationsLayout notificationsLayout, Notification notification, View view2) {
        notificationsLayout.showNotificationExpand(notification, view2);
    }

    @Nullable
    public final Function0<Unit> getOnChildAdded() {
        return this.onChildAdded;
    }

    public final void setOnChildAdded(@Nullable Function0<Unit> function0) {
        this.onChildAdded = function0;
    }

    @Nullable
    public final Function0<Integer> getGetOverlayHeight() {
        return this.getOverlayHeight;
    }

    public final void setGetOverlayHeight(@Nullable Function0<Integer> function0) {
        this.getOverlayHeight = function0;
    }

    @Nullable
    public final NotificationsInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable NotificationsInteractionListener notificationsInteractionListener) {
        this.listener = notificationsInteractionListener;
    }

    public final boolean getOnScreen() {
        return this.onScreen;
    }

    public final void setOnScreen(boolean bl) {
        this.onScreen = bl;
    }

    public void addView(@Nullable View view2) {
        Function0<Unit> function0 = function02;
        super.addView(view2);
        Function0<Unit> function02 = function0.onChildAdded;
        if (function02 != null) {
            function02.invoke();
        }
    }

    @NotNull
    public final List<Notification> clearInviteDeleteJoinNotifications() {
        LinkedHashMap linkedHashMap;
        ArrayList<Notification> arrayList;
        ArrayList<Notification> arrayList2 = arrayList;
        arrayList = new ArrayList<Notification>();
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : this.notificationsViews.entrySet()) {
            Pair pair = (Pair)entry.getValue();
            NotificationType notificationType = NotificationType.JoinToChat;
            if (((Notification)pair.getFirst()).getType() == notificationType) {
                arrayList2.add((Notification)pair.getFirst());
            }
            if (!ArraysKt.contains((Object[])new NotificationType[]{NotificationType.WaveReply, notificationType}, (Object)((Object)((Notification)pair.getFirst()).getType()))) continue;
            Map.Entry entry2 = entry;
            entry = entry2.getKey();
            ((AbstractMap)object).put(entry, entry2.getValue());
        }
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            this.removeNotification((Map.Entry)object.next());
        }
        return arrayList2;
    }

    public final void update(@NotNull List<Notification> list2) {
        ArrayList arrayList;
        ArrayList<Notification> arrayList2;
        List<Notification> list3 = list2;
        Intrinsics.checkNotNullParameter(list3, (String)"notifications");
        ArrayList<Notification> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Notification>();
        for (Object object : list3) {
            Notification notification = (Notification)object;
            if (!(this.notificationsSet.contains(notification) ^ true)) continue;
            arrayList3.add((Notification)object);
        }
        ArrayList arrayList4 = arrayList;
        arrayList = new ArrayList();
        for (Notification notification : CollectionsKt.toList(this.notificationsSet)) {
            if (!(list2.contains(notification) ^ true)) continue;
            arrayList4.add(notification);
        }
        if (arrayList4.isEmpty() ^ true) {
            this.removeNotifications(arrayList4);
        }
        if (arrayList3.isEmpty() ^ true) {
            this.addNotifications(arrayList3);
        }
    }

    public final void visible(boolean bl) {
        this.onScreen = bl;
        ViewExtensionsKt.visibleIf((View)this, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int getTooltipBottomMargin() {
        int n;
        Object object;
        if (((NotificationsLayout)((Object)object)).isPortrait && ExtensionsKt.hasSinglePredictionNotification(CollectionsKt.toList(((NotificationsLayout)((Object)object)).notificationsSet))) {
            object = ((NotificationsLayout)((Object)object)).getOverlayHeight;
            n = (object != null ? ((Number)object.invoke()).intValue() : 0) - ViewExtensionsKt.getDp(20.0f);
            return n;
        }
        Function0<Integer> function0 = object;
        int n2 = function0.getResources().getDimensionPixelSize(R.dimen.slr_notification_height);
        int n3 = function0.getResources().getDimensionPixelSize(R.dimen.slr_notification_padding) + object.getResources().getDimensionPixelSize(R.dimen.slr_view_tooltip_distance_between_view);
        if (function0.showedNotificationsIds.isEmpty() ^ true) {
            block7: {
                Function0<Integer> function02;
                try {
                    function02 = object;
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    break block7;
                }
                {
                    object = Result.constructor-impl((Object)function02.notificationsViews.getOrDefault(CollectionsKt.last(((NotificationsLayout)((Object)object)).showedNotificationsIds), null));
                }
            }
            if (Result.isFailure-impl(object)) {
                object = null;
            }
            if (((object = (object = (Pair)object) != null && (object = (BaseNotificationView)object.getSecond()) != null && (object = object.getBinding()) != null && (object = object.getRoot()) != null ? Integer.valueOf(object.getHeight()) : null) != null ? (Integer)object : 0) > 0) {
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                n = (Integer)object2 + n3;
                return n;
            }
        }
        n = n2 + n3;
        return n;
    }

    public final int getTooltipRightMargin(int n) {
        return ExtensionsKt.hasSinglePredictionNotification(CollectionsKt.toList(this.notificationsSet)) ? (int)((float)this.getWidth() - this.getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width) + (this.getResources().getDimension(R.dimen.slr_predictions_notification_landscape_width) - (float)n) / (float)2) : (int)((this.getResources().getDimension(R.dimen.slr_notification_landscape_width) - (float)n) / (float)2);
    }

    protected void onDetachedFromWindow() {
        NotificationsLayout notificationsLayout = this;
        super.onDetachedFromWindow();
        Job job = notificationsLayout.timerJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        NotificationsLayout notificationsLayout2 = this;
        notificationsLayout2.notificationsViews.clear();
        notificationsLayout2.viewProvider.clearPool((ViewGroup)this);
        notificationsLayout2.notificationsSet.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "", "hideAll", "", "onExpand", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "view", "Landroid/view/View;", "onHide", "sdk_originalVonageRelease"})
    public static interface NotificationViewAction {
        public void onExpand(@NotNull Notification var1, @NotNull View var2);

        public void onHide(@NotNull Notification var1, @NotNull View var2);

        public void hideAll();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationsInteractionListener;", "", "onAllNotificationsDismissed", "", "onNotificationClick", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "onNotificationDismissed", "isManual", "", "sdk_originalVonageRelease"})
    public static interface NotificationsInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationDismissed(@NotNull Notification var1, boolean var2);

        public void onAllNotificationsDismissed();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\"\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0013H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "", "binding", "Landroidx/viewbinding/ViewBinding;", "getBinding", "()Landroidx/viewbinding/ViewBinding;", "notificationView", "Landroid/view/View;", "getNotificationView", "()Landroid/view/View;", "bind", "", "item", "Lio/streamlayer/sdk/model/notifications/Notification;", "clear", "hideAnimate", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "onEnd", "Lkotlin/Function0;", "prepareView", "setConstraintParams", "constraintSet", "Landroidx/constraintlayout/widget/ConstraintSet;", "showAnimate", "sdk_originalVonageRelease"})
    public static interface BaseNotificationView {
        @NotNull
        public ViewBinding getBinding();

        @Nullable
        public View getNotificationView();

        public void bind(@NotNull Notification var1);

        public void clear();

        public void showAnimate(@NotNull ConstraintLayout var1, @Nullable Function0<Unit> var2);

        public void hideAnimate(@NotNull ConstraintLayout var1, @Nullable Function0<Unit> var2);

        public void prepareView(@NotNull ConstraintLayout var1);

        public void setConstraintParams(@NotNull ConstraintLayout var1, @NotNull ConstraintSet var2);

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void clear(@NotNull BaseNotificationView baseNotificationView) {
            }

            public static void showAnimate(@NotNull BaseNotificationView baseNotificationView, @NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
                Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            }

            public static /* synthetic */ void showAnimate$default(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, Function0 function0, int n, Object object) {
                if (object == null) {
                    if ((n & 2) != 0) {
                        function0 = null;
                    }
                    baseNotificationView.showAnimate(constraintLayout, (Function0<Unit>)function0);
                    return;
                }
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showAnimate");
            }

            public static void hideAnimate(@NotNull BaseNotificationView baseNotificationView, @NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
                Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
                if (function0 != null) {
                    function0.invoke();
                }
            }

            public static /* synthetic */ void hideAnimate$default(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, Function0 function0, int n, Object object) {
                if (object == null) {
                    if ((n & 2) != 0) {
                        function0 = null;
                    }
                    baseNotificationView.hideAnimate(constraintLayout, (Function0<Unit>)function0);
                    return;
                }
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hideAnimate");
            }

            public static void prepareView(@NotNull BaseNotificationView baseNotificationView, @NotNull ConstraintLayout constraintLayout) {
                Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            }

            public static void setConstraintParams(@NotNull BaseNotificationView baseNotificationView, @NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
                Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[NotificationType.WaveReply.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Poll.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Trivia.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Prediction.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.PredictionResult.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Factoid.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.FactoidTweet.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Chat.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[NotificationType.Twitter.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

